/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.outlineview;

import com.unisys.os2200.util.MemChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.LineReader;
import org.eclipse.cobol.ui.common.LineWrapper;
import org.eclipse.cobol.ui.views.outlineview.Element;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;

public class COBOLParser {
    private static String fCurrentFormat = null;
    private boolean fromFile = false;
    private Element startElement = new Element();
    private LineReader fLineReader = null;
    HashMap fLineMap = new HashMap();
    ArrayList fUnusedEnds = new ArrayList();
    private LineWrapper fLineWrapper = null;
    public String sectionName = " ";
    public String paraName = " ";
    boolean isPara = false;
    public int strPt = 7;
    boolean isParagraph = true;
    public static StringBuffer sectionArr = new StringBuffer();
    public static StringBuffer paraArr = new StringBuffer();
    public static StringBuffer varArr = new StringBuffer();
    public static StringBuffer unreferencedVarArr = new StringBuffer();
    private String wholeProg = null;
    final String sectionNames = "CONFIGURATION,INPUT-OUTPUT,FILE,WORKING-STORAGE,COMMON-STORAGE,LOCAL-STORAGE,LINKAGE";
    final String paragraphNames = "SOURCE-COMPUTER,OBJECT-COMPUTER,SPECIAL-NAMES,FILE-CONTROL,I-O-CONTROL";
    final String levelNums = "01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,66,77,88";
    private final String PROCEDURE = "PROCEDURE ";
    private final String EMPTY_STR = "";
    private final String SINGLE_SPACE = " ";
    private final String PERIOD = ".";
    private final String COMMA = ",";
    private final char ASTERISK_CHAR = (char)42;

    public void initialize() {
        sectionArr.delete(0, sectionArr.length());
        paraArr.delete(0, paraArr.length());
        varArr.delete(0, varArr.length());
        unreferencedVarArr.delete(0, unreferencedVarArr.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private short getParagraphColumn(String string, String string2, boolean bl) {
        int n;
        String string3 = "";
        String string4 = "";
        string3 = this.getTrimString(string);
        char c = '\u0000';
        char c2 = '\u0000';
        int n2 = 0;
        int n3 = 0;
        int n4 = n = this.isStructuredFormat() != 1 && this.fromFile ? 6 : 0;
        if (n >= string3.length()) {
            return 0;
        }
        if (this.isCommentLine(string3)) {
            return 0;
        }
        if (this.isStructuredFormat() != 1) {
            ++n;
        }
        n = this.skipSpace(string3, n);
        int n5 = string3.length() - n;
        while (n2 < n5) {
            if ((n = this.skipSpace(string3, n)) >= string3.length()) {
                return 0;
            }
            c = string3.charAt(n);
            if ('\"' == c || '\'' == (c = string3.charAt(n))) {
                if ((n = string3.indexOf(c, n + 1)) == -1) {
                    return 0;
                }
            } else {
                String string5;
                if ('*' == string3.charAt(n)) {
                    return 0;
                }
                if (n + string2.length() >= string3.length()) {
                    if (!string2.equalsIgnoreCase("OBJECT") && !string2.equalsIgnoreCase("FACTORY")) return 0;
                    if (n + string2.length() > string3.length()) {
                        return 0;
                    }
                }
                if (this.isStructuredFormat() != 1) {
                    string4 = string3.substring(n, n + string2.length());
                    n3 = this.strncmpi(string4, string2);
                } else {
                    string4 = string3.substring(n);
                    n3 = this.isKeywordAvailableInLine(string4, string2);
                }
                if (n3 >= 0 && string2.equalsIgnoreCase("OBJECT") && (string5 = string3.substring(n).toUpperCase()).indexOf("REFERENCE") != -1) {
                    return 0;
                }
                if (n3 == -1 && this.strncmpi(string4, "CLASS-ID") >= 0 && string2.equals("INHERITS")) {
                    n3 = string3.toLowerCase().indexOf(string2.toLowerCase()) - n;
                    string4 = string2;
                }
                if (n3 < 0) return 0;
                if ((n += n3 + string2.length()) == string3.length()) {
                    string3 = String.valueOf(string3) + " ";
                }
                if (this.isEndingWithComment(string3, string2, c2 = string3.charAt(n))) {
                    n = this.skipSpace(string3, n);
                    return (short)n;
                }
                if (!this.isSpace(c2) && !this.isEOF(c2) && '.' != c2) return 0;
                n = this.skipSpace(string3, n);
                if (!bl) {
                    return (short)(n + 1);
                }
                if (n < string3.length() && '.' == string3.charAt(n)) {
                    n = this.skipSpace(string3, n + 1);
                    if (!string2.equalsIgnoreCase("CLASS-ID") && !string2.equalsIgnoreCase("PROGRAM-ID") && !string2.equalsIgnoreCase("METHOD-ID")) return (short)n;
                    if (string3.trim().length() <= (String.valueOf(string2) + '.').length()) return 0;
                    string5 = string3.trim();
                    if (this.isDataInvalid(string5 = string5.substring(string5.indexOf(".") + 1))) return 0;
                    if (!string2.equalsIgnoreCase("METHOD-ID") || string5.trim().indexOf(32) == -1 || !string5.trim().toUpperCase().substring(0, string5.trim().indexOf(32)).trim().equalsIgnoreCase("GET") && !string5.trim().toUpperCase().substring(0, string5.trim().indexOf(32)).trim().equalsIgnoreCase("SET") || !string5.trim().substring(string5.trim().indexOf(32)).trim().toUpperCase().startsWith("PROPERTY")) return (short)n;
                    String string6 = string5.trim().substring(string5.trim().indexOf(32)).trim().toUpperCase();
                    if (string6.trim().startsWith("PROPERTY.") || string6.trim().startsWith("PROPERTY*>") || string6.trim().indexOf(32) == -1 || this.isDataInvalid(string6.trim().substring(string6.trim().indexOf(32)))) return 0;
                    return (short)n;
                }
                if (!string2.equalsIgnoreCase("CLASS-ID") && !string2.equalsIgnoreCase("PROGRAM-ID") && !string2.equalsIgnoreCase("METHOD-ID")) return (short)n;
                if (string3.trim().length() <= string2.length()) return 0;
                string5 = string3.trim();
                if (this.isDataInvalid(string5 = string5.substring(string2.length()))) return 0;
                if (!string2.equalsIgnoreCase("METHOD-ID") || string5.trim().indexOf(32) == -1 || !string5.trim().toUpperCase().substring(0, string5.trim().indexOf(32)).trim().equalsIgnoreCase("GET") && !string5.trim().toUpperCase().substring(0, string5.trim().indexOf(32)).trim().equalsIgnoreCase("SET") || !string5.trim().substring(string5.trim().indexOf(32)).trim().toUpperCase().startsWith("PROPERTY")) return (short)n;
                String string7 = string5.trim().substring(string5.trim().indexOf(32)).trim().toUpperCase();
                if (string7.trim().startsWith("PROPERTY.") || string7.trim().startsWith("PROPERTY*>") || string7.trim().indexOf(32) == -1 || this.isDataInvalid(string7.trim().substring(string7.trim().indexOf(32)))) return 0;
                return (short)n;
            }
            ++n;
            ++n2;
        }
        return 0;
    }

    private boolean getDivisionLine(String string, String string2, String string3) {
        int n;
        String string4 = string;
        String string5 = "";
        int n2 = 0;
        char c = '\u0000';
        int n3 = 0;
        int n4 = n = this.isStructuredFormat() != 1 && this.fromFile ? 6 : 0;
        if (n >= string4.length()) {
            return false;
        }
        if (this.isCommentLine(string4)) {
            return false;
        }
        n = this.skipSpace(string4, n);
        while (n3 < string4.length() - n) {
            if ((n = this.skipSpace(string4, n)) >= string4.length()) {
                return false;
            }
            c = string4.charAt(n);
            if ('\"' == c || '\'' == (c = string4.charAt(n))) {
                n = string4.indexOf(c);
                if (n == -1) {
                    return false;
                }
            } else {
                if ('*' == string4.charAt(n)) {
                    return false;
                }
                if (n + string2.length() >= string4.length()) {
                    return false;
                }
                if (this.isStructuredFormat() != 1) {
                    string5 = string4.substring(n, n + string2.length());
                    n2 = this.strncmpi(string5, string2);
                } else {
                    string5 = string4.substring(n);
                    n2 = this.isKeywordAvailableInLine(string5, string2);
                }
                if (n2 >= 0) {
                    if (' ' == string4.charAt(n += n2 + string2.length()) || '\t' == string4.charAt(n)) {
                        char c2;
                        ++n;
                        if ((n = this.skipSpace(string4, n)) + string3.length() > string4.length()) {
                            return false;
                        }
                        if (n + string3.length() == string4.length()) {
                            string4 = String.valueOf(string4) + " ";
                        }
                        if (this.strncmpi(string5 = string4.substring(n, n + string3.length()), string3) == 0 && (this.isSpace(c2 = string4.charAt(n += string3.length())) || this.isEOF(c2) || c2 == '.')) {
                            return n + 1 > 0;
                        }
                    }
                    return false;
                }
                return false;
            }
            ++n;
            ++n3;
        }
        return false;
    }

    public boolean isCommentLine(String string) {
        int n;
        String string2 = new String(string);
        char c = '\u0000';
        char c2 = '\u0000';
        int n2 = n = this.isStructuredFormat() != 1 && this.fromFile ? 6 : 0;
        if (n >= string2.length()) {
            return false;
        }
        c = string2.charAt(n);
        if (('*' == c || '/' == c) && this.isStructuredFormat() != 1) {
            return true;
        }
        if (this.isStructuredFormat() != 1) {
            ++n;
        }
        if ((n = this.skipSpace(string2, n)) + 1 >= string2.length()) {
            return false;
        }
        if ('*' == string.charAt(n)) {
            return true;
        }
        c2 = string2.charAt(n);
        return this.isCRNL(c2) || c2 == '\u0000';
    }

    public boolean isCommentAvailableInLine(String string) {
        return this.isCommentAvailableInLine(string, fCurrentFormat);
    }

    public boolean isCommentAvailableInLine(String string, String string2) {
        this.setProgramFormat(string2);
        return this.isCommentLine(string);
    }

    public boolean getProgramColumn(StringBuffer stringBuffer) {
        boolean bl = false;
        bl = this.getProgidColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        bl = this.getClassColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        bl = this.getMethodColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        bl = this.getFactoryColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        bl = this.getObjectColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        bl = this.getInherintanceColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        bl = this.getDivisionColumn(stringBuffer, "ENVIRONMENT");
        if (bl) {
            return bl;
        }
        bl = this.getDivisionColumn(stringBuffer, "DATA");
        if (bl) {
            return bl;
        }
        bl = this.getDivisionColumn(stringBuffer, "PROCEDURE");
        if (bl) {
            return bl;
        }
        bl = this.getDeclarativesColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        int n = 0;
        n = this.getSectionColumn(stringBuffer.toString());
        if (n > 0) {
            return true;
        }
        int n2 = 0;
        n2 = this.getParaColumn(stringBuffer.toString());
        return n2 > 0;
    }

    public boolean getEndProgramColumn(StringBuffer stringBuffer) {
        boolean bl = false;
        bl = this.getEndProgidColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        bl = this.getEndClassColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        bl = this.getEndMethodColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        bl = this.getEndFactoryColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        bl = this.getEndObjectColumn(stringBuffer);
        if (bl) {
            return bl;
        }
        return false;
    }

    public boolean isDivisionLine(String string, String string2, String string3) {
        return this.getDivisionLine(string, string2, string3);
    }

    public boolean isParagraphLine(String string, String string2) {
        short s = 0;
        s = this.getParagraphColumn(string, string2, false);
        return s > 0;
    }

    public boolean getProgidColumn(StringBuffer stringBuffer) {
        short s = 0;
        s = this.getParagraphColumn(stringBuffer.toString(), "PROGRAM-ID", true);
        return s > 0;
    }

    public boolean getEndProgidColumn(StringBuffer stringBuffer) {
        return this.getDivisionLine(stringBuffer.toString(), "END", "PROGRAM");
    }

    public boolean getClassColumn(StringBuffer stringBuffer) {
        short s = 0;
        s = this.getParagraphColumn(stringBuffer.toString(), "CLASS-ID", true);
        return s > 0;
    }

    public boolean getInherintanceColumn(StringBuffer stringBuffer) {
        short s = 0;
        s = this.getParagraphColumn(stringBuffer.toString(), "INHERITS", false);
        return s > 0;
    }

    public boolean getEndClassColumn(StringBuffer stringBuffer) {
        return this.getDivisionLine(stringBuffer.toString(), "END", "CLASS");
    }

    public boolean getMethodColumn(StringBuffer stringBuffer) {
        short s = 0;
        s = this.getParagraphColumn(stringBuffer.toString(), "METHOD-ID", true);
        return s > 0;
    }

    public boolean getEndMethodColumn(StringBuffer stringBuffer) {
        return this.getDivisionLine(stringBuffer.toString(), "END", "METHOD");
    }

    public boolean getFactoryColumn(StringBuffer stringBuffer) {
        short s = 0;
        s = this.getParagraphColumn(stringBuffer.toString(), "FACTORY", true);
        return s > 0;
    }

    public boolean getEndFactoryColumn(StringBuffer stringBuffer) {
        return this.getDivisionLine(stringBuffer.toString(), "END", "FACTORY");
    }

    public boolean getObjectColumn(StringBuffer stringBuffer) {
        short s = 0;
        s = this.getParagraphColumn(stringBuffer.toString(), "OBJECT", true);
        return s > 0;
    }

    public boolean getEndObjectColumn(StringBuffer stringBuffer) {
        return this.getDivisionLine(stringBuffer.toString(), "END", "OBJECT");
    }

    public boolean getDivisionColumn(StringBuffer stringBuffer, String string) {
        return this.getDivisionLine(stringBuffer.toString(), string, "DIVISION");
    }

    public boolean getDeclarativesColumn(StringBuffer stringBuffer) {
        short s = 0;
        s = this.getParagraphColumn(stringBuffer.toString(), "DECLARATIVES", true);
        return s > 0;
    }

    public boolean getEndDeclarativesColumn(StringBuffer stringBuffer) {
        return this.getDivisionLine(stringBuffer.toString(), "END", "DECLARATIVES");
    }

    private int checkSectionPara(int n, String string) {
        int n2 = this.strPt;
        int n3 = 0;
        n3 = n < n2 + 4 ? n : n2 + 4;
        String string2 = "";
        if (n3 >= n2) {
            string2 = string.substring(n2, n3).trim();
        }
        if (string2.length() <= 0) {
            return 0;
        }
        string2 = null;
        if (n >= n2) {
            string2 = string.substring(n2, n).trim();
        }
        if (string2 != null && string2.contains(" ")) {
            return 0;
        }
        string2 = null;
        n2 = this.strPt - 1;
        if (n >= n2) {
            string2 = string.substring(n2, n).trim();
        }
        if (this.isPara) {
            this.paraName = string2;
        } else {
            this.sectionName = string2;
        }
        if (string2 != null) {
            return string2.length();
        }
        return 0;
    }

    public int getSectionColumn(String string) {
        String string2;
        int n = this.isStructuredFormat() != 1 && this.fromFile ? 6 : 0;
        int n2 = (string = string.toUpperCase()).indexOf(" SECTION", n);
        if (n2 <= 0) {
            return 0;
        }
        this.isPara = false;
        int n3 = this.checkSectionPara(n2, string);
        if (n3 > 0 && !(string2 = (string = String.valueOf(string) + "          ").substring(6, string.indexOf(" SECTION")).trim()).contains(" ") && !string2.startsWith("*")) {
            String[] stringArray = "CONFIGURATION,INPUT-OUTPUT,FILE,WORKING-STORAGE,COMMON-STORAGE,LOCAL-STORAGE,LINKAGE".split(",");
            boolean bl = true;
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (string2.equalsIgnoreCase(stringArray[n4])) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) {
                sectionArr = sectionArr.length() <= 0 ? sectionArr.append(string2) : sectionArr.append("," + string2);
            }
        }
        return n3;
    }

    public int getParaColumn(String string) {
        String string2;
        if (!this.isParagraph) {
            this.isParagraph = true;
            return 0;
        }
        int n = this.isStructuredFormat() != 1 && this.fromFile ? 6 : 0;
        int n2 = (string = string.toUpperCase()).indexOf(".", n);
        if (n2 <= 0) {
            return 0;
        }
        this.isPara = true;
        int n3 = this.checkSectionPara(n2, string);
        if (n3 > 0 && !(string2 = (string = String.valueOf(string) + "          ").substring(6, string.indexOf(".")).trim()).contains(" ") && !string2.startsWith("*")) {
            String[] stringArray = "SOURCE-COMPUTER,OBJECT-COMPUTER,SPECIAL-NAMES,FILE-CONTROL,I-O-CONTROL".split(",");
            boolean bl = true;
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (string2.equalsIgnoreCase(stringArray[n4])) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) {
                paraArr = paraArr.length() <= 0 ? paraArr.append(string2) : paraArr.append("," + string2);
            }
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    private int skipSpace(String var1_1, int var2_2) {
        if (var2_2 < var1_1.length() && var2_2 >= 0) ** GOTO lbl5
        return var2_2;
lbl-1000:
        // 1 sources

        {
            if (var2_2 < var1_1.length()) continue;
            return var2_2;
lbl5:
            // 2 sources

            ** while (var2_2 >= 0 && this.isSpace((char)var1_1.charAt((int)var2_2)) && var2_2++ < var1_1.length())
        }
lbl6:
        // 1 sources

        return var2_2;
    }

    public int strncmpi(String string, String string2) {
        if (string.compareToIgnoreCase(string2) != 0) {
            return -1;
        }
        return 0;
    }

    public boolean isSpace(char c) {
        return ' ' == c || '\t' == c || '\r' == c || '\n' == c;
    }

    public boolean isCRNL(char c) {
        return '\r' == c || '\n' == c;
    }

    private boolean isEOF(char c) {
        return c == '\u001a';
    }

    private boolean isEndingWithComment(String string, String string2, char c) {
        if (string2.equalsIgnoreCase("OBJECT") || string2.equalsIgnoreCase("FACTORY")) {
            string = string.trim();
            if ('.' == c) {
                if (string.length() > (String.valueOf(string2) + '.').length()) {
                    String string3 = string;
                    string3 = string3.substring(string3.indexOf(".") + 1);
                    return this.isDataInvalid(string3);
                }
            } else if (string.length() > string2.length()) {
                String string4 = string;
                string4 = string4.substring(string2.length());
                return this.isDataInvalid(string4);
            }
        }
        return false;
    }

    private boolean isDataInvalid(String string) {
        return (string = string.trim()).startsWith("*>") || string.startsWith(".");
    }

    public void parseFile(IFile iFile) throws IOException {
        BufferedReader bufferedReader = null;
        this.fromFile = true;
        Element element = CBDTUiPlugin.getDefault().getCOBOLParserRegistry().getStartElement(iFile);
        if (element != null && element.getChildElements() != null) {
            this.startElement = element;
            return;
        }
        try {
            try {
                this.startElement = new Element();
                Element element2 = null;
                Element element3 = null;
                element3 = this.startElement;
                element3.setData("main");
                if (iFile.getLocation().toFile().exists()) {
                    if (!((Workspace)CBDTUiPlugin.getWorkspace()).isTreeLocked()) {
                        iFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                    bufferedReader = new BufferedReader(new InputStreamReader(iFile.getContents()));
                    this.fLineReader = new LineReader(bufferedReader);
                    LineWrapper lineWrapper = null;
                    String string = "";
                    int n = 0;
                    while ((lineWrapper = this.fLineReader.getNextLine()) != null) {
                        Element[] elementArray;
                        string = lineWrapper.line;
                        n = lineWrapper.lineno;
                        if (this.isCommentLine(string) || (elementArray = this.createElement(new StringBuffer(string), n, element2, element3)) == null || elementArray.length <= 0) continue;
                        element2 = elementArray[0];
                        element3 = elementArray[1];
                    }
                    bufferedReader.close();
                    CBDTUiPlugin.getDefault().getCOBOLParserRegistry().update(iFile, this.startElement);
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    public void parseDocument(IDocument iDocument) {
        if (iDocument == null) {
            return;
        }
        try {
            Object object;
            Object object2;
            this.wholeProg = iDocument.get().toUpperCase();
            String string = iDocument.getLineDelimiter(0);
            if (this.wholeProg != null && this.wholeProg.contains("PROCEDURE ")) {
                object2 = new StringBuilder();
                this.wholeProg = this.wholeProg.substring(this.wholeProg.indexOf("PROCEDURE ")).trim();
                if (string != null) {
                    object = this.wholeProg.split(string);
                    this.wholeProg = "";
                    int n = 0;
                    while (n < ((String[])object).length) {
                        if (object[n].length() > 7 && object[n].charAt(6) != '*') {
                            ((StringBuilder)object2).append(" " + object[n].replace(".", " ").replace(",", " "));
                        }
                        ++n;
                    }
                }
                this.wholeProg = ((StringBuilder)object2).toString();
            } else {
                this.wholeProg = null;
            }
            this.startElement = new Element();
            object2 = null;
            object = null;
            object = this.startElement;
            object.setData("main");
            this.fLineReader = new LineReader(iDocument);
            LineWrapper lineWrapper = null;
            String string2 = "";
            int n = 0;
            while ((lineWrapper = this.fLineReader.getNextLine()) != null) {
                Element[] elementArray;
                string2 = lineWrapper.line;
                n = lineWrapper.lineno;
                if (this.isCommentLine(string2) || (elementArray = this.createElement(new StringBuffer(string2), n, (Element)object2, (Element)object)) == null || elementArray.length <= 0) continue;
                object2 = elementArray[0];
                object = elementArray[1];
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private Element getParentProgram(Element element, int n) {
        while (element != null && element.getBlockType() != 10 && element.getBlockType() != 11 && element.getBlockType() != 12 && element.getBlockType() != 13 && element.getBlockType() != 14) {
            element.setEndLine(n - 1);
            Element element2 = element.getParent();
            if (element2 == null || element == element2) break;
            element = element2;
        }
        return element;
    }

    private Element getParentDivision(Element element, int n) {
        while (element != null && element.getBlockType() != 0 && element.getBlockType() != 1 && element.getBlockType() != 2 && element.getBlockType() != 3) {
            element.setEndLine(n - 1);
            Element element2 = element.getParent();
            if (element2 == null || element == element2) break;
            element = element2;
        }
        return element;
    }

    private Element getParentProcedure(Element element, int n) {
        while (element != null && element.getBlockType() != 2 && element.getBlockType() != 3) {
            element.setEndLine(n - 1);
            Element element2 = element.getParent();
            if (element2 == null || element == element2) break;
            element = element2;
        }
        return element;
    }

    private Element getParentSection(Element element, int n) {
        while (element != null && element.getBlockType() != 2 && element.getBlockType() != 4) {
            element.setEndLine(n - 1);
            Element element2 = element.getParent();
            if (element2 == null || element == element2) break;
            element = element2;
        }
        return element;
    }

    public Element[] createElement(StringBuffer stringBuffer, int n, Element element, Element element2) {
        Element[] elementArray = new Element[]{element, element2};
        if (!MemChecker.getInstance().hasEnoughMemory(false, false)) {
            return elementArray;
        }
        int n2 = this.isStructuredFormat() != 1 && this.fromFile ? 6 : 0;
        try {
            if (stringBuffer != null && stringBuffer.toString().length() > 0) {
                String string;
                if (this.getEndProgramColumn(stringBuffer)) {
                    element2 = this.getParentProgram(element2, n);
                    if (element == this.startElement) {
                        Integer n3 = new Integer(n);
                        if (!this.fUnusedEnds.contains(n3)) {
                            this.fUnusedEnds.add(n3);
                        }
                    } else {
                        if (element != null && element != this.startElement) {
                            element.setEndLine(n);
                            element = element2 = element.getParent();
                        } else if (element2 != this.startElement) {
                            element2.setEndLine(n);
                            element2 = element2.getParent();
                        }
                        if (this.fUnusedEnds.contains(new Integer(n))) {
                            this.fUnusedEnds.remove(new Integer(n));
                        }
                    }
                } else if (this.getEndDeclarativesColumn(stringBuffer)) {
                    if ((element2 = this.getParentProcedure(element2, n)).getBlockType() == 3) {
                        element2.setEndLine(n);
                        element2 = element2.getParent();
                    }
                } else if (this.getProgramColumn(stringBuffer)) {
                    if (element != null && element.getBlockType() == 14) {
                        return elementArray;
                    }
                    if (element == null && element2 != null && element2.getBlockType() == 14) {
                        return elementArray;
                    }
                    if (this.getProgidColumn(stringBuffer)) {
                        if (element != null) {
                            element2 = this.getParentProgram(element, n);
                        } else if (element2 != null) {
                            element2 = this.getParentProgram(element2, n);
                        }
                        element = new Element();
                        element.setBlockType(10);
                        element.setData(this.getProgramName(stringBuffer));
                        element.setStartLine(n);
                        int n4 = n;
                        n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                        element.setLineNumber(n);
                        if (n4 < n && this.getLineWrapper() != null && this.getLineWrapper().lineno == n) {
                            n4 = n;
                            stringBuffer = new StringBuffer(this.getLineWrapper().line.substring(n2));
                        }
                        String string2 = "";
                        string2 = this.getLiteralName(stringBuffer, 1);
                        if (string2.length() > 0) {
                            element.setLiteralName(string2);
                        }
                    } else if (this.getClassColumn(stringBuffer)) {
                        if (element != null) {
                            element2 = this.getParentProgram(element, n);
                        } else if (element2 != null) {
                            element2 = this.getParentProgram(element2, n);
                        }
                        element = new Element();
                        element.setBlockType(11);
                        element.setData(this.getProgramName(stringBuffer));
                        int n5 = n;
                        element.setStartLine(n);
                        n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                        element.setLineNumber(n);
                        if (n5 < n && this.getLineWrapper() != null && this.getLineWrapper().lineno == n) {
                            n5 = n;
                            stringBuffer = new StringBuffer(this.getLineWrapper().line.substring(n2));
                        }
                        String string3 = "";
                        string3 = this.getLiteralName(stringBuffer, 2);
                        if (string3.length() > 0) {
                            element.setLiteralName(string3);
                        }
                        int n6 = n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                        if (n5 < n && this.getLineWrapper() != null && this.getLineWrapper().lineno == n) {
                            stringBuffer = new StringBuffer(this.getLineWrapper().line.substring(n2));
                        }
                    } else if (this.getMethodColumn(stringBuffer)) {
                        if (element != null) {
                            element2 = this.getParentProgram(element, n);
                        } else if (element2 != null) {
                            element2 = this.getParentProgram(element2, n);
                        }
                        element = new Element();
                        element.setBlockType(14);
                        element.setData(this.getProgramName(stringBuffer));
                        element.setStartLine(n);
                        n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                        element.setLineNumber(n);
                    } else if (this.getFactoryColumn(stringBuffer)) {
                        if (element != null) {
                            element2 = this.getParentProgram(element, n);
                        } else if (element2 != null) {
                            element2 = this.getParentProgram(element2, n);
                        }
                        element = new Element();
                        element.setBlockType(12);
                        element.setData("FACTORY");
                        element.setStartLine(n);
                        n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                        element.setLineNumber(n);
                    } else if (this.getObjectColumn(stringBuffer)) {
                        if (element != null) {
                            element2 = this.getParentProgram(element, n);
                        } else if (element2 != null) {
                            element2 = this.getParentProgram(element2, n);
                        }
                        element = new Element();
                        element.setBlockType(13);
                        element.setData("OBJECT");
                        element.setStartLine(n);
                        n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                        element.setLineNumber(n);
                    } else {
                        if (this.getInherintanceColumn(stringBuffer)) {
                            return new Element[0];
                        }
                        if (this.getDivisionColumn(stringBuffer, "ENVIRONMENT")) {
                            if (element != null) {
                                element2 = this.getParentProgram(element, n);
                            } else if (element2 != null) {
                                element2 = this.getParentProgram(element2, n);
                            }
                            element = new Element();
                            element.setBlockType(0);
                            element.setData("ENVIRONMENT");
                            element.setStartLine(n);
                            n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                            element.setLineNumber(n);
                        } else if (this.getDivisionColumn(stringBuffer, "DATA")) {
                            if (element != null) {
                                element2 = this.getParentProgram(element, n);
                            } else if (element2 != null) {
                                element2 = this.getParentProgram(element2, n);
                            }
                            element = new Element();
                            element.setBlockType(1);
                            element.setData("DATA");
                            element.setStartLine(n);
                            n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                            element.setLineNumber(n);
                        } else if (this.getDivisionColumn(stringBuffer, "PROCEDURE")) {
                            if (element != null) {
                                element2 = this.getParentProgram(element, n);
                            } else if (element2 != null) {
                                element2 = this.getParentProgram(element2, n);
                            }
                            element = new Element();
                            element.setBlockType(2);
                            element.setData("PROCEDURE");
                            element.setStartLine(n);
                            n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                            element.setLineNumber(n);
                        } else if (this.getParagraphColumn(stringBuffer.toString(), "DECLARATIVES", true) > 0) {
                            if (element != null) {
                                element2 = this.getParentProcedure(element, n);
                            } else if (element2 != null) {
                                element2 = this.getParentProcedure(element2, n);
                            }
                            element = new Element();
                            element.setBlockType(3);
                            element.setData("DECLARATIVES");
                            element.setStartLine(n);
                            n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                            element.setLineNumber(n);
                        } else if (this.getSectionColumn(stringBuffer.toString()) > 0) {
                            if (element != null) {
                                element2 = this.getParentDivision(element, n);
                            } else if (element2 != null) {
                                element2 = this.getParentDivision(element2, n);
                            }
                            element = new Element();
                            element.setBlockType(4);
                            element.setData(this.sectionName);
                            element.setStartLine(n);
                            n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                            element.setLineNumber(n);
                        } else if (this.getParaColumn(stringBuffer.toString()) > 0) {
                            if (element != null) {
                                element2 = this.getParentSection(element, n);
                            } else if (element2 != null) {
                                element2 = this.getParentSection(element2, n);
                            }
                            element = new Element();
                            element.setBlockType(5);
                            element.setData(this.paraName);
                            element.setStartLine(n);
                            n = n < this.fLineReader.getCurrentLineNumber() ? this.fLineReader.getCurrentLineNumber() : n;
                            element.setLineNumber(n);
                        }
                    }
                    this.fLineMap.put(new Integer(element.getStartLine()), element);
                    if (element2 != null) {
                        element2.insertChildElement(element);
                        element.setParent(element2);
                    }
                } else if (stringBuffer.toString().length() > 10 && element2.getData().equalsIgnoreCase("DATA") && (string = stringBuffer.toString().substring(6).trim()).length() > 3 && "01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,66,77,88".contains(string.substring(0, 2)) && (string = string.substring(2)).startsWith(" ")) {
                    if (string.contains(".")) {
                        string = string.substring(0, string.indexOf("."));
                    }
                    if ((string = string.trim()).contains(" ")) {
                        string = string.substring(0, string.indexOf(" ")).trim();
                    }
                    if (varArr.length() <= 0) {
                        varArr.append(string);
                    } else {
                        varArr.append("," + string);
                    }
                    string = " " + string + " ";
                    if (this.wholeProg != null) {
                        if (!this.wholeProg.contains(string.toUpperCase())) {
                            this.appendToUnreferencedVarList(string);
                        }
                    } else {
                        this.appendToUnreferencedVarList(string);
                    }
                }
                elementArray[0] = element;
                elementArray[1] = element2;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return elementArray;
    }

    private void appendToUnreferencedVarList(String string) {
        string = string.trim();
        if (unreferencedVarArr.length() <= 0) {
            unreferencedVarArr.append(string);
        } else {
            unreferencedVarArr.append("," + string);
        }
    }

    public void parseFile(IFile iFile, IDocument iDocument) {
        this.fromFile = false;
        try {
            if (iDocument == null) {
                return;
            }
            this.startElement = new Element();
            Element element = null;
            Element element2 = null;
            element2 = this.startElement;
            element2.setData("main");
            this.fLineReader = new LineReader(iDocument);
            LineWrapper lineWrapper = null;
            String string = "";
            int n = 0;
            while ((lineWrapper = this.fLineReader.getNextLine()) != null) {
                Element[] elementArray;
                string = lineWrapper.line;
                n = lineWrapper.lineno;
                if (this.isCommentLine(string) || (elementArray = this.createElement(new StringBuffer(string), n, element, element2)) == null || elementArray.length <= 0) continue;
                element = elementArray[0];
                element2 = elementArray[1];
            }
            CBDTUiPlugin.getDefault().getCOBOLParserRegistry().update(iFile, this.startElement);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public boolean isValidLine(String string) {
        if (string.length() <= 6) {
            return false;
        }
        if ((string = string.substring(6)).length() < 1) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (this.isCRNL(string.charAt(i))) {
                continue;
            }
            return true;
        }
        return false;
    }

    public HashMap getElementLineMap() {
        return this.fLineMap;
    }

    public ArrayList getUnusedEndList() {
        return this.fUnusedEnds;
    }

    public boolean isElementValid(Element element, StringBuffer stringBuffer) {
        int n = element.getBlockType();
        boolean bl = false;
        switch (n) {
            case 10: {
                if (!this.getProgidColumn(stringBuffer)) break;
                element.setData(this.getProgramName(stringBuffer));
                element.setLiteralName("");
                String string = "";
                string = this.getLiteralName(stringBuffer, 1);
                if (string.length() > 0) {
                    element.setLiteralName(string);
                }
                bl = true;
                break;
            }
            case 11: {
                if (!this.getClassColumn(stringBuffer)) break;
                element.setData(this.getProgramName(stringBuffer));
                element.setLiteralName("");
                String string = "";
                string = this.getLiteralName(stringBuffer, 2);
                if (string.length() > 0) {
                    element.setLiteralName(string);
                }
                bl = true;
                break;
            }
            case 12: {
                if (!this.getFactoryColumn(stringBuffer)) break;
                bl = true;
                break;
            }
            case 13: {
                if (!this.getObjectColumn(stringBuffer)) break;
                bl = true;
                break;
            }
            case 14: {
                if (!this.getMethodColumn(stringBuffer)) break;
                element.setData(this.getProgramName(stringBuffer));
                bl = true;
                break;
            }
            case 0: {
                if (!this.getDivisionColumn(stringBuffer, "ENVIRONMENT")) break;
                bl = true;
                break;
            }
            case 1: {
                if (!this.getDivisionColumn(stringBuffer, "DATA")) break;
                bl = true;
                break;
            }
            case 2: {
                if (!this.getDivisionColumn(stringBuffer, "PROCEDURE")) break;
                bl = true;
                break;
            }
            case 3: {
                if (this.getParagraphColumn(stringBuffer.toString(), "DECLARATIVES", true) <= 0) break;
                bl = true;
                break;
            }
            case 4: {
                if (this.getSectionColumn(stringBuffer.toString()) <= 0) break;
                element.setData(this.sectionName);
                bl = true;
                break;
            }
            case 5: {
                if (this.getParaColumn(stringBuffer.toString()) <= 0) break;
                bl = true;
                break;
            }
            default: {
                this.getEndProgramColumn(stringBuffer);
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public String getProgramName(StringBuffer var1_1) {
        block11: {
            var2_2 = new StringBuffer("");
            var3_3 = "";
            var4_4 = 0;
            var5_5 = 0;
            var5_5 = this.getParagraphColumn(var1_1.toString(), "PROGRAM-ID", true);
            if (var5_5 == 0) {
                var5_5 = this.getParagraphColumn(var1_1.toString(), "CLASS-ID", true);
            }
            if (var5_5 != 0) break block11;
            var5_5 = this.getParagraphColumn(var1_1.toString(), "METHOD-ID", true);
            var3_3 = this.getValidLine(var1_1.toString(), var5_5);
            if (var3_3 != null && var3_3.trim().length() != 0) ** GOTO lbl15
            return var2_2.toString();
lbl-1000:
            // 1 sources

            {
                if (++var4_4 < var1_1.length()) continue;
                return var2_2.toString();
lbl15:
                // 2 sources

                ** while (var3_3.charAt((int)var4_4) == ' ' || var3_3.charAt((int)var4_4) == '\t')
            }
lbl16:
            // 1 sources

            if (var3_3.charAt(var4_4) == '\"') {
                ++var4_4;
            }
            if (var4_4 < var3_3.length()) ** GOTO lbl33
            return var2_2.toString();
lbl-1000:
            // 1 sources

            {
                if (var4_4 + 1 < var3_3.length() && var3_3.charAt(var4_4) == '*') {
                    return var2_2.toString().trim();
                }
                if (var3_3.charAt(var4_4) == ' ') {
                    if (!var3_3.substring(0, var3_3.indexOf(32)).trim().equalsIgnoreCase("GET") && !var3_3.substring(0, var3_3.indexOf(32)).trim().equalsIgnoreCase("SET") || !var3_3.substring(var3_3.indexOf(32)).trim().toUpperCase().startsWith("PROPERTY ") || this.isDataInvalid(var7_7 = (var6_6 = var3_3.substring(var3_3.toUpperCase().indexOf("PROPERTY "))).substring(var6_6.indexOf(32)).trim())) break;
                    var8_8 = 0;
                    while (var7_7.charAt(var8_8) != '\"' && var7_7.charAt(var8_8) != '.' && !this.isSpace(var7_7.charAt(var8_8)) && !this.isEOF(var7_7.charAt(var8_8))) {
                        if (var8_8 + 1 < var7_7.length() && var7_7.charAt(var8_8) == '*' || ++var8_8 >= var7_7.length()) break;
                    }
                    return var3_3.substring(0, var3_3.indexOf(var7_7) + var8_8);
                }
                var2_2.append(var3_3.charAt(var4_4));
                if (++var4_4 < var3_3.length()) continue;
                return var2_2.toString().trim();
lbl33:
                // 2 sources

                ** while (var3_3.charAt((int)var4_4) != '\"' && var3_3.charAt((int)var4_4) != '.' && !this.isSpace((char)var3_3.charAt((int)var4_4)) && !this.isEOF((char)var3_3.charAt((int)var4_4)))
            }
lbl34:
            // 2 sources

            return var2_2.toString().trim();
        }
        var3_3 = this.getValidLine(var1_1.toString(), var5_5);
        if (var3_3 != null && var3_3.trim().length() != 0) ** GOTO lbl41
        return var2_2.toString();
lbl-1000:
        // 1 sources

        {
            if (++var4_4 < var1_1.length()) continue;
            return var2_2.toString();
lbl41:
            // 2 sources

            ** while (var3_3.charAt((int)var4_4) == ' ' || var3_3.charAt((int)var4_4) == '\t')
        }
lbl42:
        // 1 sources

        if (var3_3.charAt(var4_4) == '\"') {
            ++var4_4;
        }
        if (var4_4 < var3_3.length()) ** GOTO lbl52
        return var2_2.toString();
lbl-1000:
        // 1 sources

        {
            if (var4_4 + 1 < var3_3.length() && var3_3.charAt(var4_4) == '*') {
                return var2_2.toString();
            }
            var2_2.append(var3_3.charAt(var4_4));
            if (++var4_4 < var3_3.length()) continue;
            return var2_2.toString();
lbl52:
            // 2 sources

            ** while (var3_3.charAt((int)var4_4) != '\"' && var3_3.charAt((int)var4_4) != '.' && !this.isSpace((char)var3_3.charAt((int)var4_4)) && !this.isEOF((char)var3_3.charAt((int)var4_4)))
        }
lbl53:
        // 1 sources

        return var2_2.toString();
    }

    /*
     * Unable to fully structure code
     */
    public String[] getInherintanceName(StringBuffer var1_1) {
        var2_2 = new StringBuffer("");
        var3_3 = "";
        var4_4 = 0;
        var5_5 = 0;
        var5_5 = this.getParagraphColumn(var1_1.toString(), "INHERITS", false);
        var3_3 = this.getValidLine(var1_1.toString(), var5_5 - 1);
        if (var3_3 != null && var3_3.trim().length() != 0) ** GOTO lbl11
        return this.toStringArray(var2_2.toString());
lbl-1000:
        // 1 sources

        {
            if (++var4_4 < var1_1.length()) continue;
            return this.toStringArray(var2_2.toString());
lbl11:
            // 2 sources

            ** while (var3_3.charAt((int)var4_4) == ' ' || var3_3.charAt((int)var4_4) == '\t')
        }
lbl12:
        // 1 sources

        if (var3_3.charAt(var4_4) == '\"') {
            ++var4_4;
        }
        if (var4_4 < var3_3.length()) ** GOTO lbl20
        return this.toStringArray(var2_2.toString());
lbl-1000:
        // 1 sources

        {
            var2_2.append(var3_3.charAt(var4_4));
            if (++var4_4 < var3_3.length()) continue;
            return this.toStringArray(var2_2.toString());
lbl20:
            // 2 sources

            ** while (var3_3.charAt((int)var4_4) != '\"' && var3_3.charAt((int)var4_4) != '.' && !this.isEOF((char)var3_3.charAt((int)var4_4)) && !this.isCRNL((char)var3_3.charAt((int)var4_4)))
        }
lbl21:
        // 1 sources

        return this.toStringArray(var2_2.toString());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLiteralName(StringBuffer var1_1, int var2_2) {
        var3_3 = new StringBuffer("");
        var4_4 = "";
        var5_5 = 0;
        var6_6 = 0;
        if (1 == var2_2) {
            var6_6 = this.getParagraphColumn(var1_1.toString(), "PROGRAM-ID", true);
        } else if (2 == var2_2) {
            var6_6 = this.getParagraphColumn(var1_1.toString(), "CLASS-ID", true);
        }
        var4_4 = this.getValidLine(var1_1.toString(), var6_6);
        if (var4_4 == null) return var3_3.toString();
        if (var4_4.trim().length() != 0) ** GOTO lbl16
        return var3_3.toString();
lbl-1000:
        // 1 sources

        {
            if (++var5_5 < var1_1.length()) continue;
            return "";
lbl16:
            // 2 sources

            ** while (var4_4.charAt((int)var5_5) == ' ' || var4_4.charAt((int)var5_5) == '\t')
        }
lbl17:
        // 1 sources

        if (var4_4.charAt(var5_5) == '\"') {
            ++var5_5;
        }
        if (var5_5 < var4_4.length()) ** GOTO lbl23
        return "";
lbl-1000:
        // 1 sources

        {
            if (++var5_5 < var4_4.length()) continue;
            return "";
lbl23:
            // 2 sources

            ** while (var4_4.charAt((int)var5_5) != '\"' && var4_4.charAt((int)var5_5) != '.' && !this.isSpace((char)var4_4.charAt((int)var5_5)) && !this.isEOF((char)var4_4.charAt((int)var5_5)))
        }
lbl24:
        // 1 sources

        try {
            block19: {
                var4_4 = this.getValidLine(var4_4, var5_5);
                var7_7 = this.skipSpace(var4_4, 0);
                if (var7_7 >= var4_4.length()) {
                    return "";
                }
                if (var4_4 != null && var4_4.length() < 2) {
                    return "";
                }
                var8_9 = var4_4.substring(var7_7, var7_7 + "AS".length());
                var9_10 = this.strncmpi(var8_9, "AS");
                if (var9_10 < 0) return "";
                if ((var7_7 += var9_10 + "AS".length()) == var4_4.length()) {
                    var4_4 = String.valueOf(var4_4) + " ";
                }
                if (this.isSpace(var10_11 = var4_4.charAt(var7_7)) || this.isCRNL(var10_11) || this.isEOF(var10_11) || '.' == var10_11) {
                    var7_7 = this.skipSpace(var4_4, var7_7);
                }
                ++var7_7;
                if (var5_5 >= var4_4.length()) {
                    return "";
                }
                var6_6 = (short)var7_7;
                var5_5 = 0;
                if ((var4_4 = this.getValidLine(var4_4, var6_6)) == null) return "";
                if (var4_4.trim().length() == 0) {
                    return "";
                }
                do {
                    if (var4_4.charAt(var5_5) == ' ' || var4_4.charAt(var5_5) == '\t') continue;
                    if (var4_4.charAt(var5_5) == '\"') {
                        ++var5_5;
                    }
                    if (var5_5 >= var4_4.length()) {
                        return "";
                    }
                    break block19;
                } while (++var5_5 < var1_1.length());
                return "";
            }
            var3_3 = new StringBuffer();
            do {
                if (var4_4.charAt(var5_5) == '\"') return var3_3.toString();
                if (var4_4.charAt(var5_5) == '.') return var3_3.toString();
                if (this.isSpace(var4_4.charAt(var5_5)) != false) return var3_3.toString();
                if (this.isEOF(var4_4.charAt(var5_5))) {
                    return var3_3.toString();
                }
                var3_3.append(var4_4.charAt(var5_5));
            } while (++var5_5 < var4_4.length());
            return "";
        }
        catch (Exception var7_8) {
            CBDTUiPlugin.logError(var7_8);
            return "";
        }
    }

    private String[] toStringArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer != null) {
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            String[] stringArray = new String[n];
            while (stringTokenizer.hasMoreTokens() && n2 < n) {
                stringArray[n2] = this.trim(stringTokenizer.nextToken());
                ++n2;
            }
            return stringArray;
        }
        return new String[0];
    }

    public String trim(String string) {
        if (string != null && string.length() > 1) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < string.length()) {
                if (!this.isSpace(string.charAt(n = n3++))) break;
            }
            n3 = string.length() - 1;
            while (n3 >= 0) {
                if (this.isSpace(string.charAt(n2 = n3--))) continue;
                ++n2;
                break;
            }
            if (n >= 0 && n2 >= 0 && n < string.length() && n2 <= string.length() && n < n2) {
                return string.substring(n, n2);
            }
        }
        return string;
    }

    public Element getStartElement() {
        return this.startElement;
    }

    public void setProgramFormat(String string) {
        fCurrentFormat = string;
    }

    public void setFromFile(boolean bl) {
        this.fromFile = bl;
    }

    public int isKeywordAvailableInLine(String string, String string2) {
        block6: {
            block7: {
                int n = 0;
                int n2 = 0;
                string = string.toUpperCase();
                n2 = string.indexOf("*");
                n = string.indexOf(string2);
                if (n == -1) break block6;
                if (n2 != -1 && n >= n2) break block7;
                if (n == 0) {
                    return n;
                }
                if (string.charAt(n - 1) == ' ' || string.charAt(n - 1) == '\t') {
                    return n;
                }
                return -1;
            }
            try {
                this.isParagraph = false;
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
        return -1;
    }

    public void disposeElements() {
        try {
            this.startElement.clearElements();
            this.startElement = null;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    private int isStructuredFormat() {
        if (fCurrentFormat != null) {
            if (fCurrentFormat.equals("FIXED")) {
                return 2;
            }
            if (fCurrentFormat.equals("VARIABLE")) {
                return 3;
            }
        }
        return 1;
    }

    private boolean isFreeFormat() {
        return fCurrentFormat.equals("FREE");
    }

    private boolean isDivisionFound(String string, int n) {
        char c;
        String string2 = string.substring(n, n + 8);
        return this.strncmpi(string2, "DIVISION") == 0 && (this.isSpace(c = string.charAt(n += "DIVISION".length())) || this.isCRNL(c) || this.isEOF(c) || '.' == c);
    }

    private String getTrimString(String string) {
        String string2 = "";
        string2 = this.isStructuredFormat() == 2 ? (this.fromFile ? (string.length() > 72 ? string.substring(0, 71) : string) : (string.length() > 66 ? string.substring(0, 65) : string)) : (this.isStructuredFormat() == 3 ? (this.fromFile ? (string.length() > 252 ? string.substring(0, 251) : string) : (string.length() > 246 ? string.substring(0, 245) : string)) : string);
        return string2;
    }

    private String getValidLine(String string, int n) {
        int n2;
        LineWrapper lineWrapper = null;
        String string2 = string;
        boolean bl = true;
        int n3 = n2 = this.isStructuredFormat() != 1 && this.fromFile ? 6 : 0;
        if (n >= string2.length()) {
            lineWrapper = this.fLineReader.getNextLine();
            this.setLineWrapper(lineWrapper);
            if (lineWrapper == null) {
                return null;
            }
            string2 = this.getTrimString(lineWrapper.line.substring(n2));
            n = 0;
        }
        while (bl) {
            if ((n = this.skipSpace(string2, n)) >= string2.length()) {
                lineWrapper = this.fLineReader.getNextLine();
                this.setLineWrapper(lineWrapper);
                if (lineWrapper == null) {
                    return string2;
                }
                string2 = this.getTrimString(lineWrapper.line.substring(n2));
                n = 0;
                continue;
            }
            n = n < 0 ? 0 : n;
            return string2.substring(n);
        }
        return string2;
    }

    public LineReader getLineReader() {
        return this.fLineReader;
    }

    public LineWrapper getLineWrapper() {
        return this.fLineWrapper;
    }

    public void setLineWrapper(LineWrapper lineWrapper) {
        this.fLineWrapper = lineWrapper;
    }

    public void dispose() {
        this.clear();
        this.fLineMap = null;
        this.fLineReader = null;
        this.fUnusedEnds = null;
        this.startElement = null;
    }

    private void clear() {
        if (this.fLineMap != null) {
            this.fLineMap.clear();
        }
        if (this.fLineReader != null) {
            this.fLineReader.dispose();
        }
        if (this.fUnusedEnds != null) {
            this.fUnusedEnds.clear();
        }
    }
}

