/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.outlineview;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.ICOBOLHelpContextId;
import org.eclipse.cobol.ui.common.EventData;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.editor.COBOLElementDeltaProcessor;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.outlineview.COBOLOutlineViewerSorter;
import org.eclipse.cobol.ui.views.outlineview.COBOLParser;
import org.eclipse.cobol.ui.views.outlineview.COBOLTreeContentProvider;
import org.eclipse.cobol.ui.views.outlineview.COBOLTreeLabelProvider;
import org.eclipse.cobol.ui.views.outlineview.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class COBOLContentOutlinePage
extends ContentOutlinePage {
    private IFile input;
    private COBOLParser cobolParser;
    private COBOLEditor cobolEditor;
    private IDocument document;
    private int lineOffset;
    private ISourceViewer sourceViewer;
    private TreeViewer viewer;
    private Action sortingAction;
    private Action filterAction;
    private boolean filterProcedureOnly;
    COBOLElementDeltaProcessor fDeltaProcessor = null;
    private ISelectionChangedListener fSingleClickListener;
    private static final String DOT = ".";
    private static final String HYPHEN = " - ";

    public COBOLContentOutlinePage(IFile iFile, COBOLEditor cOBOLEditor, ISourceViewer iSourceViewer) {
        try {
            this.cobolEditor = cOBOLEditor;
            this.sourceViewer = iSourceViewer;
            this.cobolParser = new COBOLParser();
            this.input = iFile;
            this.cobolParser.setProgramFormat(this.cobolEditor.getReferenceFormat());
            this.cobolParser.parseFile(iFile, this.cobolEditor.getCurrentSourceViewer().getDocument());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public COBOLContentOutlinePage(IDocument iDocument, COBOLEditor cOBOLEditor, ISourceViewer iSourceViewer) {
        try {
            this.cobolEditor = cOBOLEditor;
            this.sourceViewer = iSourceViewer;
            this.cobolParser = new COBOLParser();
            this.document = iDocument;
            this.cobolParser.setProgramFormat(this.cobolEditor.getReferenceFormat());
            this.cobolParser.parseDocument(iDocument);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public COBOLParser getCOBOLParser() {
        return this.cobolParser;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        try {
            this.viewer = this.getTreeViewer();
            this.viewer.setContentProvider((IContentProvider)new COBOLTreeContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new COBOLTreeLabelProvider());
            this.viewer.addFilter((ViewerFilter)new FilterSection());
            this.viewer.setInput((Object)this.cobolParser.getStartElement());
            this.viewer.expandAll();
            this.fDeltaProcessor = new COBOLElementDeltaProcessor(this.sourceViewer, this.cobolParser.getStartElement(), this.cobolParser, this.viewer);
            this.fDeltaProcessor.setElementLineMap(this.cobolParser.getElementLineMap());
            this.fDeltaProcessor.setUnusedEndList(this.cobolParser.getUnusedEndList());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        this.fSingleClickListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                COBOLContentOutlinePage.this.highlightCOBOLKeyWord();
                COBOLContentOutlinePage.this.handleSelectionChanged(selectionChangedEvent);
            }
        };
        this.viewer.addSelectionChangedListener(this.fSingleClickListener);
        this.registerToolbarActions();
        this.enableToolbar();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), ICOBOLHelpContextId.COBOL_OUTLINE_VIEW);
    }

    protected void handleSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        this.updateStatusLine(iStructuredSelection);
    }

    private void updateStatusLine(IStructuredSelection iStructuredSelection) {
        if (!(this.cobolEditor.getEditorInput() instanceof IFileEditorInput)) {
            return;
        }
        String string = ViewsUtil.setOSString(ViewsUtil.getStatusLineMessage(iStructuredSelection));
        if (iStructuredSelection.size() == 1) {
            IFile iFile = ((IFileEditorInput)this.cobolEditor.getEditorInput()).getFile();
            if (iFile == null || !iFile.exists()) {
                return;
            }
            String string2 = iFile.getProject().getName();
            String string3 = iFile.getName();
            int n = string3.indexOf(DOT);
            if (n == -1) {
                return;
            }
            string3 = string3.substring(0, n);
            string = String.valueOf(string3) + DOT + string + HYPHEN + string2;
        }
        this.getSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    public void update() {
        try {
            this.cobolParser.setProgramFormat(this.cobolEditor.getReferenceFormat());
            if (this.input == null) {
                this.cobolParser.parseDocument(this.document);
            } else {
                this.cobolParser.parseFile(this.input, this.cobolEditor.getCurrentSourceViewer().getDocument());
            }
            int n = this.cobolParser.getStartElement().getChildElements().size();
            if (n == 0) {
                if (this.sortingAction != null) {
                    this.sortingAction.setEnabled(false);
                }
            } else if (this.sortingAction != null) {
                this.sortingAction.setEnabled(true);
            }
            if (this.getTreeViewer().getContentProvider() != null) {
                this.getTreeViewer().setInput((Object)this.cobolParser.getStartElement());
                this.getTreeViewer().expandAll();
            }
            this.fDeltaProcessor.setRootElement(this.cobolParser.getStartElement());
            this.fDeltaProcessor.setElementLineMap(this.cobolParser.getElementLineMap());
            this.fDeltaProcessor.setUnusedEndList(this.cobolParser.getUnusedEndList());
            this.fDeltaProcessor.setLineReader(this.cobolParser.getLineReader());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public boolean deltaUpdate(final EventData eventData) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (eventData != null && COBOLContentOutlinePage.this.fDeltaProcessor != null) {
                    try {
                        COBOLContentOutlinePage.this.fDeltaProcessor.setEventData(eventData);
                        COBOLContentOutlinePage.this.fDeltaProcessor.processDelta();
                        COBOLContentOutlinePage.this.enableToolbar();
                    }
                    catch (Exception exception) {
                        CBDTUiPlugin.logError(exception);
                    }
                }
            }
        };
        try {
            Display.getDefault().syncExec(runnable);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        if (this.fDeltaProcessor != null) {
            return this.fDeltaProcessor.isModelAffected();
        }
        return false;
    }

    private void highlightCOBOLKeyWord() {
        try {
            ISelection iSelection = this.viewer.getSelection();
            Object[] objectArray = ((IStructuredSelection)iSelection).toArray();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            Element element = (Element)objectArray[0];
            this.document = this.sourceViewer.getDocument();
            this.lineOffset = this.document.getLineOffset(element.getLineNumber());
            int n = this.document.getLineLength(element.getLineNumber());
            String string = this.document.get(this.lineOffset, n);
            string = string.toUpperCase();
            n = element.getData().length();
            int n2 = -1;
            if (element.getBlockType() == 10 || element.getBlockType() == 11 || element.getBlockType() == 14) {
                String string2 = ViewsUtil.getKeyword(element);
                n2 = string.indexOf(string2);
                if (n2 >= 0) {
                    n2 = string.indexOf(element.getData().toUpperCase(), n2 + string2.length());
                }
            } else {
                n2 = string.indexOf(element.getData().toUpperCase());
            }
            if (n2 >= 0) {
                this.lineOffset += n2;
            }
            if (this.cobolEditor != null) {
                this.cobolEditor.selectAndReveal(this.lineOffset, n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            CBDTUiPlugin.logError(arrayIndexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private void enableToolbar() {
        int n = this.cobolParser.getStartElement().getChildElements().size();
        if (n == 0) {
            if (this.sortingAction != null) {
                this.sortingAction.setEnabled(false);
            }
        } else if (this.sortingAction != null) {
            this.sortingAction.setEnabled(true);
        }
    }

    private void registerToolbarActions() {
        IToolBarManager iToolBarManager = this.getSite().getActionBars().getToolBarManager();
        if (iToolBarManager != null) {
            this.sortingAction = new LexicalSortingAction();
            if (this.sortingAction != null) {
                iToolBarManager.add((IAction)this.sortingAction);
            }
            this.filterAction = new FilterSectionAction();
            iToolBarManager.add((IAction)this.filterAction);
        }
    }

    public void dispose() {
        try {
            this.input = null;
            if (this.cobolParser != null) {
                this.cobolParser.dispose();
                this.cobolParser = null;
            }
            this.cobolEditor = null;
            this.document = null;
            this.sourceViewer = null;
            if (this.viewer != null) {
                this.viewer.removeSelectionChangedListener(this.fSingleClickListener);
                this.fSingleClickListener = null;
                this.viewer = null;
            }
            if (this.fDeltaProcessor != null) {
                this.fDeltaProcessor.handleDispose();
                this.fDeltaProcessor = null;
            }
            this.sortingAction = null;
            super.dispose();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    private class FilterSection
    extends ViewerFilter {
        private FilterSection() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (COBOLContentOutlinePage.this.filterProcedureOnly) {
                int n;
                return !(object2 instanceof Element) || (n = ((Element)object2).getBlockType()) != 0 && n != 1;
            }
            return true;
        }
    }

    private class FilterSectionAction
    extends Action {
        public FilterSectionAction() {
            this.setText(Messages.getString((String)"COBOLContentOutlinePage.Filter.label"));
            COBOLPluginImages.setToolImageDescriptors((IAction)this, "ap5tre15p");
            boolean bl = CBDTUiPlugin.getDefault().getPreferenceStore().getBoolean("FilterSectionAction.isChecked");
            this.valueChanged(bl, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean bl, boolean bl2) {
            this.setChecked(bl);
            COBOLContentOutlinePage.this.filterProcedureOnly = bl;
            COBOLContentOutlinePage.this.getTreeViewer().refresh();
            this.setToolTipText(bl ? Messages.getString((String)"COBOLContentOutlinePage.Filter.tooltip.checked") : Messages.getString((String)"COBOLContentOutlinePage.Filter.tooltip.unchecked"));
            this.setDescription(bl ? Messages.getString((String)"COBOLContentOutlinePage.Filter.description.checked") : Messages.getString((String)"COBOLContentOutlinePage.Filter.description.unchecked"));
            if (bl2) {
                CBDTUiPlugin.getDefault().getPreferenceStore().setValue("FilterSectionAction.isChecked", bl);
            }
        }
    }

    private class LexicalSortingAction
    extends Action {
        public LexicalSortingAction() {
            this.setText(Messages.getString((String)"COBOLContentOutlinePage.Sort.label"));
            COBOLPluginImages.setToolImageDescriptors((IAction)this, "alphab_sort_co");
            boolean bl = CBDTUiPlugin.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(bl, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean bl, boolean bl2) {
            this.setChecked(bl);
            COBOLOutlineViewerSorter cOBOLOutlineViewerSorter = new COBOLOutlineViewerSorter();
            COBOLContentOutlinePage.this.viewer.setSorter((ViewerSorter)(bl ? cOBOLOutlineViewerSorter : null));
            this.setToolTipText(bl ? Messages.getString((String)"COBOLContentOutlinePage.Sort.tooltip.checked") : Messages.getString((String)"COBOLContentOutlinePage.Sort.tooltip.unchecked"));
            this.setDescription(bl ? Messages.getString((String)"COBOLContentOutlinePage.Sort.description.checked") : Messages.getString((String)"COBOLContentOutlinePage.Sort.description.unchecked"));
            if (bl2) {
                CBDTUiPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", bl);
            }
        }
    }
}

