/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.dependency;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.dependency.ResourceAndContainerGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class WizardNewFileCreationPage
extends WizardPage
implements Listener {
    private IStructuredSelection currentSelection = null;
    private IFile newFile = null;
    private String initialFileName = "";
    private IPath initialContainerFullPath = null;
    private boolean enable = true;
    private String projectNature = "";
    private Composite topLevel = null;
    private ResourceAndContainerGroup resourceGroup = null;
    private int fValidation = -1;
    private int TWO_THOUSAND = 2000;
    private int ONE_THOUSAND = 1000;
    private int fResourceFilter = -1;
    private boolean fAllowNewContainerName = true;

    public WizardNewFileCreationPage(String string, IStructuredSelection iStructuredSelection, boolean bl, String string2) {
        super(string);
        this.setPageComplete(false);
        this.projectNature = string2;
        this.currentSelection = iStructuredSelection;
        this.enable = bl;
    }

    public WizardNewFileCreationPage(String string, IStructuredSelection iStructuredSelection, boolean bl, String string2, int n) {
        super(string);
        this.setPageComplete(false);
        this.projectNature = string2;
        this.currentSelection = iStructuredSelection;
        this.enable = bl;
        this.fValidation = n;
    }

    public void createControl(Composite composite) {
        try {
            this.topLevel = new Composite(composite, 0);
            this.topLevel.setLayout((Layout)new GridLayout());
            this.topLevel.setLayoutData((Object)new GridData(272));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.topLevel, "org.eclipse.ui.ide.new_file_wizard_page_context");
            this.resourceGroup = new ResourceAndContainerGroup(this.topLevel, this, this.getNewFileLabel(), IDEWorkbenchMessages.WizardNewFileCreationPage_file, false, this.enable, this.projectNature, this.fResourceFilter, this.fAllowNewContainerName);
            this.resourceGroup.setAllowExistingResources(false);
            this.initialPopulateContainerNameField();
            if (this.initialFileName != null) {
                this.resourceGroup.setResource(this.initialFileName);
            }
            this.validatePage();
            this.setErrorMessage(null);
            this.setMessage(null);
            this.setControl((Control)this.topLevel);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    protected void createFile(IFile iFile, InputStream inputStream, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            if (inputStream == null) {
                inputStream = new ByteArrayInputStream(new byte[0]);
            }
            iFile.create(inputStream, false, iProgressMonitor);
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFile createFileHandle(IPath iPath) {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFile(iPath);
    }

    public IFile createNewFile() {
        if (this.newFile != null) {
            return this.newFile;
        }
        final IPath iPath = this.resourceGroup.getContainerFullPath();
        IPath iPath2 = iPath.append(this.resourceGroup.getResource());
        final IFile iFile = this.createFileHandle(iPath2);
        final InputStream inputStream = this.getInitialContents();
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
                try {
                    iProgressMonitor.beginTask(IDEWorkbenchMessages.WizardNewFileCreationPage_progress, WizardNewFileCreationPage.this.TWO_THOUSAND);
                    ContainerGenerator containerGenerator = new ContainerGenerator(iPath);
                    containerGenerator.generateContainer((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, WizardNewFileCreationPage.this.ONE_THOUSAND));
                    WizardNewFileCreationPage.this.createFile(iFile, inputStream, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, WizardNewFileCreationPage.this.ONE_THOUSAND));
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            CBDTUiPlugin.logError(interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError(invocationTargetException);
        }
        this.newFile = iFile;
        return this.newFile;
    }

    public IPath getContainerFullPath() {
        return this.resourceGroup.getContainerFullPath();
    }

    public String getFileName() {
        if (this.resourceGroup == null) {
            return this.initialFileName;
        }
        return this.resourceGroup.getResource();
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected String getNewFileLabel() {
        return IDEWorkbenchMessages.WizardNewFileCreationPage_fileLabel;
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected void initialPopulateContainerNameField() {
        try {
            if (this.initialContainerFullPath != null) {
                this.resourceGroup.setContainerFullPath(this.initialContainerFullPath);
            } else {
                Iterator iterator = this.currentSelection.iterator();
                if (iterator.hasNext()) {
                    Object e = iterator.next();
                    IResource iResource = null;
                    if (e instanceof IResource) {
                        iResource = (IResource)e;
                    } else if (e instanceof IAdaptable) {
                        iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class);
                    }
                    if (iResource != null) {
                        if (iResource.getType() == 1) {
                            iResource = iResource.getParent();
                        }
                        if (iResource.isAccessible()) {
                            this.resourceGroup.setContainerFullPath(iResource.getFullPath());
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void setContainerFullPath(IPath iPath) {
        if (this.resourceGroup == null) {
            this.initialContainerFullPath = iPath;
        } else {
            this.resourceGroup.setContainerFullPath(iPath);
        }
    }

    public void setFileName(String string) {
        if (this.resourceGroup == null) {
            this.initialFileName = string;
        } else {
            this.resourceGroup.setResource(string);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.resourceGroup.setFocus();
        }
    }

    public String getFolderName() {
        return this.resourceGroup.getFolderName();
    }

    protected boolean validatePage() {
        String string;
        boolean bl = true;
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus iStatus = iWorkspace.validateName(string = this.getFileName(), 1);
        if (!iStatus.isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        if (string.trim().endsWith(".java") || string.trim().endsWith(".JAVA")) {
            this.setErrorMessage(Messages.getString((String)"JavaFileCreationNotPossible"));
            return false;
        }
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            bl = false;
        }
        if (bl) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return bl;
    }
}

