/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.dependency;

import java.util.ArrayList;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class MinimizedFileSystemElement
extends FileSystemElement {
    private boolean populated = false;
    private String[] fExistingFiles = new String[0];

    MinimizedFileSystemElement(String string, FileSystemElement fileSystemElement, boolean bl) {
        super(string, fileSystemElement, bl);
    }

    public Object[] getFiles(IImportStructureProvider iImportStructureProvider) {
        if (!this.populated) {
            this.populate(iImportStructureProvider);
        }
        return super.getFiles().getChildren();
    }

    public Object[] getFolders(IImportStructureProvider iImportStructureProvider) {
        if (!this.populated) {
            this.populate(iImportStructureProvider);
        }
        return super.getFolders().getChildren();
    }

    boolean isPopulated() {
        return this.populated;
    }

    boolean notPopulated() {
        return !this.populated;
    }

    private void populate(IImportStructureProvider iImportStructureProvider) {
        Object object = this.getFileSystemObject();
        ArrayList arrayList = iImportStructureProvider.getChildren(object);
        if (arrayList == null) {
            arrayList = new ArrayList(1);
        }
        for (Object e : arrayList) {
            String string = iImportStructureProvider.getLabel(e);
            if (string.equalsIgnoreCase("build.xml")) continue;
            boolean bl = true;
            int n = 0;
            while (n < this.fExistingFiles.length) {
                if (string.equalsIgnoreCase(this.fExistingFiles[n])) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            MinimizedFileSystemElement minimizedFileSystemElement = new MinimizedFileSystemElement(string, this, iImportStructureProvider.isFolder(e));
            minimizedFileSystemElement.setFileSystemObject(e);
        }
        this.setPopulated();
    }

    void setPopulated() {
        this.populated = true;
    }

    public void setExistingFiles(ArrayList arrayList) {
        if (arrayList != null) {
            int n = arrayList.size();
            this.fExistingFiles = null;
            this.fExistingFiles = new String[n];
            int n2 = 0;
            while (n2 < n) {
                if (arrayList.get(n2) instanceof TreeElement) {
                    this.fExistingFiles[n2] = ((TreeElement)arrayList.get(n2)).getName();
                } else if (arrayList.get(n2) instanceof String) {
                    this.fExistingFiles[n2] = (String)arrayList.get(n2);
                }
                ++n2;
            }
        }
    }
}

