/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.dependency;

import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.common.COBOLResourceDeltaVisitor;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.TreeElementMapper;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchWindow;

public class DependencyViewContentProvider
implements ITreeContentProvider {
    private static DependencyViewContentProvider fDependencyViewContentProvider = null;
    private static ResourceListener resourceLisener;

    private DependencyViewContentProvider(TreeViewer treeViewer) {
        try {
            if (resourceLisener == null) {
                resourceLisener = new ResourceListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)resourceLisener, 15);
            }
            resourceLisener.setCurrentTreeViewer(treeViewer);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static DependencyViewContentProvider getDependencyViewContentProvider(TreeViewer treeViewer) {
        if (fDependencyViewContentProvider == null) {
            fDependencyViewContentProvider = new DependencyViewContentProvider(treeViewer);
        }
        return fDependencyViewContentProvider;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public Object[] getChildren(Object object) {
        TreeElement treeElement;
        ArrayList arrayList;
        if (object instanceof ViewsTreeModel) {
            if (((ViewsTreeModel)object).getRoot().hasChildren()) {
                return ((ViewsTreeModel)object).getRoot().getChildren().toArray();
            }
        } else if (object instanceof TreeElement && (arrayList = (treeElement = (TreeElement)object).getChildren()) != null && arrayList.size() != 0) {
            ArrayList<TreeElement> arrayList2 = new ArrayList<TreeElement>();
            int n = 0;
            while (n < arrayList.size()) {
                TreeElement treeElement2 = (TreeElement)arrayList.get(n);
                String string = (String)treeElement2.getProperties().get("TYPE");
                if (!(string.equals(IViewConstants.PROGRAM_ID_NAME) || string.equals(IViewConstants.CLASS_ID_NAME) || string.equals(IViewConstants.FACTORY_ID_NAME) || string.equals(IViewConstants.OBJECT_ID_NAME) || string.equals(IViewConstants.METHOD_ID_NAME) || string.equals(IViewConstants.REPOSITORY_FOLDER_NAME) || string.equals(IViewConstants.REPOSITORY_CLASS_NAME) || string.equals(IViewConstants.FACTORY_PROPERTY_NAME) || string.equals(IViewConstants.FACTORY_METHOD_NAME) || string.equals(IViewConstants.OBJECT_PROPERTY_NAME) || string.equals(IViewConstants.OBJECT_METHOD_NAME))) {
                    arrayList2.add(treeElement2);
                }
                ++n;
            }
            if (arrayList2.size() > 0) {
                return arrayList2.toArray();
            }
        }
        return new Object[0];
    }

    public Object getParent(Object object) {
        if (object instanceof TreeElement) {
            return ((TreeElement)object).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ViewsTreeModel) {
            return ((ViewsTreeModel)object).getRoot().hasChildren();
        }
        if (object instanceof TreeElement) {
            TreeElement treeElement = (TreeElement)object;
            ArrayList arrayList = treeElement.getChildren();
            if (arrayList != null && arrayList.size() > 0) {
                ArrayList<TreeElement> arrayList2 = new ArrayList<TreeElement>();
                int n = 0;
                while (n < arrayList.size()) {
                    TreeElement treeElement2 = (TreeElement)arrayList.get(n);
                    String string = (String)treeElement2.getProperties().get("TYPE");
                    if (!(string.equals(IViewConstants.PROGRAM_ID_NAME) || string.equals(IViewConstants.CLASS_ID_NAME) || string.equals(IViewConstants.FACTORY_ID_NAME) || string.equals(IViewConstants.OBJECT_ID_NAME) || string.equals(IViewConstants.METHOD_ID_NAME) || string.equals(IViewConstants.REPOSITORY_FOLDER_NAME) || string.equals(IViewConstants.REPOSITORY_CLASS_NAME) || string.equals(IViewConstants.FACTORY_PROPERTY_NAME) || string.equals(IViewConstants.FACTORY_METHOD_NAME) || string.equals(IViewConstants.OBJECT_PROPERTY_NAME) || string.equals(IViewConstants.OBJECT_METHOD_NAME))) {
                        arrayList2.add(treeElement2);
                    }
                    ++n;
                }
                if (arrayList2.size() > 0) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public void dispose() {
        resourceLisener.setCurrentTreeViewer(null);
    }

    protected void processDelta(IResourceChangeEvent iResourceChangeEvent, TreeViewer treeViewer) {
        TreeElementMapper.getInstance().updateMarker(iResourceChangeEvent);
        IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        if (iWorkbenchWindowArray != null && iWorkbenchWindowArray.length > 0) {
            try {
                iResourceChangeEvent.getDelta().accept((IResourceDeltaVisitor)new COBOLResourceDeltaVisitor());
            }
            catch (CoreException coreException) {}
        }
    }

    class ResourceListener
    implements IResourceChangeListener {
        private TreeViewer fCurrentTreeviwer;

        ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            if (iResourceChangeEvent.getSource() instanceof IWorkspace && iResourceChangeEvent.getDelta() != null) {
                DependencyViewContentProvider.this.processDelta(iResourceChangeEvent, this.fCurrentTreeviwer);
            }
        }

        public void setCurrentTreeViewer(TreeViewer treeViewer) {
            this.fCurrentTreeviwer = treeViewer;
        }

        public TreeViewer getCurrentTreeViewer() {
            return this.fCurrentTreeviwer;
        }
    }
}

