/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.dependency;

import org.eclipse.cobol.ui.views.actions.BuildActionGroup;
import org.eclipse.cobol.ui.views.actions.GoToActionGroup;
import org.eclipse.cobol.ui.views.actions.NewActionGroup;
import org.eclipse.cobol.ui.views.actions.OpenActionGroup;
import org.eclipse.cobol.ui.views.actions.PropertyActionGroup;
import org.eclipse.cobol.ui.views.actions.RefreshActionGroup;
import org.eclipse.cobol.ui.views.actions.ResourceActionGroup;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.TreeElementContributorResourceAdapter;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.ObjectActionContributorManager;

public class DependencyViewActionGroup
extends ActionGroup {
    private ActionGroup[] fActionGroups = null;
    private DependencyView fView = null;

    public DependencyViewActionGroup(DependencyView dependencyView) {
        this.fView = dependencyView;
        this.addGroup(new NewActionGroup((IViewPart)this.fView, "group.new"));
        this.addGroup(new BuildActionGroup((IViewPart)this.fView, "group.build"));
        this.addGroup(new OpenActionGroup((IViewPart)this.fView, "group.open"));
        this.addGroup(new GoToActionGroup((IViewPart)this.fView, "group.goto"));
        this.addGroup(new ResourceActionGroup((IViewPart)this.fView, "group.resource"));
        this.addGroup(new RefreshActionGroup((IViewPart)this.fView, "group.refresh"));
        this.addGroup(new PropertyActionGroup((IViewPart)this.fView, "group.properties"));
    }

    public void addGroup(ActionGroup actionGroup) {
        if (this.fActionGroups == null) {
            this.fActionGroups = new ActionGroup[]{actionGroup};
        } else {
            ActionGroup[] actionGroupArray = new ActionGroup[this.fActionGroups.length + 1];
            System.arraycopy(this.fActionGroups, 0, actionGroupArray, 0, this.fActionGroups.length);
            actionGroupArray[this.fActionGroups.length] = actionGroup;
            this.fActionGroups = actionGroupArray;
        }
    }

    public void setContext(ActionContext actionContext) {
        super.setContext(actionContext);
        int n = 0;
        while (this.fActionGroups != null && n < this.fActionGroups.length) {
            this.fActionGroups[n].setContext(actionContext);
            ++n;
        }
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        int n = 0;
        while (this.fActionGroups != null && n < this.fActionGroups.length) {
            this.fActionGroups[n].fillContextMenu(iMenuManager);
            ++n;
        }
        this.addObjectActions(iMenuManager);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        int n = 0;
        while (this.fActionGroups != null && n < this.fActionGroups.length) {
            this.fActionGroups[n].fillActionBars(iActionBars);
            ++n;
        }
    }

    public void dispose() {
        super.dispose();
        int n = 0;
        while (this.fActionGroups != null && n < this.fActionGroups.length) {
            this.fActionGroups[n].dispose();
            ++n;
        }
        this.fActionGroups = null;
        this.fView = null;
    }

    public void createStandardGroups(IMenuManager iMenuManager) {
        if (iMenuManager != null && !iMenuManager.isEmpty()) {
            return;
        }
        iMenuManager.add((IContributionItem)new Separator("group.new"));
        iMenuManager.add((IContributionItem)new Separator("group.open"));
        iMenuManager.add((IContributionItem)new Separator("group.goto"));
        iMenuManager.add((IContributionItem)new Separator("group.inherits"));
        iMenuManager.add((IContributionItem)new Separator("group.resource"));
        iMenuManager.add((IContributionItem)new Separator("group.build"));
        iMenuManager.add((IContributionItem)new Separator("group.insert"));
        iMenuManager.add((IContributionItem)new Separator("group.refresh"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("group.properties"));
    }

    private void addObjectActions(IMenuManager iMenuManager) {
        ISelectionProvider iSelectionProvider = this.fView.getViewSite().getSelectionProvider();
        if (iSelectionProvider != null) {
            TreeElementContributorResourceAdapter treeElementContributorResourceAdapter;
            Object object = ((StructuredSelection)iSelectionProvider.getSelection()).getFirstElement();
            if (object != null && object instanceof TreeElement && ((TreeElement)object).getAdapter(IContributorResourceAdapter.class) != null && (treeElementContributorResourceAdapter = (TreeElementContributorResourceAdapter)((TreeElement)object).getAdapter(IContributorResourceAdapter.class)).getAdaptedResource((IAdaptable)object) == null) {
                return;
            }
            if (ObjectActionContributorManager.getManager().contributeObjectActions((IWorkbenchPart)this.fView, iMenuManager, iSelectionProvider, null)) {
                iMenuManager.add((IContributionItem)new Separator());
            }
        }
    }
}

