/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.dependency;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferenceGeneralBlock;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.COBOLTreeLabelProvider;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.ProblemTreeViewer;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.TreeElementDragSourceAdapter;
import org.eclipse.cobol.ui.views.common.TreeElementDropTargetListener;
import org.eclipse.cobol.ui.views.common.TreeElementLabelProviderListener;
import org.eclipse.cobol.ui.views.common.TreeElementMapper;
import org.eclipse.cobol.ui.views.common.ViewsDoubleClickListener;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.dependency.DependencyFrameSource;
import org.eclipse.cobol.ui.views.dependency.DependencyViewActionGroup;
import org.eclipse.cobol.ui.views.dependency.DependencyViewContentProvider;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.MainActionGroup;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class DependencyView
extends ViewPart
implements IMenuListener,
ISetSelectionTarget,
IResourceNavigator {
    private DependencyFrameSource fFrameSource = null;
    private FrameList fFrameList = null;
    private IMemento fMemento;
    private TreeViewer fTreeViewer = null;
    private ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    private IDialogSettings settings;
    private static final String STORE_WORKING_SET = "ResourceWorkingSetFilter.STORE_WORKING_SET";
    private ResourcePatternFilter patternFilter = new ResourcePatternFilter();
    private static final String STORE_SORT_TYPE = "ResourceViewer.STORE_SORT_TYPE";
    private ResourceNavigatorActionGroup actionGroup;
    static final String COMMA_SEPARATOR = ",";
    static final String FILTERS_TAG = "resourceFilters";
    private static ViewsTreeModel fViewsTreeModel = null;
    private Control control = null;
    private Runnable fRunnable = null;
    private DependencyViewActionGroup fDependencyViewActionGroup = null;
    private Menu fContextMenu = null;
    private ViewsDoubleClickListener fDoubleClickListener = null;
    private DecoratingLabelProvider fDecoratingLabelProvider = null;
    private TreeElementLabelProviderListener fTreeElementLabelProviderListener = null;
    private boolean linkingEnabled;
    private boolean dragDetected;
    private Listener dragDetectListener;
    public IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof IEditorPart && COBOLEditorPreferenceGeneralBlock.isDependencyLink() && DependencyView.this.fTreeViewer != null) {
                ViewsUtil.editorActivated((IEditorPart)iWorkbenchPart, DependencyView.this.fTreeViewer, ViewsTreeModel.getInstance().getRoot());
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof IEditorPart && DependencyView.this.fTreeViewer != null && COBOLEditorPreferenceGeneralBlock.isDependencyLink()) {
                ViewsUtil.editorActivated((IEditorPart)iWorkbenchPart, DependencyView.this.fTreeViewer, ViewsTreeModel.getInstance().getRoot());
            }
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };

    public DependencyView() {
        if (fViewsTreeModel == null) {
            fViewsTreeModel = ViewsTreeModel.getInstance();
        }
        this.initLinkingEnabled();
    }

    private void initLinkingEnabled() {
        this.linkingEnabled = COBOLEditorPreferenceGeneralBlock.isDependencyLink();
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean bl) {
        this.linkingEnabled = bl;
        COBOLEditorPreferenceGeneralBlock.setDependencyLink(this.linkingEnabled);
    }

    public void createPartControl(Composite composite) {
        try {
            this.control = composite;
            this.fTreeViewer = new ProblemTreeViewer(composite, 770, this);
            this.fTreeViewer.setContentProvider((IContentProvider)DependencyViewContentProvider.getDependencyViewContentProvider(this.fTreeViewer));
            this.fDecoratingLabelProvider = new DecoratingLabelProvider((ILabelProvider)new COBOLTreeLabelProvider(), this.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator());
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fDecoratingLabelProvider);
            this.fTreeViewer.setInput(this.findInputElement());
            this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
            this.initFrameList();
            this.createActions();
            this.makeActions();
            this.fTreeViewer.addTreeListener(new ITreeViewerListener(){

                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                    if (treeExpansionEvent.getElement() != null && treeExpansionEvent.getElement() instanceof TreeElement) {
                        DependencyView.this.setExpansionProperty((TreeElement)treeExpansionEvent.getElement(), false);
                    }
                }

                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                    if (treeExpansionEvent.getElement() != null && treeExpansionEvent.getElement() instanceof TreeElement) {
                        DependencyView.this.setExpansionProperty((TreeElement)treeExpansionEvent.getElement(), true);
                    }
                }
            });
            this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    DependencyView.this.handleSelectionChanged(selectionChangedEvent);
                }
            });
            this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            iWorkbenchPage.addPartListener(this.partListener);
            this.refreshProjects();
            this.fTreeViewer.setExpandedState((Object)ViewsTreeModel.getInstance().getRoot(), true);
            Object[] objectArray = this.getExpandedNodes(ViewsTreeModel.getInstance().getRoot().getAllChildren());
            if (objectArray != null && objectArray.length > 0) {
                this.fTreeViewer.setExpandedElements(objectArray);
            }
            this.findInputElement();
            this.updateTitle();
            if (this.fTreeViewer != null) {
                this.fTreeViewer.refresh();
            }
            this.fDoubleClickListener = new ViewsDoubleClickListener(this.fTreeViewer);
            this.fTreeViewer.addDoubleClickListener((IDoubleClickListener)this.fDoubleClickListener);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cobol.ui.dependency_view");
            this.initDragAndDrop();
            this.fTreeElementLabelProviderListener = new TreeElementLabelProviderListener(this.getViewer());
            this.fDecoratingLabelProvider.addListener((ILabelProviderListener)this.fTreeElementLabelProviderListener);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public ResourceComparator getComparator() {
        return (ResourceComparator)this.fTreeViewer.getComparator();
    }

    public void setComparator(ResourceComparator resourceComparator) {
        this.fTreeViewer.setComparator((ViewerComparator)resourceComparator);
    }

    private Object[] getExpandedNodes(ArrayList arrayList) {
        Vector vector = new Vector(10);
        try {
            Object[] objectArray = this.getExpandedNodes(arrayList, vector);
            return objectArray;
        }
        catch (Exception exception) {
        }
        finally {
            if (vector != null && vector.size() > 0) {
                vector.clear();
            }
        }
        return vector.toArray();
    }

    private Object[] getExpandedNodes(ArrayList arrayList, Vector vector) {
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                if (((TreeElement)arrayList.get(n)).getAttribute("DV_EXPANDED").equalsIgnoreCase("TRUE") && ((TreeElement)arrayList.get(n)).getAttribute("OPENED").equalsIgnoreCase("TRUE") && SelectionAction.isProject((TreeElement)arrayList.get(n))) {
                    vector.add((TreeElement)arrayList.get(n));
                    this.getExpandedNodes(((TreeElement)arrayList.get(n)).getAllChildren(), vector);
                } else if (((TreeElement)arrayList.get(n)).getAttribute("DV_EXPANDED").equalsIgnoreCase("TRUE") && !SelectionAction.isProject((TreeElement)arrayList.get(n)) && ((TreeElement)arrayList.get(n)).hasChildren()) {
                    vector.add((TreeElement)arrayList.get(n));
                    this.getExpandedNodes(((TreeElement)arrayList.get(n)).getAllChildren(), vector);
                }
                ++n;
            }
        }
        return vector.toArray();
    }

    private void refreshProjects() {
        ArrayList arrayList = ViewsTreeModel.getInstance().getRoot().getAllChildrenOfType(IViewConstants.PROJECT_NAME);
        if (arrayList != null && arrayList.size() > 0) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            int n = 0;
            while (n < arrayList.size()) {
                TreeElement treeElement = (TreeElement)arrayList.get(n);
                IProject iProject = iWorkspace.getRoot().getProject(treeElement.getName());
                if (iProject != null && iProject.getLocation() != null && !iProject.isOpen()) {
                    treeElement.setAttribute("OPENED", "false");
                }
                ++n;
            }
        }
    }

    protected void handleSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        String string;
        final IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        this.updateStatusLine(iStructuredSelection);
        TreeElement treeElement = null;
        if (!(iStructuredSelection == null || iStructuredSelection.size() <= 0 || (string = (treeElement = (TreeElement)iStructuredSelection.getFirstElement()).getAttribute("TYPE")).equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string.equals("TARGET_OBJECT_FOLDER") || string.equals("TARGET_REPOSITORY_FOLDER"))) {
            this.dragDetected = false;
            if (this.isLinkingEnabled()) {
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!DependencyView.this.dragDetected) {
                            ViewsUtil.bringToTopEditor(iStructuredSelection);
                        }
                    }
                });
            }
        }
        if (iStructuredSelection != null) {
            this.refreshProjectMenuBar();
        }
    }

    private void updateStatusLine(IStructuredSelection iStructuredSelection) {
        String string = ViewsUtil.getStatusLineMessage(iStructuredSelection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    public Shell getShell() {
        return this.getViewSite().getShell();
    }

    public void setFocus() {
        try {
            if (this.fTreeViewer != null) {
                this.fTreeViewer.getTree().setFocus();
            }
        }
        catch (SWTException sWTException) {
            CBDTUiPlugin.logError((Exception)((Object)sWTException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        IMemento iMemento2 = null;
        iMemento2 = ViewsTreeModel.getDependencyViewMemento();
        super.init(iViewSite, iMemento2);
        this.fMemento = iMemento2;
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
        if (this.fDependencyViewActionGroup != null) {
            this.fDependencyViewActionGroup.dispose();
        }
        if (this.fDoubleClickListener != null) {
            this.fTreeViewer.removeDoubleClickListener((IDoubleClickListener)this.fDoubleClickListener);
            this.fDoubleClickListener = null;
        }
        TreeElementMapper.getInstance().clearMapper(this.getViewer());
        if (this.fTreeElementLabelProviderListener != null) {
            this.fTreeElementLabelProviderListener.dispose();
            this.fDecoratingLabelProvider.removeListener((ILabelProviderListener)this.fTreeElementLabelProviderListener);
        }
        if (this.fTreeViewer != null && this.fTreeViewer instanceof ProblemTreeViewer) {
            ((ProblemTreeViewer)this.fTreeViewer).dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(ISelectionProvider.class)) {
            return this.fTreeViewer;
        }
        return super.getAdapter(clazz);
    }

    private void createActions() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        this.fDependencyViewActionGroup = new DependencyViewActionGroup(this);
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        if (this.fDependencyViewActionGroup != null) {
            this.fDependencyViewActionGroup.createStandardGroups(iMenuManager);
            this.fDependencyViewActionGroup.setContext(new ActionContext(this.getViewer().getSelection()));
            this.fDependencyViewActionGroup.fillContextMenu(iMenuManager);
            this.fDependencyViewActionGroup.setContext(null);
        }
    }

    public void addProject(String string, String string2) {
        try {
            if (string2 != null) {
                if (fViewsTreeModel.getRoot().getChildFromName(string2) != null) {
                    return;
                }
                TreeElement treeElement = fViewsTreeModel.getRoot().addChild(string, string2, IViewConstants.PROJECT_NAME, false);
                treeElement.addChild(IViewConstants.SOURCE_FOLDER_VALUE, "SOURCE_FOLDER", "SOURCE_FOLDER", false);
                treeElement.addChild(IViewConstants.LINKING_FILES_FOLDER_VALUE, IViewConstants.LINKING_FILES_FOLDER_NAME, IViewConstants.LINKING_FILES_FOLDER_NAME, false);
                treeElement.addChild(IViewConstants.OTHER_FILES_FOLDER_VALUE, IViewConstants.OTHER_FILES_FOLDER_NAME, IViewConstants.OTHER_FILES_FOLDER_NAME, false);
                this.refreshAllViews();
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void refresh() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.refresh();
        }
    }

    private void refreshProjectMenuBar() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        iActionBars.updateActionBars();
        this.fDependencyViewActionGroup.fillActionBars(iActionBars);
    }

    public Runnable getRunnable() {
        try {
            if (this.fRunnable == null) {
                this.fRunnable = new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow[] iWorkbenchWindowArray = DependencyView.this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkbenchWindows();
                        int n = 0;
                        while (n < iWorkbenchWindowArray.length) {
                            IViewPart[] iViewPartArray = ViewsUtil.getViews(iWorkbenchWindowArray[n].getActivePage());
                            int n2 = 0;
                            while (n2 < iViewPartArray.length) {
                                IMenuListener iMenuListener;
                                if (iViewPartArray[n2] instanceof DependencyView) {
                                    iMenuListener = (DependencyView)iViewPartArray[n2];
                                    iMenuListener.refresh();
                                }
                                if (iViewPartArray[n2] instanceof StructuresView) {
                                    iMenuListener = (StructuresView)iViewPartArray[n2];
                                    iMenuListener.refresh();
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                };
            }
            return this.fRunnable;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    public void refreshAllViews() {
        try {
            IWorkbenchWindow[] iWorkbenchWindowArray = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkbenchWindows();
            if (iWorkbenchWindowArray.length > 0) {
                Display display = this.getSite().getShell().getDisplay();
                display.asyncExec(this.getRunnable());
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public String getToolTipText(Object object) {
        String string = "";
        if (object instanceof IResource) {
            IPath iPath = ((IResource)object).getFullPath();
            string = iPath.isRoot() ? "Dependency" : iPath.makeRelative().toOSString();
        }
        return string;
    }

    public void updateTitle() {
        IAdaptable iAdaptable = this.getSite().getPage().getInput();
        try {
            String string = this.getConfigurationElement().getAttribute("name");
            if (iAdaptable instanceof IWorkspace || iAdaptable instanceof IWorkspaceRoot) {
                this.setTitleAndToolTip(string, string);
            } else if (iAdaptable instanceof IContainer) {
                Object object;
                String string2 = "";
                if (iAdaptable instanceof IProject && (object = fViewsTreeModel.getRoot().getChildFromName(((IProject)iAdaptable).getName())) != null) {
                    string2 = ((Project)iAdaptable).getName();
                }
                object = string;
                if (!string2.equals("")) {
                    object = String.valueOf(object) + " : " + string2;
                    this.setTitleAndToolTip((String)object, string2);
                } else {
                    this.setTitleAndToolTip((String)object, (String)object);
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private void initFrameList() {
        try {
            this.fFrameSource = new DependencyFrameSource(this);
            this.fFrameList = new FrameList((IFrameSource)this.fFrameSource);
            this.fFrameSource.connectTo(this.fFrameList);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private Object findInputElement() {
        IAdaptable iAdaptable = this.getSite().getPage().getInput();
        if (iAdaptable instanceof IWorkspace || iAdaptable instanceof IWorkspaceRoot) {
            return fViewsTreeModel;
        }
        if (iAdaptable instanceof IContainer) {
            if (iAdaptable instanceof IProject) {
                TreeElement treeElement = fViewsTreeModel.getRoot().getChildFromName(((IProject)iAdaptable).getName());
                if (treeElement != null) {
                    return treeElement;
                }
            } else if (iAdaptable instanceof IFolder) {
                IProject iProject = ((IFolder)iAdaptable).getProject();
                TreeElement treeElement = fViewsTreeModel.getRoot().getChildFromName(iProject.getName());
                if (treeElement != null) {
                    return treeElement;
                }
            }
        }
        return fViewsTreeModel;
    }

    private void setExpansionProperty(TreeElement treeElement, boolean bl) {
        if (bl) {
            treeElement.setAttribute("DV_EXPANDED", "true");
        } else {
            treeElement.setAttribute("DV_EXPANDED", "false");
        }
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        Object[] objectArray = this.fTreeViewer.getExpandedElements();
        ISelection iSelection = this.fTreeViewer.getSelection();
        this.workingSetFilter.setWorkingSet(iWorkingSet);
        if (iWorkingSet != null) {
            this.settings.put(STORE_WORKING_SET, iWorkingSet.getName());
        }
        this.updateTitle();
        this.fTreeViewer.refresh();
        this.fTreeViewer.setExpandedElements(objectArray);
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            this.fTreeViewer.reveal(iStructuredSelection.getFirstElement());
        }
    }

    public TreeViewer getViewer() {
        return this.fTreeViewer;
    }

    public ResourcePatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSetFilter.getWorkingSet();
    }

    public ResourceSorter getSorter() {
        return (ResourceSorter)this.fTreeViewer.getSorter();
    }

    public void setSorter(ResourceSorter resourceSorter) {
        TreeViewer treeViewer = this.fTreeViewer;
        treeViewer.getControl().setRedraw(false);
        treeViewer.setSorter((ViewerSorter)resourceSorter);
        treeViewer.getControl().setRedraw(true);
        this.settings.put(STORE_SORT_TYPE, resourceSorter.getCriteria());
        this.updateActionBars((IStructuredSelection)treeViewer.getSelection());
    }

    protected void updateActionBars(IStructuredSelection iStructuredSelection) {
        this.getActionGroup().setContext(new ActionContext((ISelection)iStructuredSelection));
        this.getActionGroup().updateActionBars();
    }

    protected ResourceNavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public void setFiltersPreference(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(COMMA_SEPARATOR);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        this.getPlugin().getPreferenceStore().setValue(FILTERS_TAG, stringBuffer.toString());
    }

    public AbstractUIPlugin getPlugin() {
        return (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
    }

    public FrameList getFrameList() {
        return this.fFrameList;
    }

    protected void setActionGroup(ResourceNavigatorActionGroup resourceNavigatorActionGroup) {
        this.actionGroup = resourceNavigatorActionGroup;
    }

    protected void makeActions() {
        this.setActionGroup((ResourceNavigatorActionGroup)new MainActionGroup((IResourceNavigator)this));
    }

    public void selectReveal(ISelection iSelection) {
        StructuredSelection structuredSelection = this.convertSelection(iSelection);
        if (!structuredSelection.isEmpty()) {
            this.getViewer().getControl().setRedraw(false);
            this.getViewer().setSelection((ISelection)structuredSelection, true);
            this.getViewer().getControl().setRedraw(true);
        }
    }

    private StructuredSelection convertSelection(ISelection iSelection) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                IResource iResource = null;
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                } else if (e instanceof IAdaptable) {
                    iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class);
                }
                if (iResource == null) continue;
                arrayList.add(iResource);
            }
        }
        return new StructuredSelection(arrayList);
    }

    private void initDragAndDrop() {
        int n = 3;
        Transfer[] transferArray = new Transfer[]{FileTransfer.getInstance()};
        TreeElementDragSourceAdapter treeElementDragSourceAdapter = null;
        TreeViewer treeViewer = this.getViewer();
        treeElementDragSourceAdapter = new TreeElementDragSourceAdapter(treeViewer);
        treeViewer.addDragSupport(n, transferArray, (DragSourceListener)treeElementDragSourceAdapter);
        n = 19;
        DropTarget dropTarget = new DropTarget(treeViewer.getControl(), n);
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener((DropTargetListener)new TreeElementDropTargetListener(treeElementDragSourceAdapter, this.getViewer()));
    }

    private void setTitleAndToolTip(String string, String string2) {
        this.setTitle(string);
        this.setTitleToolTip(string2);
    }
}

