/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.dependency;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ContainerContentProvider
implements ITreeContentProvider {
    private Viewer viewer;
    private boolean showClosedProjects = true;
    private int fResourceFilter = -1;

    public void dispose() {
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IWorkspace) {
            Object[] objectArray = ((IWorkspace)object).getRoot().getProjects();
            if (this.showClosedProjects) {
                return objectArray;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n].isOpen()) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        if (object instanceof IContainer) {
            IContainer iContainer = (IContainer)object;
            if (iContainer.isAccessible()) {
                try {
                    ArrayList<IResource> arrayList = new ArrayList<IResource>();
                    IResource[] iResourceArray = iContainer.members();
                    int n = 0;
                    while (n < iResourceArray.length) {
                        if (iResourceArray[n].getType() != 1) {
                            arrayList.add(iResourceArray[n]);
                        }
                        ++n;
                    }
                    return arrayList.toArray();
                }
                catch (CoreException coreException) {
                    CBDTUiPlugin.logError((Exception)((Object)coreException));
                }
            }
        } else if (object instanceof Vector) {
            ArrayList<IProject> arrayList = new ArrayList<IProject>();
            int n = 0;
            while (n < ((Vector)object).size()) {
                IProject iProject = (IProject)((Vector)object).get(n);
                if (iProject.isOpen()) {
                    arrayList.add(iProject);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public Object getParent(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.viewer = viewer;
    }

    public boolean isDeleted(Object object) {
        return object instanceof IResource && !((IResource)object).exists();
    }

    public void showClosedProjects(boolean bl) {
        this.showClosedProjects = bl;
    }

    public void setResourceFilter(int n) {
        this.fResourceFilter = n;
    }
}

