/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.dependency;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.views.common.DialogUtil;
import org.eclipse.cobol.ui.views.dependency.BasicNewResourceWizard;
import org.eclipse.cobol.ui.views.dependency.WizardNewFileCreationPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class BasicNewFileResourceWizard
extends BasicNewResourceWizard {
    private WizardNewFileCreationPage fMainPage;
    private IFile fNewFile;
    private String fNodeType;
    private String fProjectName;

    public BasicNewFileResourceWizard(String string, String string2) {
        this.fNodeType = string2;
        this.fProjectName = string;
    }

    public void addPages() {
        super.addPages();
        this.fMainPage = new WizardNewFileCreationPage(Messages.getString((String)"DependencyView.NewFileCreationPage"), this.getSelection(), true, "org.eclipse.cobol.core.COBOLNature");
        this.fMainPage.setTitle(Messages.getString((String)"DependencyView.pageTile"));
        this.fMainPage.setDescription(Messages.getString((String)"DependencyView.pageDescription"));
        this.addPage((IWizardPage)this.fMainPage);
    }

    @Override
    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.setWindowTitle(Messages.getString((String)"DependencyView.NEW"));
        this.setNeedsProgressMonitor(true);
    }

    public IFile getNewFile() {
        return this.fNewFile;
    }

    @Override
    protected void initializeDefaultPageImageDescriptor() {
        try {
            ImageDescriptor imageDescriptor = COBOLPluginImages.DESC_IMG_FILE_WIZARD;
            this.setDefaultPageImageDescriptor(imageDescriptor);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public boolean performFinish() {
        String string = this.fMainPage.getFileName();
        if (string != null && !string.equals("")) {
            IFile iFile;
            if (this.fNodeType.equals("SOURCE_FOLDER")) {
                int n = string.lastIndexOf(".");
                if (string.length() > 0) {
                    if (n == -1) {
                        this.fMainPage.setFileName(String.valueOf(string) + ".cob");
                    } else if (string.length() <= n + 1) {
                        this.fMainPage.setFileName(String.valueOf(string) + ".cob");
                    }
                }
            }
            if (!this.fMainPage.validatePage()) {
                return false;
            }
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IProject iProject = iWorkspace.getRoot().getProject(this.fProjectName);
            if (iProject == null || iProject.getLocation() == null) {
                String[] stringArray = new String[]{Messages.getString((String)"Ok")};
                MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString((String)"ProjectDoesNotExist"), null, Messages.getString((String)"ProjectDoesNotExistMessage"), 2, stringArray, 0);
                messageDialog.open();
                return true;
            }
            String string2 = this.fMainPage.getContainerFullPath().toOSString();
            int n = string2.indexOf(iProject.toString()) + iProject.toString().length();
            String string3 = "";
            string3 = string2.length() > n + 1 ? String.valueOf(string2.substring(n + 1)) + File.separator + this.fMainPage.getFileName() : this.fMainPage.getFileName();
            IFile iFile2 = iProject.getFile(string3);
            if (iFile2.exists()) {
                String[] stringArray = new String[]{Messages.getString((String)"Ok")};
                MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString((String)"FileAlreadyPresent"), null, Messages.getString((String)"FileCannotBeCreatedMessage"), 2, stringArray, 0);
                messageDialog.open();
                return true;
            }
            this.fNewFile = iFile = this.fMainPage.createNewFile();
            if (iFile == null) {
                return false;
            }
            this.selectAndReveal((IResource)iFile);
            IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
            try {
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage != null) {
                    String string4;
                    IEditorDescriptor iEditorDescriptor = IDE.getDefaultEditor((IFile)iFile);
                    if (iEditorDescriptor == null) {
                        string4 = PlatformUI.getWorkbench().getEditorRegistry();
                        iEditorDescriptor = string4.findEditor("org.eclipse.ui.systemInPlaceEditor");
                    }
                    string4 = "org.eclipse.ui.systemExternalEditor";
                    if (iEditorDescriptor != null) {
                        string4 = iEditorDescriptor.getId();
                    }
                    iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), string4);
                }
            }
            catch (PartInitException partInitException) {
                DialogUtil.openError(iWorkbenchWindow.getShell(), Messages.getString((String)"DependencyView.errorMessage"), partInitException.getMessage(), partInitException);
                CBDTUiPlugin.logError((Exception)((Object)partInitException));
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
                return false;
            }
            return true;
        }
        return false;
    }
}

