/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.dependency;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.dependency.AddFilesResource;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.dependency.MinimizedFileSystemElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class AddFilesDialog
extends AddFilesResource
implements Listener {
    private Combo fSourceName;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private boolean fAddToSourceFolder = false;
    private String fProjectPath = "";
    private static final String SELECT_ALL_TITLE = Messages.getString((String)"SelectAll");
    private static final String DESELECT_ALL_TITLE = Messages.getString((String)"DeselectAll");
    private static final String SELECT_SOURCE_MESSAGE = Messages.getString((String)"SelectSource");
    private Shell fShell = null;
    private ArrayList fExistingFiles = new ArrayList();
    private String[] fListOfFilesSelected = null;

    public AddFilesDialog(Shell shell, boolean bl, String string, String string2, DependencyView dependencyView, ArrayList arrayList) {
        super(shell, string2);
        this.fShell = shell;
        this.fAddToSourceFolder = bl;
        this.fProjectPath = string;
        this.fExistingFiles = arrayList;
    }

    public AddFilesDialog(Shell shell, boolean bl, String string, String string2, ArrayList arrayList) {
        super(shell, string2);
        this.fShell = shell;
        this.fAddToSourceFolder = bl;
        this.fProjectPath = string;
        this.fExistingFiles = arrayList;
    }

    private Button createButton(Composite composite, String string) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        button.setLayoutData((Object)gridData);
        button.setText(string);
        return button;
    }

    private final void createButtonsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        this.fSelectAllButton = this.createButton(composite2, SELECT_ALL_TITLE);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddFilesDialog.this.setAllSelections(true);
            }
        };
        this.fSelectAllButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.fDeselectAllButton = this.createButton(composite2, DESELECT_ALL_TITLE);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddFilesDialog.this.setAllSelections(false);
            }
        };
        this.fDeselectAllButton.addSelectionListener((SelectionListener)selectionAdapter);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cobol.ui.dependency_view_add_file");
    }

    private void updateFromSourceField() {
        this.setSourceName(this.fSourceName.getText());
        this.selectionGroup.setFocus();
        this.updateWidgetEnablements();
    }

    private MinimizedFileSystemElement createRootElement(Object object, IImportStructureProvider iImportStructureProvider) {
        boolean bl = iImportStructureProvider.isFolder(object);
        String string = iImportStructureProvider.getLabel(object);
        MinimizedFileSystemElement minimizedFileSystemElement = new MinimizedFileSystemElement("", null, true);
        minimizedFileSystemElement.setPopulated();
        MinimizedFileSystemElement minimizedFileSystemElement2 = new MinimizedFileSystemElement(string, minimizedFileSystemElement, bl);
        minimizedFileSystemElement2.setFileSystemObject(object);
        minimizedFileSystemElement2.setExistingFiles(this.fExistingFiles);
        minimizedFileSystemElement2.getFiles(iImportStructureProvider);
        return minimizedFileSystemElement;
    }

    @Override
    protected void createSourceGroup(Composite composite) {
        try {
            this.createFileSelectionGroup(composite);
            this.createButtonsGroup(composite);
            if (this.fProjectPath != null && !this.fProjectPath.equals("")) {
                this.setSourceName(this.fProjectPath);
                this.selectionGroup.setFocus();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CBDTUiPlugin.logError(illegalArgumentException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    protected void enableButtonGroup(boolean bl) {
        try {
            this.fSelectAllButton.setEnabled(bl);
            this.fDeselectAllButton.setEnabled(bl);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    @Override
    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)object);
                    return minimizedFileSystemElement.getFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        File file;
        block4: {
            file = this.getSourceDirectory();
            if (file != null) break block4;
            return null;
        }
        try {
            return this.selectFiles(file, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    @Override
    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)object);
                    return minimizedFileSystemElement.getFolders((IImportStructureProvider)FileSystemStructureProvider.INSTANCE);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object object) {
                if (object instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)object);
                    if (minimizedFileSystemElement.isPopulated()) {
                        return this.getChildren((Object)minimizedFileSystemElement).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected File getSourceDirectory() {
        try {
            String string = "";
            string = this.fAddToSourceFolder ? this.fProjectPath : this.fSourceName.getText();
            return this.getSourceDirectory(string);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    private File getSourceDirectory(String string) {
        File file;
        block4: {
            file = new File(this.getSourceDirectoryName(string));
            if (file.exists() && file.isDirectory()) break block4;
            return null;
        }
        try {
            return file;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    private String getSourceDirectoryName(String string) {
        try {
            Path path = new Path(string.trim());
            path = path.getDevice() != null && path.segmentCount() == 0 ? path.addTrailingSeparator() : path.removeTrailingSeparator();
            return path.toOSString();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    protected void resetSelection() {
        try {
            MinimizedFileSystemElement minimizedFileSystemElement = this.getFileSystemTree();
            this.selectionGroup.setRoot((Object)minimizedFileSystemElement);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    protected MinimizedFileSystemElement selectFiles(final Object object, final IImportStructureProvider iImportStructureProvider) {
        try {
            final MinimizedFileSystemElement[] minimizedFileSystemElementArray = new MinimizedFileSystemElement[1];
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    minimizedFileSystemElementArray[0] = AddFilesDialog.this.createRootElement(object, iImportStructureProvider);
                }
            });
            return minimizedFileSystemElementArray[0];
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    @Override
    protected void setAllSelections(boolean bl) {
        try {
            super.setAllSelections(bl);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    protected void setSourceName(String string) {
        if (string.length() > 0) {
            if (!this.fAddToSourceFolder) {
                String[] stringArray = this.fSourceName.getItems();
                int n = -1;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equals(string)) {
                        n = n2;
                    }
                    ++n2;
                }
                if (n < 0) {
                    n2 = stringArray.length;
                    String[] stringArray2 = new String[n2 + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, n2);
                    stringArray2[n2] = string;
                    this.fSourceName.setItems(stringArray2);
                    n = n2;
                }
                this.fSourceName.select(n);
            }
            this.resetSelection();
        }
    }

    @Override
    protected void updateSelections(Map map) {
        try {
            super.updateSelections(map);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    @Override
    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
    }

    @Override
    protected boolean validateSourceGroup() {
        File file = this.getSourceDirectory();
        if (file == null) {
            this.enableButtonGroup(false);
            return false;
        }
        this.enableButtonGroup(true);
        return true;
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        super.createDialogArea(composite);
        this.validateSourceGroup();
        return composite;
    }

    protected void okPressed() {
        try {
            List list = this.getSelectedResources();
            int n = list.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                MinimizedFileSystemElement minimizedFileSystemElement = (MinimizedFileSystemElement)((Object)list.get(n2));
                if (!minimizedFileSystemElement.isDirectory()) {
                    stringArray[n2] = minimizedFileSystemElement.getFileSystemObject().toString();
                }
                ++n2;
            }
            this.fListOfFilesSelected = stringArray;
            this.close();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    protected void cancelPressed() {
        this.close();
    }

    public String[] getSelectedFiles() {
        return this.fListOfFilesSelected;
    }
}

