/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import java.io.IOException;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ui.XMLMemento;
import org.w3c.dom.Document;

class XMLMementoWrapper {
    private XMLMemento fXMLMemento = null;
    private Document fDocument = null;

    public XMLMementoWrapper(XMLMemento xMLMemento, Document document) {
        this.fXMLMemento = xMLMemento;
        this.fDocument = document;
    }

    public Document getDocument() {
        return this.fDocument;
    }

    public XMLMemento getXMLMemento() {
        return this.fXMLMemento;
    }

    public void save(Writer writer) throws IOException {
        try {
            StreamResult streamResult = new StreamResult(writer);
            DOMSource dOMSource = new DOMSource(this.fDocument);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw (IOException)new IOException().initCause(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw (IOException)new IOException().initCause(transformerException);
        }
    }
}

