/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cobol.core.build.BuildController;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.core.util.ValidateThreadUtil;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.views.common.COBOLResourceDeltaVisitor;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.ProblemTreeViewer;
import org.eclipse.cobol.ui.views.common.RemoteFile;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.XMLMementoWrapper;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.outlineview.COBOLParser;
import org.eclipse.cobol.ui.views.structures.RepositoryData;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ViewsUtil {
    private static COBOLParser fParser = null;
    private static Runnable fRunnable = null;
    public static final QualifiedName fMainKey = new QualifiedName("org.eclipse.cobol.ui.views.dependency", "MAIN_FILE");

    private ViewsUtil() {
    }

    public static File getViewsFile(boolean bl) {
        IPath iPath = CBDTUiPlugin.getDefault().getStateLocation();
        if (!(iPath = iPath.append("CBDTViews.xml")).toFile().exists() && !bl) {
            return null;
        }
        return iPath.toFile();
    }

    /*
     * Loose catch block
     */
    public static IMemento getMemento(File file) {
        XMLMemento xMLMemento = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            try {
                if (file != null) {
                    fileInputStream = new FileInputStream(file);
                    inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                    xMLMemento = XMLMemento.createReadRoot((Reader)inputStreamReader);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                CBDTUiPlugin.logError(fileNotFoundException);
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        CBDTUiPlugin.logError(iOException);
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        CBDTUiPlugin.logError(iOException);
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                block37: {
                    CBDTUiPlugin.logError(unsupportedEncodingException);
                    if (inputStreamReader == null) break block37;
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        CBDTUiPlugin.logError(iOException);
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        CBDTUiPlugin.logError(iOException);
                    }
                }
            }
            catch (Exception exception) {
                block38: {
                    CBDTUiPlugin.logError(exception);
                    if (inputStreamReader == null) break block38;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        CBDTUiPlugin.logError(iOException);
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        CBDTUiPlugin.logError(iOException);
                    }
                }
            }
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    CBDTUiPlugin.logError(iOException);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    CBDTUiPlugin.logError(iOException);
                }
            }
        }
        return xMLMemento;
    }

    public static RemoteFile[] getSelectedRemoteFiles(TreeViewer treeViewer) {
        try {
            ArrayList<RemoteFile> arrayList = null;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
            if (!iStructuredSelection.isEmpty()) {
                arrayList = new ArrayList<RemoteFile>();
                for (Object object : iStructuredSelection) {
                    if (!(object instanceof TreeElement)) continue;
                    arrayList.add(new RemoteFile((TreeElement)object));
                }
                if (arrayList != null && !arrayList.isEmpty()) {
                    Object object;
                    object = new RemoteFile[arrayList.size()];
                    arrayList.toArray((T[])object);
                    return object;
                }
            }
            return new RemoteFile[0];
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return new RemoteFile[0];
        }
    }

    public static TreeElement addChild(IMemento iMemento, TreeElement treeElement, boolean bl) {
        IMemento iMemento2 = iMemento.getChild("PROPERTIES");
        String string = iMemento2.getString("LOCATION");
        String string2 = iMemento2.getString("NAME");
        String string3 = iMemento2.getString("TYPE");
        if (treeElement != null) {
            TreeElement treeElement2 = treeElement.addChild(string, string2, string3, bl);
            String string4 = iMemento2.getString("OPENED");
            if (treeElement2 != null) {
                String string5;
                treeElement2.setAttribute("OPENED", string4);
                String string6 = iMemento2.getString("DV_EXPANDED");
                if (string6.equalsIgnoreCase("true")) {
                    treeElement2.setAttribute("DV_EXPANDED", "true");
                }
                if ((string6 = iMemento2.getString("SV_EXPANDED")).equalsIgnoreCase("true")) {
                    treeElement2.setAttribute("SV_EXPANDED", "true");
                }
                if ((string5 = iMemento2.getString("PROBLEMMARKER")) != null && string5.equalsIgnoreCase("ERROR")) {
                    treeElement2.setMarker(2);
                } else if (string5 != null && string5.equalsIgnoreCase("WARNING")) {
                    treeElement2.setMarker(1);
                } else {
                    treeElement2.setMarker(-1);
                }
            }
            return treeElement2;
        }
        return null;
    }

    public static TreeElement getSelection(TreeViewer treeViewer) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
        for (Object e : iStructuredSelection) {
            if (!(e instanceof TreeElement)) continue;
            return (TreeElement)e;
        }
        return null;
    }

    public static void restoreData(TreeElement treeElement, IMemento iMemento, boolean bl) {
        Object object;
        Object object2;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IMemento iMemento2 = iMemento.getChild("SOURCE_FOLDER");
        if (iMemento2 != null) {
            object2 = ViewsUtil.addChild(iMemento2, treeElement, bl);
            object = iMemento2.getChildren("SOURCE_FILE");
            if (object != null) {
                int n = 0;
                while (n < ((IMemento)object).length) {
                    IProject iProject;
                    IMemento[] iMementoArray;
                    TreeElement treeElement2;
                    TreeElement treeElement3 = ViewsUtil.addChild(object[n], (TreeElement)object2, bl);
                    IMemento iMemento3 = object[n].getChild("TARGET_REPOSITORY_FOLDER");
                    if (iMemento3 != null) {
                        treeElement2 = ViewsUtil.addChild(iMemento3, treeElement3, bl);
                        iMementoArray = iMemento3.getChildren("TARGET_FILES");
                        if (iMementoArray != null) {
                            int n2 = 0;
                            while (n2 < iMementoArray.length) {
                                ViewsUtil.addChild(iMementoArray[n2], treeElement2, bl);
                                ++n2;
                            }
                        }
                    }
                    if ((treeElement2 = object[n].getChild(IViewConstants.DEPENDENT_FILES_FOLDER_NAME)) != null) {
                        iMementoArray = ViewsUtil.addChild((IMemento)treeElement2, treeElement3, bl);
                        IMemento[] iMementoArray2 = treeElement2.getChildren(IViewConstants.DEPENDENT_FILES_NAME);
                        if (iMementoArray2 != null) {
                            int n3 = 0;
                            while (n3 < iMementoArray2.length) {
                                ViewsUtil.addChild(iMementoArray2[n3], (TreeElement)iMementoArray, bl);
                                ++n3;
                            }
                        }
                    }
                    if ((iMementoArray = object[n].getChild("TARGET_OBJECT_FOLDER")) != null) {
                        TreeElement treeElement4 = ViewsUtil.addChild((IMemento)iMementoArray, treeElement3, bl);
                        IMemento[] iMementoArray3 = iMementoArray.getChildren("TARGET_OBJECT_FILES");
                        if (iMementoArray3 != null && treeElement4 != null) {
                            int n4 = 0;
                            while (n4 < iMementoArray3.length) {
                                ViewsUtil.addChild(iMementoArray3[n4], treeElement4, bl);
                                ++n4;
                            }
                        }
                    }
                    if ((iProject = iWorkspace.getRoot().getProject(treeElement.getName())) != null && iProject.getLocation() != null && iProject.getLocation().toFile().exists()) {
                        ArrayList arrayList;
                        org.eclipse.cobol.ui.views.outlineview.Element element;
                        Object object3;
                        IFile iFile = null;
                        Path path = new Path(treeElement3.getLocation());
                        try {
                            if (path != null && path.getDevice() != null && path.getDevice().length() > 0) {
                                object3 = new RemoteFile(path.toOSString());
                                if (object3 != null) {
                                    iFile = ((RemoteFile)((Object)object3)).fFileToOpen;
                                }
                            } else {
                                object3 = iProject.findMember(path.removeFirstSegments(1).toString());
                                if (object3 != null && object3 instanceof IFile) {
                                    iFile = (IFile)object3;
                                }
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            CBDTUiPlugin.logError(fileNotFoundException);
                        }
                        catch (IOException iOException) {
                            CBDTUiPlugin.logError(iOException);
                        }
                        if (fParser == null) {
                            fParser = new COBOLParser();
                        }
                        object3 = ViewsUtil.getReferenceFormat();
                        fParser.setProgramFormat((String)object3);
                        fParser.setFromFile(true);
                        try {
                            if (iFile != null && iFile.exists()) {
                                fParser.parseFile(iFile);
                            }
                        }
                        catch (IOException iOException) {
                            CBDTUiPlugin.logError(iOException);
                        }
                        if ((element = fParser.getStartElement()) != null && (arrayList = element.getChildElements()) != null && arrayList.size() > 0) {
                            int n5 = 0;
                            while (n5 < arrayList.size()) {
                                ViewsUtil.traverseAndAdd(treeElement3, (org.eclipse.cobol.ui.views.outlineview.Element)arrayList.get(n5));
                                ++n5;
                            }
                        }
                    }
                    ++n;
                }
            }
        }
        if ((object2 = iMemento.getChild(IViewConstants.LINKING_FILES_FOLDER_NAME)) != null) {
            object = ViewsUtil.addChild(object2, treeElement, bl);
            IMemento[] iMementoArray = object2.getChildren(IViewConstants.LINKING_FILES_NAME);
            if (iMementoArray != null) {
                int n = 0;
                while (n < iMementoArray.length) {
                    ViewsUtil.addChild(iMementoArray[n], (TreeElement)object, bl);
                    ++n;
                }
            }
        }
        if ((object = iMemento.getChild(IViewConstants.OTHER_FILES_FOLDER_NAME)) != null) {
            TreeElement treeElement5 = ViewsUtil.addChild(object, treeElement, bl);
            ViewsUtil.addSubfolders(object, treeElement5);
            treeElement5.sortOtherFolders();
        }
        RepositoryData.populateRepositoryDataWithoutElement(treeElement);
    }

    private static void addSubfolders(IMemento iMemento, TreeElement treeElement) {
        IMemento[] iMementoArray = iMemento.getChildren(IViewConstants.OTHER_FILES_NAME);
        if (iMementoArray != null) {
            int n = 0;
            while (n < iMementoArray.length) {
                ViewsUtil.addChild(iMementoArray[n], treeElement, false);
                ++n;
            }
        }
        IMemento[] iMementoArray2 = iMemento.getChildren(IViewConstants.OTHER_FILES_SUBFOLDER_NAME);
        if (iMementoArray != null) {
            int n = 0;
            while (n < iMementoArray2.length) {
                TreeElement treeElement2 = ViewsUtil.addChild(iMementoArray2[n], treeElement, false);
                ViewsUtil.addSubfolders(iMementoArray2[n], treeElement2);
                ++n;
            }
        }
    }

    public static void traverseAndAdd(TreeElement treeElement, org.eclipse.cobol.ui.views.outlineview.Element element) {
        TreeElement treeElement2 = null;
        if (element != null && element.getData() != null) {
            Object object;
            int n = element.getBlockType();
            switch (n) {
                case 10: {
                    treeElement2 = treeElement.addChild(element.getData(), element.getData(), IViewConstants.PROGRAM_ID_NAME, false);
                    treeElement.sortTreeElements();
                    break;
                }
                case 11: {
                    treeElement2 = treeElement.addChild(element.getData(), element.getData(), IViewConstants.CLASS_ID_NAME, false);
                    treeElement.sortTreeElements();
                    break;
                }
                case 12: {
                    treeElement2 = treeElement.addChild(element.getData(), element.getData(), IViewConstants.FACTORY_ID_NAME, false);
                    break;
                }
                case 13: {
                    treeElement2 = treeElement.addChild(element.getData(), element.getData(), IViewConstants.OBJECT_ID_NAME, false);
                    treeElement.sortTreeElements();
                    break;
                }
                case 14: {
                    treeElement2 = treeElement.addChild(element.getData(), element.getData(), IViewConstants.METHOD_ID_NAME, false);
                    treeElement.sortTreeElements();
                    break;
                }
                case 0: {
                    treeElement2 = treeElement.addChild(element.getData(), element.getData(), IViewConstants.ENVIRONMENT_ID_NAME, false);
                    treeElement.sortTreeElements();
                    break;
                }
                case 1: {
                    treeElement2 = treeElement.addChild(element.getData(), element.getData(), IViewConstants.DATA_ID_NAME, false);
                    treeElement.sortTreeElements();
                    break;
                }
                case 2: {
                    treeElement2 = treeElement.addChild(element.getData(), element.getData(), IViewConstants.PROCEDURE_ID_NAME, false);
                    treeElement.sortTreeElements();
                    break;
                }
                case 3: {
                    treeElement2 = treeElement.addChild(element.getData(), element.getData(), IViewConstants.DECLARATIVES_ID_NAME, false);
                    treeElement.sortTreeElements();
                    break;
                }
                case 4: {
                    treeElement2 = element.getParent().getBlockType() == 0 || element.getParent().getBlockType() == 1 ? treeElement.addChild(element.getData(), element.getData(), IViewConstants.SECTION_ID_NAME, false) : treeElement.addChild(element.getData(), element.getData(), IViewConstants.STATEMENT_ID_NAME, false);
                    treeElement.sortTreeElements();
                }
            }
            if (treeElement2.getAttribute("TYPE").equals(IViewConstants.CLASS_ID_NAME)) {
                String string;
                object = null;
                if (object != null && ((ArrayList)object).size() > 0) {
                    treeElement2.setAttribute("INHERINTANCE", ((ArrayList)object).toArray(new String[((ArrayList)object).size()]));
                }
                if ((string = element.getLiteralName()) != null && string.length() > 0) {
                    treeElement2.setLiteralName(string);
                }
            }
            if (treeElement2.getAttribute("TYPE").equals(IViewConstants.PROGRAM_ID_NAME) && (object = element.getLiteralName()) != null && ((String)object).length() > 0) {
                treeElement2.setLiteralName((String)object);
            }
            treeElement2.setAttribute("LINE_NUMBER", element.getLineNumber());
            object = element.getChildElements();
            if (object != null && ((ArrayList)object).size() > 0) {
                int n2 = 0;
                while (n2 < ((ArrayList)object).size()) {
                    ViewsUtil.traverseAndAdd(treeElement2, (org.eclipse.cobol.ui.views.outlineview.Element)((ArrayList)object).get(n2));
                    ++n2;
                }
            }
        }
    }

    public static synchronized void saveState(TreeViewer treeViewer) {
        XMLMementoWrapper xMLMementoWrapper = ViewsUtil.createWriteRoot("CDBT_VIEW");
        XMLMemento xMLMemento = xMLMementoWrapper.getXMLMemento();
        ViewsTreeModel viewsTreeModel = ViewsTreeModel.getInstance();
        if (viewsTreeModel != null) {
            block25: {
                TreeElement treeElement = viewsTreeModel.getRoot();
                if (treeElement != null) {
                    ViewsUtil.saveData(treeElement, (IMemento)xMLMemento, treeViewer);
                    File file = ViewsUtil.getViewsFile(true);
                    FileOutputStream fileOutputStream = null;
                    OutputStreamWriter outputStreamWriter = null;
                    try {
                        try {
                            fileOutputStream = new FileOutputStream(file);
                            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                            xMLMementoWrapper.save(outputStreamWriter);
                        }
                        catch (IOException iOException) {
                            file.delete();
                            CBDTUiPlugin.logError("Error while saving the view", iOException);
                            if (outputStreamWriter != null) {
                                try {
                                    outputStreamWriter.close();
                                }
                                catch (IOException iOException2) {
                                    CBDTUiPlugin.logError(iOException2);
                                }
                            }
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException3) {
                                    CBDTUiPlugin.logError(iOException3);
                                }
                            }
                            break block25;
                        }
                    }
                    catch (Throwable throwable) {
                        if (outputStreamWriter != null) {
                            try {
                                outputStreamWriter.close();
                            }
                            catch (IOException iOException) {
                                CBDTUiPlugin.logError(iOException);
                            }
                        }
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException iOException) {
                                CBDTUiPlugin.logError(iOException);
                            }
                        }
                        throw throwable;
                    }
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (IOException iOException) {
                            CBDTUiPlugin.logError(iOException);
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            CBDTUiPlugin.logError(iOException);
                        }
                    }
                }
            }
            viewsTreeModel.setDirty(false);
        }
        xMLMemento = null;
        xMLMementoWrapper = null;
    }

    private static void saveData(TreeElement treeElement, IMemento iMemento, TreeViewer treeViewer) {
        if (treeElement.hasChildren()) {
            int n = treeElement.sizeOfChildren();
            int n2 = 0;
            while (n2 < n) {
                try {
                    TreeElement treeElement2 = (TreeElement)treeElement.getAllChildren().get(n2);
                    String string = treeElement2.getAttribute("TYPE");
                    if (!(string.equals(IViewConstants.CLASS_ID_NAME) || string.equals(IViewConstants.PROGRAM_ID_NAME) || string.equals(IViewConstants.OBJECT_ID_NAME) || string.equals(IViewConstants.OBJECT_METHOD_NAME) || string.equals(IViewConstants.OBJECT_PROPERTY_NAME) || string.equals(IViewConstants.FACTORY_ID_NAME) || string.equals(IViewConstants.FACTORY_METHOD_NAME) || string.equals(IViewConstants.FACTORY_PROPERTY_NAME) || string.equals(IViewConstants.REPOSITORY_FOLDER_NAME))) {
                        IMemento iMemento2 = iMemento.createChild(treeElement2.getAttribute("TYPE"));
                        ViewsUtil.addProperties(iMemento2, treeElement2);
                        ViewsUtil.saveData(treeElement2, iMemento2, treeViewer);
                    }
                }
                catch (DOMException dOMException) {
                    CBDTUiPlugin.logError(dOMException);
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                }
                ++n2;
            }
        }
    }

    private static void addProperties(IMemento iMemento, TreeElement treeElement) {
        try {
            IMemento iMemento2 = iMemento.createChild("PROPERTIES");
            HashMap hashMap = treeElement.getProperties();
            for (String string : hashMap.keySet()) {
                if (!(hashMap.get(string) instanceof String)) continue;
                iMemento2.putString(string, (String)hashMap.get(string));
            }
            if (treeElement.getMarker() == 2) {
                iMemento2.putString("PROBLEMMARKER", "ERROR");
            } else if (treeElement.getMarker() == 1) {
                iMemento2.putString("PROBLEMMARKER", "WARNING");
            } else {
                iMemento2.putString("PROBLEMMARKER", "FALSE");
            }
        }
        catch (RuntimeException runtimeException) {
            CBDTUiPlugin.logError(runtimeException);
        }
    }

    public static void parseAndAdd(String string, TreeElement treeElement) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(string);
        if (iProject == null || iProject.getLocation() == null) {
            return;
        }
        IFile iFile = iProject.getFile(treeElement.getLocation());
        if (iFile == null || !iFile.exists()) {
            return;
        }
        if (!CommonBuildUtil.isSourceFileSupported((IProject)iProject, (String)iFile.getName())) {
            return;
        }
        String string2 = ViewsUtil.getReferenceFormat();
        if (fParser == null) {
            fParser = new COBOLParser();
        }
        fParser.setProgramFormat(string2);
        try {
            fParser.parseFile(iFile);
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        org.eclipse.cobol.ui.views.outlineview.Element element = fParser.getStartElement();
        if (treeElement.hasChildren()) {
            treeElement.deleteChildren();
        }
        if (element != null) {
            int n = element.getChildElements().size();
            ArrayList arrayList = element.getChildElements();
            int n2 = 0;
            while (n2 < n) {
                ViewsUtil.traverseAndAdd(treeElement, (org.eclipse.cobol.ui.views.outlineview.Element)arrayList.get(n2));
                ++n2;
            }
        }
    }

    public static void addItem(String string, String string2, String string3, String string4) {
        if (ViewsTreeModel.getInstance() != null) {
            try {
                TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
                if (treeElement != null && string4.equals("SOURCE_FILE")) {
                    if (treeElement.getChildFromName("SOURCE_FOLDER").getChildFromLocation(string2) != null) {
                        return;
                    }
                    TreeElement treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER").addChild(string2, string3, string4, true);
                    ViewsUtil.parseAndAdd(string, treeElement2);
                } else if (string4.equals("TARGET_FILES")) {
                    treeElement.getChildFromName("TARGET_REPOSITORY_FOLDER").addChild(string2, string3, string4, false);
                } else if (string4.equals(IViewConstants.DEPENDENT_FILES_NAME)) {
                    treeElement.getChildFromName(IViewConstants.DEPENDENT_FILES_FOLDER_NAME).addChild(string2, string3, string4, false);
                } else if (string4.equals(IViewConstants.LINKING_FILES_NAME)) {
                    treeElement.getChildFromName(IViewConstants.LINKING_FILES_FOLDER_NAME).addChild(string2, string3, string4, false);
                } else if (string4.equals(IViewConstants.OTHER_FILES_NAME)) {
                    treeElement.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME).addChild(string2, string3, string4, false);
                }
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    public static void addItemInPos(String string, String string2, String string3, String string4, int n) {
        if (ViewsTreeModel.getInstance() != null) {
            try {
                TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
                if (treeElement != null && string4.equals("SOURCE_FILE")) {
                    if (treeElement.getChildFromName("SOURCE_FOLDER").getChildFromLocation(string2) != null) {
                        return;
                    }
                    TreeElement treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER").addChildInPos(string2, string3, string4, n);
                    ViewsUtil.parseAndAdd(string, treeElement2);
                } else if (string4.equals("TARGET_FILES")) {
                    treeElement.getChildFromName("TARGET_REPOSITORY_FOLDER").addChildInPos(string2, string3, string4, n);
                } else if (string4.equals(IViewConstants.DEPENDENT_FILES_NAME)) {
                    treeElement.getChildFromName(IViewConstants.DEPENDENT_FILES_FOLDER_NAME).addChildInPos(string2, string3, string4, n);
                } else if (string4.equals(IViewConstants.LINKING_FILES_NAME)) {
                    treeElement.getChildFromName(IViewConstants.LINKING_FILES_FOLDER_NAME).addChildInPos(string2, string3, string4, n);
                } else if (string4.equals(IViewConstants.OTHER_FILES_NAME)) {
                    treeElement.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME).addChildInPos(string2, string3, string4, n);
                }
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    public static void deleteFile(String string, String string2, String string3) {
        if (ViewsTreeModel.getInstance() != null) {
            try {
                TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
                TreeElement treeElement2 = null;
                if (string3.equals("SOURCE_FILE")) {
                    treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER").getChildFromLocation(string2);
                } else if (string3.equals(IViewConstants.OTHER_FILES_NAME)) {
                    treeElement2 = treeElement.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME).getChildFromLocation(string2);
                } else if (string3.equals(IViewConstants.LINKING_FILES_NAME)) {
                    treeElement2 = treeElement.getChildFromName(IViewConstants.LINKING_FILES_FOLDER_NAME).getChildFromLocation(string2);
                } else if (string3.equals(IViewConstants.PROJECT_NAME)) {
                    treeElement2 = treeElement;
                }
                if (treeElement2 != null) {
                    TreeElement treeElement3 = treeElement2.getParent();
                    treeElement2.deleteChildren();
                    treeElement3.deleteChild(treeElement2);
                }
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    public static void renameFile(String string, String string2, String string3, String string4) {
        try {
            if (!string4.equals(IViewConstants.PROJECT_NAME)) {
                TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
                TreeElement treeElement2 = null;
                if (treeElement != null) {
                    if (string4.equals("SOURCE_FILE")) {
                        treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER");
                    } else if (string4.equals(IViewConstants.LINKING_FILES_NAME)) {
                        treeElement2 = treeElement.getChildFromName(IViewConstants.LINKING_FILES_FOLDER_NAME);
                    } else if (string4.equals(IViewConstants.OTHER_FILES_NAME)) {
                        treeElement2 = treeElement.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
                    }
                    Path path = new Path(string2);
                    treeElement2 = treeElement2.getChildFromLocation(string2);
                    if (path != null && path.getDevice() != null && path.getDevice().length() > 0 && path.segmentCount() > 0) {
                        string3 = path.segment(path.segmentCount() - 1);
                    }
                    treeElement2.setAttribute("LOCATION", string2);
                    treeElement2.setAttribute("NAME", string3);
                    ViewsUtil.parseAndAdd(string, treeElement2);
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void editorActivated(IEditorPart iEditorPart, TreeViewer treeViewer, TreeElement treeElement) {
        if (treeViewer == null) {
            return;
        }
        TreeElement treeElement2 = ViewsUtil.getSelection(treeViewer);
        if (treeElement2 == null) {
            return;
        }
        try {
            IFileEditorInput iFileEditorInput;
            IFile iFile;
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput && (iFile = (iFileEditorInput = (IFileEditorInput)iEditorInput).getFile()) != null && iFile.exists()) {
                Object object;
                String string = iFile.getFullPath().toString();
                if (string.startsWith(String.valueOf('/'))) {
                    string = string.substring(1);
                }
                if ((treeElement2.getAttribute("TYPE").equals(IViewConstants.PROGRAM_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.CLASS_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.OBJECT_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.FACTORY_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.METHOD_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.ENVIRONMENT_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.DATA_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.PROCEDURE_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.DECLARATIVES_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.SECTION_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.STATEMENT_ID_NAME) || treeElement2.getAttribute("TYPE").equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || treeElement2.getAttribute("TYPE").equals("TARGET_OBJECT_FOLDER") || treeElement2.getAttribute("TYPE").equals("TARGET_REPOSITORY_FOLDER")) && ((TreeElement)(object = ViewsUtil.getFileNode(ViewsUtil.getSelection(treeViewer)))).getLocation().equals(string)) {
                    return;
                }
                if (treeViewer.getSelection() == null || treeViewer.getSelection().isEmpty() || iFile.getProject() == null) {
                    return;
                }
                if (!ViewsUtil.getSelection(treeViewer).getLocation().equals(string)) {
                    object = iFile.getProject().getName();
                    TreeElement treeElement3 = treeElement.getChildFromName((String)object);
                    String string2 = iFile.getFullPath().toString();
                    if (treeElement3 == null) {
                        return;
                    }
                    TreeElement treeElement4 = treeElement3.getChildFromName("SOURCE_FOLDER").getChildFromLocation(string2.substring(1));
                    if (treeElement4 == null) {
                        return;
                    }
                    StructuredSelection structuredSelection = new StructuredSelection((Object)treeElement4);
                    if (!treeViewer.getSelection().equals(structuredSelection)) {
                        treeViewer.setSelection((ISelection)structuredSelection);
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private static TreeElement getFileNode(TreeElement treeElement) {
        if (treeElement.getAttribute("TYPE").equals("SOURCE_FILE")) {
            return treeElement;
        }
        return ViewsUtil.getFileNode(treeElement.getParent());
    }

    public static boolean isWindows() {
        return SWT.getPlatform().equalsIgnoreCase("win32");
    }

    public static boolean openFileInEditor(IWorkbenchPage iWorkbenchPage, IFile iFile) {
        Shell shell = null;
        shell = iWorkbenchPage != null ? iWorkbenchPage.getActivePart().getSite().getShell() : new Shell();
        try {
            if (iFile != null) {
                String string;
                IEditorDescriptor iEditorDescriptor = IDE.getDefaultEditor((IFile)iFile);
                if (iEditorDescriptor == null) {
                    string = PlatformUI.getWorkbench().getEditorRegistry();
                    iEditorDescriptor = string.findEditor("org.eclipse.ui.systemInPlaceEditor");
                }
                string = "org.eclipse.ui.systemExternalEditor";
                if (iEditorDescriptor != null) {
                    string = iEditorDescriptor.getId();
                }
                iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), string);
                return true;
            }
        }
        catch (PartInitException partInitException) {
            ViewsUtil.displayFileNotOpenableMessage(shell, partInitException.getMessage());
            return false;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return false;
        }
        return false;
    }

    public static String getActualFileName(String string, String string2) {
        try {
            int n = string.lastIndexOf(string2);
            string = string.substring(0, n);
            File file = new File(String.valueOf(string) + string2);
            string = file.getCanonicalPath();
            return string;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    public static void displayFileNotOpenableMessage(Shell shell, String string) {
        String[] stringArray = new String[]{Messages.getString((String)"Ok")};
        MessageDialog messageDialog = new MessageDialog(shell, Messages.getString((String)"FileOpenError"), null, string, 1, stringArray, 0);
        messageDialog.open();
    }

    public static String getFileLocation(String string, String string2, TreeElement treeElement) {
        String string3 = treeElement.getProject().getAbsolutePath();
        int n = string2.indexOf(string3);
        if (ViewsUtil.isWindows()) {
            n = string2.toUpperCase().indexOf(string3.toUpperCase());
        }
        if (n == -1) {
            return String.valueOf(string2) + File.separator + string;
        }
        if (string2.length() != string3.length()) {
            return String.valueOf(string2.substring(n + string3.length() + 1)) + File.separator + string;
        }
        return string;
    }

    public static TreeElement[] getAllSelection(TreeViewer treeViewer) {
        TreeElement[] treeElementArray = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
        Iterator iterator = iStructuredSelection.iterator();
        treeElementArray = new TreeElement[iStructuredSelection.size()];
        int n = 0;
        try {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof TreeElement)) continue;
                treeElementArray[n] = (TreeElement)e;
                ++n;
            }
            return treeElementArray;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return null;
    }

    public static IEditorPart[] getEditors(IWorkbenchPage iWorkbenchPage) {
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        IEditorPart[] iEditorPartArray = new IEditorPart[n];
        int n2 = 0;
        while (n2 < n) {
            iEditorPartArray[n2] = iEditorReferenceArray[n2].getEditor(false);
            ++n2;
        }
        return iEditorPartArray;
    }

    public static IViewPart[] getViews(IWorkbenchPage iWorkbenchPage) {
        if (iWorkbenchPage != null) {
            IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
            int n = iViewReferenceArray.length;
            IViewPart[] iViewPartArray = new IViewPart[n];
            int n2 = 0;
            while (n2 < n) {
                iViewPartArray[n2] = iViewReferenceArray[n2].getView(false);
                ++n2;
            }
            return iViewPartArray;
        }
        IViewPart[] iViewPartArray = new IViewPart[]{};
        return iViewPartArray;
    }

    public static String getReferenceFormat() {
        return CBDTUiPlugin.getDefault().getPreferenceStore().getString("Reference Format");
    }

    public static void displayUnsupportedSourceMessage(String string) {
        if (string != null && string.length() > 0) {
            String[] stringArray = new String[]{Messages.getString((String)"Ok")};
            Shell shell = CBDTUiPlugin.getActiveWorkbenchShell();
            if (shell == null) {
                return;
            }
            String string2 = "";
            if (string.indexOf(".") != -1) {
                string2 = string.substring(string.indexOf("."));
            }
            String string3 = MessageFormat.format(Messages.getString((String)"ViewsActionUtil.BuildNotSupported.message"), string2, string);
            MessageDialog messageDialog = new MessageDialog(shell, Messages.getString((String)"ViewsActionUtil.BuildNotSupported.title"), null, string3, 4, stringArray, 0);
            messageDialog.open();
        }
    }

    public static void compileSourceFile(Shell shell, final IFile iFile) {
        if (iFile == null) {
            return;
        }
        final IProject iProject = iFile.getProject();
        if (iProject == null) {
            return;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                BuildController buildController = new BuildController(iProject, iProgressMonitor);
                String string = iFile.getName();
                if (CommonBuildUtil.isSourceFileSupported((IProject)iProject, (String)string)) {
                    buildController.compileCobolSourceFile(iFile);
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            CBDTUiPlugin.logError(interruptedException);
        }
    }

    public static String getStatusLineMessage(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IResource) {
                return ((IResource)object).getFullPath().makeRelative().toString();
            }
            if (object instanceof TreeElement) {
                return ((TreeElement)object).getStatusDisplayPath();
            }
            if (object instanceof org.eclipse.cobol.ui.views.outlineview.Element) {
                return ((org.eclipse.cobol.ui.views.outlineview.Element)object).getPath();
            }
            return ResourceNavigatorMessages.getString((String)"ResourceNavigator.oneItemSelected");
        }
        if (iStructuredSelection.size() > 1) {
            return ResourceNavigatorMessages.format((String)"ResourceNavigator.statusLine", (Object[])new Object[]{new Integer(iStructuredSelection.size())});
        }
        return "";
    }

    public static String setOSString(String string) {
        if (ViewsUtil.isWindows() && string != null) {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    public static void updateOtherViews() {
        try {
            IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
            if (iWorkbenchWindowArray.length > 0) {
                Display.getDefault().asyncExec(ViewsUtil.getRunnable());
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static Runnable getRunnable() {
        try {
            if (fRunnable == null) {
                fRunnable = new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                        int n = 0;
                        while (n < iWorkbenchWindowArray.length) {
                            IViewPart[] iViewPartArray = ViewsUtil.getViews(iWorkbenchWindowArray[n].getActivePage());
                            int n2 = 0;
                            while (n2 < iViewPartArray.length) {
                                IMenuListener iMenuListener;
                                if (iViewPartArray[n2] instanceof DependencyView) {
                                    iMenuListener = (DependencyView)iViewPartArray[n2];
                                    iMenuListener.refresh();
                                }
                                if (iViewPartArray[n2] instanceof StructuresView) {
                                    iMenuListener = (StructuresView)iViewPartArray[n2];
                                    iMenuListener.refresh();
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                };
            }
            return fRunnable;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    public static void refreshTreeViewer(final TreeViewer treeViewer, boolean bl) {
        if (treeViewer != null) {
            if (treeViewer.getControl() != null) {
                treeViewer.getControl().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        treeViewer.refresh();
                    }
                });
            }
        } else if (bl) {
            ViewsUtil.saveState(null);
        }
    }

    public static IEditorPart getEditorPart(IStructuredSelection iStructuredSelection) {
        IFile iFile = null;
        if (iStructuredSelection == null) {
            return null;
        }
        if (iStructuredSelection.getFirstElement() instanceof TreeElement && ((TreeElement)iStructuredSelection.getFirstElement()).getFile().getAdapter(IResource.class) != null && ((TreeElement)iStructuredSelection.getFirstElement()).getFile().getAdapter(IResource.class) instanceof IFile) {
            iFile = (IFile)((TreeElement)iStructuredSelection.getFirstElement()).getFile().getAdapter(IResource.class);
            IEditorReference[] iEditorReferenceArray = CBDTUiPlugin.getActivePage().getEditorReferences();
            if (iEditorReferenceArray.length == 0) {
                return null;
            }
            int n = 0;
            while (n < iEditorReferenceArray.length) {
                Object object;
                IEditorInput iEditorInput;
                IEditorPart iEditorPart = iEditorReferenceArray[n].getEditor(true);
                if (iEditorPart != null && (iEditorInput = iEditorPart.getEditorInput()) != null && (object = iEditorInput.getAdapter(IFile.class)) != null && object instanceof IFile && object.equals(iFile)) {
                    return iEditorPart;
                }
                ++n;
            }
        }
        return null;
    }

    public static boolean bringToTopEditor(IStructuredSelection iStructuredSelection) {
        IEditorPart iEditorPart = ViewsUtil.getEditorPart(iStructuredSelection);
        if (iEditorPart != null) {
            CBDTUiPlugin.getActivePage().bringToTop((IWorkbenchPart)iEditorPart);
            return true;
        }
        return false;
    }

    public static void addProjectToViews(final IProject iProject, String[] stringArray, String[] stringArray2) {
        Object object;
        TreeElement treeElement;
        Object object2;
        final IViewPart iViewPart = CBDTUiPlugin.getActivePage().findView("org.eclipse.cobol.ui.views.dependency.DependencyView");
        if (iViewPart != null) {
            try {
                object2 = (DependencyView)iViewPart;
                if (iProject.isOpen() && iProject.getLocation() != null && iProject.getLocation().toFile().exists()) {
                    ((DependencyView)((Object)object2)).addProject(iProject.getLocation().toOSString(), iProject.getName());
                }
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        } else if (iProject.getLocation() != null) {
            object2 = ViewsTreeModel.getInstance().getRoot();
            if (!((TreeElement)object2).hasChildren()) {
                ViewsUtil.restoreState();
            }
            if ((treeElement = ((TreeElement)object2).addChild((String)(object = iProject.getLocation().toOSString()), iProject.getName(), IViewConstants.PROJECT_NAME, false)) == null) {
                return;
            }
            treeElement.addChild(IViewConstants.SOURCE_FOLDER_VALUE, "SOURCE_FOLDER", "SOURCE_FOLDER", false);
            treeElement.addChild(IViewConstants.LINKING_FILES_FOLDER_VALUE, IViewConstants.LINKING_FILES_FOLDER_NAME, IViewConstants.LINKING_FILES_FOLDER_NAME, false);
            treeElement.addChild(IViewConstants.OTHER_FILES_FOLDER_VALUE, IViewConstants.OTHER_FILES_FOLDER_NAME, IViewConstants.OTHER_FILES_FOLDER_NAME, false);
            ViewsUtil.saveState(null);
        }
        object2 = CBDTUiPlugin.getActivePage().findView("org.eclipse.cobol.ui.views.structures.StructuresView");
        if (iProject.isOpen() && iProject.getLocation() != null && iProject.getLocation().toFile().exists()) {
            object = iProject.getLocation().toOSString();
            treeElement = ViewsTreeModel.getInstance().getRoot().addChild((String)object, iProject.getName(), IViewConstants.PROJECT_NAME, false);
            if (treeElement != null) {
                treeElement.addChild(IViewConstants.SOURCE_FOLDER_VALUE, "SOURCE_FOLDER", "SOURCE_FOLDER", false);
                treeElement.addChild(IViewConstants.LINKING_FILES_FOLDER_VALUE, IViewConstants.LINKING_FILES_FOLDER_NAME, IViewConstants.LINKING_FILES_FOLDER_NAME, false);
                treeElement.addChild(IViewConstants.OTHER_FILES_FOLDER_VALUE, IViewConstants.OTHER_FILES_FOLDER_NAME, IViewConstants.OTHER_FILES_FOLDER_NAME, false);
            }
        }
        ViewsUtil.addSourceFiles(iProject.getName(), stringArray);
        ViewsUtil.addOtherFiles(iProject.getName(), stringArray2);
        RepositoryData.populateRepositoryData(ViewsTreeModel.getInstance().getRoot().getChildFromName(iProject.getName()));
        if (object2 != null) {
            try {
                if (ValidateThreadUtil.isValidThread()) {
                    object = (StructuresView)((Object)object2);
                    if (iProject.getLocation() != null) {
                        ((StructuresView)((Object)object)).refreshAllViews();
                    }
                    ((StructuresView)((Object)object)).refresh();
                } else {
                    Display.getDefault().syncExec(new Runnable((IViewPart)object2, iProject){
                        private final /* synthetic */ IViewPart val$structuresViewPart;
                        private final /* synthetic */ IProject val$project;
                        {
                            this.val$structuresViewPart = iViewPart;
                            this.val$project = iProject;
                        }

                        @Override
                        public void run() {
                            StructuresView structuresView = (StructuresView)this.val$structuresViewPart;
                            if (this.val$project.getLocation() != null) {
                                structuresView.refreshAllViews();
                            }
                            structuresView.refresh();
                        }
                    });
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
        if (iViewPart != null) {
            try {
                if (ValidateThreadUtil.isValidThread()) {
                    object = (DependencyView)iViewPart;
                    if (iProject.getLocation() != null) {
                        ((DependencyView)((Object)object)).refreshAllViews();
                    }
                    ((DependencyView)((Object)object)).refresh();
                } else {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DependencyView dependencyView = (DependencyView)iViewPart;
                            if (iProject.getLocation() != null) {
                                dependencyView.refreshAllViews();
                            }
                            dependencyView.refresh();
                        }
                    });
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    public static void addSourceFiles(String string, String[] stringArray) {
        if (stringArray == null || string == null) {
            return;
        }
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        TreeElement treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER");
        int n = 0;
        while (n < stringArray.length) {
            treeElement2.addChild(String.valueOf(string) + '/' + stringArray[n], stringArray[n], "SOURCE_FILE", true);
            ++n;
        }
    }

    public static void deleteSourceFiles(String string, String[] stringArray) {
        if (stringArray == null || string == null) {
            return;
        }
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        TreeElement treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER");
        int n = 0;
        while (n < stringArray.length) {
            TreeElement treeElement3 = treeElement2.getChildFromName(stringArray[n]);
            if (treeElement3 != null) {
                treeElement2.deleteChild(treeElement3);
            }
            ViewsUtil.deleteFile(string, stringArray[n], "SOURCE_FILE");
            ++n;
        }
    }

    public static void addOtherFiles(String string, String[] stringArray) {
        if (stringArray == null || string == null) {
            return;
        }
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        TreeElement treeElement2 = treeElement.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
        int n = 0;
        while (n < stringArray.length) {
            treeElement2.addChild(String.valueOf(string) + '/' + stringArray[n], stringArray[n], IViewConstants.OTHER_FILES_NAME, false);
            ++n;
        }
    }

    public static void deleteOtherFiles(String string, String[] stringArray) {
        if (stringArray == null || string == null) {
            return;
        }
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        TreeElement treeElement2 = treeElement.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
        int n = 0;
        while (n < stringArray.length) {
            TreeElement treeElement3 = treeElement2.getChildFromName(stringArray[n]);
            if (treeElement3 != null) {
                treeElement2.deleteChild(treeElement3);
            }
            ViewsUtil.deleteFile(string, stringArray[n], IViewConstants.OTHER_FILES_NAME);
            ++n;
        }
    }

    private static void restoreState() {
        try {
            File file = ViewsUtil.getViewsFile(false);
            if (file != null) {
                TreeElement treeElement = ViewsTreeModel.getInstance().getRoot();
                IMemento iMemento = ViewsUtil.getMemento(file);
                IMemento[] iMementoArray = iMemento.getChildren(IViewConstants.PROJECT_NAME);
                if (iMementoArray != null) {
                    int n = 0;
                    while (n < iMementoArray.length) {
                        TreeElement treeElement2 = ViewsUtil.addChild(iMementoArray[n], treeElement, false);
                        ViewsUtil.restoreData(treeElement2, iMementoArray[n], true);
                        ++n;
                    }
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void removeMainProgramSetting(String string) {
        if (string == null) {
            return;
        }
        QualifiedName qualifiedName = new QualifiedName("org.eclipse.cobol.ui.views.dependency", "MAIN_FILE");
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(string);
        try {
            if (iProject != null && iProject.getLocation() != null) {
                iProject.setPersistentProperty(qualifiedName, "");
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private static XMLMementoWrapper createWriteRoot(String string) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(string);
            document.appendChild(element);
            XMLMemento xMLMemento = new XMLMemento(document, element);
            return new XMLMementoWrapper(xMLMemento, document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Error(parserConfigurationException);
        }
    }

    public static void initViewsModel() {
        ViewsTreeModel.getInstance();
    }

    public static void sortElements(ArrayList arrayList) {
        if (arrayList == null && arrayList.size() <= 0) {
            return;
        }
        int n = arrayList.size();
        ArrayList<String> arrayList2 = null;
        HashMap<String, org.eclipse.cobol.ui.views.outlineview.Element> hashMap = null;
        org.eclipse.cobol.ui.views.outlineview.Element element = null;
        int n2 = 0;
        while (n2 < n) {
            element = (org.eclipse.cobol.ui.views.outlineview.Element)arrayList.get(n2);
            ArrayList arrayList3 = element.getChildElements();
            int n3 = arrayList3.size();
            if (n3 > 0) {
                element = null;
                element = (org.eclipse.cobol.ui.views.outlineview.Element)arrayList3.get(0);
                if (element.getBlockType() == 14) {
                    org.eclipse.cobol.ui.views.outlineview.Element element2 = element.getParent();
                    ArrayList arrayList4 = element2.getChildElements();
                    int n4 = arrayList4.size();
                    arrayList2 = new ArrayList<String>(n4);
                    hashMap = new HashMap<String, org.eclipse.cobol.ui.views.outlineview.Element>(n4);
                    int n5 = 0;
                    while (n5 < n4) {
                        element = null;
                        element = (org.eclipse.cobol.ui.views.outlineview.Element)arrayList4.get(n5);
                        arrayList2.add(element.getData());
                        hashMap.put(element.getData(), element);
                        ++n5;
                    }
                    Collections.sort(arrayList2);
                    element2.getChildElements().clear();
                    n5 = 0;
                    while (n5 < n4) {
                        element2.addChildElement((org.eclipse.cobol.ui.views.outlineview.Element)hashMap.get(arrayList2.get(n5)));
                        ++n5;
                    }
                    arrayList2 = null;
                    hashMap = null;
                    element = null;
                } else {
                    ViewsUtil.sortElements(arrayList3);
                }
            }
            ++n2;
        }
    }

    public static void checkAndAddProjectNodeOnImport(IProject iProject) {
        if (iProject == null) {
            return;
        }
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(iProject.getName());
        if (treeElement == null && iProject.getLocation() != null) {
            String string;
            TreeElement treeElement2 = ViewsTreeModel.getInstance().getRoot();
            if (!treeElement2.hasChildren()) {
                ViewsUtil.restoreState();
            }
            if ((treeElement = treeElement2.addChild(string = iProject.getLocation().toOSString(), iProject.getName(), IViewConstants.PROJECT_NAME, false)) == null) {
                return;
            }
            treeElement.addChild(IViewConstants.SOURCE_FOLDER_VALUE, "SOURCE_FOLDER", "SOURCE_FOLDER", false);
            treeElement.addChild(IViewConstants.LINKING_FILES_FOLDER_VALUE, IViewConstants.LINKING_FILES_FOLDER_NAME, IViewConstants.LINKING_FILES_FOLDER_NAME, false);
            treeElement.addChild(IViewConstants.OTHER_FILES_FOLDER_VALUE, IViewConstants.OTHER_FILES_FOLDER_NAME, IViewConstants.OTHER_FILES_FOLDER_NAME, false);
            ViewsUtil.saveState(null);
        }
    }

    public static void addLinkingFiles(IProject iProject, String[] stringArray) {
        String string = "";
        if (stringArray == null || iProject == null) {
            return;
        }
        string = iProject.getName();
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        TreeElement treeElement2 = treeElement.getChildFromName(IViewConstants.LINKING_FILES_FOLDER_NAME);
        int n = 0;
        while (n < stringArray.length) {
            Path path = new Path(stringArray[n]);
            if (path.segmentCount() > 0) {
                String string2 = path.segment(path.segmentCount() - 1);
                String string3 = ViewsUtil.getFileLocation(iProject, path.removeLastSegments(1).toOSString());
                treeElement2.addChild(string3.concat(string2), string2, IViewConstants.LINKING_FILES_NAME, false);
            }
            ++n;
        }
    }

    public static void addSourceFilesToDepView(IProject iProject, String[] stringArray) {
        String string = "";
        if (stringArray == null || iProject == null) {
            return;
        }
        string = iProject.getName();
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        TreeElement treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER");
        int n = 0;
        while (n < stringArray.length) {
            Path path = new Path(stringArray[n]);
            if (path.segmentCount() > 0) {
                String string2 = path.segment(path.segmentCount() - 1);
                String string3 = ViewsUtil.getFileLocation(iProject, path.removeLastSegments(1).toOSString());
                if (string3 != null && string3.length() > 0) {
                    string3 = (String.valueOf(iProject.getName()) + '/').concat(string3);
                    treeElement2.addChild(string3.concat(string2), string2, "SOURCE_FILE", true);
                } else {
                    treeElement2.addChild(String.valueOf(iProject.getName()) + '/' + string2, string2, "SOURCE_FILE", true);
                }
            }
            ++n;
        }
    }

    public static String getFileLocation(IProject iProject, String string) {
        String string2 = string;
        if (iProject == null) {
            return string2;
        }
        if (string == null || string != null && string.length() == 0) {
            return string2;
        }
        IPath iPath = iProject.getWorkspace().getRoot().getLocation().makeAbsolute();
        if (iPath == null) {
            return string2;
        }
        String string3 = "";
        try {
            string3 = iPath.toFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
        }
        if (!string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        if (string.length() > string3.length() && string.startsWith(string3)) {
            string2 = string.substring(string3.length() + 1);
            Path path = new Path(string2);
            if (iProject.getWorkspace().getRoot().findMember(path.segments()[0]) instanceof IProject) {
                try {
                    iProject.getWorkspace().getRoot().findMember(path.segments()[0]).refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    CBDTUiPlugin.logError((Exception)((Object)coreException));
                }
                if (string2.indexOf(File.separatorChar) > 0) {
                    string2 = string2.replace(File.separatorChar, '/');
                }
                if (string2.length() > 0 && !string2.endsWith(String.valueOf('/'))) {
                    string2 = String.valueOf(string2) + '/';
                }
            } else {
                string2 = string;
            }
        }
        if (string2.indexOf(File.separatorChar) > 0) {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (string2.length() > 0 && !string2.endsWith(String.valueOf('/'))) {
            string2 = String.valueOf(string2) + '/';
        }
        return string2;
    }

    public static ArrayList getSourceFiles(String string) {
        ArrayList arrayList = new ArrayList(10);
        if (string == null || string != null && string.length() == 0) {
            return arrayList;
        }
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        if (treeElement == null) {
            return arrayList;
        }
        TreeElement treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER");
        if (treeElement2 == null) {
            return arrayList;
        }
        ArrayList arrayList2 = treeElement2.getAllChildren();
        if (arrayList2 == null) {
            return arrayList;
        }
        return arrayList2;
    }

    public static ArrayList getSourceFileNamesList(String string) {
        ArrayList arrayList = ViewsUtil.getListOfFileNames(string, "SOURCE_FOLDER", "SOURCE_FILE", true);
        return arrayList;
    }

    public static ArrayList getLinkingFileNamesList(String string) {
        ArrayList arrayList = ViewsUtil.getListOfFileNames(string, IViewConstants.LINKING_FILES_FOLDER_NAME, IViewConstants.LINKING_FILES_NAME, false);
        return arrayList;
    }

    public static ArrayList getSourceFilesWithNameOption(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (string == null || string != null && string.length() == 0) {
            return arrayList;
        }
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        if (treeElement == null) {
            return arrayList;
        }
        TreeElement treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER");
        ArrayList arrayList2 = treeElement2.getAllChildrenOfType("SOURCE_FILE");
        if (arrayList2 != null && arrayList2.size() > 0) {
            int n = arrayList2.size();
            Object var6_6 = null;
            Object object = null;
            int n2 = 0;
            while (n2 < n) {
                var6_6 = arrayList2.get(n2);
                if (var6_6 != null && var6_6 instanceof TreeElement && (object = ((TreeElement)var6_6).getAdapter(IResource.class)) != null && object instanceof IFile && BuildUtil.getNameOptionFromResourcePersistance((IResource)((IFile)object))) {
                    arrayList.add(((TreeElement)var6_6).getName());
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public static String getMainSourceFileName(String string) {
        String string2 = "";
        if (string == null || string != null && string.length() == 0) {
            return string2;
        }
        try {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IProject iProject = iWorkspace.getRoot().getProject(string);
            if (iProject != null && iProject.getLocation() != null) {
                string2 = iProject.getPersistentProperty(fMainKey);
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return string2;
    }

    private static ArrayList getListOfFileNames(String string, String string2, String string3, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (string == null || string != null && string.length() == 0) {
            return arrayList;
        }
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        if (treeElement == null) {
            return arrayList;
        }
        TreeElement treeElement2 = treeElement.getChildFromName(string2);
        ArrayList arrayList2 = treeElement2.getAllChildrenOfType(string3);
        if (arrayList2 != null && arrayList2.size() > 0) {
            int n = arrayList2.size();
            Object var9_9 = null;
            String string4 = "";
            Path path = null;
            int n2 = 0;
            while (n2 < n) {
                var9_9 = arrayList2.get(n2);
                if (var9_9 != null && var9_9 instanceof TreeElement) {
                    if (bl) {
                        string4 = ((TreeElement)var9_9).getPath();
                        path = new Path(string4);
                        if (path.segmentCount() > 0) {
                            path = path.removeFirstSegments(1);
                            string4 = path.toString();
                            arrayList.add(string4);
                        }
                    } else {
                        arrayList.add(((TreeElement)var9_9).getAbsolutePath());
                    }
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public static void updateSourceFilesWithNameOption(String string, String[] stringArray) {
        if (string == null || string != null && string.length() == 0) {
            return;
        }
        if (stringArray != null && stringArray.length > 0) {
            ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>();
            TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
            TreeElement treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER");
            TreeElement treeElement3 = null;
            IResource iResource = null;
            int n = 0;
            while (n < stringArray.length) {
                treeElement3 = treeElement2.getChildFromName(stringArray[n]);
                iResource = (IResource)treeElement3.getAdapter(IResource.class);
                if (iResource != null && iResource instanceof IFile) {
                    BuildUtil.setNameOptionInFilePersistance((IResource)((IFile)iResource), true);
                    arrayList.add(treeElement3);
                }
                ++n;
            }
        }
    }

    public static void refreshDependencyView(final IProject iProject) {
        if (iProject == null) {
            return;
        }
        final IViewPart iViewPart = CBDTUiPlugin.getActivePage().findView("org.eclipse.cobol.ui.views.dependency.DependencyView");
        if (iViewPart != null) {
            try {
                if (ValidateThreadUtil.isValidThread()) {
                    DependencyView dependencyView = (DependencyView)iViewPart;
                    if (iProject.getLocation() != null) {
                        dependencyView.refreshAllViews();
                    }
                    dependencyView.refresh();
                } else {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DependencyView dependencyView = (DependencyView)iViewPart;
                            if (iProject.getLocation() != null) {
                                dependencyView.refreshAllViews();
                            }
                            dependencyView.refresh();
                        }
                    });
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    public static ArrayList getOtherFiles(String string) {
        ArrayList arrayList = new ArrayList(10);
        if (string == null || string != null && string.length() == 0) {
            return arrayList;
        }
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        TreeElement treeElement2 = treeElement.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
        return treeElement2.getAllChildren();
    }

    public static TreeElement isSourceFileExists(String string, String string2) {
        if (string == null || string != null && string.length() == 0) {
            return null;
        }
        if (string2 == null || string2 != null && string2.length() == 0) {
            return null;
        }
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        TreeElement treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER");
        return treeElement2.isChildFromNameExists(string2);
    }

    public static void refreshFromLocal(TreeElement treeElement, Shell shell) {
        String string = null;
        String string2 = null;
        IWorkspace iWorkspace = null;
        IProject iProject = null;
        IRunnableWithProgress iRunnableWithProgress = null;
        string = treeElement.getAttribute("TYPE");
        string2 = treeElement.getName();
        if (string.equals(IViewConstants.PROJECT_NAME)) {
            iWorkspace = ResourcesPlugin.getWorkspace();
            iProject = iWorkspace.getRoot().getProject(string2);
            if (iProject == null || iProject.getLocation() == null) {
                return;
            }
            final IProject iProject2 = iProject;
            iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    try {
                        if (iProject2.isOpen() && iProject2.getLocation().toFile().exists()) {
                            iProject2.refreshLocal(0, iProgressMonitor);
                        }
                    }
                    catch (CoreException coreException) {
                        CBDTUiPlugin.logError((Exception)((Object)coreException));
                    }
                    catch (Exception exception) {
                        CBDTUiPlugin.logError(exception);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(shell).run(true, true, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                CBDTUiPlugin.logError(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                CBDTUiPlugin.logError(interruptedException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    public static ArrayList getFilesForFolder(TreeElement treeElement, String string) {
        ArrayList arrayList = new ArrayList();
        TreeElement treeElement2 = null;
        String string2 = "";
        ArrayList arrayList2 = new ArrayList(10);
        arrayList = treeElement.getChildren();
        int n = 0;
        while (n < arrayList.size()) {
            treeElement2 = (TreeElement)arrayList.get(n);
            string2 = treeElement2.getAttribute("TYPE");
            if (treeElement2 != null && string2.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) && string2.equals(string)) {
                arrayList2 = treeElement2.getChildren();
            }
            if (treeElement2 != null && string2.equals(IViewConstants.OTHER_FILES_FOLDER_NAME) && string2.equals(string)) {
                arrayList2 = treeElement2.getChildren();
            }
            if (treeElement2 != null && string2.equals("SOURCE_FOLDER") && string2.equals(string)) {
                arrayList2 = treeElement2.getChildren();
            }
            ++n;
        }
        return arrayList2;
    }

    public static ArrayList getCobolEditorFiles() {
        IFileEditorMapping[] iFileEditorMappingArray = WorkbenchPlugin.getDefault().getEditorRegistry().getFileEditorMappings();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        int n = 0;
        while (n < iFileEditorMappingArray.length) {
            FileEditorMapping fileEditorMapping = (FileEditorMapping)iFileEditorMappingArray[n];
            fileEditorMapping = (FileEditorMapping)fileEditorMapping.clone();
            IEditorDescriptor[] iEditorDescriptorArray = fileEditorMapping.getEditors();
            int n2 = 0;
            while (iEditorDescriptorArray != null && n2 < iEditorDescriptorArray.length) {
                String string = iEditorDescriptorArray[n2].getId();
                if ("org.eclipse.cobol.ui.editor.COBOLEditor".equalsIgnoreCase(string)) {
                    arrayList.add(fileEditorMapping.getExtension());
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    public static boolean isValidCOBOLSource(String string) {
        ArrayList arrayList = ViewsUtil.getCobolEditorFiles();
        int n = 0;
        while (string != null && arrayList != null && n < arrayList.size()) {
            if (string.equalsIgnoreCase((String)arrayList.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static TreeElement getOtherFilesFolderFromTreeModal(IProject iProject) {
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot();
        if (treeElement == null) {
            return null;
        }
        TreeElement treeElement2 = treeElement.getChildFromName(iProject.getName());
        if (treeElement2 == null) {
            return null;
        }
        TreeElement treeElement3 = treeElement2.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
        if (treeElement3 == null) {
            return null;
        }
        return treeElement3;
    }

    public static void refreshViews(TreeElement treeElement) {
        IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IViewPart[] iViewPartArray = ViewsUtil.getViews(iWorkbenchWindowArray[n].getActivePage());
            int n2 = 0;
            while (n2 < iViewPartArray.length) {
                IMenuListener iMenuListener;
                if (iViewPartArray[n2] instanceof DependencyView) {
                    iMenuListener = (DependencyView)iViewPartArray[n2];
                    iMenuListener.getViewer().refresh((Object)treeElement);
                }
                if (iViewPartArray[n2] instanceof StructuresView) {
                    iMenuListener = (StructuresView)iViewPartArray[n2];
                    iMenuListener.getViewer().refresh((Object)treeElement);
                }
                ++n2;
            }
            ++n;
        }
    }

    public static void refreshViews(TreeElement treeElement, int n) {
        IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        StructuredSelection structuredSelection = new StructuredSelection((Object)treeElement);
        int n2 = 0;
        while (n2 < iWorkbenchWindowArray.length) {
            IViewPart[] iViewPartArray = ViewsUtil.getViews(iWorkbenchWindowArray[n2].getActivePage());
            int n3 = 0;
            while (n3 < iViewPartArray.length) {
                IMenuListener iMenuListener;
                if (iViewPartArray[n3] instanceof DependencyView && 1 == n) {
                    iMenuListener = (DependencyView)iViewPartArray[n3];
                    iMenuListener.refresh();
                    if (structuredSelection != null && treeElement != null && treeElement.getAllChildren() != null) {
                        iMenuListener.getViewer().refresh((Object)treeElement.getAllChildren().toArray(), true);
                        iMenuListener.getViewer().setSelection((ISelection)structuredSelection);
                    }
                }
                if (iViewPartArray[n3] instanceof StructuresView && 2 == n) {
                    iMenuListener = (StructuresView)iViewPartArray[n3];
                    TreeViewer treeViewer = iMenuListener.getViewer();
                    if (treeViewer instanceof ProblemTreeViewer) {
                        ((ProblemTreeViewer)treeViewer).setExpandToLevelFired(true);
                    }
                    iMenuListener.refresh();
                    if (structuredSelection != null && treeElement != null && treeElement.getAllChildren() != null) {
                        iMenuListener.getViewer().refresh((Object)treeElement.getAllChildren().toArray(), true);
                        iMenuListener.getViewer().setSelection((ISelection)structuredSelection);
                        ViewsUtil.expandToLevel(treeElement, treeViewer);
                        if (treeViewer instanceof ProblemTreeViewer) {
                            ((ProblemTreeViewer)treeViewer).setExpandToLevelFired(false);
                        }
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    private static void expandToLevel(TreeElement treeElement, TreeViewer treeViewer) {
        ArrayList arrayList = treeElement.getAllChildren();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                TreeElement treeElement2 = (TreeElement)arrayList.get(n);
                if (!treeElement2.getAttribute("TYPE").equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) && !treeElement2.getAttribute("TYPE").equals("TARGET_REPOSITORY_FOLDER")) {
                    treeViewer.expandToLevel((Object)treeElement2, 1);
                    ViewsUtil.expandToLevel(treeElement2, treeViewer);
                }
                ++n;
            }
        }
    }

    public static TreeElement isFileExistInOtherFolder(TreeElement treeElement, IPath iPath) {
        TreeElement treeElement2;
        IPath iPath2 = iPath.removeLastSegments(1);
        String string = iPath.toString();
        if (iPath.segmentCount() == 0 || iPath2.segmentCount() == 0) {
            return null;
        }
        if (string.startsWith(String.valueOf('/'))) {
            string = string.substring(1);
        }
        if ((treeElement2 = treeElement.getChildFromLocation(string)) != null) {
            return treeElement2;
        }
        TreeElement treeElement3 = COBOLResourceDeltaVisitor.getOtherSubFolder(treeElement, iPath2.removeFirstSegments(1), iPath2.segment(iPath2.segmentCount() - 1));
        if (treeElement3 != null) {
            treeElement2 = treeElement3.getChildFromName(iPath.segment(iPath.segmentCount() - 1));
        }
        return treeElement2;
    }

    public static void deleteFileInOtherFolder(TreeElement treeElement, IPath iPath) {
        TreeElement treeElement2;
        IPath iPath2 = iPath.removeLastSegments(1);
        String string = iPath.toString();
        if (iPath.segmentCount() == 0) {
            return;
        }
        if (string.startsWith(String.valueOf('/'))) {
            string = string.substring(1);
        }
        if ((treeElement2 = treeElement.getChildFromLocation(string)) != null) {
            treeElement.deleteChild(treeElement2);
            return;
        }
        TreeElement treeElement3 = COBOLResourceDeltaVisitor.getOtherSubFolder(treeElement, iPath2.removeFirstSegments(1), iPath2.segment(iPath2.segmentCount() - 1));
        if (treeElement3 != null) {
            treeElement2 = treeElement3.getChildFromName(iPath.segment(iPath.segmentCount() - 1));
            treeElement3.deleteChild(treeElement2);
        }
    }

    public static void refreshTreeElement(ArrayList arrayList) {
        if (arrayList != null) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                TreeElement treeElement = (TreeElement)arrayList.get(n2);
                if (treeElement != null) {
                    ViewsUtil.refreshTreeElement(treeElement);
                }
                ++n2;
            }
        }
    }

    private static void refreshTreeElement(TreeElement treeElement) {
        if (treeElement != null) {
            String string = treeElement.getAttribute("TYPE");
            if (string.equalsIgnoreCase(IViewConstants.PROJECT_NAME)) {
                IProject iProject = treeElement.getIProject();
                try {
                    if (iProject != null) {
                        iProject.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException coreException) {
                    CBDTUiPlugin.logError((Exception)((Object)coreException));
                }
            } else if (string.equalsIgnoreCase("SOURCE_FILE") || string.equalsIgnoreCase(IViewConstants.LINKING_FILES_NAME) || string.equalsIgnoreCase(IViewConstants.REPOSITORY_CLASS_NAME) || string.equalsIgnoreCase(IViewConstants.DEPENDENT_FILES_NAME) || string.equalsIgnoreCase("TARGET_OBJECT_FILES") || string.equalsIgnoreCase(IViewConstants.OTHER_FILES_NAME)) {
                String string2 = treeElement.getLocation().toLowerCase();
                string2 = string2.replace('/', File.separatorChar);
                String string3 = treeElement.getAbsolutePath();
                String string4 = "";
                String string5 = treeElement.getName();
                try {
                    int n;
                    File file = new File(string3);
                    string4 = file.getCanonicalPath();
                    Path path = new Path(string4);
                    string5 = path.lastSegment();
                    if (file != null && file.exists() && string4.toLowerCase().endsWith(string2) && (n = string4.indexOf(string2)) != -1) {
                        String string6 = string4.substring(n, string4.length());
                        Path path2 = new Path(string6);
                        if ((string6 = path2.toString()).startsWith(String.valueOf('/'))) {
                            string6 = string6.substring(1);
                        }
                        treeElement.setAttribute("NAME", string5);
                        treeElement.setAttribute("LOCATION", string6);
                    }
                }
                catch (IOException iOException) {
                    CBDTUiPlugin.logError(iOException);
                }
            }
        }
    }

    public static boolean isSelectedElementOpenable(String string) {
        return string.equals(IViewConstants.LINKING_FILES_NAME) || string.equals(IViewConstants.OTHER_FILES_NAME) || string.equals("TARGET_FILES") || string.equals(IViewConstants.DEPENDENT_FILES_NAME) || string.equals("SOURCE_FILE") || string.equals(IViewConstants.PROGRAM_ID_NAME) || string.equals(IViewConstants.CLASS_ID_NAME) || string.equals(IViewConstants.OBJECT_ID_NAME) || string.equals(IViewConstants.FACTORY_ID_NAME) || string.equals(IViewConstants.METHOD_ID_NAME) || string.equals(IViewConstants.ENVIRONMENT_ID_NAME) || string.equals(IViewConstants.DATA_ID_NAME) || string.equals(IViewConstants.PROCEDURE_ID_NAME) || string.equals(IViewConstants.DECLARATIVES_ID_NAME) || string.equals(IViewConstants.SECTION_ID_NAME) || string.equals(IViewConstants.STATEMENT_ID_NAME);
    }

    public static boolean canHighlightElement(String string) {
        return string.equals(IViewConstants.PROGRAM_ID_NAME) || string.equals(IViewConstants.CLASS_ID_NAME) || string.equals(IViewConstants.OBJECT_ID_NAME) || string.equals(IViewConstants.FACTORY_ID_NAME) || string.equals(IViewConstants.METHOD_ID_NAME) || string.equals(IViewConstants.ENVIRONMENT_ID_NAME) || string.equals(IViewConstants.DATA_ID_NAME) || string.equals(IViewConstants.PROCEDURE_ID_NAME) || string.equals(IViewConstants.DECLARATIVES_ID_NAME) || string.equals(IViewConstants.SECTION_ID_NAME) || string.equals(IViewConstants.STATEMENT_ID_NAME) || string.equals("SOURCE_FILE");
    }

    public static void highlightCOBOLKeyWord(IEditorPart iEditorPart, TreeElement treeElement) {
        try {
            if (treeElement.getAttribute("TYPE").equals("SOURCE_FILE")) {
                return;
            }
            if (CBDTUiPlugin.getActivePage() == null || !(CBDTUiPlugin.getActivePage().getActiveEditor() instanceof COBOLEditor)) {
                return;
            }
            COBOLEditor cOBOLEditor = (COBOLEditor)iEditorPart;
            if (cOBOLEditor == null) {
                cOBOLEditor = (COBOLEditor)CBDTUiPlugin.getActivePage().getActiveEditor();
            }
            ISourceViewer iSourceViewer = cOBOLEditor.getCurrentSourceViewer();
            IDocument iDocument = iSourceViewer.getDocument();
            int n = iDocument.getLineOffset(treeElement.getLineNumber());
            int n2 = iDocument.getLineLength(treeElement.getLineNumber());
            String string = iDocument.get(n, n2);
            string = string.toUpperCase();
            n2 = treeElement.getName().length();
            int n3 = -1;
            String string2 = treeElement.getAttribute("TYPE");
            if (string2.equals(IViewConstants.PROGRAM_ID_NAME) || string2.equals(IViewConstants.CLASS_ID_NAME) || string2.equals(IViewConstants.METHOD_ID_NAME)) {
                String string3 = ViewsUtil.getKeyword(treeElement);
                n3 = string.indexOf(string3);
                if (n3 >= 0) {
                    n3 = string.indexOf(treeElement.getName().toUpperCase(), n3 + string3.length());
                }
            } else {
                n3 = string.indexOf(treeElement.getName().toUpperCase());
            }
            if (n3 >= 0) {
                n += n3;
            }
            if (cOBOLEditor != null) {
                cOBOLEditor.selectAndReveal(n, n2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            CBDTUiPlugin.logError(arrayIndexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static String getKeyword(org.eclipse.cobol.ui.views.outlineview.Element element) {
        switch (element.getBlockType()) {
            case 10: {
                return "PROGRAM-ID";
            }
            case 11: {
                return "CLASS-ID";
            }
            case 14: {
                return "METHOD-ID";
            }
            case 0: {
                return "ENVIRONMENT";
            }
            case 1: {
                return "DATA";
            }
            case 2: {
                return "PROCEDURE";
            }
            case 3: {
                return "DECLARATIVES";
            }
            case 4: {
                return element.getData();
            }
        }
        return "";
    }

    public static String getKeyword(TreeElement treeElement) {
        String string = treeElement.getAttribute("TYPE");
        if (string.equalsIgnoreCase(IViewConstants.PROGRAM_ID_NAME)) {
            return "PROGRAM-ID";
        }
        if (string.equalsIgnoreCase(IViewConstants.CLASS_ID_NAME)) {
            return "CLASS-ID";
        }
        if (string.equalsIgnoreCase(IViewConstants.METHOD_ID_NAME)) {
            return "METHOD-ID";
        }
        if (string.equalsIgnoreCase(IViewConstants.ENVIRONMENT_ID_NAME)) {
            return "ENVIRONMENT";
        }
        if (string.equalsIgnoreCase(IViewConstants.DATA_ID_NAME)) {
            return "DATA";
        }
        if (string.equalsIgnoreCase(IViewConstants.PROCEDURE_ID_NAME)) {
            return "PROCEDURE";
        }
        if (string.equalsIgnoreCase(IViewConstants.DECLARATIVES_ID_NAME)) {
            return "DECLARATIVES";
        }
        return "";
    }

    public static void dispose() {
        if (fParser != null) {
            fParser = null;
        }
        fRunnable = null;
    }

    public static TreeElement[] getTargetRepositoryElements(TreeElement treeElement) {
        ArrayList arrayList = new ArrayList(10);
        ArrayList<TreeElement> arrayList2 = new ArrayList<TreeElement>(10);
        TreeElement treeElement2 = treeElement.getChildFromType("TARGET_REPOSITORY_FOLDER");
        int n = 0;
        if (treeElement2 != null) {
            arrayList = treeElement2.getAllChildrenOfType("TARGET_FILES");
            if (arrayList == null) {
                return new TreeElement[0];
            }
            n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                arrayList2.add((TreeElement)arrayList.get(n2));
                ++n2;
            }
        }
        return arrayList2.toArray(new TreeElement[arrayList2.size()]);
    }

    public static TreeElement[] getDependentFilesElement(TreeElement treeElement) {
        ArrayList arrayList = new ArrayList(10);
        TreeElement treeElement2 = treeElement.getChildFromType(IViewConstants.DEPENDENT_FILES_FOLDER_NAME);
        if (treeElement2 != null) {
            arrayList = treeElement2.getAllChildrenOfType(IViewConstants.DEPENDENT_FILES_NAME);
        }
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList.toArray(new TreeElement[arrayList.size()]);
        }
        return null;
    }

    public static TreeElement[] getTargetObjectElements(TreeElement treeElement) {
        ArrayList arrayList = new ArrayList(10);
        TreeElement treeElement2 = treeElement.getChildFromType("TARGET_OBJECT_FOLDER");
        if (treeElement2 != null) {
            arrayList = treeElement2.getAllChildrenOfType("TARGET_OBJECT_FILES");
        }
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList.toArray(new TreeElement[arrayList.size()]);
        }
        return null;
    }
}

