/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.outlineview.COBOLParser;
import org.eclipse.cobol.ui.views.outlineview.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class ViewsTreeModel {
    private static TreeElement fRoot = null;
    private static ViewsTreeModel fViewTreeModel = null;
    private static final String ROOT = "ROOT";
    private static final String DATA_VIEW = "DATA VIEW";
    private static IMemento fViewMemento = null;
    private boolean isDirty = false;
    private COBOLParser fParser = null;

    private ViewsTreeModel() {
        if (fRoot == null) {
            fRoot = new TreeElement(ROOT, DATA_VIEW, ROOT, null);
        }
    }

    public static ViewsTreeModel getInstance() {
        if (fViewTreeModel == null) {
            fViewTreeModel = new ViewsTreeModel();
            ViewsTreeModel.getPopulatedModelInstance();
        }
        return fViewTreeModel;
    }

    public TreeElement getRoot() {
        return fRoot;
    }

    private static ViewsTreeModel getPopulatedModelInstance() {
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot();
        if (!treeElement.hasChildren()) {
            ViewsTreeModel.restoreState();
        }
        return fViewTreeModel;
    }

    private static void restoreState() {
        try {
            File file = ViewsUtil.getViewsFile(false);
            if (file != null) {
                TreeElement treeElement = ViewsTreeModel.getInstance().getRoot();
                fViewMemento = ViewsUtil.getMemento(file);
                ViewsTreeModel.restoreData(treeElement, fViewMemento);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private static void restoreData(TreeElement treeElement, IMemento iMemento) {
        IMemento[] iMementoArray = iMemento.getChildren(IViewConstants.PROJECT_NAME);
        if (iMementoArray != null) {
            int n = 0;
            while (n < iMementoArray.length) {
                TreeElement treeElement2 = ViewsUtil.addChild(iMementoArray[n], treeElement, false);
                ViewsUtil.restoreData(treeElement2, iMementoArray[n], false);
                ++n;
            }
        }
    }

    public static IMemento getDependencyViewMemento() {
        if (fViewMemento == null) {
            ViewsTreeModel.getPopulatedModelInstance();
        }
        return fViewMemento;
    }

    public ArrayList getClassNames(String string) {
        ArrayList arrayList = new ArrayList();
        TreeElement treeElement = this.getProjectNode(string);
        try {
            if (treeElement != null && treeElement.hasChildren()) {
                ArrayList arrayList2 = treeElement.getChildren();
                int n = arrayList2.size();
                int n2 = 0;
                while (n2 < n) {
                    TreeElement treeElement2 = (TreeElement)arrayList2.get(n2);
                    if (treeElement2.getAttribute("TYPE").equals("SOURCE_FOLDER") && treeElement2.hasChildren() || treeElement2.getAttribute("TYPE").equals(IViewConstants.REPOSITORY_FOLDER_NAME) && treeElement2.hasChildren()) {
                        this.populateClassIDList(treeElement2, arrayList);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return arrayList;
    }

    private void populateClassIDList(TreeElement treeElement, ArrayList arrayList) {
        if (treeElement != null) {
            try {
                if ((treeElement.getAttribute("TYPE").equals(IViewConstants.CLASS_ID_NAME) || treeElement.getAttribute("TYPE").equals(IViewConstants.REPOSITORY_CLASS_NAME)) && !this.doesIDExists(treeElement.getName(), arrayList)) {
                    arrayList.add(treeElement.getName());
                }
                if (treeElement.hasChildren()) {
                    int n = treeElement.sizeOfChildren();
                    int n2 = 0;
                    while (n2 < n) {
                        TreeElement treeElement2 = (TreeElement)treeElement.getChildren().get(n2);
                        this.populateClassIDList(treeElement2, arrayList);
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    private void populateClassAndMethodIDList(TreeElement treeElement, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, HashMap hashMap, HashMap hashMap2) {
        if (treeElement != null) {
            TreeElement treeElement2;
            int n;
            int n2;
            if (treeElement.getAttribute("TYPE").equals(IViewConstants.CLASS_ID_NAME) && !this.doesIDExists(treeElement.getName(), arrayList)) {
                arrayList.add(treeElement.getName());
                if (treeElement.hasChildren()) {
                    arrayList2 = new ArrayList<String>();
                    arrayList3 = new ArrayList<String>();
                    n2 = treeElement.sizeOfChildren();
                    n = 0;
                    while (n < n2) {
                        int n3;
                        int n4;
                        ArrayList arrayList4;
                        treeElement2 = (TreeElement)treeElement.getChildren().get(n);
                        if (treeElement2.getAttribute("TYPE").equals(IViewConstants.FACTORY_ID_NAME)) {
                            if (treeElement2.hasChildren()) {
                                arrayList4 = treeElement2.getChildren();
                                n4 = arrayList4.size();
                                n3 = 0;
                                while (n3 < n4) {
                                    arrayList2.add(((TreeElement)arrayList4.get(n3)).getName());
                                    ++n3;
                                }
                            }
                        } else if (treeElement2.getAttribute("TYPE").equals(IViewConstants.OBJECT_ID_NAME)) {
                            if (treeElement2.hasChildren()) {
                                arrayList4 = treeElement2.getChildren();
                                n4 = arrayList4.size();
                                n3 = 0;
                                while (n3 < n4) {
                                    arrayList3.add(((TreeElement)arrayList4.get(n3)).getName());
                                    ++n3;
                                }
                            }
                        } else if (treeElement2.getAttribute("TYPE").equals(IViewConstants.METHOD_ID_NAME)) {
                            arrayList3.add(treeElement2.getName());
                        }
                        ++n;
                    }
                    if (arrayList3.size() > 0) {
                        hashMap2.put(treeElement.getName(), arrayList3);
                    }
                    if (arrayList2.size() > 0) {
                        hashMap.put(treeElement.getName(), arrayList2);
                    }
                }
            }
            if (treeElement.hasChildren()) {
                n2 = treeElement.sizeOfChildren();
                n = 0;
                while (n < n2) {
                    treeElement2 = (TreeElement)treeElement.getChildren().get(n);
                    this.populateClassAndMethodIDList(treeElement2, arrayList, arrayList2, arrayList3, hashMap, hashMap2);
                    ++n;
                }
            }
        }
    }

    private void populateClassAndMethodIDFromRep(TreeElement treeElement, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, HashMap hashMap, HashMap hashMap2) {
        if (treeElement != null) {
            TreeElement treeElement2;
            int n;
            int n2;
            if (treeElement.getAttribute("TYPE").equals(IViewConstants.REPOSITORY_CLASS_NAME) && !this.doesIDExists(treeElement.getName(), arrayList)) {
                arrayList.add(treeElement.getName());
                if (treeElement.hasChildren()) {
                    arrayList2 = new ArrayList<String>();
                    arrayList3 = new ArrayList<String>();
                    n2 = treeElement.sizeOfChildren();
                    n = 0;
                    while (n < n2) {
                        treeElement2 = (TreeElement)treeElement.getChildren().get(n);
                        if (treeElement2.getAttribute("TYPE").equals(IViewConstants.FACTORY_METHOD_NAME)) {
                            arrayList2.add(treeElement2.getName());
                        } else if (treeElement2.getAttribute("TYPE").equals(IViewConstants.OBJECT_METHOD_NAME)) {
                            arrayList3.add(treeElement2.getName());
                        }
                        ++n;
                    }
                    if (arrayList3.size() > 0) {
                        hashMap2.put(treeElement.getName(), arrayList3);
                    }
                    if (arrayList2.size() > 0) {
                        hashMap.put(treeElement.getName(), arrayList2);
                    }
                }
            }
            if (treeElement.hasChildren()) {
                n2 = treeElement.sizeOfChildren();
                n = 0;
                while (n < n2) {
                    treeElement2 = (TreeElement)treeElement.getChildren().get(n);
                    this.populateClassAndMethodIDFromRep(treeElement2, arrayList, arrayList2, arrayList3, hashMap, hashMap2);
                    ++n;
                }
            }
        }
    }

    public HashMap getClassAndMethodIDs(String string) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = new ArrayList();
        HashMap<String, Cloneable> hashMap3 = new HashMap<String, Cloneable>();
        TreeElement treeElement = this.getProjectNode(string);
        if (treeElement != null && treeElement.hasChildren()) {
            ArrayList arrayList4 = treeElement.getChildren();
            int n = arrayList4.size();
            int n2 = 0;
            while (n2 < n) {
                TreeElement treeElement2 = (TreeElement)arrayList4.get(n2);
                if (treeElement2.getAttribute("TYPE").equals("SOURCE_FOLDER") && treeElement2.hasChildren()) {
                    this.populateClassAndMethodIDList(treeElement2, arrayList3, arrayList, arrayList2, hashMap, hashMap2);
                } else if (treeElement2.getAttribute("TYPE").equals(IViewConstants.REPOSITORY_FOLDER_NAME) && treeElement2.hasChildren()) {
                    this.populateClassAndMethodIDFromRep(treeElement2, arrayList3, arrayList, arrayList2, hashMap, hashMap2);
                }
                ++n2;
            }
            if (hashMap2.size() > 0) {
                hashMap3.put("OM", hashMap2);
            }
            if (hashMap.size() > 0) {
                hashMap3.put("FM", hashMap);
            }
            if (arrayList3.size() > 0) {
                hashMap3.put("CLASS", arrayList3);
            }
        }
        return hashMap3;
    }

    public ArrayList getProgramIds(String string) {
        ArrayList arrayList = new ArrayList();
        TreeElement treeElement = this.getProjectNode(string);
        if (treeElement != null && treeElement.hasChildren()) {
            ArrayList arrayList2 = treeElement.getChildren();
            int n = arrayList2.size();
            int n2 = 0;
            while (n2 < n) {
                TreeElement treeElement2 = (TreeElement)arrayList2.get(n2);
                if (treeElement2.getAttribute("TYPE").equals("SOURCE_FOLDER") && treeElement2.hasChildren()) {
                    this.populateProgramIDList(treeElement2, arrayList);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    private void populateProgramIDList(TreeElement treeElement, ArrayList arrayList) {
        if (treeElement != null) {
            if (treeElement.getAttribute("TYPE").equals(IViewConstants.PROGRAM_ID_NAME) && !this.doesIDExists(treeElement.getName(), arrayList)) {
                arrayList.add(treeElement.getName());
            }
            if (treeElement.hasChildren()) {
                int n = treeElement.sizeOfChildren();
                int n2 = 0;
                while (n2 < n) {
                    TreeElement treeElement2 = (TreeElement)treeElement.getChildren().get(n2);
                    this.populateProgramIDList(treeElement2, arrayList);
                    ++n2;
                }
            }
        }
    }

    public boolean doesIDExists(String string, ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)arrayList.get(n2);
            if (string.equalsIgnoreCase(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public TreeElement getProjectNode(String string) {
        TreeElement treeElement = null;
        try {
            ArrayList arrayList = this.getRoot().getChildren();
            if (arrayList != null) {
                int n = arrayList.size();
                int n2 = 0;
                while (n2 < n) {
                    treeElement = (TreeElement)arrayList.get(n2);
                    if (treeElement.getName().equalsIgnoreCase(string)) {
                        return treeElement;
                    }
                    ++n2;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return null;
    }

    public void refreshStructuresView() {
        IWorkbenchPage iWorkbenchPage = CBDTUiPlugin.getActivePage();
        COBOLEditor cOBOLEditor = null;
        if (iWorkbenchPage.getActiveEditor() instanceof COBOLEditor && (cOBOLEditor = (COBOLEditor)iWorkbenchPage.getActiveEditor()) != null && cOBOLEditor.getEditorInput() != null && cOBOLEditor.getEditorInput() instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)cOBOLEditor.getEditorInput()).getFile();
            if (iFile == null || !iFile.exists()) {
                return;
            }
            String string = iFile.getProject().getName();
            String string2 = iFile.getFullPath().toString();
            if (string2.startsWith(String.valueOf('/'))) {
                string2 = string2.substring(1);
            }
            TreeElement treeElement = this.getRoot().getChildFromName(string);
            TreeElement treeElement2 = null;
            if (treeElement == null) {
                return;
            }
            treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER");
            TreeElement treeElement3 = null;
            if (treeElement2 != null) {
                treeElement3 = treeElement2.getChildFromLocation(string2);
                if (treeElement3 == null) {
                    return;
                }
            } else {
                return;
            }
            try {
                IFile iFile2 = ((FileEditorInput)cOBOLEditor.getEditorInput()).getFile();
                this.createClassElements(treeElement3, string, iFile2, cOBOLEditor.getReferenceFormat());
                ViewsUtil.refreshViews(treeElement3, 2);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
                return;
            }
        }
    }

    public void createClassElements(TreeElement treeElement, String string, IFile iFile, String string2) {
        Object object;
        if (treeElement == null || iFile == null || string == null) {
            return;
        }
        if (treeElement != null && treeElement.hasChildren()) {
            object = treeElement.getAllChildrenOfType(IViewConstants.PROGRAM_ID_NAME);
            int n = 0;
            while (object != null && n < ((ArrayList)object).size()) {
                treeElement.deleteChild((TreeElement)((ArrayList)object).get(n));
                ++n;
            }
            object = treeElement.getAllChildrenOfType(IViewConstants.FACTORY_ID_NAME);
            n = 0;
            while (object != null && n < ((ArrayList)object).size()) {
                treeElement.deleteChild((TreeElement)((ArrayList)object).get(n));
                ++n;
            }
            object = treeElement.getAllChildrenOfType(IViewConstants.CLASS_ID_NAME);
            n = 0;
            while (object != null && n < ((ArrayList)object).size()) {
                treeElement.deleteChild((TreeElement)((ArrayList)object).get(n));
                ++n;
            }
            object = treeElement.getAllChildrenOfType(IViewConstants.OBJECT_ID_NAME);
            n = 0;
            while (object != null && n < ((ArrayList)object).size()) {
                treeElement.deleteChild((TreeElement)((ArrayList)object).get(n));
                ++n;
            }
            object = treeElement.getAllChildrenOfType(IViewConstants.METHOD_ID_NAME);
            n = 0;
            while (object != null && n < ((ArrayList)object).size()) {
                treeElement.deleteChild((TreeElement)((ArrayList)object).get(n));
                ++n;
            }
        }
        if (this.fParser == null) {
            this.fParser = new COBOLParser();
        }
        try {
            ArrayList arrayList;
            this.fParser.setProgramFormat(string2);
            this.fParser.setFromFile(false);
            this.fParser.parseFile(iFile);
            object = this.fParser.getStartElement();
            if (object != null && (arrayList = ((Element)object).getChildElements()) != null && arrayList.size() > 0) {
                int n = 0;
                while (n < arrayList.size()) {
                    ViewsUtil.traverseAndAdd(treeElement, (Element)arrayList.get(n));
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return;
        }
    }

    public void paresFile(final TreeElement treeElement, IFile iFile, String string) {
        if (treeElement != null && iFile != null) {
            this.createClassElements(treeElement, string, iFile, ViewsUtil.getReferenceFormat());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ViewsUtil.refreshViews(treeElement);
                }
            });
        }
    }

    public void refreshStructuresViewAndUpdateModel(IFile iFile) {
        Object object;
        String string = iFile.getProject().getName();
        String string2 = iFile.getFullPath().toString();
        if (string2.startsWith(String.valueOf('/'))) {
            string2 = string2.substring(1);
        }
        TreeElement treeElement = this.getRoot().getChildFromName(string);
        TreeElement treeElement2 = null;
        if (treeElement == null) {
            return;
        }
        treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER");
        TreeElement treeElement3 = null;
        if (treeElement2 != null) {
            treeElement3 = treeElement2.getChildFromLocation(string2);
            if (treeElement3 == null) {
                return;
            }
        } else {
            return;
        }
        if (treeElement3 != null && treeElement3.hasChildren()) {
            object = treeElement3.getAllChildrenOfType(IViewConstants.PROGRAM_ID_NAME);
            int n = 0;
            while (object != null && n < ((ArrayList)object).size()) {
                treeElement3.deleteChild((TreeElement)((ArrayList)object).get(n));
                ++n;
            }
            object = treeElement3.getAllChildrenOfType(IViewConstants.FACTORY_ID_NAME);
            n = 0;
            while (object != null && n < ((ArrayList)object).size()) {
                treeElement3.deleteChild((TreeElement)((ArrayList)object).get(n));
                ++n;
            }
            object = treeElement3.getAllChildrenOfType(IViewConstants.CLASS_ID_NAME);
            n = 0;
            while (object != null && n < ((ArrayList)object).size()) {
                treeElement3.deleteChild((TreeElement)((ArrayList)object).get(n));
                ++n;
            }
            object = treeElement3.getAllChildrenOfType(IViewConstants.OBJECT_ID_NAME);
            n = 0;
            while (object != null && n < ((ArrayList)object).size()) {
                treeElement3.deleteChild((TreeElement)((ArrayList)object).get(n));
                ++n;
            }
            object = treeElement3.getAllChildrenOfType(IViewConstants.METHOD_ID_NAME);
            n = 0;
            while (object != null && n < ((ArrayList)object).size()) {
                treeElement3.deleteChild((TreeElement)((ArrayList)object).get(n));
                ++n;
            }
        }
        if (this.fParser == null) {
            this.fParser = new COBOLParser();
        }
        try {
            ArrayList arrayList;
            this.fParser.setProgramFormat(ViewsTreeModel.getReferenceFormat());
            this.fParser.setFromFile(true);
            if (!iFile.exists()) {
                return;
            }
            this.fParser.parseFile(iFile);
            object = this.fParser.getStartElement();
            if (object != null && (arrayList = ((Element)object).getChildElements()) != null && arrayList.size() > 0) {
                int n = 0;
                while (n < arrayList.size()) {
                    ViewsUtil.traverseAndAdd(treeElement3, (Element)arrayList.get(n));
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return;
        }
    }

    private static String getReferenceFormat() {
        return CBDTUiPlugin.getDefault().getPreferenceStore().getString("Reference Format");
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    private String endsWithFileSeparator(String string) {
        Path path = new Path(string);
        if (path != null && path.getDevice() != null && path.getDevice().length() > 0) {
            String string2 = System.getProperty("file.separator");
            if (string2 != null && !string.endsWith(string2)) {
                string = String.valueOf(string) + string2;
            }
        } else if (path != null && path.getDevice() == null && !string.endsWith(String.valueOf('/'))) {
            string = String.valueOf(string) + '/';
        }
        return string;
    }

    private String getFileCannonicalPath(File file) {
        try {
            IWorkspaceRoot iWorkspaceRoot;
            String string;
            String string2 = file.getCanonicalPath();
            if (!string2.endsWith(File.separator)) {
                string2 = String.valueOf(string2) + File.separator;
            }
            if (string2.startsWith(string = (iWorkspaceRoot = CBDTUiPlugin.getWorkspace().getRoot()).getLocation().toFile().getCanonicalPath())) {
                int n = string.length();
                String string3 = string2.substring(n);
                Path path = new Path(string3);
                if (path != null && iWorkspaceRoot.findMember((IPath)path) != null && iWorkspaceRoot.findMember((IPath)path) instanceof IResource) {
                    string3 = path.toString();
                    if ('/' == string3.charAt(0)) {
                        string3 = string3.substring(1);
                        return string3;
                    }
                } else {
                    return string2;
                }
            }
            return string2;
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
            return "";
        }
    }

    private String getREPLocation(String string, String string2) {
        try {
            String string3;
            File file;
            File file2;
            if (string != null && string.length() > 0 && (file2 = new File(string)) != null && file2.isDirectory() && file2.exists() && (file = new File(string3 = String.valueOf(file2.getCanonicalPath()) + File.separator + string2)) != null && file.isFile() && file.exists()) {
                return string3;
            }
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
        }
        return null;
    }

    public void dispose() {
        if (fRoot != null) {
            fRoot.deleteChildren();
            fRoot.dispose();
            fRoot = null;
        }
    }
}

