/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.common.RemoteFile;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPage;

public class ViewsDoubleClickListener
implements IDoubleClickListener {
    TreeViewer fTreeViewer = null;

    public ViewsDoubleClickListener(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        if (doubleClickEvent != null) {
            Object object = null;
            if (doubleClickEvent instanceof DoubleClickEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
                object = iStructuredSelection.getFirstElement();
            }
            if (object == null) {
                return;
            }
            if (object != null && this.fTreeViewer.isExpandable(object)) {
                this.fTreeViewer.setExpandedState(object, !this.fTreeViewer.getExpandedState(object));
            }
            this.openFile();
        }
    }

    private void openFile() {
        TreeElement[] treeElementArray = ViewsUtil.getAllSelection(this.fTreeViewer);
        if (treeElementArray != null) {
            int n = treeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                try {
                    Object[] objectArray;
                    Object object;
                    MessageDialog messageDialog;
                    String[] stringArray;
                    IWorkspace iWorkspace;
                    IWorkbenchPage iWorkbenchPage;
                    String string = treeElementArray[n2].getAttribute("TYPE");
                    String string2 = treeElementArray[n2].getName();
                    if (!ViewsUtil.isSelectedElementOpenable(string)) {
                        return;
                    }
                    if (string2.endsWith(".so") || string2.endsWith(".SO") || string2.endsWith(".o") || string2.endsWith(".O") || string2.endsWith(".dll") || string2.endsWith(".DLL")) {
                        iWorkbenchPage = new IWorkbenchPage[]{Messages.getString((String)"Ok")};
                        iWorkspace = new MessageDialog(this.fTreeViewer.getControl().getShell(), Messages.getString((String)"UnableToOpenFile"), null, Messages.getString((String)"UnableToOpenFileMessage"), 2, (String[])iWorkbenchPage, 0);
                        iWorkspace.open();
                        return;
                    }
                    iWorkbenchPage = CBDTUiPlugin.getActivePage();
                    iWorkspace = ResourcesPlugin.getWorkspace();
                    IProject iProject = iWorkspace.getRoot().getProject(treeElementArray[n2].getProject().getName());
                    if (iProject == null || iProject.getLocation() == null) {
                        stringArray = new String[]{Messages.getString((String)"Ok")};
                        messageDialog = new MessageDialog(this.fTreeViewer.getControl().getShell(), Messages.getString((String)"ProjectDoesNotExist"), null, Messages.getString((String)"ProjectDoesNotExistMessage"), 2, stringArray, 0);
                        messageDialog.open();
                        return;
                    }
                    stringArray = treeElementArray[n2].getAdapter(IResource.class);
                    messageDialog = null;
                    Path path = new Path(treeElementArray[n2].getFile().getLocation());
                    if (stringArray != null && stringArray instanceof IFile) {
                        messageDialog = (IFile)stringArray;
                    } else if (path != null && path.getDevice() != null && path.getDevice().length() > 0) {
                        object = new RemoteFile(path.toOSString());
                        if (object != null) {
                            messageDialog = object.fFileToOpen;
                        }
                    } else {
                        object = iProject.findMember(path.removeFirstSegments(1).toString());
                        if (object != null && object instanceof IFile) {
                            messageDialog = (IFile)object;
                        }
                    }
                    if (messageDialog != null) {
                        ViewsUtil.openFileInEditor(iWorkbenchPage, (IFile)messageDialog);
                    }
                    if (ViewsUtil.canHighlightElement(string) && (objectArray = ((IStructuredSelection)(object = this.fTreeViewer.getSelection())).toArray()) != null && objectArray.length > 0 && objectArray[0] instanceof TreeElement) {
                        TreeElement treeElement = (TreeElement)objectArray[0];
                        ViewsUtil.highlightCOBOLKeyWord(ViewsUtil.getEditorPart((IStructuredSelection)object), treeElement);
                    }
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                }
                ++n2;
            }
        }
    }
}

