/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.ProblemMarkerLabelProvider;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;

public class TreeElementMapper {
    private HashMap fTreeElementList = new HashMap(10);
    private static TreeElementMapper fTreeElementMapper = null;
    private ProblemMarkerLabelProvider fProblemMarkerLabelProvider = null;
    private ArrayList viewerList = new ArrayList(5);

    private TreeElementMapper() {
        this.fProblemMarkerLabelProvider = new ProblemMarkerLabelProvider();
    }

    public static TreeElementMapper getInstance() {
        if (fTreeElementMapper == null) {
            fTreeElementMapper = new TreeElementMapper();
        }
        return fTreeElementMapper;
    }

    public void resourceChanged(IResource iResource) {
        Object v;
        TreeElement treeElement = this.getTreeElement(iResource);
        if (treeElement != null && (v = this.fTreeElementList.get(treeElement)) != null) {
            ArrayList arrayList = (ArrayList)v;
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                this.updateItem(treeElement, (Item)arrayList.get(n2));
                ++n2;
            }
        }
    }

    private TreeElement getTreeElement(IResource iResource) {
        TreeElement treeElement = null;
        if (iResource instanceof IProject) {
            treeElement = ViewsTreeModel.getInstance().getProjectNode(iResource.getName());
        } else if (iResource instanceof IFile) {
            TreeElement treeElement2;
            IProject iProject = ((IFile)iResource).getProject();
            TreeElement treeElement3 = ViewsTreeModel.getInstance().getProjectNode(iProject.getName());
            if (treeElement3 != null && (treeElement2 = treeElement3.getChildFromType("SOURCE_FOLDER")) != null) {
                String string = ((IFile)iResource).getFullPath().toString();
                if (string.startsWith(String.valueOf('/'))) {
                    string = string.substring(1);
                }
                treeElement = treeElement2.getChildFromLocation(string);
            }
        }
        return treeElement;
    }

    private void updateItem(TreeElement treeElement, Item item) {
        if (!item.isDisposed()) {
            TreeViewer treeViewer;
            Object object = item.getData();
            Image image = item.getImage();
            Image image2 = null;
            if (treeElement.getMarker() == 2) {
                image2 = this.fProblemMarkerLabelProvider.getImage(object);
            } else if (treeElement.getMarker() == 1) {
                image2 = this.fProblemMarkerLabelProvider.getImage(object);
            } else if (treeElement.getMarker() == -1 && (treeViewer = (TreeViewer)this.viewerList.get(0)) != null) {
                image2 = ((ILabelProvider)treeViewer.getLabelProvider()).getImage(object);
            }
            if (image2 != null && !image2.equals((Object)image)) {
                item.setImage(image2);
            }
        }
    }

    public void addToMap(Object object, Item item) {
        if (object != null && object instanceof TreeElement && this.isValidElementToMap((TreeElement)object)) {
            Object v = this.fTreeElementList.get(object);
            if (v == null) {
                ArrayList arrayList = this.getList();
                arrayList.add(item);
                this.fTreeElementList.put(object, arrayList);
            } else {
                ArrayList arrayList = (ArrayList)v;
                if (!arrayList.contains(item)) {
                    arrayList.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object object, Item item) {
        if (object != null && object instanceof TreeElement && this.isValidElementToMap((TreeElement)object)) {
            Object v = this.fTreeElementList.get(object);
            if (v == null) {
                return;
            }
            ArrayList arrayList = (ArrayList)v;
            arrayList.remove(item);
            if (arrayList.isEmpty()) {
                this.fTreeElementList.remove(object);
            }
        }
    }

    private boolean isValidElementToMap(TreeElement treeElement) {
        return SelectionAction.isProject(treeElement) || SelectionAction.isSourceFolder(treeElement) || SelectionAction.isSourceFile(treeElement);
    }

    void removeMapTreeElement(TreeElement treeElement) {
        if (treeElement != null && this.isValidElementToMap(treeElement)) {
            Object v = this.fTreeElementList.get(treeElement);
            if (v == null) {
                return;
            }
            ArrayList arrayList = (ArrayList)v;
            arrayList.clear();
            this.fTreeElementList.remove(treeElement);
        }
    }

    public ArrayList getList() {
        return new ArrayList();
    }

    public void clearMapper(TreeViewer treeViewer) {
        this.viewerList.remove(treeViewer);
        if (this.viewerList.size() > 0) {
            return;
        }
        if (this.fTreeElementList != null) {
            this.fTreeElementList.clear();
            this.fProblemMarkerLabelProvider.dispose();
            this.viewerList.clear();
        }
    }

    public boolean isProblemMarkerChanged(IResourceDelta iResourceDelta) {
        if (iResourceDelta != null && (iResourceDelta.getFlags() & 0x20000) != 0) {
            IMarkerDelta[] iMarkerDeltaArray = iResourceDelta.getMarkerDeltas();
            int n = 0;
            while (n < iMarkerDeltaArray.length) {
                if (iMarkerDeltaArray[n].isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                    int n2 = iMarkerDeltaArray[n].getKind();
                    if (n2 == 1) {
                        TreeElement treeElement = this.getTreeElement(iResourceDelta.getResource());
                        if (treeElement != null) {
                            treeElement.setMarker(1);
                        }
                        return true;
                    }
                    if (n2 == 2) {
                        TreeElement treeElement = this.getTreeElement(iResourceDelta.getResource());
                        if (treeElement != null) {
                            treeElement.setMarker(2);
                        }
                        return true;
                    }
                    int n3 = iMarkerDeltaArray[n].getAttribute("severity", -1);
                    int n4 = iMarkerDeltaArray[n].getMarker().getAttribute("severity", -1);
                    if (n4 != n3) {
                        TreeElement treeElement = this.getTreeElement(iResourceDelta.getResource());
                        if (treeElement != null) {
                            treeElement.setMarker(1);
                        }
                        return true;
                    }
                }
                ++n;
            }
        }
        return false;
    }

    public void setViewPart(TreeViewer treeViewer) {
        this.viewerList.add(treeViewer);
    }

    public void updateMarker(final IResourceDelta iResourceDelta) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (iResourceDelta != null && TreeElementMapper.this.isProblemMarkerChanged(iResourceDelta)) {
                    TreeElementMapper.this.resourceChanged(iResourceDelta.getResource());
                }
            }
        });
    }

    public void updateMarker(IResourceChangeEvent iResourceChangeEvent) {
        Display display;
        IMarkerDelta[] iMarkerDeltaArray = iResourceChangeEvent.findMarkerDeltas(null, true);
        final ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
        final ArrayList<TreeElement> arrayList2 = new ArrayList<TreeElement>(10);
        int n = 0;
        while (iMarkerDeltaArray != null && n < iMarkerDeltaArray.length) {
            IMarkerDelta iMarkerDelta = iMarkerDeltaArray[n];
            int n2 = iMarkerDelta.getKind();
            IResource iResource = iMarkerDeltaArray[n].getResource();
            int n3 = iMarkerDeltaArray[n].getAttribute("severity", -1);
            if (iMarkerDelta.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                TreeElement treeElement = null;
                TreeElement treeElement2 = null;
                TreeElement treeElement3 = null;
                switch (n2) {
                    case 1: 
                    case 4: {
                        if (n3 == 0 || (treeElement = this.getTreeElement(iResource)) == null) break;
                        if (SelectionAction.isProject(treeElement)) {
                            treeElement2 = treeElement.getChildFromType("SOURCE_FOLDER");
                            if (treeElement2 != null && treeElement2.getMarker() < n3) {
                                treeElement2.setMarker(n3);
                            }
                            if (treeElement2 != null && !arrayList.contains(treeElement2)) {
                                arrayList.add(treeElement2);
                                treeElement2.setMarker(n3);
                            }
                        }
                        if (treeElement.getMarker() < n3) {
                            treeElement.setMarker(n3);
                        }
                        if (arrayList.contains(treeElement)) break;
                        arrayList.add(treeElement);
                        treeElement.setMarker(this.isMarkerAssociated(iResource, n3));
                        break;
                    }
                    case 2: {
                        TreeElement treeElement4;
                        treeElement = this.getTreeElement(iResource);
                        if (treeElement == null) break;
                        if (!arrayList.contains(treeElement)) {
                            treeElement.setMarker(-1);
                        }
                        if (!arrayList2.contains(treeElement)) {
                            arrayList2.add(treeElement);
                        }
                        if (SelectionAction.isSourceFile(treeElement)) {
                            treeElement2 = treeElement.getParent();
                            if (!arrayList.contains(treeElement2)) {
                                treeElement2.setMarker(-1);
                            }
                            if (!arrayList.contains(treeElement3 = treeElement.getProject())) {
                                treeElement3.setMarker(-1);
                            }
                        }
                        if (!SelectionAction.isProject(treeElement) || (treeElement4 = treeElement.getChildFromType("SOURCE_FOLDER")) == null || treeElement4.getMarker() <= 0 || treeElement4.hasChildren()) break;
                        treeElement4.setMarker(-1);
                    }
                }
            }
            ++n;
        }
        if (!this.isMarkerAssociatedInSource(arrayList)) {
            this.updateRemoveMarkersForSourceFolder(arrayList2);
        }
        if ((display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                int n;
                int n2;
                TreeElement treeElement;
                int n3 = 0;
                while (n3 < arrayList2.size()) {
                    int n4;
                    ArrayList<Object> arrayList5;
                    Object object;
                    treeElement = (TreeElement)arrayList2.get(n3);
                    int n5 = treeElement.getMarker();
                    treeElement.setMarker(-1);
                    if (treeElement != null && (object = TreeElementMapper.this.fTreeElementList.get(treeElement)) != null) {
                        arrayList5 = (ArrayList)object;
                        n2 = arrayList5.size();
                        n4 = 0;
                        while (n4 < n2) {
                            TreeElementMapper.this.updateItem(treeElement, (Item)arrayList5.get(n4));
                            ++n4;
                        }
                    }
                    if (SelectionAction.isSourceFile(treeElement)) {
                        int n6 = treeElement.getParent().getMarker();
                        treeElement.getParent().setMarker(-1);
                        arrayList5 = TreeElementMapper.this.fTreeElementList.get(treeElement.getParent());
                        if (arrayList5 != null) {
                            ArrayList<Object> arrayList22 = arrayList5;
                            n4 = arrayList22.size();
                            n = 0;
                            while (n < n4) {
                                TreeElementMapper.this.updateItem(treeElement.getParent(), (Item)arrayList22.get(n));
                                ++n;
                            }
                        }
                        treeElement.getParent().setMarker(n6);
                        n6 = treeElement.getProject().getMarker();
                        treeElement.getProject().setMarker(-1);
                        arrayList5 = TreeElementMapper.this.fTreeElementList.get(treeElement.getProject());
                        if (arrayList5 != null) {
                            ArrayList<Object> arrayList3 = arrayList5;
                            n4 = arrayList3.size();
                            n = 0;
                            while (n < n4) {
                                TreeElementMapper.this.updateItem(treeElement.getProject(), (Item)arrayList3.get(n));
                                ++n;
                            }
                        }
                        treeElement.getProject().setMarker(n6);
                        TreeElementMapper.this.setProblemMarkerForFile(treeElement);
                    } else if (SelectionAction.isProject(treeElement) && (object = treeElement.getChildFromType("SOURCE_FOLDER")) != null) {
                        int n7 = ((TreeElement)object).getMarker();
                        ((TreeElement)object).setMarker(-1);
                        Object v = TreeElementMapper.this.fTreeElementList.get(object);
                        if (v != null) {
                            ArrayList arrayList4 = (ArrayList)v;
                            n = arrayList4.size();
                            int n8 = 0;
                            while (n8 < n) {
                                TreeElementMapper.this.updateItem((TreeElement)object, (Item)arrayList4.get(n8));
                                ++n8;
                            }
                        }
                        ((TreeElement)object).setMarker(n7);
                    }
                    treeElement.setMarker(n5);
                    ++n3;
                }
                n3 = 0;
                while (n3 < arrayList.size()) {
                    treeElement = (TreeElement)arrayList.get(n3);
                    if ((!SelectionAction.isSourceFolder(treeElement) || TreeElementMapper.this.isMarkerExistsInSourceFile(treeElement.getAllChildrenOfType("SOURCE_FILE"))) && treeElement != null) {
                        Object v = TreeElementMapper.this.fTreeElementList.get(treeElement);
                        if (v != null) {
                            ArrayList arrayList6 = (ArrayList)v;
                            int n9 = arrayList6.size();
                            n2 = 0;
                            while (n2 < n9) {
                                TreeElementMapper.this.updateItem(treeElement, (Item)arrayList6.get(n2));
                                ++n2;
                            }
                        }
                        TreeElementMapper.this.setProblemMarkerForFile(treeElement);
                        if (1 == treeElement.getMarker() && SelectionAction.isSourceFile(treeElement)) {
                            TreeElement treeElement2;
                            if (2 != treeElement.getProject().getMarker()) {
                                treeElement.getProject().setMarker(1);
                                Object v2 = TreeElementMapper.this.fTreeElementList.get(treeElement.getProject());
                                if (v2 != null) {
                                    ArrayList arrayList7 = (ArrayList)v2;
                                    n2 = arrayList7.size();
                                    int n10 = 0;
                                    while (n10 < n2) {
                                        TreeElementMapper.this.updateItem(treeElement.getProject(), (Item)arrayList7.get(n10));
                                        ++n10;
                                    }
                                }
                            }
                            if ((treeElement2 = treeElement.getParent()) != null && 2 != treeElement2.getMarker()) {
                                treeElement2.setMarker(1);
                                Object v3 = TreeElementMapper.this.fTreeElementList.get(treeElement2);
                                if (v3 != null) {
                                    ArrayList arrayList8 = (ArrayList)v3;
                                    int n11 = arrayList8.size();
                                    n = 0;
                                    while (n < n11) {
                                        TreeElementMapper.this.updateItem(treeElement2, (Item)arrayList8.get(n));
                                        ++n;
                                    }
                                }
                            }
                        }
                    }
                    ++n3;
                }
            }
        });
    }

    private boolean isMarkerExistsInSourceFile(ArrayList arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            int n = arrayList.size();
            TreeElement treeElement = ((TreeElement)arrayList.get(0)).getParent();
            int n2 = treeElement.getMarker();
            int n3 = 0;
            while (n3 < n) {
                if (n2 == ((TreeElement)arrayList.get(n3)).getMarker()) {
                    return true;
                }
                ++n3;
            }
            treeElement.setMarker(-1);
        }
        return false;
    }

    private int isMarkerAssociated(IResource iResource, int n) {
        int n2 = n;
        try {
            if (iResource != null) {
                IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int n3 = 0;
                while (iMarkerArray != null && n3 < iMarkerArray.length) {
                    if (iMarkerArray[n3].getAttribute("severity", -1) > n2) {
                        n2 = iMarkerArray[n3].getAttribute("severity", -1);
                    }
                    ++n3;
                }
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        return n2;
    }

    private void setProblemMarkerForFile(TreeElement treeElement) {
        if (treeElement != null && SelectionAction.isSourceFile(treeElement)) {
            IEditorReference[] iEditorReferenceArray;
            String string = treeElement.getLocation();
            if (CBDTUiPlugin.getActivePage() != null && (iEditorReferenceArray = CBDTUiPlugin.getActivePage().getEditorReferences()) != null && iEditorReferenceArray.length > 0) {
                int n = 0;
                while (n < iEditorReferenceArray.length) {
                    IEditorPart iEditorPart = iEditorReferenceArray[n].getEditor(false);
                    if (iEditorPart instanceof COBOLEditor && BuildUtil.isCobolFileExtn(treeElement.getName()) && iEditorPart.getEditorInput() instanceof IFileEditorInput) {
                        String string2 = ((IFileEditorInput)iEditorPart.getEditorInput()).getFile().getFullPath().toString();
                        if ('/' == string2.charAt(0)) {
                            string2 = string2.substring(1);
                        }
                        if (string.equals(string2)) {
                            ((COBOLEditor)iEditorPart).setTitleImage(COBOLPluginImages.get("org.eclipse.cobol.ui.Cobol_File_Icon.gif"));
                        }
                    }
                    ++n;
                }
            }
        }
    }

    private boolean isMarkerAssociatedInSource(ArrayList arrayList) {
        int n = 0;
        if (arrayList != null && (n = arrayList.size()) > 0) {
            int n2 = 0;
            while (n2 < n) {
                TreeElement treeElement = (TreeElement)arrayList.get(n2);
                if (SelectionAction.isSourceFile(treeElement) && (treeElement.getMarker() == 2 || treeElement.getMarker() == 1)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void updateRemoveMarkersForSourceFolder(ArrayList arrayList) {
        int n = 0;
        if (arrayList != null && (n = arrayList.size()) > 0) {
            int n2 = 0;
            while (n2 < n) {
                TreeElement treeElement;
                TreeElement treeElement2 = (TreeElement)arrayList.get(n2);
                if (SelectionAction.isProject(treeElement2) && (treeElement = treeElement2.getChildFromType("SOURCE_FOLDER")) != null) {
                    treeElement.setMarker(treeElement2.getMarker());
                    return;
                }
                ++n2;
            }
        }
    }
}

