/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;

public class TreeElementLabelProviderListener
implements ILabelProviderListener {
    private TreeViewer fTreeViewer = null;

    public TreeElementLabelProviderListener(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
    }

    public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        Object[] objectArray = labelProviderChangedEvent.getElements();
        TreeElement treeElement = this.getProjectNode(objectArray);
        if (treeElement != null && SelectionAction.isProject(treeElement) && this.fTreeViewer != null) {
            ViewsUtil.refreshViews(treeElement);
        }
    }

    private TreeElement getProjectNode(Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof IProject) {
                    String string = ((IProject)objectArray[n]).getName();
                    TreeElement treeElement = ViewsTreeModel.getInstance().getProjectNode(string);
                    if (treeElement != null) {
                        return treeElement;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    public void dispose() {
        this.fTreeViewer = null;
    }
}

