/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.build.DependencyModelManipulation;
import org.eclipse.cobol.ui.views.actions.AddToSourceAction;
import org.eclipse.cobol.ui.views.actions.RemoveFromSourceAction;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.RemoteFile;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.TreeElementDragSourceAdapter;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class TreeElementDropTargetListener
implements DropTargetListener {
    private TreeElementDragSourceAdapter fDragSourceAdapter = null;
    private TreeViewer fTreeViewer = null;
    private int dragOperation = 2;

    public TreeElementDropTargetListener(TreeElementDragSourceAdapter treeElementDragSourceAdapter, TreeViewer treeViewer) {
        this.fDragSourceAdapter = treeElementDragSourceAdapter;
        this.fTreeViewer = treeViewer;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.dragOperation = dropTargetEvent.detail;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        this.dragOperation = dropTargetEvent.detail;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        TreeElement treeElement;
        dropTargetEvent.feedback = 25;
        if (!this.fDragSourceAdapter.isDraggedFromSameView() && this.fDragSourceAdapter.getSelectedTreeElements().size() == 0) {
            dropTargetEvent.detail = 0;
            return;
        }
        this.fDragSourceAdapter.setDraggedFromSameView(true);
        Object object = ((Item)dropTargetEvent.item).getData();
        dropTargetEvent.detail = object != null && object instanceof TreeElement ? (SelectionAction.isSourceFile(treeElement = (TreeElement)object) || SelectionAction.isSourceFolder(treeElement) || SelectionAction.isOtherFile(treeElement) || SelectionAction.isOtherFolder(treeElement) || SelectionAction.isOtherSubFolder(treeElement) || SelectionAction.isProject(treeElement) ? (dropTargetEvent.detail == 1 ? 1 : this.dragOperation) : 0) : 0;
    }

    public void drop(final DropTargetEvent dropTargetEvent) {
        if (dropTargetEvent.data == null) {
            dropTargetEvent.detail = 0;
            return;
        }
        if (dropTargetEvent.item instanceof Item) {
            final ArrayList arrayList = new ArrayList(10);
            final IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    block20: {
                        Object object = ((Item)dropTargetEvent.item).getData();
                        if (!(object instanceof TreeElement)) break block20;
                        TreeElement treeElement = (TreeElement)object;
                        IPath iPath = TreeElementDropTargetListener.this.getDestinationPath(treeElement);
                        if (!(dropTargetEvent.data instanceof String[])) break block20;
                        String[] stringArray = (String[])dropTargetEvent.data;
                        int n = 0;
                        while (stringArray != null && n < stringArray.length) {
                            block21: {
                                Object object2;
                                String string;
                                boolean bl;
                                TreeElement treeElement2;
                                String string2;
                                TreeElement treeElement3;
                                String string3;
                                block29: {
                                    block28: {
                                        Object object3;
                                        block27: {
                                            boolean bl2;
                                            block25: {
                                                IPath iPath2;
                                                ArrayList arrayList2;
                                                block26: {
                                                    boolean bl3;
                                                    block22: {
                                                        block24: {
                                                            TreeElement treeElement4;
                                                            block23: {
                                                                string3 = new Path(stringArray[n]).lastSegment();
                                                                treeElement3 = TreeElementDropTargetListener.this.getDropPlaceHolder(treeElement);
                                                                string2 = TreeElementDropTargetListener.this.getElementType(treeElement, stringArray[n]);
                                                                treeElement2 = TreeElementDropTargetListener.this.getSourceElement(n, TreeElementDropTargetListener.this.getSourceLocation(stringArray[n]));
                                                                boolean bl4 = bl = dropTargetEvent.detail != 1;
                                                                if (IViewConstants.OTHER_FILES_SUBFOLDER_NAME.equals(string2) && !TreeElementDropTargetListener.this.validateSubfolderDragOperation(treeElement3, stringArray[n]) || new Path(stringArray[n]).toFile().isDirectory() && !string2.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME) || treeElement3 == null || string2 == null) break block21;
                                                                string = iPath.append(string3).toString();
                                                                if (string != null && string.charAt(0) == '/') {
                                                                    string = string.substring(1);
                                                                }
                                                                arrayList2 = TreeElementDropTargetListener.this.getAllChildElements(treeElement3);
                                                                if (string.endsWith("build.xml")) {
                                                                    return;
                                                                }
                                                                bl2 = TreeElementDropTargetListener.this.isFileAlreadyExist(arrayList2, string);
                                                                treeElement4 = ViewsActionUtil.isCopyingSameLocation(treeElement3, stringArray[n], string);
                                                                boolean bl5 = bl3 = treeElement4 != null;
                                                                if (!bl3 || !bl) break block22;
                                                                if (!SelectionAction.isSourceFile(treeElement4) || !SelectionAction.isOtherFolder(treeElement3) && !SelectionAction.isOtherSubFolder(treeElement3)) break block23;
                                                                RemoveFromSourceAction.moveToOtherFolder(treeElement4);
                                                                break block24;
                                                            }
                                                            if (!SelectionAction.isOtherFile(treeElement4) || !SelectionAction.isSourceFolder(treeElement3)) break block21;
                                                            AddToSourceAction.moveToSourceFolder(treeElement4);
                                                        }
                                                        if (!arrayList.contains(treeElement3.getProject())) {
                                                            arrayList.add(treeElement3.getProject());
                                                        }
                                                        break block21;
                                                    }
                                                    if (!bl3 || bl) break block25;
                                                    object2 = CBDTUiPlugin.getWorkspace();
                                                    object3 = object2.getRoot().findMember(String.valueOf('/') + string);
                                                    iPath2 = object3.getFullPath().removeLastSegments(1);
                                                    String[] stringArray2 = new String[]{""};
                                                    TreeElementDropTargetListener.this.fTreeViewer.getTree().getShell().getDisplay().syncExec(new Runnable((IResource)object3, stringArray2, arrayList2, iPath2, (IWorkspace)object2){
                                                        private final /* synthetic */ IResource val$resource;
                                                        private final /* synthetic */ String[] val$returnValue;
                                                        private final /* synthetic */ ArrayList val$childElements;
                                                        private final /* synthetic */ IPath val$prefix;
                                                        private final /* synthetic */ IWorkspace val$workspace;
                                                        {
                                                            this.val$resource = iResource;
                                                            this.val$returnValue = stringArray;
                                                            this.val$childElements = arrayList;
                                                            this.val$prefix = iPath;
                                                            this.val$workspace = iWorkspace;
                                                        }

                                                        @Override
                                                        public void run() {
                                                            IInputValidator iInputValidator = new IInputValidator(){

                                                                public String isValid(String string) {
                                                                    if (val$resource.getName().equals(string) || TreeElementDropTargetListener.this.isFileAlreadyExist(val$childElements, val$prefix.append(string).toString())) {
                                                                        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameMustBeDifferent;
                                                                    }
                                                                    IStatus iStatus = val$workspace.validateName(string, val$resource.getType());
                                                                    if (!iStatus.isOK()) {
                                                                        return iStatus.getMessage();
                                                                    }
                                                                    if (val$workspace.getRoot().exists(val$prefix.append(string))) {
                                                                        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameExists;
                                                                    }
                                                                    return null;
                                                                }
                                                            };
                                                            InputDialog inputDialog = new InputDialog(TreeElementDropTargetListener.this.fTreeViewer.getTree().getShell(), IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogTitle, IDEWorkbenchMessages.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object[])new String[]{this.val$resource.getName()}), this.val$resource.getName(), iInputValidator);
                                                            inputDialog.setBlockOnOpen(true);
                                                            inputDialog.open();
                                                            if (inputDialog.getReturnCode() == 1) {
                                                                return;
                                                            }
                                                            this.val$returnValue[0] = inputDialog.getValue();
                                                        }
                                                    });
                                                    string3 = stringArray2[0];
                                                    if (string3 != null && !string3.equals("")) break block26;
                                                    bl2 = false;
                                                    break block21;
                                                }
                                                string = iPath2.append(string3).toString();
                                                if (string != null && string.startsWith(String.valueOf('/'))) {
                                                    string = string.substring(1);
                                                }
                                                bl2 = TreeElementDropTargetListener.this.isFileAlreadyExist(arrayList2, string);
                                                break block27;
                                            }
                                            if (bl2 && !ViewsActionUtil.canOverwriteMove(TreeElementDropTargetListener.this.getShell(), string3)) break block21;
                                        }
                                        if (!string2.equals("SOURCE_FILE")) break block28;
                                        ViewsActionUtil.showCOBOLUnsupportedMessage(treeElement.getProject().getIProject(), string3);
                                        object2 = new ArrayList();
                                        object3 = ViewsUtil.getFilesForFolder(treeElement.getProject(), "SOURCE_FOLDER");
                                        if (object3 != null) {
                                            int n2 = 0;
                                            while (n2 < ((ArrayList)object3).size()) {
                                                ((ArrayList)object2).add(((TreeElement)((ArrayList)object3).get(n2)).getName().trim());
                                                ++n2;
                                            }
                                        }
                                        break block29;
                                    }
                                    if (string2.equals(IViewConstants.LINKING_FILES_NAME) && !TreeElementDropTargetListener.this.isValidLinkingFile(string3)) break block21;
                                }
                                if (IViewConstants.OTHER_FILES_SUBFOLDER_NAME.equals(string2)) {
                                    TreeElementDropTargetListener.this.copyFolder(treeElement3, iPath, string3, stringArray[n], bl);
                                } else {
                                    TreeElementDropTargetListener.this.copyFile(treeElement3, treeElement2, iPath, string3, stringArray[n], bl);
                                }
                                TreeElementDropTargetListener.this.addChild(arrayList, treeElement3, string, string3, string2, treeElement2, bl);
                                if ("SOURCE_FILE" == string2 && BuildUtil.isCobolFileExtn(string3) && (object2 = treeElement3.getChildFromLocation(string)) != null) {
                                    if (treeElement2 != null) {
                                        ViewsActionUtil.updateMianProgram((TreeElement)object2, treeElement2);
                                    } else {
                                        ViewsActionUtil.updateMianProgram((TreeElement)object2, stringArray[n]);
                                    }
                                    ViewsActionUtil.setStructuredSelection(TreeElementDropTargetListener.this.fTreeViewer, (TreeElement)object2);
                                }
                            }
                            ++n;
                        }
                        n = arrayList.size();
                        int n3 = 0;
                        while (n3 < n) {
                            ViewsUtil.refreshViews((TreeElement)arrayList.get(n3));
                            ((TreeElement)arrayList.get(n3)).getIProject().refreshLocal(0, iProgressMonitor);
                            DependencyModelManipulation.generateAntFile((TreeElement)arrayList.get(n3));
                            ++n3;
                        }
                    }
                }
            };
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    iProgressMonitor.worked(10);
                    try {
                        CBDTUiPlugin.getWorkspace().run(iWorkspaceRunnable, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        CBDTUiPlugin.logError((Exception)((Object)coreException));
                    }
                    TreeElementDropTargetListener.this.fDragSourceAdapter.resetList();
                    dropTargetEvent.data = null;
                    dropTargetEvent.detail = 0;
                    TreeElementDropTargetListener.this.dragOperation = 0;
                }
            };
            try {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
                progressMonitorDialog.run(false, true, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                CBDTUiPlugin.logError(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                CBDTUiPlugin.logError(interruptedException);
            }
        }
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 0;
        switch (this.dragOperation) {
            case 1: {
                dropTargetEvent.detail = 1;
                break;
            }
            case 2: 
            case 16: {
                dropTargetEvent.detail = 2;
            }
        }
    }

    private TreeElement getSourceElement(int n, String string) {
        TreeElement treeElement;
        ArrayList arrayList = this.fDragSourceAdapter.getSelectedTreeElements();
        if (arrayList != null && n <= arrayList.size() - 1 && string != null && (treeElement = (TreeElement)arrayList.get(n)).getLocation().toLowerCase().equals(string.toLowerCase())) {
            return treeElement;
        }
        return null;
    }

    private void addChild(ArrayList arrayList, TreeElement treeElement, String string, String string2, String string3, TreeElement treeElement2, boolean bl) {
        TreeElement treeElement3;
        TreeElement treeElement4 = null;
        if (treeElement != null && string != null && string2 != null && string3 != null && arrayList != null) {
            treeElement4 = treeElement.addChild(string, string2, string3, true);
            if (!arrayList.contains(treeElement.getProject())) {
                arrayList.add(treeElement.getProject());
            }
            if (SelectionAction.isSourceFolder(treeElement)) {
                treeElement3 = treeElement.getProject().getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME);
                if (treeElement3 != null && treeElement3.getChildFromLocation(string) != null && !string2.equalsIgnoreCase("build.xml")) {
                    treeElement3.deleteChild(treeElement3.getChildFromLocation(string));
                }
                if (string2.equalsIgnoreCase("build.xml")) {
                    treeElement.deleteChild(treeElement4);
                }
            } else if (SelectionAction.isOtherFolder(treeElement) && (treeElement3 = treeElement.getProject().getChildFromType("SOURCE_FOLDER")) != null && treeElement3.getChildFromLocation(string) != null) {
                treeElement3.deleteChild(treeElement3.getChildFromLocation(string));
            }
            if (SelectionAction.isOtherFolder(treeElement) || SelectionAction.isOtherSubFolder(treeElement)) {
                treeElement.sortOtherFolders();
            }
        }
        if (treeElement2 != null && bl) {
            TreeElement treeElement5;
            treeElement3 = treeElement2.getChildFromType(IViewConstants.REPOSITORY_FOLDER_NAME);
            if (treeElement3 != null) {
                treeElement3.deleteChildren();
                treeElement2.deleteChild(treeElement3);
            }
            if ((treeElement5 = treeElement2.getChildFromType(IViewConstants.DEPENDENT_FILES_FOLDER_NAME)) != null) {
                treeElement5.deleteChildren();
                treeElement2.deleteChild(treeElement5);
            }
            treeElement2.getParent().deleteChild(treeElement2);
            if (!arrayList.contains(treeElement2.getProject())) {
                arrayList.add(treeElement2.getProject());
            }
        }
        if (treeElement4 != null && string3.equals("SOURCE_FILE") && (treeElement3 = (IFile)treeElement4.getAdapter(IResource.class)) != null) {
            ViewsTreeModel.getInstance().refreshStructuresViewAndUpdateModel((IFile)treeElement3);
        }
        if (SelectionAction.isLinkingFolder(treeElement) && this.getElementNode(treeElement, string) == null && treeElement2 == null && (treeElement3 = treeElement.getProject().getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME)) != null) {
            treeElement3.addChild(string, string2, string3, false);
        }
    }

    private void showMessage(String string) {
        Shell shell = this.fDragSourceAdapter.getTreeViewer().getTree().getShell();
        MessageDialog.openInformation((Shell)shell, (String)Messages.getString((String)"DropOperation"), (String)string);
    }

    private boolean showConfirmationMessage(String string) {
        Shell shell = this.fDragSourceAdapter.getTreeViewer().getTree().getShell();
        return MessageDialog.openConfirm((Shell)shell, (String)Messages.getString((String)"DropOperation"), (String)string);
    }

    private IPath getDestinationPath(TreeElement treeElement) {
        if (SelectionAction.isOtherSubFolder(treeElement)) {
            return new Path(treeElement.getLocation());
        }
        if (SelectionAction.isOtherFile(treeElement) && SelectionAction.isOtherSubFolder(treeElement.getParent())) {
            return new Path(treeElement.getParent().getLocation());
        }
        return treeElement.getIProject().getFullPath();
    }

    private void copyFile(TreeElement treeElement, TreeElement treeElement2, IPath iPath, String string, String string2, boolean bl) {
        IProject iProject = treeElement.getIProject();
        if (iProject != null && iPath != null && string != null && string2 != null) {
            Object object;
            IFile iFile;
            IPath iPath2 = iPath.removeFirstSegments(1).append(string);
            IResource iResource = iProject.findMember(iPath2);
            try {
                if (iResource == null) {
                    iFile = iProject.getFile(iPath2);
                    object = iFile.getLocation().toFile().getCanonicalPath();
                    object = object.substring(iProject.getLocation().toOSString().length());
                    iResource = iProject.findMember((IPath)new Path(object));
                }
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
            if (!this.isCopyAllowed(string2, iPath.append(string))) {
                if (!SelectionAction.isLinkingFolder(treeElement)) {
                    this.deleteElementNode(treeElement, iResource.getFullPath().toString());
                }
                return;
            }
            try {
                if (iResource != null && iResource.exists() && bl) {
                    iResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    if (!SelectionAction.isLinkingFolder(treeElement)) {
                        this.deleteElementNode(treeElement, iResource.getFullPath().toString());
                    }
                    iResource.getProject().refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
            }
            try {
                iFile = iProject.getFile(iPath2);
                object = new RemoteFile(string2);
                if (treeElement2 != null && iFile != null && !iFile.getLocation().toFile().exists()) {
                    IResource iResource2 = (IResource)treeElement2.getAdapter(IResource.class);
                    iResource2.copy(iFile.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
                } else if (iFile != null) {
                    if (iFile.getLocation().toFile().exists()) {
                        iFile.delete(true, null);
                    }
                    iFile.copy(((RemoteFile)((Object)object)).fFileToOpen.getLocation(), 1, null);
                }
                if (bl) {
                    this.deleteFileFromSource(string2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                CBDTUiPlugin.logError(fileNotFoundException);
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
            }
        }
    }

    private void copyFolder(TreeElement treeElement, IPath iPath, String string, String string2, boolean bl) {
        IProject iProject = treeElement.getIProject();
        if (iProject != null && iPath != null && string != null && string2 != null) {
            IFolder iFolder;
            IPath iPath2 = iPath.removeFirstSegments(1).append(string);
            IResource iResource = iProject.findMember(iPath2);
            try {
                if (iResource == null) {
                    iFolder = iProject.getFolder(iPath2);
                    String string3 = iFolder.getLocation().toFile().getCanonicalPath();
                    string3 = string3.substring(iProject.getLocation().toOSString().length());
                    iResource = iProject.findMember((IPath)new Path(string3));
                }
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
            if (!this.isCopyAllowed(string2, iPath.append(string))) {
                return;
            }
            try {
                iFolder = iProject.getFolder(iPath2);
                ViewsActionUtil.moveFolder(iFolder.getLocation().toOSString(), string2);
                if (bl) {
                    ViewsActionUtil.deleteFolder(string2);
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    private void deleteElementNode(TreeElement treeElement, String string) {
        TreeElement treeElement2 = treeElement.getProject();
        if (treeElement2 == null) {
            return;
        }
        TreeElement treeElement3 = treeElement2.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
        if (treeElement3 == null) {
            return;
        }
        TreeElement treeElement4 = treeElement2.getChildFromName(IViewConstants.LINKING_FILES_FOLDER_NAME);
        if (treeElement4 == null) {
            return;
        }
        TreeElement treeElement5 = treeElement2.getChildFromName("SOURCE_FOLDER");
        if (treeElement5 == null) {
            return;
        }
        TreeElement treeElement6 = null;
        if (string.startsWith(String.valueOf('/'))) {
            string = string.substring(1);
        }
        if ((treeElement6 = treeElement5.getChildFromLocation(string)) != null && !treeElement.equals(treeElement5)) {
            treeElement5.deleteChild(treeElement6);
            return;
        }
        treeElement6 = treeElement3.getChildFromLocation(string);
        if (treeElement6 != null && !treeElement.equals(treeElement3)) {
            treeElement3.deleteChild(treeElement6);
            treeElement3.sortOtherFolders();
            return;
        }
        Path path = new Path(string);
        if (path.segmentCount() > 1) {
            path = path.removeFirstSegments(1);
        }
        if (path.segmentCount() > 1 && (treeElement6 = ViewsUtil.isFileExistInOtherFolder(treeElement3, (IPath)path)) != null && !treeElement.equals(treeElement6.getParent())) {
            treeElement6.getParent().deleteChild(treeElement6);
            return;
        }
    }

    private TreeElement getElementNode(TreeElement treeElement, String string) {
        TreeElement treeElement2 = treeElement.getProject();
        if (treeElement2 == null) {
            return null;
        }
        TreeElement treeElement3 = treeElement2.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
        if (treeElement3 == null) {
            return null;
        }
        TreeElement treeElement4 = treeElement2.getChildFromName(IViewConstants.LINKING_FILES_FOLDER_NAME);
        if (treeElement4 == null) {
            return null;
        }
        TreeElement treeElement5 = treeElement2.getChildFromName("SOURCE_FOLDER");
        if (treeElement5 == null) {
            return null;
        }
        TreeElement treeElement6 = null;
        if (string.startsWith(String.valueOf('/'))) {
            string = string.substring(1);
        }
        if ((treeElement6 = treeElement5.getChildFromLocation(string)) != null) {
            return treeElement6;
        }
        treeElement6 = treeElement3.getChildFromLocation(string);
        if (treeElement6 != null) {
            return treeElement6;
        }
        Path path = new Path(string);
        if (path.segmentCount() > 1) {
            path = path.removeFirstSegments(1);
        }
        if (path.segmentCount() > 1 && (treeElement6 = ViewsUtil.isFileExistInOtherFolder(treeElement3, (IPath)path)) != null) {
            return treeElement6;
        }
        return null;
    }

    private void deleteFileFromSource(String string) {
        try {
            if (string != null) {
                String string2 = CBDTUiPlugin.getWorkspace().getRoot().getLocation().toOSString();
                File file = new File(string2);
                string2 = file.getCanonicalPath();
                file = new File(string);
                if ((string = file.getCanonicalPath()).toLowerCase().indexOf(string2.toLowerCase()) >= 0) {
                    String string3 = string.substring(string2.length());
                    IResource iResource = CBDTUiPlugin.getWorkspace().getRoot().findMember((IPath)new Path(string3));
                    if (iResource != null && iResource.exists()) {
                        iResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
    }

    private boolean isCopyAllowed(String string, IPath iPath) {
        try {
            if (string != null) {
                String string2;
                Path path;
                String string3 = CBDTUiPlugin.getWorkspace().getRoot().getLocation().toOSString();
                File file = new File(string3);
                string3 = file.getCanonicalPath();
                file = new File(string);
                if ((string = file.getCanonicalPath()).toLowerCase().indexOf(string3.toLowerCase()) >= 0 && (path = new Path(string2 = string.substring(string3.length()))).toString().toLowerCase().equals(iPath.toString().toLowerCase())) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
        }
        return true;
    }

    private String getSourceLocation(String string) {
        try {
            if (string != null) {
                String string2 = CBDTUiPlugin.getWorkspace().getRoot().getLocation().toOSString();
                File file = new File(string2);
                string2 = file.getCanonicalPath();
                file = new File(string);
                if ((string = file.getCanonicalPath()).toLowerCase().indexOf(string2.toLowerCase()) >= 0) {
                    String string3 = string.substring(string2.length());
                    Path path = new Path(string3);
                    IResource iResource = CBDTUiPlugin.getWorkspace().getRoot().findMember((IPath)path);
                    if (iResource != null && iResource.exists()) {
                        String string4 = iResource.getFullPath().toString();
                        if ('/' == string4.charAt(0)) {
                            string4 = string4.substring(1);
                        }
                        return string4;
                    }
                }
            }
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
        }
        return null;
    }

    private TreeElement getDropPlaceHolder(TreeElement treeElement) {
        if (SelectionAction.isTargetFile(treeElement) || SelectionAction.isTargetObjectFile(treeElement) || SelectionAction.isDependentFile(treeElement) || SelectionAction.isFactoryMethod(treeElement) || SelectionAction.isFactoryProperty(treeElement) || SelectionAction.isObjectMethod(treeElement) || SelectionAction.isObjectProperty(treeElement)) {
            return treeElement.getParent().getParent().getParent();
        }
        if (SelectionAction.isTargetRepositoryFolder(treeElement) || SelectionAction.isTargetObjectFolder(treeElement) || SelectionAction.isDependentFolder(treeElement) || SelectionAction.isREPFolder(treeElement) || SelectionAction.isRepositoryClass(treeElement) || SelectionAction.isProgramIdName(treeElement)) {
            return treeElement.getParent().getParent();
        }
        if (SelectionAction.isLinkingFile(treeElement) || SelectionAction.isSourceFile(treeElement)) {
            return treeElement.getParent();
        }
        if (SelectionAction.isSourceFolder(treeElement) || SelectionAction.isLinkingFolder(treeElement)) {
            return treeElement;
        }
        if (SelectionAction.isOtherFile(treeElement)) {
            return treeElement.getParent();
        }
        if (SelectionAction.isOtherFolder(treeElement) || SelectionAction.isOtherSubFolder(treeElement)) {
            return treeElement;
        }
        if (SelectionAction.isProject(treeElement)) {
            return treeElement.getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME);
        }
        return null;
    }

    private String getElementType(TreeElement treeElement, String string) {
        if (SelectionAction.isTargetFile(treeElement) || SelectionAction.isTargetObjectFile(treeElement) || SelectionAction.isDependentFile(treeElement) || SelectionAction.isFactoryMethod(treeElement) || SelectionAction.isFactoryProperty(treeElement) || SelectionAction.isObjectMethod(treeElement) || SelectionAction.isObjectProperty(treeElement) || SelectionAction.isRepositoryClass(treeElement) || SelectionAction.isTargetRepositoryFolder(treeElement) || SelectionAction.isTargetObjectFolder(treeElement) || SelectionAction.isDependentFolder(treeElement) || SelectionAction.isREPFolder(treeElement) || SelectionAction.isSourceFile(treeElement) || SelectionAction.isSourceFolder(treeElement) || SelectionAction.isProgramIdName(treeElement)) {
            return "SOURCE_FILE";
        }
        if (SelectionAction.isLinkingFile(treeElement) || SelectionAction.isLinkingFolder(treeElement)) {
            return IViewConstants.LINKING_FILES_NAME;
        }
        if (SelectionAction.isOtherFile(treeElement) || SelectionAction.isOtherSubFolder(treeElement) || SelectionAction.isOtherFolder(treeElement) || SelectionAction.isProject(treeElement)) {
            Path path = new Path(string);
            if (path != null && path.toFile().exists() && path.toFile().isDirectory()) {
                return IViewConstants.OTHER_FILES_SUBFOLDER_NAME;
            }
            return IViewConstants.OTHER_FILES_NAME;
        }
        return null;
    }

    private boolean isValidLinkingFile(String string) {
        if (string != null && string.toLowerCase().endsWith(".lib")) {
            return true;
        }
        this.showMessage(Messages.getString((String)"DropOperation.InvalidLinkingFile.Message"));
        return false;
    }

    public ArrayList getAllChildElements(TreeElement treeElement) {
        int n;
        TreeElement treeElement2;
        ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
        ArrayList arrayList2 = new ArrayList(5);
        TreeElement treeElement3 = treeElement;
        if (treeElement3 != null && (SelectionAction.isSourceFolder(treeElement3) || SelectionAction.isOtherFolder(treeElement3) || SelectionAction.isOtherSubFolder(treeElement3)) && (treeElement2 = treeElement3.getProject().getChildFromType("SOURCE_FOLDER")) != null && (arrayList2 = treeElement2.getChildren()) != null) {
            n = 0;
            while (n < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n));
                ++n;
            }
        }
        if (treeElement3 != null && (SelectionAction.isOtherFolder(treeElement3) || SelectionAction.isSourceFolder(treeElement3)) && (treeElement2 = treeElement3.getProject().getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME)) != null && (arrayList2 = treeElement2.getChildren()) != null) {
            n = 0;
            while (n < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n));
                ++n;
            }
        }
        if (treeElement3 != null && SelectionAction.isLinkingFolder(treeElement3) && (arrayList2 = treeElement3.getChildren()) != null) {
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n2));
                ++n2;
            }
        }
        if (treeElement3 != null && SelectionAction.isOtherSubFolder(treeElement3) && (arrayList2 = treeElement3.getChildren()) != null) {
            int n3 = 0;
            while (n3 < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n3));
                ++n3;
            }
        }
        return arrayList;
    }

    public boolean isFileAlreadyExist(ArrayList arrayList, String string) {
        if (string != null && string.startsWith(String.valueOf('/'))) {
            string = string.substring(1);
        }
        int n = 0;
        while (arrayList != null && n < arrayList.size()) {
            String string2 = ((TreeElement)arrayList.get(n)).getLocation();
            if (string.equalsIgnoreCase(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Shell getShell() {
        return this.fDragSourceAdapter.getTreeViewer().getTree().getShell();
    }

    private boolean validateSubfolderDragOperation(TreeElement treeElement, String string) {
        String string2 = treeElement.getAbsolutePath();
        Path path = new Path(string2);
        Path path2 = new Path(string);
        if (!SelectionAction.isOtherFolder(treeElement) && !SelectionAction.isOtherSubFolder(treeElement)) {
            ViewsActionUtil.showErrorMessage(this.getShell(), Messages.getString((String)"DropOperation"), Messages.getString((String)"DropOperation.SubFolder.Message_02"));
            return false;
        }
        if (string2.toLowerCase().startsWith(string.toLowerCase()) && path2.segmentCount() < path.segmentCount()) {
            ViewsActionUtil.showErrorMessage(this.getShell(), Messages.getString((String)"DropOperation"), Messages.getString((String)"DropOperation.SubFolder.Message_01"));
            return false;
        }
        return !string2.toLowerCase().equals(string.toLowerCase());
    }
}

