/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import com.unisys.os2200.i18nSupport.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.Shell;

public class TreeElementDragSourceAdapter
extends DragSourceAdapter {
    private TreeViewer fTreeViewer = null;
    private ArrayList dragList = new ArrayList(10);
    private ArrayList selectedTreeElements = new ArrayList(10);
    private boolean isDraggedFromSameView = true;

    public TreeElementDragSourceAdapter(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
        this.setDraggedFromSameView(true);
        this.dragList.clear();
        for (Object e : iStructuredSelection) {
            if (!(e instanceof TreeElement)) continue;
            TreeElement treeElement = (TreeElement)e;
            if (SelectionAction.isSourceFile(treeElement) || SelectionAction.isOtherFile(treeElement) || SelectionAction.isOtherSubFolder(treeElement)) {
                this.dragList.add(e);
                continue;
            }
            this.dragList.clear();
            this.setDraggedFromSameView(false);
            dragSourceEvent.doit = true;
            return;
        }
        if (this.dragList.size() > 0) {
            dragSourceEvent.doit = true;
            return;
        }
        dragSourceEvent.doit = false;
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (dragSourceEvent == null) {
            return;
        }
        if (dragSourceEvent.detail == 2 && dragSourceEvent.data == null) {
            ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>();
            StructuredSelection structuredSelection = (StructuredSelection)this.fTreeViewer.getSelection();
            for (TreeElement treeElement : structuredSelection) {
                if (treeElement == null) continue;
                try {
                    Object object;
                    if ((SelectionAction.isSourceFile(treeElement) || SelectionAction.isOtherFile(treeElement) || SelectionAction.isOtherSubFolder(treeElement)) && (object = treeElement.getAdapter(IResource.class)) != null && (object instanceof IFile || object instanceof IFolder)) {
                        ((IResource)object).delete(3, null);
                    }
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                }
                if (arrayList.contains(treeElement.getProject())) continue;
                arrayList.add(treeElement.getProject());
            }
            int n = 0;
            while (n < arrayList.size()) {
                ViewsUtil.refreshViews((TreeElement)arrayList.get(n));
                ++n;
            }
        } else if (dragSourceEvent.detail == 8 && dragSourceEvent.data == null) {
            StructuredSelection structuredSelection = (StructuredSelection)this.fTreeViewer.getSelection();
            for (TreeElement treeElement : structuredSelection) {
                if (treeElement == null) continue;
                try {
                    treeElement.getIProject().refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    ViewsUtil.refreshViews(treeElement);
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                }
            }
        }
        this.resetList();
        this.setDraggedFromSameView(true);
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (FileTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            int n = this.dragList.size();
            this.resetList();
            int n2 = 0;
            while (n2 < n) {
                TreeElement treeElement = (TreeElement)this.dragList.get(n2);
                if (SelectionAction.isLinkingFile(treeElement) || SelectionAction.isDependentFile(treeElement) || SelectionAction.isTargetFile(treeElement) || SelectionAction.isTargetObjectFile(treeElement)) {
                    this.showMessage(MessageFormat.format(Messages.getString((String)"DropOperation.LinkingFile.Message"), treeElement.getName()));
                } else {
                    Object object = treeElement.getAdapter(IResource.class);
                    if (object instanceof IFile) {
                        if (((IFile)object).getLocation().toFile().exists()) {
                            if (Platform.getOS().equals("win32")) {
                                arrayList.add(((IFile)object).getLocation().toString().replace('/', '\\'));
                            } else {
                                arrayList.add(((IFile)object).getLocation().toString().replace('/', '/'));
                            }
                            this.addElement(treeElement);
                        }
                    } else if (object instanceof IFolder && ((IFolder)object).getLocation().toFile().exists()) {
                        if (Platform.getOS().equals("win32")) {
                            arrayList.add(((IFile)object).getLocation().toString().replace('/', '\\'));
                        } else {
                            arrayList.add(((IFile)object).getLocation().toString().replace('/', '/'));
                        }
                        this.addElement(treeElement);
                    }
                }
                ++n2;
            }
            dragSourceEvent.data = arrayList.toArray(new String[arrayList.size()]);
        }
    }

    private void showMessage(String string) {
        Shell shell = this.fTreeViewer.getTree().getShell();
        MessageDialog.openInformation((Shell)shell, (String)Messages.getString((String)"DropOperation"), (String)string);
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    private void addElement(TreeElement treeElement) {
        if (this.selectedTreeElements != null) {
            this.selectedTreeElements.add(treeElement);
        }
    }

    public ArrayList getSelectedTreeElements() {
        return this.selectedTreeElements;
    }

    public void resetList() {
        if (this.selectedTreeElements != null) {
            this.selectedTreeElements.clear();
        }
    }

    public boolean isDraggedFromSameView() {
        return this.isDraggedFromSameView;
    }

    public void setDraggedFromSameView(boolean bl) {
        this.isDraggedFromSameView = bl;
    }
}

