/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.core.common.ICOBOLCILDataItem;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.COBOLPropertyDescriptor;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.RemoteFile;
import org.eclipse.cobol.ui.views.common.TreeComparator;
import org.eclipse.cobol.ui.views.common.TreeElementComparator;
import org.eclipse.cobol.ui.views.common.TreeElementContributorResourceAdapter;
import org.eclipse.cobol.ui.views.common.TreeElementMapper;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class TreeElement
extends PlatformObject
implements IPropertySource,
Comparable {
    private static Vector descriptors = new Vector();
    private IProject fProject;
    private IFile fFile;
    private TreeElement fParent;
    private ArrayList fChildren;
    private HashMap fHashMap;
    public static final String LOCATION = "LOCATION";
    public static final String NAME = "NAME";
    public static final String OPENED = "OPENED";
    public static final String TYPE = "TYPE";
    public static final String DV_EXPANDED = "DV_EXPANDED";
    public static final String SV_EXPANDED = "SV_EXPANDED";
    public static final String DEPENDENT_OF_TARGET = "TargetDependent";
    private static String DOT;
    private static final String HYPHEN = " - ";
    private String fLiteralName;
    private boolean isCopied;
    private int fMarker;

    static {
        COBOLPropertyDescriptor cOBOLPropertyDescriptor = new COBOLPropertyDescriptor("editable", IViewConstants.EDITABLE_VALUE);
        descriptors.addElement(cOBOLPropertyDescriptor);
        cOBOLPropertyDescriptor = new COBOLPropertyDescriptor("last modified", IViewConstants.LAST_MODIFIED_VALUE);
        descriptors.addElement(cOBOLPropertyDescriptor);
        cOBOLPropertyDescriptor = new COBOLPropertyDescriptor("name", IViewConstants.NAME_VALUE);
        descriptors.addElement(cOBOLPropertyDescriptor);
        cOBOLPropertyDescriptor = new COBOLPropertyDescriptor("path", IViewConstants.PATH_VALUE);
        descriptors.addElement(cOBOLPropertyDescriptor);
        cOBOLPropertyDescriptor = new COBOLPropertyDescriptor("size", IViewConstants.SIZE_VALUE);
        descriptors.addElement(cOBOLPropertyDescriptor);
        cOBOLPropertyDescriptor = new COBOLPropertyDescriptor("description", IViewConstants.DESCRIPTION_VALUE);
        descriptors.addElement(cOBOLPropertyDescriptor);
        DOT = ".";
    }

    static Vector getDescriptors() {
        return descriptors;
    }

    public void setPropertyValue(Object object, Object object2) {
    }

    public Object getEditableValue() {
        return this.toString();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return TreeElement.getDescriptors().toArray(new IPropertyDescriptor[TreeElement.getDescriptors().size()]);
    }

    public Object getPropertyValue(Object object) {
        File file = new File(this.getAbsolutePath());
        String string = this.getAttribute(TYPE);
        if (object.equals("editable")) {
            if (this.checkForLogicalItem()) {
                return new String(new Boolean(false).toString());
            }
            return new String(new Boolean(file.canWrite()).toString());
        }
        if (object.equals("last modified")) {
            if (string.equalsIgnoreCase(IViewConstants.OBJECT_PROPERTY_NAME) || string.equalsIgnoreCase(IViewConstants.FACTORY_METHOD_NAME) || string.equalsIgnoreCase(IViewConstants.FACTORY_PROPERTY_NAME) || string.equalsIgnoreCase(IViewConstants.OBJECT_METHOD_NAME)) {
                return "";
            }
            if (string.equalsIgnoreCase(IViewConstants.REPOSITORY_CLASS_NAME)) {
                Path path = new Path(file.getAbsoluteFile().toString());
                path = path.append(File.separator).append(this.getAttribute(NAME));
                String string2 = path.toString();
                string2 = string2.concat(".rep");
                file = new File(string2);
                return this.getDate(file);
            }
            return this.getDate(file);
        }
        if (object.equals("name")) {
            return this.getRelativeName();
        }
        if (object.equals("path")) {
            if (string.equalsIgnoreCase(IViewConstants.OBJECT_PROPERTY_NAME) || string.equalsIgnoreCase(IViewConstants.FACTORY_METHOD_NAME) || string.equalsIgnoreCase(IViewConstants.FACTORY_PROPERTY_NAME) || string.equalsIgnoreCase(IViewConstants.OBJECT_METHOD_NAME)) {
                return "";
            }
            String string3 = this.getAbsolutePath();
            if (string3 != null && string3.indexOf(File.separator) != -1 && string3.endsWith(File.separator)) {
                string3 = string3.substring(0, string3.lastIndexOf(File.separator));
            }
            file = null;
            file = new File(string3);
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return string3;
            }
        }
        if (object.equals("size")) {
            if (file == null || !file.exists()) {
                return "";
            }
            if (string.equalsIgnoreCase(IViewConstants.REPOSITORY_FOLDER_NAME) || string.equalsIgnoreCase(IViewConstants.OBJECT_PROPERTY_NAME) || string.equalsIgnoreCase(IViewConstants.FACTORY_METHOD_NAME) || string.equalsIgnoreCase(IViewConstants.FACTORY_PROPERTY_NAME) || string.equalsIgnoreCase(IViewConstants.OBJECT_METHOD_NAME) || string.equalsIgnoreCase(IViewConstants.PROJECT_NAME) || string.equalsIgnoreCase("SOURCE_FOLDER") || string.equalsIgnoreCase("TARGET_REPOSITORY_FOLDER") || string.equalsIgnoreCase(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string.equalsIgnoreCase(IViewConstants.LINKING_FILES_FOLDER_NAME) || string.equalsIgnoreCase(IViewConstants.OTHER_FILES_FOLDER_NAME) || string.equalsIgnoreCase(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) {
                return "";
            }
            if (string.equalsIgnoreCase(IViewConstants.REPOSITORY_CLASS_NAME)) {
                return this.getClassSize(file);
            }
            return Long.toString(file.length());
        }
        if (object.equals("description")) {
            if (string.equals(IViewConstants.OBJECT_PROPERTY_NAME) || string.equals(IViewConstants.FACTORY_PROPERTY_NAME)) {
                ICOBOLCILDataItem iCOBOLCILDataItem = this.getDataAttribute("RETURN_PARAMETER");
                if (iCOBOLCILDataItem != null) {
                    return String.valueOf(this.getName()) + " PIC " + iCOBOLCILDataItem.getPictureItem() + " PROPERTY";
                }
            } else {
                if (string.equals(IViewConstants.CLASS_ID_NAME) || string.equals(IViewConstants.REPOSITORY_CLASS_NAME)) {
                    String string4 = "CLASS-ID " + this.getName();
                    ArrayList arrayList = this.getAllChildrenOfType(IViewConstants.REPOSITORY_CLASS_NAME);
                    if (arrayList != null && arrayList.size() > 0) {
                        string4 = String.valueOf(string4) + " INHERITS";
                        int n = 0;
                        while (n < arrayList.size()) {
                            string4 = String.valueOf(string4) + " " + ((TreeElement)arrayList.get(n)).getName();
                            ++n;
                        }
                    }
                    return string4;
                }
                if (string.equals(IViewConstants.FACTORY_METHOD_NAME) || string.equals(IViewConstants.OBJECT_METHOD_NAME)) {
                    String string5 = "METHOD-ID " + this.getName();
                    String string6 = this.getAttribute("NO_OF_INPUT_PARAMETERS");
                    int n = 0;
                    if (string6 != null) {
                        try {
                            n = Integer.parseInt(string6);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    int n2 = 0;
                    while (n2 < n) {
                        ICOBOLCILDataItem iCOBOLCILDataItem = this.getDataAttribute("INPUT_PARAMETER" + n2);
                        if (iCOBOLCILDataItem != null && iCOBOLCILDataItem instanceof ICOBOLCILDataItem) {
                            if (iCOBOLCILDataItem.getPictureItem() != null && iCOBOLCILDataItem.getPictureItem().length() > 0) {
                                string5 = String.valueOf(string5) + " " + iCOBOLCILDataItem.getDataItemName() + " PIC " + iCOBOLCILDataItem.getPictureItem();
                            } else if (iCOBOLCILDataItem.getObjRefClassName() != null && iCOBOLCILDataItem.getObjRefClassName().length() > 0) {
                                string5 = String.valueOf(string5) + " " + iCOBOLCILDataItem.getDataItemName() + " " + iCOBOLCILDataItem.getObjRefClassName();
                            }
                        }
                        ++n2;
                    }
                    ICOBOLCILDataItem iCOBOLCILDataItem = this.getDataAttribute("RETURN_PARAMETER");
                    if (iCOBOLCILDataItem != null && iCOBOLCILDataItem instanceof ICOBOLCILDataItem) {
                        if (iCOBOLCILDataItem.getPictureItem() != null && iCOBOLCILDataItem.getPictureItem().length() > 0) {
                            string5 = String.valueOf(string5) + " " + iCOBOLCILDataItem.getDataItemName() + " PIC " + iCOBOLCILDataItem.getPictureItem();
                        } else if (iCOBOLCILDataItem.getObjRefClassName() != null && iCOBOLCILDataItem.getObjRefClassName().length() > 0) {
                            string5 = String.valueOf(string5) + " " + iCOBOLCILDataItem.getDataItemName() + " " + iCOBOLCILDataItem.getObjRefClassName();
                        }
                    }
                    return string5;
                }
            }
            return "";
        }
        return this.getRelativeName();
    }

    public boolean isPropertySet(Object object) {
        return true;
    }

    public void resetPropertyValue(Object object) {
    }

    public TreeElement(String string, String string2, String string3, TreeElement treeElement) {
        block5: {
            this.fFile = null;
            this.fLiteralName = "";
            this.isCopied = false;
            this.fMarker = -1;
            this.fHashMap = new HashMap();
            this.fChildren = new ArrayList();
            if (string3.equals("SOURCE_FILE")) {
                File file = new File(string);
                try {
                    if (file.exists()) {
                        this.fHashMap.put(LOCATION, file.getCanonicalPath());
                        break block5;
                    }
                    this.fHashMap.put(LOCATION, string);
                }
                catch (IOException iOException) {
                    this.fHashMap.put(LOCATION, string);
                }
            } else {
                this.fHashMap.put(LOCATION, string);
            }
        }
        this.fHashMap.put(NAME, string2);
        this.fHashMap.put(OPENED, "true");
        this.fHashMap.put(DV_EXPANDED, "false");
        this.fHashMap.put(SV_EXPANDED, "false");
        this.fHashMap.put(TYPE, string3);
        this.fParent = treeElement;
        this.setProject(string2, string3, treeElement);
        this.setFile(string, string3);
    }

    public void setProject(String string, String string2, TreeElement treeElement) {
        if (treeElement != null) {
            String string3 = new String("");
            if (!string2.equals(IViewConstants.PROJECT_NAME)) {
                string3 = treeElement.getProject().getName();
                IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                if (iWorkspace != null && string3 != null) {
                    this.fProject = iWorkspace.getRoot().getProject(string3);
                }
            }
            if (string2.equals(IViewConstants.PROJECT_NAME)) {
                this.setProjectForChildren(string);
            }
            this.updateModelDirty();
        }
    }

    private void setProjectForChildren(String string) {
        ArrayList arrayList;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace != null && string != null) {
            this.fProject = iWorkspace.getRoot().getProject(string);
        }
        if ((arrayList = this.getAllChildren()) != null) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                ((TreeElement)arrayList.get(n2)).setProjectForChildren(string);
                ++n2;
            }
        }
        this.updateModelDirty();
    }

    private void setFile(String string, String string2) {
        if (this.fProject != null && (string2.equals("SOURCE_FILE") || string2.equals("TARGET_FILES") || string2.equals(IViewConstants.LINKING_FILES_NAME) || string2.equals(IViewConstants.DEPENDENT_FILES_NAME) || string2.equals(IViewConstants.OTHER_FILES_NAME))) {
            Path path = new Path(string);
            this.fFile = path.getDevice() != null && path.getDevice().length() > 0 ? new RemoteFile((TreeElement)this).fFileToOpen : (this.fProject.findMember(string) instanceof IResource ? this.fProject.getFile(string) : (path.segmentCount() > 0 && this.fProject.getWorkspace().getRoot().findMember(path.segments()[0]) instanceof IProject ? ((IProject)this.fProject.getWorkspace().getRoot().findMember(path.segments()[0])).getFile(path.removeFirstSegments(1)) : (path.segmentCount() > 0 ? this.fProject.getFile(path.removeFirstSegments(1)) : this.fProject.getFile(string))));
            this.updateModelDirty();
        }
    }

    public HashMap getProperties() {
        return this.fHashMap;
    }

    public void closeTreeElement() {
        this.fHashMap.put(OPENED, "false");
        this.updateModelDirty();
    }

    public void openTreeElement() {
        this.fHashMap.put(OPENED, "true");
        this.updateModelDirty();
    }

    public boolean isOpened() {
        return ((String)this.fHashMap.get(OPENED)).equalsIgnoreCase("true");
    }

    public String toString() {
        String string = this.getAttribute(TYPE);
        if (string.equals("SOURCE_FILE") || string.equals(IViewConstants.LINKING_FILES_NAME) || string.equals(IViewConstants.REPOSITORY_CLASS_NAME) || string.equals("TARGET_OBJECT_FILES") || string.equals("TARGET_FILES") || string.equals(IViewConstants.DEPENDENT_FILES_NAME)) {
            String string2 = (String)this.fHashMap.get(LOCATION);
            String string3 = (String)this.fHashMap.get(NAME);
            if (string3.equals(string2)) {
                return string2;
            }
            if (string.equals(IViewConstants.REPOSITORY_CLASS_NAME)) {
                return string3;
            }
            Path path = new Path(this.getAttribute(LOCATION));
            if (path.getDevice() != null && path.getDevice().length() > 0) {
                if (string2.toLowerCase().endsWith(string3.toLowerCase())) {
                    string2 = path.removeLastSegments(1).toOSString();
                }
                return String.valueOf(string3) + HYPHEN + string2;
            }
            if (path.segmentCount() > 0 && this.getIProject().getName().equalsIgnoreCase(path.segments()[0])) {
                if (string2.toLowerCase().endsWith(string3.toLowerCase())) {
                    string2 = path.removeFirstSegments(1).removeLastSegments(1).toString();
                }
                if (string2.trim().length() == 0) {
                    return string3;
                }
                return String.valueOf(string3) + HYPHEN + string2;
            }
            if (path.segmentCount() > 0 && this.getIProject().getWorkspace().getRoot().findMember(path.segments()[0]) != null) {
                if (string2.toLowerCase().endsWith(string3.toLowerCase())) {
                    string2 = path.removeLastSegments(1).toString();
                }
                return String.valueOf(string3) + HYPHEN + '/' + string2;
            }
            if (string2.indexOf(string3) != -1) {
                string2 = string2.substring(0, string2.indexOf(string3) - 1);
                return String.valueOf(string3) + HYPHEN + string2;
            }
            return string3;
        }
        if (string.equals(IViewConstants.PROJECT_NAME) || string.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_NAME)) {
            return (String)this.fHashMap.get(NAME);
        }
        return (String)this.fHashMap.get(LOCATION);
    }

    public String getLocation() {
        return (String)this.fHashMap.get(LOCATION);
    }

    public String getName() {
        return (String)this.fHashMap.get(NAME);
    }

    private String getRelativeName() {
        String string = this.getAttribute(TYPE);
        if (string.equals("SOURCE_FOLDER") || string.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_FOLDER_NAME) || string.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string.equals("TARGET_OBJECT_FOLDER") || string.equals("TARGET_REPOSITORY_FOLDER")) {
            return (String)this.fHashMap.get(LOCATION);
        }
        if (string.equals(IViewConstants.REPOSITORY_FOLDER_NAME)) {
            return "";
        }
        return (String)this.fHashMap.get(NAME);
    }

    public int getPropertieslength() {
        return this.fHashMap.size();
    }

    public String getDate(File file) {
        if (file == null || !file.exists()) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        return simpleDateFormat.format(new Date(file.lastModified()));
    }

    public String getPath() {
        String string = this.getAttribute(TYPE);
        if (string.equals(IViewConstants.PROJECT_NAME)) {
            return this.fProject.getFullPath().toString();
        }
        if (string.equals("SOURCE_FOLDER") || string.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_FOLDER_NAME) || string.equals("TARGET_REPOSITORY_FOLDER") || string.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string.equals("TARGET_OBJECT_FOLDER")) {
            return this.getParent().getPath();
        }
        if (string.equals("SOURCE_FILE")) {
            return this.fFile.getFullPath().toString();
        }
        if (string.equals("TARGET_FILES") || string.equals(IViewConstants.DEPENDENT_FILES_NAME) || string.equals(IViewConstants.LINKING_FILES_NAME) || string.equals(IViewConstants.OTHER_FILES_NAME) || string.equals("TARGET_OBJECT_FILES")) {
            String string2 = this.getAttribute(LOCATION);
            Path path = new Path(string2);
            if (path.getDevice() != null && path.getDevice().length() > 0) {
                return string2;
            }
            File file = new File(String.valueOf(this.getIProject().getLocation().toOSString()) + File.separator + string2);
            if (file.exists()) {
                return this.getIProject().getFile(string2).getFullPath().toString();
            }
            if (path.segmentCount() > 0 && (file = new File(String.valueOf(this.getIProject().getWorkspace().getRoot().getLocation().toOSString()) + File.separator + path.segments()[0])).exists()) {
                return String.valueOf(this.getIProject().getWorkspace().getRoot().getFullPath().toString()) + "/" + path.toString();
            }
            return this.getIProject().getFile(string2).getFullPath().toString();
        }
        return this.getAbsolutePath();
    }

    public TreeElement getProject() {
        if (this.getAttribute(TYPE).equals(IViewConstants.PROJECT_NAME)) {
            return this;
        }
        if (this.getParent() != null) {
            return this.getParent().getProject();
        }
        return null;
    }

    public TreeElement getFile() {
        String string = this.getAttribute(TYPE);
        if (string.equals("SOURCE_FILE") || string.equals(IViewConstants.LINKING_FILES_NAME) || string.equals("TARGET_FILES") || string.equals(IViewConstants.DEPENDENT_FILES_NAME) || string.equals(IViewConstants.OTHER_FILES_NAME) || string.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) {
            return this;
        }
        if (this.getParent() == null) {
            return this;
        }
        return this.getParent().getFile();
    }

    public String getAbsolutePath() {
        String string = this.getAttribute(TYPE);
        if (string.equals(IViewConstants.PROJECT_NAME)) {
            return this.getAttribute(LOCATION);
        }
        if (string.equals("SOURCE_FOLDER") || string.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_FOLDER_NAME) || string.equals("TARGET_REPOSITORY_FOLDER") || string.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string.equals("TARGET_OBJECT_FOLDER")) {
            return this.getParent().getAbsolutePath();
        }
        if (string.equals("SOURCE_FILE")) {
            Path path = new Path(this.getAttribute(LOCATION));
            if (path.segmentCount() > 0 && this.getIProject().getWorkspace().getRoot().findMember(path.segments()[0]) != null) {
                return (String.valueOf(this.getIProject().getWorkspace().getRoot().getLocation().toOSString()) + File.separator + path.toOSString()).replace('/', '\\');
            }
            return this.getAttribute(LOCATION);
        }
        if (string.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_NAME) && this.getParent().getAttribute(TYPE).equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) {
            Path path = new Path(this.getAttribute(LOCATION));
            if (path.getDevice() != null && path.getDevice().length() > 0) {
                return this.getAttribute(LOCATION);
            }
            try {
                return this.getIProject().getWorkspace().getRoot().getLocation().append((IPath)path).toFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
                return path.makeAbsolute().toOSString();
            }
        }
        if (string.equals("TARGET_FILES") || string.equals(IViewConstants.DEPENDENT_FILES_NAME) || string.equals(IViewConstants.LINKING_FILES_NAME) || string.equals(IViewConstants.OTHER_FILES_NAME) || string.equals("TARGET_OBJECT_FILES")) {
            Path path = new Path(this.getAttribute(LOCATION));
            if (path.getDevice() != null && path.getDevice().length() > 0) {
                return this.getAttribute(LOCATION);
            }
            if (path.segmentCount() > 0 && this.getIProject().getWorkspace().getRoot().findMember(path.segments()[0]) != null) {
                return (String.valueOf(this.getIProject().getWorkspace().getRoot().getLocation().toOSString()) + File.separator + path.toOSString()).replace('/', '\\');
            }
            return this.getAttribute(LOCATION);
        }
        if (string.equals(IViewConstants.REPOSITORY_FOLDER_NAME)) {
            return this.repPath();
        }
        if (string.equals(IViewConstants.REPOSITORY_CLASS_NAME)) {
            String string2;
            String string3 = this.getAttribute(NAME);
            if (string3.equals(string2 = this.getAttribute(LOCATION))) {
                return this.getParent().getAbsolutePath();
            }
            return this.getAttribute(LOCATION);
        }
        if (string.equals(IViewConstants.FACTORY_PROPERTY_NAME) || string.equals(IViewConstants.FACTORY_METHOD_NAME) || string.equals(IViewConstants.OBJECT_PROPERTY_NAME) || string.equals(IViewConstants.OBJECT_METHOD_NAME)) {
            return this.getParent().getAbsolutePath();
        }
        return this.getFile().getAbsolutePath();
    }

    public String getStatusDisplayPath() {
        String string = this.getAttribute(TYPE);
        if (string.equals(IViewConstants.PROJECT_NAME)) {
            return this.toString();
        }
        if (string.equals("SOURCE_FOLDER") || string.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_FOLDER_NAME) || string.equals("TARGET_REPOSITORY_FOLDER") || string.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME)) {
            return String.valueOf(this.toString()) + HYPHEN + this.getProject().getName();
        }
        if (string.equals("SOURCE_FILE")) {
            return String.valueOf(this.getFile().getName()) + HYPHEN + this.getProject().getName();
        }
        if (string.equals("TARGET_FILES") || string.equals(IViewConstants.DEPENDENT_FILES_NAME) || string.equals(IViewConstants.LINKING_FILES_NAME) || string.equals(IViewConstants.OTHER_FILES_NAME)) {
            return String.valueOf(this.toString()) + HYPHEN + this.getProject().getName();
        }
        if (string.equals(IViewConstants.PROGRAM_ID_NAME) || string.equals(IViewConstants.CLASS_ID_NAME) || string.equals(IViewConstants.METHOD_ID_NAME) || string.equals(IViewConstants.FACTORY_ID_NAME) || string.equals(IViewConstants.OBJECT_ID_NAME) || string.equals(IViewConstants.ENVIRONMENT_ID_NAME) || string.equals(IViewConstants.DATA_ID_NAME) || string.equals(IViewConstants.PROCEDURE_ID_NAME) || string.equals(IViewConstants.DECLARATIVES_ID_NAME) || string.equals(IViewConstants.SECTION_ID_NAME) || string.equals(IViewConstants.STATEMENT_ID_NAME)) {
            String string2 = this.getProject().getName();
            String string3 = this.getFile().getName();
            int n = string3.indexOf(DOT);
            if (n == -1) {
                return "";
            }
            string3 = string3.substring(0, n);
            return String.valueOf(string3) + DOT + this.getElementPath() + HYPHEN + string2;
        }
        return null;
    }

    public String getAttribute(String string) {
        return (String)this.fHashMap.get(string);
    }

    public ICOBOLCILDataItem getDataAttribute(String string) {
        return (ICOBOLCILDataItem)this.fHashMap.get(string);
    }

    public void setAttribute(String string, int n) {
        this.fHashMap.put(string, Integer.toString(n));
        this.updateModelDirty();
    }

    public void setAttribute(String string, ICOBOLCILDataItem iCOBOLCILDataItem) {
        if (iCOBOLCILDataItem != null) {
            this.fHashMap.put(string, iCOBOLCILDataItem);
        }
        this.updateModelDirty();
    }

    public void setAttribute(String string, String string2) {
        if (string2 != null) {
            this.fHashMap.put(string, string2);
            if (string.equals(LOCATION)) {
                this.setFile(string2, this.getAttribute(TYPE));
            }
        }
        this.updateModelDirty();
    }

    public void setAttribute(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.fHashMap.put(string, stringArray);
        } else {
            this.fHashMap.put(string, new String[0]);
        }
    }

    public Object getObjectAttribute(String string) {
        return this.fHashMap.get(string);
    }

    public boolean hasChildren() {
        return this.fChildren != null && this.fChildren.size() > 0;
    }

    public TreeElement addChild(String string, String string2, String string3, boolean bl) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        if ((string2.equalsIgnoreCase(".CobolOptions") || string2.equalsIgnoreCase(".project")) && string3.equals(IViewConstants.OTHER_FILES_NAME)) {
            return null;
        }
        this.updateModelDirty();
        if (string3.equals("SOURCE_FOLDER") || string3.equals("TARGET_REPOSITORY_FOLDER") || string3.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string3.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string3.equals("TARGET_OBJECT_FOLDER") || string3.equals(IViewConstants.OTHER_FILES_FOLDER_NAME)) {
            if (this.getChildFromName(string2) != null) {
                return this.getChildFromName(string2);
            }
        } else if ((string3.equals(IViewConstants.PROJECT_NAME) || string3.equals("SOURCE_FILE") || string3.equals("TARGET_FILES") || string3.equals(IViewConstants.DEPENDENT_FILES_NAME) || string3.equals(IViewConstants.LINKING_FILES_NAME) || string3.equals("TARGET_OBJECT_FILES") || string3.equals(IViewConstants.OTHER_FILES_NAME) || string3.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) && this.getChildFromLocation(string) != null) {
            return this.getChildFromLocation(string);
        }
        TreeElement treeElement = new TreeElement(string, string2, string3, this);
        if (!string3.equals(IViewConstants.PROJECT_NAME)) {
            this.fChildren.add(treeElement);
            this.sortFolders(treeElement);
            if (string3.equals("SOURCE_FILE") && CommonBuildUtil.isSourceFileSupported((IProject)this.getIProject(), (String)string2)) {
                treeElement.addChild(IViewConstants.TARGET_REPOSITORY_FOLDER_VALUE, IViewConstants.TARGET_REPOSITORY_FOLDER_VALUE, "TARGET_REPOSITORY_FOLDER", false);
                treeElement.addChild(IViewConstants.DEPENDENT_FILES_FOLDER_VALUE, IViewConstants.DEPENDENT_FILES_FOLDER_VALUE, IViewConstants.DEPENDENT_FILES_FOLDER_NAME, false);
            }
            return treeElement;
        }
        int n = this.getIndex(treeElement.toString());
        this.fChildren.add(n, treeElement);
        this.sortFolders(treeElement);
        return treeElement;
    }

    public TreeElement addChild(String string, String string2, String string3) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        if ((string2.equalsIgnoreCase(".CobolOptions") || string2.equalsIgnoreCase(".project")) && string3.equals(IViewConstants.OTHER_FILES_NAME)) {
            return null;
        }
        this.updateModelDirty();
        if (string3.equals("SOURCE_FOLDER") || string3.equals("TARGET_REPOSITORY_FOLDER") || string3.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string3.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string3.equals("TARGET_OBJECT_FOLDER") || string3.equals(IViewConstants.OTHER_FILES_FOLDER_NAME)) {
            if (this.getChildFromName(string2) != null) {
                return this.getChildFromName(string2);
            }
        } else if ((string3.equals(IViewConstants.PROJECT_NAME) || string3.equals("SOURCE_FILE") || string3.equals("TARGET_FILES") || string3.equals(IViewConstants.DEPENDENT_FILES_NAME) || string3.equals(IViewConstants.LINKING_FILES_NAME) || string3.equals("TARGET_OBJECT_FILES") || string3.equals(IViewConstants.OTHER_FILES_NAME) || string3.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) && this.getChildFromLocation(string) != null) {
            return this.getChildFromLocation(string);
        }
        TreeElement treeElement = new TreeElement(string, string2, string3, this);
        if (!string3.equals(IViewConstants.PROJECT_NAME)) {
            this.fChildren.add(treeElement);
            this.sortFolders(treeElement);
            return treeElement;
        }
        int n = this.getIndex(treeElement.toString());
        this.fChildren.add(n, treeElement);
        this.sortFolders(treeElement);
        return treeElement;
    }

    private void sortFolders(TreeElement treeElement) {
        int n;
        Object object;
        String string = treeElement.getAttribute(TYPE);
        if (string.equals("TARGET_REPOSITORY_FOLDER") || string.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string.equals("TARGET_OBJECT_FOLDER")) {
            object = new Object[3];
            n = 0;
            while (this.fChildren != null && n < this.fChildren.size()) {
                String string2 = ((TreeElement)this.fChildren.get(n)).getAttribute(TYPE);
                if (string2.equals("TARGET_REPOSITORY_FOLDER")) {
                    object[0] = this.fChildren.get(n);
                } else if (string2.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME)) {
                    object[1] = this.fChildren.get(n);
                } else if (string2.equals("TARGET_OBJECT_FOLDER")) {
                    object[2] = this.fChildren.get(n);
                }
                ++n;
            }
            n = 0;
            while (n < 3) {
                if (object[n] != null) {
                    this.fChildren.remove(object[n]);
                    this.fChildren.add(object[n]);
                }
                ++n;
            }
        }
        if (string.equals(IViewConstants.REPOSITORY_FOLDER_NAME)) {
            object = new ArrayList(10);
            n = this.fChildren.size();
            int n2 = 0;
            while (this.fChildren != null && n2 < n) {
                String string3 = ((TreeElement)this.fChildren.get(n2)).getLocation();
                if (this.getREPType(string3) == 2) {
                    ((ArrayList)object).add(this.fChildren.get(n2));
                }
                ++n2;
            }
            n = ((ArrayList)object).size();
            n2 = 0;
            while (object != null && n2 < n) {
                this.fChildren.remove(((ArrayList)object).get(n2));
                this.fChildren.add(((ArrayList)object).get(n2));
                ++n2;
            }
        }
    }

    public int getREPType(String string) {
        if (string != null) {
            String string2 = Messages.getString((String)"PROJECT_REPOSITORY");
            String string3 = " " + Messages.getString((String)"HYPHEN") + " ";
            if (string2 != null && string2.length() > 0 && string.indexOf(String.valueOf(string2) + string3) > 0) {
                return 2;
            }
        }
        return -1;
    }

    public void swapElements(int n, int n2) {
        try {
            int n3 = this.fChildren.size();
            if (n3 != 0) {
                TreeElement treeElement = (TreeElement)this.fChildren.get(n);
                this.fChildren.remove(n);
                if (n < n2) {
                    this.fChildren.add(n2 - 1, treeElement);
                } else if (n > n2) {
                    this.fChildren.add(n2, treeElement);
                }
            }
            this.updateModelDirty();
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public int getIndex(String string) {
        try {
            int n = this.fChildren.size();
            if (n != 0) {
                return this.getIndexByBinarySearch(string, 1, n);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return 0;
    }

    private int getIndexByBinarySearch(String string, int n, int n2) {
        try {
            if (string.compareToIgnoreCase(((TreeElement)this.fChildren.get(n - 1)).toString()) < 0 || string.compareToIgnoreCase(((TreeElement)this.fChildren.get(n - 1)).toString()) == 0) {
                return n - 1;
            }
            if (string.compareToIgnoreCase(((TreeElement)this.fChildren.get(n2 - 1)).toString()) > 0 || string.compareToIgnoreCase(((TreeElement)this.fChildren.get(n2 - 1)).toString()) == 0) {
                return n2;
            }
            int n3 = (n + n2) / 2;
            if ((string.compareToIgnoreCase(((TreeElement)this.fChildren.get(n3)).toString()) < 0 || string.compareToIgnoreCase(((TreeElement)this.fChildren.get(n3)).toString()) == 0) && string.compareToIgnoreCase(((TreeElement)this.fChildren.get(n3 - 1)).toString()) > 0 || string.compareToIgnoreCase(((TreeElement)this.fChildren.get(n3 - 1)).toString()) == 0) {
                return n3;
            }
            if (string.compareToIgnoreCase(((TreeElement)this.fChildren.get(n3)).toString()) < 0) {
                return this.getIndexByBinarySearch(string, n, n3);
            }
            return this.getIndexByBinarySearch(string, n3, n2);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return 0;
        }
    }

    public TreeElement getParent() {
        return this.fParent;
    }

    public ArrayList getChildren() {
        if (this.hasChildren()) {
            ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>();
            int n = 0;
            while (n < this.sizeOfChildren()) {
                TreeElement treeElement = (TreeElement)this.fChildren.get(n);
                if (treeElement.getProject() != null && treeElement.getProject().isOpened()) {
                    arrayList.add(treeElement);
                } else if (treeElement.getAttribute(TYPE).equals(IViewConstants.PROJECT_NAME)) {
                    arrayList.add(treeElement);
                }
                ++n;
            }
            return arrayList;
        }
        return null;
    }

    public ArrayList getAllChildren() {
        if (this.hasChildren()) {
            ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>();
            int n = 0;
            while (n < this.sizeOfChildren()) {
                arrayList.add((TreeElement)this.fChildren.get(n));
                ++n;
            }
            return arrayList;
        }
        return null;
    }

    public ArrayList getAllChildrenOfType(String string) {
        if (this.hasChildren()) {
            ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>();
            int n = 0;
            while (n < this.sizeOfChildren()) {
                if (((TreeElement)this.fChildren.get(n)).getAttribute(TYPE).equals(string)) {
                    arrayList.add((TreeElement)this.fChildren.get(n));
                }
                ++n;
            }
            return arrayList;
        }
        return null;
    }

    public void deleteChildren() {
        this.updateModelDirty();
        if (this.fChildren != null) {
            ArrayList arrayList = this.fChildren;
            if (arrayList != null) {
                int n = arrayList.size();
                int n2 = 0;
                while (n2 < n) {
                    TreeElementMapper.getInstance().removeMapTreeElement((TreeElement)arrayList.get(n2));
                    ((TreeElement)arrayList.get(n2)).deleteChildren();
                    ++n2;
                }
            }
            this.fChildren.clear();
            this.fChildren = null;
        }
    }

    public void deleteChild(TreeElement treeElement) {
        this.updateModelDirty();
        if (this.fChildren != null && treeElement != null) {
            this.fChildren.remove(treeElement);
            TreeElementMapper.getInstance().removeMapTreeElement(treeElement);
            ArrayList arrayList = treeElement.getAllChildren();
            if (arrayList != null) {
                int n = arrayList.size();
                int n2 = 0;
                while (n2 < n) {
                    treeElement.deleteChild((TreeElement)arrayList.get(n2));
                    ++n2;
                }
            }
        }
        this.resetMarker(treeElement);
    }

    public int sizeOfChildren() {
        if (this.fChildren != null) {
            return this.fChildren.size();
        }
        return 0;
    }

    public TreeElement getChildFromLocation(String string) {
        try {
            ArrayList arrayList = this.getChildren();
            if (arrayList != null) {
                int n = arrayList.size();
                int n2 = 0;
                while (n2 < n) {
                    if (((TreeElement)arrayList.get(n2)).getLocation().equalsIgnoreCase(string)) {
                        return (TreeElement)arrayList.get(n2);
                    }
                    ++n2;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public TreeElement getChildFromName(String string) {
        try {
            ArrayList arrayList = this.getChildren();
            if (arrayList != null) {
                int n = arrayList.size();
                int n2 = 0;
                while (n2 < n) {
                    if (((TreeElement)arrayList.get(n2)).getName().equalsIgnoreCase(string)) {
                        return (TreeElement)arrayList.get(n2);
                    }
                    ++n2;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public TreeElement getChildFromType(String string) {
        try {
            ArrayList arrayList = this.getChildren();
            if (arrayList != null) {
                int n = arrayList.size();
                int n2 = 0;
                while (n2 < n) {
                    if (((TreeElement)arrayList.get(n2)).getAttribute(TYPE).equals(string)) {
                        return (TreeElement)arrayList.get(n2);
                    }
                    ++n2;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public TreeElement getClosedProject(String string) {
        try {
            int n = this.sizeOfChildren();
            ArrayList arrayList = this.fChildren;
            int n2 = 0;
            while (n2 < n) {
                if (((TreeElement)arrayList.get(n2)).getName().equals(string)) {
                    return (TreeElement)arrayList.get(n2);
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public int hashCode() {
        return this.getLocation().hashCode() ^ this.getName().hashCode() ^ this.getAttribute(TYPE).hashCode();
    }

    public int getLineNumber() {
        return Integer.parseInt(this.getAttribute("LINE_NUMBER"));
    }

    public ArrayList getClassNames(String string, ViewsTreeModel viewsTreeModel) {
        TreeElement treeElement = viewsTreeModel.getRoot().getChildFromName(string);
        ArrayList arrayList = treeElement.getChildren();
        return arrayList;
    }

    public Object getAdapter(Class clazz) {
        if (IContributorResourceAdapter.class.equals((Object)clazz)) {
            return TreeElementContributorResourceAdapter.getInstance();
        }
        boolean bl = IProject.class.equals((Object)clazz);
        if (bl && this.fProject != null) {
            if (this.fFile != null) {
                return this.fFile;
            }
            return this.fProject;
        }
        boolean bl2 = IResource.class.equals((Object)clazz);
        if (bl2 && this.fProject != null) {
            File file;
            Path path;
            try {
                if (this.fFile != null && !this.fFile.exists() && this.fFile instanceof org.eclipse.core.internal.resources.File && (path = (org.eclipse.core.internal.resources.File)this.fFile) != null && path.getLocation() != null && (file = path.getLocation().toFile()) != null && file.exists()) {
                    String string = path.getProject().getLocation().toOSString().toLowerCase();
                    String string2 = "";
                    int n = path.getLocation().toOSString().toLowerCase().indexOf(string);
                    if (n >= 0) {
                        string2 = file.getCanonicalPath().substring(string.length());
                    }
                    Path path2 = new Path(string2);
                    IResource iResource = path.getProject().findMember((IPath)path2);
                    if (iResource != null && iResource instanceof IFile) {
                        return (IFile)iResource;
                    }
                }
            }
            catch (IOException iOException) {}
            if (this.getAttribute(TYPE).equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) {
                path = new Path(this.getLocation());
                file = null;
                if (path != null && path.segmentCount() > 1) {
                    path = path.removeFirstSegments(1);
                    try {
                        file = this.getIProject().findMember((IPath)path);
                        if (file == null) {
                            return this.getIProject().getFolder((IPath)path);
                        }
                    }
                    catch (Exception exception) {
                        return this.getIProject().getFolder((IPath)path);
                    }
                }
                if (file != null && file instanceof IFolder) {
                    return (IFolder)file;
                }
            }
            if (this.fFile != null) {
                return this.fFile;
            }
            return this.fProject;
        }
        return super.getAdapter(clazz);
    }

    public IProject getIProject() {
        return this.fProject;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TreeElement)) {
            return false;
        }
        return (TreeElement)object == this;
    }

    public void moveTreeElement(TreeElement treeElement, boolean bl) {
        int n = 0;
        while (n < this.fChildren.size()) {
            if (this.fChildren.get(n).equals(treeElement)) {
                this.updateModelDirty();
                try {
                    TreeElement treeElement2;
                    if (bl) {
                        treeElement2 = (TreeElement)this.fChildren.get(n - 1);
                        this.fChildren.remove(n - 1);
                        this.fChildren.add(n, treeElement2);
                        return;
                    }
                    treeElement2 = (TreeElement)this.fChildren.get(n + 1);
                    this.fChildren.remove(n + 1);
                    this.fChildren.add(n, treeElement2);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    CBDTUiPlugin.logError(arrayIndexOutOfBoundsException);
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                }
            }
            ++n;
        }
    }

    private boolean checkForLogicalItem() {
        String string = this.getAttribute(TYPE);
        return string.equals("SOURCE_FOLDER") || string.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_FOLDER_NAME) || string.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string.equals("TARGET_REPOSITORY_FOLDER") || string.equals("TARGET_OBJECT_FOLDER") || string.equals(IViewConstants.REPOSITORY_CLASS_NAME) || string.equals(IViewConstants.REPOSITORY_FOLDER_NAME) || string.equals(IViewConstants.FACTORY_METHOD_NAME) || string.equals(IViewConstants.FACTORY_PROPERTY_NAME) || string.equals(IViewConstants.OBJECT_METHOD_NAME) || string.equals(IViewConstants.OBJECT_PROPERTY_NAME) || string.equals("REPOSITORY_CLASS");
    }

    public String getElementPath() {
        TreeElement treeElement = this;
        String string = "";
        String string2 = "";
        while (!treeElement.getName().equals(this.getFile().getName())) {
            string2 = string.trim().length() == 0 ? string : DOT;
            string = String.valueOf(treeElement.getName()) + string2 + string;
            treeElement = treeElement.getParent();
        }
        return string;
    }

    public TreeElement addChild(TreeElement treeElement, String string, String string2, String string3) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.updateModelDirty();
        if (string3.equals("SOURCE_FOLDER") || string3.equals("TARGET_REPOSITORY_FOLDER") || string3.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string3.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string3.equals(IViewConstants.OTHER_FILES_FOLDER_NAME)) {
            if (this.getChildFromName(string2) != null) {
                return this.getChildFromName(string2);
            }
        } else if ((string3.equals(IViewConstants.PROJECT_NAME) || string3.equals("SOURCE_FILE") || string3.equals("TARGET_FILES") || string3.equals(IViewConstants.DEPENDENT_FILES_NAME) || string3.equals(IViewConstants.LINKING_FILES_NAME) || string3.equals(IViewConstants.OTHER_FILES_NAME)) && this.getChildFromLocation(string) != null) {
            return this.getChildFromName(string);
        }
        if (!string3.equals(IViewConstants.PROJECT_NAME)) {
            this.fChildren.add(treeElement);
            return treeElement;
        }
        int n = this.getIndex(treeElement.toString());
        this.fChildren.add(n, treeElement);
        return treeElement;
    }

    public ArrayList getSortedChildren() {
        if (this.hasChildren()) {
            ArrayList arrayList = this.getChildren();
            String string = this.getAttribute(TYPE);
            if (string.equals("SOURCE_FILE") || string.equals(IViewConstants.PROGRAM_ID_NAME) || string.equals(IViewConstants.CLASS_ID_NAME) || string.equals(IViewConstants.METHOD_ID_NAME) || string.equals(IViewConstants.FACTORY_ID_NAME) || string.equals(IViewConstants.OBJECT_ID_NAME)) {
                Collections.sort(arrayList);
            }
            this.updateModelDirty();
            return arrayList;
        }
        return null;
    }

    public TreeElement isChildFromNameExists(String string) {
        try {
            ArrayList arrayList = this.getAllChildren();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                if (((TreeElement)arrayList.get(n2)).getName().equals(string)) {
                    return (TreeElement)arrayList.get(n2);
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public TreeElement addChildInPos(String string, String string2, String string3, int n) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        if ((string3.equals("SOURCE_FOLDER") || string3.equals("TARGET_REPOSITORY_FOLDER") || string3.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || string3.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string3.equals(IViewConstants.OTHER_FILES_FOLDER_NAME)) && this.getChildFromName(string2) != null) {
            return this.getChildFromName(string2);
        }
        if ((string3.equals(IViewConstants.PROJECT_NAME) || string3.equals("SOURCE_FILE") || string3.equals("TARGET_FILES") || string3.equals(IViewConstants.DEPENDENT_FILES_NAME) || string3.equals(IViewConstants.LINKING_FILES_NAME) || string3.equals(IViewConstants.OTHER_FILES_NAME)) && this.getChildFromLocation(string) != null) {
            return this.getChildFromName(string);
        }
        TreeElement treeElement = new TreeElement(string, string2, string3, this);
        if (!string3.equals(IViewConstants.PROJECT_NAME)) {
            if (n < 0) {
                n = 0;
            }
            this.fChildren.add(n, treeElement);
            return treeElement;
        }
        int n2 = this.getIndex(treeElement.toString());
        this.fChildren.add(n2, treeElement);
        this.updateModelDirty();
        return treeElement;
    }

    public int compareTo(Object object) {
        String string = ((TreeElement)object).getName();
        return this.getName().compareTo(string);
    }

    public void sortOtherFolders() {
        String string = this.getAttribute(TYPE);
        if (string.equals(IViewConstants.OTHER_FILES_FOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) {
            ArrayList arrayList = this.getAllChildrenOfType(IViewConstants.OTHER_FILES_NAME);
            ArrayList arrayList2 = this.getAllChildrenOfType(IViewConstants.OTHER_FILES_SUBFOLDER_NAME);
            int n = 0;
            while (arrayList2 != null && n < arrayList2.size()) {
                ((TreeElement)arrayList2.get(n)).sortOtherFolders();
                ++n;
            }
            if (arrayList2 != null) {
                Collections.sort(arrayList2, new TreeComparator());
            }
            if (arrayList != null) {
                Collections.sort(arrayList, new TreeComparator());
            }
            if (this.fChildren == null) {
                this.fChildren = new ArrayList();
            }
            this.fChildren.clear();
            if (arrayList2 != null) {
                this.fChildren.addAll(arrayList2);
            }
            if (arrayList2 != null && arrayList != null) {
                this.fChildren.addAll(arrayList2.size(), arrayList);
            } else if (arrayList != null) {
                this.fChildren.addAll(arrayList);
            }
        }
        this.updateModelDirty();
    }

    public void sortTreeElements() {
        String string = this.getAttribute(TYPE);
        ArrayList arrayList = null;
        if (string.equals("TARGET_REPOSITORY_FOLDER")) {
            arrayList = this.getAllChildrenOfType("TARGET_FILES");
        } else if (string.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME)) {
            arrayList = this.getAllChildrenOfType(IViewConstants.DEPENDENT_FILES_NAME);
        } else if (string.equals("TARGET_OBJECT_FOLDER")) {
            arrayList = this.getAllChildrenOfType("TARGET_OBJECT_FILES");
        } else if (string.equals(IViewConstants.LINKING_FILES_FOLDER_NAME)) {
            arrayList = this.getAllChildrenOfType(IViewConstants.LINKING_FILES_NAME);
        } else {
            if (string.equals("SOURCE_FILE")) {
                ArrayList arrayList2;
                arrayList = this.getAllChildrenOfType(IViewConstants.CLASS_ID_NAME);
                if (arrayList != null) {
                    this.sortAndMergeWithChildren(arrayList);
                }
                if ((arrayList2 = this.getAllChildrenOfType(IViewConstants.PROGRAM_ID_NAME)) != null) {
                    this.sortAndMergeWithChildren(arrayList2);
                }
                return;
            }
            if (string.equals(IViewConstants.CLASS_ID_NAME)) {
                ArrayList arrayList3;
                arrayList = this.getAllChildrenOfType(IViewConstants.METHOD_ID_NAME);
                if (arrayList != null) {
                    this.sortAndMergeWithChildren(arrayList);
                }
                if ((arrayList3 = this.getAllChildrenOfType(IViewConstants.OBJECT_ID_NAME)) != null) {
                    this.sortAndMergeWithChildren(arrayList3);
                }
                return;
            }
        }
        this.sortElements(arrayList);
    }

    private void sortAndMergeWithChildren(ArrayList arrayList) {
        if (this.fChildren != null && arrayList != null && arrayList.size() > 0) {
            Collections.sort(arrayList, new TreeElementComparator());
            int n = 0;
            while (n < arrayList.size()) {
                if (this.fChildren.contains(arrayList.get(n))) {
                    this.fChildren.remove(arrayList.get(n));
                }
                this.fChildren.add(arrayList.get(n));
                ++n;
            }
        }
    }

    private void sortElements(ArrayList arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            Collections.sort(arrayList, new TreeElementComparator());
            if (this.fChildren == null) {
                this.fChildren = new ArrayList();
            }
            this.fChildren.clear();
            this.fChildren.addAll(arrayList);
        }
    }

    private void updateModelDirty() {
        String string = this.getAttribute(TYPE);
        if (!(string.equals(IViewConstants.CLASS_ID_NAME) || string.equals(IViewConstants.PROGRAM_ID_NAME) || string.equals(IViewConstants.OBJECT_ID_NAME) || string.equals(IViewConstants.OBJECT_METHOD_NAME) || string.equals(IViewConstants.OBJECT_PROPERTY_NAME) || string.equals(IViewConstants.FACTORY_ID_NAME) || string.equals(IViewConstants.FACTORY_METHOD_NAME) || string.equals(IViewConstants.FACTORY_PROPERTY_NAME) || string.equals(IViewConstants.REPOSITORY_FOLDER_NAME))) {
            ViewsTreeModel.getInstance().setDirty(true);
        }
    }

    public void setLocation(String string) {
        this.setAttribute(LOCATION, string);
    }

    public void setName(String string) {
        this.setAttribute(NAME, string);
    }

    private String repPath() {
        String string = this.getAttribute(TYPE);
        if (string.equalsIgnoreCase(IViewConstants.REPOSITORY_FOLDER_NAME)) {
            String string2 = this.getLocation();
            if (string2 != null) {
                String string3 = Messages.getString((String)"PROJECT_REPOSITORY");
                String string4 = " " + Messages.getString((String)"HYPHEN") + " ";
                int n = -1;
                if (string3 != null && string3.length() > 0 && (n = string2.indexOf(String.valueOf(string3) + string4)) > 0) {
                    string2 = string2.substring(n + (String.valueOf(string3) + string4).length()).trim();
                }
            }
            return string2;
        }
        return "";
    }

    private String getClassSize(File file) {
        Path path = new Path(file.getAbsoluteFile().toString());
        path = path.append(File.separator).append(this.getAttribute(NAME));
        String string = path.toString();
        File file2 = new File(string = string.concat(".rep"));
        if (file2.exists()) {
            return Long.toString(file2.length());
        }
        return "";
    }

    public boolean isInherintanceSet() {
        String string = this.getAttribute("INHERINTANCE");
        if (string != null && string.equals("true")) {
            return true;
        }
        if (string != null && string.equals("false")) {
            return false;
        }
        return false;
    }

    public void setInherintance(boolean bl) {
        if (bl) {
            this.setAttribute("INHERINTANCE", "true");
        } else {
            this.setAttribute("INHERINTANCE", "false");
        }
    }

    public boolean isValidClassSource() {
        String string = this.getName();
        return string != null && string.toLowerCase().endsWith(".rep");
    }

    public void repositionElement(String string) {
        TreeElement treeElement = this.getChildFromName(string);
        if (treeElement != null) {
            this.fChildren.remove(treeElement);
            int n = this.getIndex(treeElement.toString());
            if (n >= 0) {
                this.fChildren.add(n, treeElement);
            }
        }
    }

    public String getLiteralName() {
        return this.fLiteralName;
    }

    public void setLiteralName(String string) {
        this.fLiteralName = string;
    }

    public void setCopied(boolean bl) {
        this.isCopied = bl;
    }

    public boolean isCopied() {
        return this.isCopied;
    }

    public int getMarker() {
        return this.fMarker;
    }

    public void setMarker(int n) {
        this.fMarker = n;
    }

    private void resetMarker(TreeElement treeElement) {
        TreeElement treeElement2 = null;
        if (treeElement != null) {
            if (SelectionAction.isSourceFile(treeElement)) {
                treeElement2 = treeElement.getParent();
            } else if (SelectionAction.isSourceFolder(treeElement)) {
                treeElement2 = treeElement;
            } else if (SelectionAction.isProject(treeElement)) {
                treeElement2 = treeElement.getChildFromType("SOURCE_FOLDER");
            }
            if (treeElement2 != null) {
                ArrayList arrayList = treeElement2.getAllChildrenOfType("SOURCE_FILE");
                int n = 0;
                while (arrayList != null && n < arrayList.size()) {
                    if (((TreeElement)arrayList.get(n)).getMarker() > 0 && !arrayList.get(n).equals(treeElement)) {
                        return;
                    }
                    ++n;
                }
                treeElement2.setMarker(-1);
                treeElement2.getParent().setMarker(-1);
            }
        }
    }

    public void dispose() {
        if (descriptors != null) {
            descriptors.removeAllElements();
            descriptors = null;
        }
        if (this.fChildren != null) {
            this.fChildren.clear();
            this.fChildren = null;
        }
        this.fFile = null;
        if (this.fHashMap != null) {
            this.fHashMap.clear();
            this.fHashMap = null;
        }
        this.fParent = null;
        this.fProject = null;
    }
}

