/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.common.RemoteFile;
import org.eclipse.cobol.ui.views.common.RemoteFileStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RemoteFileEditorInput
implements IWorkbenchAdapter,
IStorageEditorInput,
IFileEditorInput {
    private RemoteFile fRemoteFile = null;
    private IStorage fStorage;

    public RemoteFileEditorInput(RemoteFile remoteFile) {
        this.fRemoteFile = remoteFile;
    }

    public boolean exists() {
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteFileEditorInput)) {
            return false;
        }
        RemoteFileEditorInput remoteFileEditorInput = (RemoteFileEditorInput)object;
        return this.fRemoteFile.equals((Object)remoteFileEditorInput.fRemoteFile);
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    public Object[] getChildren(Object object) {
        return new Object[0];
    }

    public InputStream getContents() throws CoreException {
        try {
            return new ByteArrayInputStream(this.fRemoteFile.getContents());
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    public String getContentType() {
        String string = this.fRemoteFile.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public String getFullPath() {
        return this.getName();
    }

    public ImageDescriptor getImageDescriptor() {
        IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)this.fRemoteFile.getAdapter(IWorkbenchAdapter.class);
        return iWorkbenchAdapter == null ? null : iWorkbenchAdapter.getImageDescriptor((Object)this.fRemoteFile);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)this.fRemoteFile.getAdapter(IWorkbenchAdapter.class);
        return iWorkbenchAdapter == null ? null : iWorkbenchAdapter.getImageDescriptor((Object)this.fRemoteFile);
    }

    public String getLabel(Object object) {
        return this.fRemoteFile.getName();
    }

    public String getName() {
        return this.fRemoteFile.getName();
    }

    public Object getParent(Object object) {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        if (this.fStorage == null) {
            this.fStorage = new RemoteFileStorage(this.fRemoteFile);
        }
        return this.fStorage;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public IFile getFile() {
        return this.fRemoteFile.fFileToOpen;
    }
}

