/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.common.COBOLFile;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RemoteFile
extends PlatformObject
implements IWorkbenchAdapter {
    private byte[] fContents;
    private StringBuffer fFileContentsBuffer;
    private String fFileName;
    public IFile fFileToOpen;
    public IProject fProject;

    public Object[] getChildren(Object object) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object object) {
        return "";
    }

    public Object getParent(Object object) {
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RemoteFile)) {
            return false;
        }
        RemoteFile remoteFile = (RemoteFile)((Object)object);
        if (remoteFile.fFileContentsBuffer == null) {
            remoteFile.readFileContent();
        }
        if (this.fFileContentsBuffer == null) {
            this.readFileContent();
        }
        if (remoteFile.fFileContentsBuffer != null && this.fFileContentsBuffer != null && remoteFile.fFileContentsBuffer.toString().equals(this.fFileContentsBuffer.toString())) {
            return true;
        }
        return this.fContents.equals(remoteFile.getContents());
    }

    public byte[] getContents() {
        try {
            this.readFileContent();
            if (this.fFileContentsBuffer != null) {
                return this.fFileContentsBuffer.toString().getBytes();
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    public String getName() {
        return this.fFileName;
    }

    public void setName(String string) {
        this.fFileName = string;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    public RemoteFile(TreeElement treeElement) {
        block14: {
            this.fContents = new byte[10000];
            this.fFileName = "";
            this.fFileName = treeElement.getLocation();
            Path path = null;
            IProject iProject = null;
            this.fProject = treeElement.getIProject();
            try {
                Object object;
                Object object2;
                File file = new File(this.fFileName);
                if (!file.exists()) {
                    object2 = (IResource)treeElement.getAdapter(IResource.class);
                    if (object2 != null) {
                        iProject = object2.getProject();
                    }
                    if (iProject != null && iProject.getLocation() != null) {
                        object = iProject.getFile(new Path(this.fFileName).removeFirstSegments(1).toString());
                        File file2 = object.getLocation().toFile();
                        if (file2 != null && file2.exists()) {
                            String string = object.getProject().getLocation().toOSString().toLowerCase();
                            String string2 = "";
                            int n = object.getLocation().toOSString().toLowerCase().indexOf(string);
                            if (n >= 0) {
                                string2 = file2.getCanonicalPath().substring(string.length());
                            }
                            Path path2 = new Path(string2);
                            IResource iResource = object.getProject().findMember((IPath)path2);
                            if (iResource != null && iResource instanceof IFile) {
                                object = (IFile)iResource;
                            }
                        }
                        this.fFileToOpen = object;
                        file = object.getLocation().toFile();
                    }
                } else {
                    path = new Path(this.fFileName);
                    object2 = new COBOLFile(this, path);
                    this.fFileToOpen = object2;
                }
                if (!file.exists() || !file.isFile()) break block14;
                object2 = null;
                object = null;
                try {
                    object2 = new FileInputStream(file);
                    object = new InputStreamReader(new BufferedInputStream((InputStream)object2));
                }
                finally {
                    this.closeStreams((FileInputStream)object2, (InputStreamReader)object);
                }
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
            catch (ClassCastException classCastException) {
                CBDTUiPlugin.logError(classCastException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    public RemoteFile(String string) throws IOException, FileNotFoundException {
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        this.fContents = new byte[10000];
        this.fFileName = "";
        Path path = null;
        File file = new File(string);
        this.fFileName = file.getName();
        if (file.exists()) {
            path = new Path(string);
            COBOLFile cOBOLFile = new COBOLFile(this, path);
            this.fFileToOpen = cOBOLFile;
            fileInputStream = null;
            inputStreamReader = null;
            try {
                fileInputStream = new FileInputStream(file);
                inputStreamReader = new InputStreamReader(new BufferedInputStream(fileInputStream));
            }
            catch (Throwable throwable) {
                this.closeStreams(fileInputStream, inputStreamReader);
                throw throwable;
            }
        } else {
            throw new IOException("File does not exists: " + string);
        }
        this.closeStreams(fileInputStream, inputStreamReader);
    }

    public void readFileContent() {
        IFile iFile = this.fFileToOpen;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            try {
                if (iFile != null && this.fFileContentsBuffer == null && iFile.getLocation().toFile().exists()) {
                    String string = iFile.getLocation().toOSString();
                    File file = new File(string);
                    fileInputStream = new FileInputStream(file);
                    inputStreamReader = new InputStreamReader(new BufferedInputStream(fileInputStream));
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = new char[2048];
                    int n = inputStreamReader.read(cArray);
                    while (n > 0) {
                        stringBuffer.append(cArray, 0, n);
                        n = inputStreamReader.read(cArray);
                    }
                    this.fFileContentsBuffer = stringBuffer;
                    stringBuffer = null;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                CBDTUiPlugin.logError(fileNotFoundException);
                this.closeStreams(fileInputStream, inputStreamReader);
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
                this.closeStreams(fileInputStream, inputStreamReader);
            }
        }
        finally {
            this.closeStreams(fileInputStream, inputStreamReader);
        }
    }

    private void closeStreams(FileInputStream fileInputStream, InputStreamReader inputStreamReader) {
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
        }
        if (inputStreamReader != null) {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
        }
    }
}

