/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import java.util.ArrayList;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.TreeElementMapper;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

public class ProblemTreeViewer
extends TreeViewer {
    private ViewPart fPart = null;
    long lastRefreshed = 0L;
    Object lastRefreshElement = null;
    boolean fIsExpandToLevelFired;

    public ProblemTreeViewer(Composite composite, ViewPart viewPart) {
        super(composite);
        this.initMapper();
        this.fPart = viewPart;
    }

    public ProblemTreeViewer(Composite composite, int n, ViewPart viewPart) {
        super(composite, n);
        this.initMapper();
        this.fPart = viewPart;
    }

    public ProblemTreeViewer(Tree tree, ViewPart viewPart) {
        super(tree);
        this.initMapper();
        this.fPart = viewPart;
    }

    private void initMapper() {
        TreeElementMapper.getInstance().setViewPart(this);
    }

    protected void mapElement(Object object, Widget widget) {
        super.mapElement(object, widget);
        if (widget instanceof Item) {
            TreeElementMapper.getInstance().addToMap(object, (Item)widget);
        }
    }

    protected void unmapElement(Object object, Widget widget) {
        if (widget instanceof Item) {
            TreeElementMapper.getInstance().removeFromMap(object, (Item)widget);
        }
        super.unmapElement(object, widget);
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        super.handleLabelProviderChanged(labelProviderChangedEvent);
        Object[] objectArray = labelProviderChangedEvent.getElements();
        if (objectArray != null && (objectArray = this.getTreeElements(objectArray)) != null && objectArray.length > 0) {
            this.update(objectArray, null);
        }
    }

    private Object[] getTreeElements(Object[] objectArray) {
        ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof IResource) {
                    TreeElement treeElement;
                    String string = ((IResource)objectArray[n]).getProject().getName();
                    String string2 = ((IResource)objectArray[n]).getFullPath().toString();
                    if ('/' == string2.charAt(0)) {
                        string2 = string2.substring(1);
                    }
                    if ((treeElement = ViewsTreeModel.getInstance().getProjectNode(string)) != null && objectArray[n] instanceof IProject) {
                        arrayList.add(treeElement);
                    } else if (treeElement != null) {
                        TreeElement treeElement2 = treeElement.getChildFromType("SOURCE_FOLDER");
                        TreeElement treeElement3 = treeElement.getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME);
                        TreeElement treeElement4 = null;
                        if (new Path(string2).segmentCount() > 2 && treeElement3 != null && (treeElement4 = ViewsUtil.isFileExistInOtherFolder(treeElement3, (IPath)new Path(string2))) != null) {
                            arrayList.add(treeElement4);
                        } else if (treeElement2 != null && (treeElement4 = treeElement2.getChildFromLocation(string2)) != null) {
                            arrayList.add(treeElement4);
                        } else if (treeElement3 != null && (treeElement4 = treeElement3.getChildFromLocation(string2)) != null) {
                            arrayList.add(treeElement4);
                        }
                    }
                }
                ++n;
            }
        }
        return arrayList.toArray();
    }

    public void refresh() {
        super.refresh();
    }

    public void internalRefresh(Object object) {
        if (this.shouldRefresh(object)) {
            super.internalRefresh(object);
        }
    }

    protected void internalRefresh(Object object, boolean bl) {
        super.internalRefresh(object, bl);
    }

    protected void setExpanded(Item item, boolean bl) {
        if (item != null && item.getData() != null && item.getData() instanceof TreeElement) {
            String string = "false";
            if (bl) {
                string = "true";
            }
            if (this.fPart instanceof DependencyView) {
                ((TreeElement)item.getData()).setAttribute("DV_EXPANDED", string);
            } else if (this.fPart instanceof StructuresView) {
                ((TreeElement)item.getData()).setAttribute("SV_EXPANDED", string);
                if (!bl && this.fIsExpandToLevelFired) {
                    return;
                }
            }
        }
        super.setExpanded(item, bl);
    }

    public void dispose() {
        this.fPart = null;
    }

    private boolean shouldRefresh(Object object) {
        long l = System.currentTimeMillis();
        boolean bl = true;
        this.lastRefreshed = l;
        this.lastRefreshElement = object;
        return bl;
    }

    public void setExpandToLevelFired(boolean bl) {
        this.fIsExpandToLevelFired = bl;
    }
}

