/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class COBOLTreeLabelProvider
extends LabelProvider {
    private QualifiedName fKeyMainFile;
    private static final String QUALIFIER = "org.eclipse.cobol.ui.views.dependency";
    private static final String PROPERTY_MAIN_FILE = "MAIN_FILE";
    private Hashtable imageTable = null;

    public boolean checkMainFileName(TreeElement treeElement) {
        String string = "";
        String string2 = "";
        IWorkspace iWorkspace = null;
        try {
            this.fKeyMainFile = new QualifiedName(QUALIFIER, PROPERTY_MAIN_FILE);
            iWorkspace = ResourcesPlugin.getWorkspace();
            IProject iProject = iWorkspace.getRoot().getProject(treeElement.getProject().getName());
            string = treeElement.getLocation();
            if (iProject != null && iProject.getLocation() != null && iProject.isOpen()) {
                string2 = iProject.getPersistentProperty(this.fKeyMainFile);
            }
        }
        catch (CoreException coreException) {
            string2 = "";
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            string2 = "";
            CBDTUiPlugin.logError(exception);
        }
        try {
            return string2 != null && !string2.equals("") && string2.equals(string);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return false;
    }

    public String getText(Object object) {
        block4: {
            try {
                if (object != null && !object.equals("")) break block4;
                return "NO Elements";
            }
            catch (Exception exception) {
                return "NO Elements";
            }
        }
        if (object instanceof ViewsTreeModel) {
            return ((ViewsTreeModel)object).toString();
        }
        return ((TreeElement)object).toString();
    }

    private String getFileNameWithoutExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private String getFileExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "NOEXTENSION";
        }
        return string.substring(n + 1);
    }

    public Image getImage(Object object) {
        try {
            TreeElement treeElement = (TreeElement)object;
            String string = treeElement.getAttribute("TYPE");
            if (string.equals(IViewConstants.PROJECT_NAME)) {
                if (!treeElement.isOpened()) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.closeproject.gif");
                }
                if (treeElement.getMarker() == 2) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.problem_project.gif");
                }
                if (treeElement.getMarker() == 1) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.warning_project.gif");
                }
                return COBOLPluginImages.get("org.eclipse.cobol.ui.project.gif");
            }
            if (string.equals("SOURCE_FOLDER")) {
                if (treeElement.getMarker() == 2) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.problem_fldr_src.gif");
                }
                if (treeElement.getMarker() == 1) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.warning_fldr_src.gif");
                }
                return COBOLPluginImages.get("org.eclipse.cobol.ui.fldr_src.gif");
            }
            if (string.equals(IViewConstants.LINKING_FILES_FOLDER_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.fldr_link.gif");
            }
            if (string.equals(IViewConstants.OTHER_FILES_FOLDER_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.fldr_other.gif");
            }
            if (string.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.fldr_obj.gif");
            }
            if (string.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.fldr_dep.gif");
            }
            if (string.equals("TARGET_REPOSITORY_FOLDER")) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.fldr_rep.gif");
            }
            if (string.equals(IViewConstants.REPOSITORY_FOLDER_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.fldr_rep.gif");
            }
            if (string.equals("TARGET_OBJECT_FOLDER")) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.fldr_obj.gif");
            }
            if (string.equals(IViewConstants.CLASS_ID_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre16.gif");
            }
            if (string.equals(IViewConstants.PROGRAM_ID_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre15.gif");
            }
            if (string.equals(IViewConstants.FACTORY_ID_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.factory.gif");
            }
            if (string.equals(IViewConstants.OBJECT_ID_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.Object.gif");
            }
            if (string.equals(IViewConstants.METHOD_ID_NAME)) {
                if (treeElement.getParent().getAttribute("TYPE").equals(IViewConstants.FACTORY_ID_NAME)) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre17.gif");
                }
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre18.gif");
            }
            if (string.equals(IViewConstants.ENVIRONMENT_ID_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre15e.gif");
            }
            if (string.equals(IViewConstants.DATA_ID_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre15d.gif");
            }
            if (string.equals(IViewConstants.PROCEDURE_ID_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre15pg.gif");
            }
            if (string.equals(IViewConstants.DECLARATIVES_ID_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre15pg.gif");
            }
            if (string.equals(IViewConstants.SECTION_ID_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre15s.gif");
            }
            if (string.equals(IViewConstants.STATEMENT_ID_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre15p.gif");
            }
            if (string.equals(IViewConstants.REPOSITORY_CLASS_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre16.gif");
            }
            if (string.equals(IViewConstants.OBJECT_METHOD_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre18.gif");
            }
            if (string.equals(IViewConstants.FACTORY_METHOD_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre17.gif");
            }
            if (string.equals(IViewConstants.OBJECT_PROPERTY_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre20.gif");
            }
            if (string.equals(IViewConstants.FACTORY_PROPERTY_NAME)) {
                return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre19.gif");
            }
            if (string.equals("SOURCE_FILE")) {
                Image image;
                if (this.checkMainFileName(treeElement)) {
                    if (treeElement.getMarker() == 2) {
                        return COBOLPluginImages.get("org.eclipse.cobol.ui.problem_main_cobol_icon.gif");
                    }
                    if (treeElement.getMarker() == 1) {
                        return COBOLPluginImages.get("org.eclipse.cobol.ui.warning_main_cobol_icon.gif");
                    }
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.Main_Cobol_Icon.gif");
                }
                if (treeElement.getMarker() == 2) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.problem_cobol_file_icon.gif");
                }
                if (treeElement.getMarker() == 1) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.warning_cobol_file_icon.gif");
                }
                String string2 = this.getFileNameWithoutExtension(treeElement.getName());
                String string3 = this.getFileExtension(treeElement.getName());
                if (CommonBuildUtil.getCobolEditorFiles().contains(string3)) {
                    int n = treeElement.getParent().getAllChildren().indexOf(treeElement);
                    ArrayList arrayList = treeElement.getParent().getAllChildren();
                    int n2 = 0;
                    while (n2 < arrayList.size()) {
                        int n3;
                        TreeElement treeElement2 = (TreeElement)arrayList.get(n2);
                        String string4 = this.getFileNameWithoutExtension(treeElement2.getName());
                        if (string4.equals(string2) && (n3 = treeElement.getParent().getAllChildren().indexOf(treeElement2)) < n) {
                            return COBOLPluginImages.get("org.eclipse.cobol.ui.file_obj.gif");
                        }
                        ++n2;
                    }
                }
                if ((image = this.assignFileIcon(string3, treeElement)) == null) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.Cobol_File_Icon.gif");
                }
                return image;
            }
            if (string.equals(IViewConstants.LINKING_FILES_NAME)) {
                String string5 = this.getFileExtension(treeElement.getName());
                Image image = this.assignFileIcon(string5, treeElement);
                if (image == null) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.file_obj.gif");
                }
                return image;
            }
            if (string.equals(IViewConstants.OTHER_FILES_NAME)) {
                String string6 = this.getFileExtension(treeElement.getName());
                Image image = this.assignFileIcon(string6, treeElement);
                if (image == null) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.file_obj.gif");
                }
                return image;
            }
            if (string.equals(IViewConstants.DEPENDENT_FILES_NAME)) {
                String string7 = this.getFileExtension(treeElement.getName());
                Image image = this.assignFileIcon(string7, treeElement);
                if (image == null) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre12.gif");
                }
                return image;
            }
            if (string.equals("TARGET_FILES")) {
                String string8 = this.getFileExtension(treeElement.getName());
                Image image = this.assignFileIcon(string8, treeElement);
                if (image == null) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.file_obj.gif");
                }
                return image;
            }
            if (string.equals("TARGET_OBJECT_FILES")) {
                String string9 = this.getFileExtension(treeElement.getName());
                Image image = this.assignFileIcon(string9, treeElement);
                if (image == null) {
                    return COBOLPluginImages.get("org.eclipse.cobol.ui.file_obj.gif");
                }
                return image;
            }
            String string10 = this.getFileExtension(treeElement.getName());
            return this.assignFileIcon(string10, treeElement);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return null;
    }

    public Image assignFileIcon(String string, TreeElement treeElement) {
        if (treeElement == null) {
            return null;
        }
        if (string.equalsIgnoreCase("cbl") || string.equalsIgnoreCase("cobol") || string.equalsIgnoreCase("cob")) {
            return COBOLPluginImages.get("org.eclipse.cobol.ui.Cobol_File_Icon.gif");
        }
        if (string.equalsIgnoreCase("rep")) {
            return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre11.gif");
        }
        if (string.equalsIgnoreCase("so")) {
            return COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre13.gif");
        }
        return this.getOtherImage(treeElement);
    }

    private Image getOtherImage(TreeElement treeElement) {
        Image image;
        ImageDescriptor imageDescriptor;
        block7: {
            IWorkbenchAdapter iWorkbenchAdapter;
            IFile iFile;
            block6: {
                try {
                    IWorkspace iWorkspace = CBDTUiPlugin.getWorkspace();
                    IProject iProject = iWorkspace.getRoot().getProject(treeElement.getProject().getName());
                    String string = null;
                    string = !treeElement.getName().equalsIgnoreCase(treeElement.toString()) ? ViewsUtil.getFileLocation(treeElement.getName(), treeElement.toString(), treeElement) : treeElement.getName();
                    iFile = iProject.getFile(string);
                    iWorkbenchAdapter = this.getAdapter(iFile);
                    if (iWorkbenchAdapter != null) break block6;
                    return null;
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                    return null;
                }
            }
            imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iFile);
            if (imageDescriptor != null) break block7;
            return null;
        }
        if (this.imageTable == null) {
            this.imageTable = new Hashtable(40);
        }
        if ((image = (Image)this.imageTable.get(imageDescriptor)) == null) {
            image = imageDescriptor.createImage();
            this.imageTable.put(imageDescriptor, image);
        }
        return image;
    }

    protected final IWorkbenchAdapter getAdapter(Object object) {
        if (object == null || !(object instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter)((IAdaptable)object).getAdapter(IWorkbenchAdapter.class);
    }

    public void dispose() {
        this.fKeyMainFile = null;
        if (this.imageTable != null) {
            this.imageTable.clear();
            this.imageTable = null;
        }
        super.dispose();
    }
}

