/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.common;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.cobol.core.build.model.IBuildTool;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.COBOLTreeLabelProvider;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.structures.RepositoryData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;

public class COBOLResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private boolean isRequiredToRefresh = false;
    private ArrayList listOfDeletedFiles = new ArrayList(10);

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        final ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
        this.listOfDeletedFiles = new ArrayList(10);
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        iResourceDeltaArray = this.getOrderedResourceDeltaList(iResourceDeltaArray);
        int n = 0;
        while (iResourceDeltaArray != null && n < iResourceDeltaArray.length) {
            if (iResourceDeltaArray[n].getResource().getType() == 4) {
                this.processProjectDelta(iResourceDeltaArray[n]);
            }
            if (iResourceDeltaArray[n].getResource().getType() == 2) {
                this.processFolderDelta(iResourceDeltaArray[n]);
            }
            if (iResourceDeltaArray[n].getResource().getType() == 1) {
                this.processFileDelta(iResourceDeltaArray[n]);
            }
            if (this.isRequiredToRefresh) {
                String string = iResourceDeltaArray[n].getResource().getProject().getName();
                final TreeElement treeElement = ViewsTreeModel.getInstance().getProjectNode(string);
                if (treeElement != null && !arrayList.contains(treeElement)) {
                    arrayList.add(treeElement);
                    Display display = Display.getCurrent();
                    if (display == null) {
                        display = Display.getDefault();
                    }
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (treeElement != null) {
                                arrayList.remove(treeElement);
                                ViewsUtil.refreshViews(treeElement);
                            }
                        }
                    });
                    this.setRefreshRequired(false);
                }
            }
            ++n;
        }
        return iResourceDeltaArray != null && iResourceDeltaArray.length > 0;
    }

    private IResourceDelta[] getOrderedResourceDeltaList(IResourceDelta[] iResourceDeltaArray) {
        if (iResourceDeltaArray != null && iResourceDeltaArray.length > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>(10);
            ArrayList<IResourceDelta> arrayList2 = new ArrayList<IResourceDelta>(10);
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                if (2 == iResourceDeltaArray[n].getKind()) {
                    arrayList.add(iResourceDeltaArray[n]);
                } else {
                    arrayList2.add(iResourceDeltaArray[n]);
                }
                ++n;
            }
            arrayList.addAll(arrayList2);
            return arrayList.toArray(new IResourceDelta[arrayList.size()]);
        }
        return null;
    }

    private void setRefreshRequired(boolean bl) {
        this.isRequiredToRefresh = bl;
    }

    private boolean isAdded(IResourceDelta iResourceDelta) {
        return iResourceDelta.getKind() == 1;
    }

    private boolean isRemoved(IResourceDelta iResourceDelta) {
        return iResourceDelta.getKind() == 2;
    }

    private void processProjectDelta(IResourceDelta iResourceDelta) {
        String string;
        Object object;
        TreeElement treeElement;
        IProject iProject;
        ViewsTreeModel viewsTreeModel = ViewsTreeModel.getInstance();
        int n = iResourceDelta.getKind();
        int n2 = iResourceDelta.getFlags();
        if (n == 4 && (n2 & 0x4000) != 0 && (iProject = (IProject)iResourceDelta.getResource()) != null && iProject.getLocation() != null && (treeElement = viewsTreeModel.getRoot().getClosedProject(iProject.getName())) != null) {
            if (iProject.isOpen()) {
                treeElement.openTreeElement();
                RepositoryData.populateRepositoryData(treeElement);
                this.setRefreshRequired(false);
                ViewsUtil.updateOtherViews();
            } else {
                treeElement.closeTreeElement();
                this.setRefreshRequired(false);
                ViewsUtil.updateOtherViews();
            }
        }
        if (n == 2 && iResourceDelta.getResource().getType() == 4 && (iProject = (IProject)iResourceDelta.getResource()) != null) {
            if (iResourceDelta.getMovedToPath() != null) {
                treeElement = iResourceDelta.getMovedToPath();
                object = treeElement.lastSegment();
                string = CBDTUiPlugin.getWorkspace().getRoot().getLocation().append((String)object);
                if (object != null && ((String)object).length() > 0) {
                    this.updateProjectDetails((String)object, string.toOSString(), iProject.getName());
                    this.setRefreshRequired(false);
                    ViewsUtil.updateOtherViews();
                    TreeElement treeElement2 = viewsTreeModel.getRoot().getChildFromName((String)object);
                    return;
                }
            }
            if ((treeElement = viewsTreeModel.getRoot().getChildFromName(iProject.getName())) != null) {
                treeElement.deleteChildren();
                RepositoryData.deleteRepositoryData(treeElement);
                viewsTreeModel.getRoot().deleteChild(treeElement);
                this.setRefreshRequired(false);
                ViewsUtil.updateOtherViews();
            }
        }
        if (n == 1 && iResourceDelta.getResource().getType() == 4) {
            iProject = (IProject)iResourceDelta.getResource();
            if (!iProject.isAccessible()) {
                return;
            }
            if (iResourceDelta.getMovedFromPath() != null && (string = (object = iResourceDelta.getMovedFromPath()).lastSegment()) != null && string.length() > 0) {
                this.updateProjectDetails(iProject.getName(), iProject.getFullPath().toOSString(), string);
                this.setRefreshRequired(false);
                ViewsUtil.updateOtherViews();
                return;
            }
            try {
                treeElement = iProject.getNature("org.eclipse.cobol.core.COBOLNature");
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
                return;
            }
            object = viewsTreeModel.getRoot().getChildFromName(iProject.getName());
            if (treeElement != null && object == null) {
                this.create(iProject);
                this.setRefreshRequired(false);
                ViewsUtil.updateOtherViews();
            }
        }
    }

    private void processFileDelta(IResourceDelta iResourceDelta) {
        ViewsTreeModel viewsTreeModel = ViewsTreeModel.getInstance();
        int n = iResourceDelta.getKind();
        IPath iPath = iResourceDelta.getFullPath();
        if (iPath.segmentCount() == 0) {
            return;
        }
        TreeElement treeElement = viewsTreeModel.getProjectNode(iPath.segments()[0]);
        if (treeElement == null) {
            return;
        }
        TreeElement treeElement2 = treeElement.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
        if (treeElement2 == null) {
            return;
        }
        TreeElement treeElement3 = treeElement.getChildFromName(IViewConstants.LINKING_FILES_FOLDER_NAME);
        if (treeElement3 == null) {
            return;
        }
        TreeElement treeElement4 = treeElement.getChildFromName("SOURCE_FOLDER");
        if (treeElement4 == null) {
            return;
        }
        if (n == 4 && iResourceDelta.getResource().getType() == 1) {
            IPath iPath2 = iResourceDelta.getResource().getFullPath();
            String string = iPath2.toString();
            String string2 = iResourceDelta.getResource().getName();
            if (string2.equals(".CobolOptions") || string2.equals(".project")) {
                return;
            }
            if (string.startsWith(String.valueOf('/'))) {
                string = string.substring(1);
            }
            if (iResourceDelta.getMovedFromPath() != null) {
                this.renameFileElement(iResourceDelta);
                this.setRefreshRequired(true);
                return;
            }
            int n2 = iResourceDelta.getFlags();
            String string3 = iResourceDelta.getResource().getProject().getFullPath().append("build.xml").toString();
            if (iResourceDelta.getResource().getName().equalsIgnoreCase("build.xml") && ((n2 & 0x100) != 0 || (n2 & 0x40000) != 0) && string3.toLowerCase().equals(iResourceDelta.getResource().getFullPath().toString().toLowerCase())) {
                treeElement2.addChild(string, iResourceDelta.getResource().getName(), IViewConstants.OTHER_FILES_NAME, false);
                treeElement2.sortOtherFolders();
                this.setRefreshRequired(true);
            }
        } else if (n == 1 && iResourceDelta.getResource().getType() == 1) {
            IPath iPath3 = iResourceDelta.getResource().getFullPath();
            String string = iPath3.toString();
            TreeElement treeElement5 = treeElement2;
            if (string.startsWith(String.valueOf('/'))) {
                string = string.substring(1);
            }
            if (iResourceDelta.getMovedFromPath() != null) {
                this.renameFileElement(iResourceDelta);
                this.setRefreshRequired(true);
            } else if (iResourceDelta.getMovedToPath() != null) {
                return;
            }
            if (treeElement4.getChildFromLocation(string) != null) {
                return;
            }
            if (treeElement3.getChildFromLocation(string) != null) {
                return;
            }
            DeletedFiles deletedFiles = this.isExistInDeletedList(string);
            if (deletedFiles != null) {
                String string4 = deletedFiles.getType();
                if (string4 != null && "SOURCE_FILE".equals(string4)) {
                    TreeElement treeElement6 = treeElement4.addChild(string, iResourceDelta.getResource().getName(), "SOURCE_FILE", true);
                    if (treeElement6 != null && deletedFiles.isMainSet()) {
                        ViewsActionUtil.setAsMainProgram(treeElement6);
                    }
                    this.setRefreshRequired(true);
                    return;
                }
                if (string4 != null && IViewConstants.LINKING_FILES_NAME.equals(string4)) {
                    treeElement3.addChild(string, iResourceDelta.getResource().getName(), IViewConstants.LINKING_FILES_NAME, false);
                    this.setRefreshRequired(true);
                    return;
                }
            }
            if (iPath3.segmentCount() > 0) {
                treeElement5 = this.createOtherSubFolder(treeElement2, iPath3.removeFirstSegments(1).removeLastSegments(1), iPath3.segment(iPath3.segmentCount() - 1));
            }
            if (treeElement5 != null && treeElement5.getChildFromName(iResourceDelta.getResource().getName()) == null) {
                treeElement5.addChild(string, iResourceDelta.getResource().getName(), IViewConstants.OTHER_FILES_NAME, false);
                treeElement5.sortOtherFolders();
                this.setRefreshRequired(true);
            }
        } else if (n == 2 && iResourceDelta.getResource().getType() == 1) {
            if (iResourceDelta.getMovedToPath() != null) {
                boolean bl = iResourceDelta.getMovedToPath().removeLastSegments(1).toString().equals(iResourceDelta.getResource().getFullPath().removeLastSegments(1).toString());
                if (iResourceDelta.getMovedToPath() != null && !bl && !iResourceDelta.getResource().getLocation().toFile().exists()) {
                    this.deleteFile(iResourceDelta.getResource().getFullPath(), iResourceDelta.getResource().getName(), treeElement4, treeElement3, treeElement2);
                    return;
                }
            }
            if (iResourceDelta.getMovedFromPath() != null || iResourceDelta.getMovedToPath() != null) {
                return;
            }
            this.deleteFile(iResourceDelta.getResource().getFullPath(), iResourceDelta.getResource().getName(), treeElement4, treeElement3, treeElement2);
        }
    }

    private void deleteFile(IPath iPath, String string, TreeElement treeElement, TreeElement treeElement2, TreeElement treeElement3) {
        String string2 = iPath.toString();
        TreeElement treeElement4 = treeElement3;
        TreeElement treeElement5 = null;
        if (string2.startsWith(String.valueOf('/'))) {
            string2 = string2.substring(1);
        }
        if ((treeElement5 = treeElement.getChildFromLocation(string2)) != null) {
            treeElement.deleteChild(treeElement5);
            this.setRefreshRequired(true);
            COBOLTreeLabelProvider cOBOLTreeLabelProvider = new COBOLTreeLabelProvider();
            boolean bl = false;
            if (cOBOLTreeLabelProvider.checkMainFileName(treeElement5)) {
                bl = true;
                ViewsActionUtil.resetMainProgram(treeElement5);
            }
            this.addToDeletedList(treeElement5.getLocation(), "SOURCE_FILE", bl);
            return;
        }
        treeElement5 = treeElement2.getChildFromLocation(string2);
        if (treeElement5 != null) {
            treeElement2.deleteChild(treeElement5);
            this.setRefreshRequired(true);
            this.addToDeletedList(treeElement5.getLocation(), IViewConstants.LINKING_FILES_NAME, false, false);
            return;
        }
        treeElement5 = treeElement3.getChildFromLocation(string2);
        if (treeElement5 != null) {
            treeElement3.deleteChild(treeElement5);
            treeElement3.sortOtherFolders();
            this.setRefreshRequired(true);
            return;
        }
        if (iPath.segmentCount() > 0) {
            treeElement4 = COBOLResourceDeltaVisitor.getOtherSubFolder(treeElement3, iPath.removeFirstSegments(1).removeLastSegments(1), iPath.segment(iPath.segmentCount() - 1));
        }
        if (treeElement4 != null && (treeElement5 = treeElement4.getChildFromName(string)) != null) {
            treeElement4.deleteChild(treeElement5);
            treeElement4.sortOtherFolders();
            this.setRefreshRequired(true);
        }
    }

    private void processFolderDelta(IResourceDelta iResourceDelta) {
        TreeElement treeElement;
        ViewsTreeModel viewsTreeModel = ViewsTreeModel.getInstance();
        int n = iResourceDelta.getKind();
        IPath iPath = iResourceDelta.getFullPath();
        if (iPath.segmentCount() == 0) {
            return;
        }
        TreeElement treeElement2 = viewsTreeModel.getProjectNode(iPath.segments()[0]);
        if (treeElement2 == null) {
            return;
        }
        TreeElement treeElement3 = treeElement2.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
        if (treeElement3 == null) {
            return;
        }
        if (n == 1 && iResourceDelta.getResource().getType() == 2) {
            TreeElement treeElement4 = this.createOtherSubFolder(treeElement3, iResourceDelta.getFullPath().removeFirstSegments(1), iResourceDelta.getResource().getName());
            treeElement4.getParent().sortOtherFolders();
            this.setRefreshRequired(true);
        } else if (n == 2 && iResourceDelta.getResource().getType() == 2 && (treeElement = COBOLResourceDeltaVisitor.getOtherSubFolder(treeElement3, iResourceDelta.getFullPath().removeFirstSegments(1), iResourceDelta.getResource().getName())) != null) {
            treeElement.deleteChildren();
            treeElement.getParent().deleteChild(treeElement);
            treeElement.getParent().sortOtherFolders();
            this.setRefreshRequired(true);
        }
    }

    private TreeElement createOtherSubFolder(TreeElement treeElement, IPath iPath, String string) {
        String[] stringArray = iPath.segments();
        TreeElement treeElement2 = treeElement;
        if (stringArray.length > 0) {
            treeElement2 = treeElement.getChildFromName(stringArray[0]);
            if (treeElement2 == null) {
                String string2 = "";
                string2 = treeElement.getAttribute("TYPE").equals(IViewConstants.OTHER_FILES_FOLDER_NAME) ? String.valueOf(treeElement.getIProject().getName()) + '/' + stringArray[0] : String.valueOf(treeElement.getLocation()) + '/' + stringArray[0];
                treeElement2 = treeElement.addChild(string2, stringArray[0], IViewConstants.OTHER_FILES_SUBFOLDER_NAME, false);
            }
            if (iPath.removeFirstSegments(1).segmentCount() > 0) {
                treeElement2 = this.createOtherSubFolder(treeElement2, iPath.removeFirstSegments(1), string);
            }
        }
        return treeElement2;
    }

    public static TreeElement getOtherSubFolder(TreeElement treeElement, IPath iPath, String string) {
        String[] stringArray = iPath.segments();
        TreeElement treeElement2 = null;
        if (stringArray.length > 0) {
            treeElement2 = treeElement.getChildFromName(stringArray[0]);
            if (iPath.removeFirstSegments(1).segmentCount() > 0 && treeElement2 != null) {
                treeElement2 = COBOLResourceDeltaVisitor.getOtherSubFolder(treeElement2, iPath.removeFirstSegments(1), string);
            }
        }
        return treeElement2;
    }

    public static boolean isInTargetRepFolderAndTargetObjectFolder(TreeElement treeElement, String string) {
        ArrayList arrayList = treeElement.getAllChildrenOfType("SOURCE_FILE");
        int n = 0;
        while (arrayList != null && n < arrayList.size()) {
            TreeElement treeElement2;
            int n2;
            ArrayList arrayList2;
            TreeElement treeElement3 = (TreeElement)arrayList.get(n);
            TreeElement treeElement4 = treeElement3.getChildFromName(IViewConstants.TARGET_REPOSITORY_FOLDER_VALUE);
            TreeElement treeElement5 = treeElement3.getChildFromName(IViewConstants.TARGET_OBJECT_FOLDER_VALUE);
            if (treeElement4 != null) {
                arrayList2 = treeElement4.getAllChildrenOfType("TARGET_FILES");
                n2 = 0;
                while (arrayList2 != null && n2 < arrayList2.size()) {
                    treeElement2 = null;
                    treeElement2 = (TreeElement)arrayList2.get(n2);
                    if (treeElement2.getLocation().equalsIgnoreCase(string)) {
                        if (treeElement2 != null && !treeElement2.getLocation().equals(string)) {
                            treeElement2.setLocation(string);
                        }
                        return true;
                    }
                    ++n2;
                }
            }
            if (treeElement5 != null) {
                arrayList2 = treeElement5.getAllChildrenOfType("TARGET_OBJECT_FILES");
                n2 = 0;
                while (arrayList2 != null && n2 < arrayList2.size()) {
                    treeElement2 = null;
                    treeElement2 = (TreeElement)arrayList2.get(n2);
                    if (treeElement2.getLocation().equalsIgnoreCase(string)) {
                        if (treeElement2 != null && !treeElement2.getLocation().equals(string)) {
                            treeElement2.setLocation(string);
                        }
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    private void renameFileElement(IResourceDelta iResourceDelta) {
        TreeElement treeElement;
        Object object;
        TreeElement treeElement2;
        TreeElement treeElement3;
        String string;
        String string2 = iResourceDelta.getResource().getProject().getName();
        String string3 = iResourceDelta.getFullPath().lastSegment();
        String string4 = iResourceDelta.getFullPath().toString();
        if (string4.startsWith(String.valueOf('/'))) {
            string4 = string4.substring(1);
        }
        TreeElement treeElement4 = ViewsTreeModel.getInstance().getProjectNode(string2);
        TreeElement treeElement5 = treeElement4.getChildFromType("SOURCE_FOLDER");
        TreeElement treeElement6 = treeElement4.getChildFromType(IViewConstants.LINKING_FILES_FOLDER_NAME);
        TreeElement treeElement7 = treeElement4.getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME);
        Path path = new Path(string4);
        String string5 = "";
        if (path.segmentCount() >= 2) {
            string5 = path.lastSegment();
        }
        if ((string = iResourceDelta.getMovedFromPath().toString()).startsWith(String.valueOf('/'))) {
            string = string.substring(1);
        }
        if (string.endsWith("build.xml")) {
            return;
        }
        if (treeElement5 != null) {
            treeElement3 = treeElement5.getChildFromLocation(string);
            treeElement2 = treeElement6.getChildFromLocation(string);
            if (treeElement3 != null) {
                COBOLTreeLabelProvider cOBOLTreeLabelProvider = new COBOLTreeLabelProvider();
                boolean bl = cOBOLTreeLabelProvider.checkMainFileName(treeElement3);
                if (!string4.equalsIgnoreCase(string)) {
                    this.deleteFile((IPath)path, string5, treeElement5, treeElement6, treeElement7);
                }
                treeElement3.setName(string3);
                treeElement3.setLocation(string4);
                if (bl) {
                    ViewsActionUtil.setAsMainProgram(treeElement3);
                }
                if (treeElement2 != null) {
                    treeElement2.setName(string3);
                    treeElement2.setLocation(string4);
                }
                CommonBuildUtil.isSourceFileSupported((IProject)treeElement4.getIProject(), (String)string3);
                return;
            }
        }
        if (treeElement6 != null) {
            treeElement3 = treeElement6.getChildFromLocation(string);
            treeElement2 = treeElement7.getChildFromLocation(string);
            if (treeElement3 != null) {
                if (!string4.equalsIgnoreCase(string)) {
                    this.deleteFile((IPath)path, string5, treeElement5, treeElement6, treeElement7);
                }
                treeElement3.setName(string3);
                treeElement3.setLocation(string4);
                if (treeElement2 != null) {
                    treeElement2.setName(string3);
                    treeElement2.setLocation(string4);
                }
                return;
            }
        }
        boolean bl = false;
        if (treeElement7 != null && (treeElement2 = treeElement7.getChildFromLocation(string)) != null) {
            treeElement7.deleteChild(treeElement2);
            bl = true;
        }
        treeElement2 = new Path(string);
        if (treeElement7 != null && treeElement2.segmentCount() > 2 && (object = COBOLResourceDeltaVisitor.getOtherSubFolder(treeElement7, treeElement2.removeFirstSegments(1).removeLastSegments(1), treeElement2.segment(treeElement2.segmentCount() - 2))) != null && (treeElement = ((TreeElement)object).getChildFromLocation(string)) != null) {
            ((TreeElement)object).deleteChild(treeElement);
            bl = true;
        }
        object = new Path(string4);
        if (bl) {
            if (object.segmentCount() == 2) {
                treeElement7.addChild(string4, string3, IViewConstants.OTHER_FILES_NAME, false);
                treeElement7.sortOtherFolders();
            } else {
                this.createOtherSubFolder(treeElement7, object.removeFirstSegments(1).removeLastSegments(1), object.segment(object.segmentCount() - 1));
            }
        }
    }

    private void updateProjectDetails(String string, String string2, String string3) {
        TreeElement treeElement = ViewsTreeModel.getInstance().getProjectNode(string3);
        if (treeElement != null) {
            treeElement.setName(string);
            treeElement.setLocation(string2);
            treeElement.setProject(treeElement.getName(), treeElement.getAttribute("TYPE"), treeElement.getParent());
            this.updateProjectResources(treeElement, string, string3);
            ViewsTreeModel.getInstance().getRoot().repositionElement(string);
        }
    }

    private void updateProjectResources(TreeElement treeElement, String string, String string2) {
        TreeElement treeElement2;
        int n;
        ArrayList arrayList;
        TreeElement treeElement3 = treeElement.getChildFromType("SOURCE_FOLDER");
        TreeElement treeElement4 = treeElement.getChildFromType(IViewConstants.LINKING_FILES_FOLDER_NAME);
        TreeElement treeElement5 = treeElement.getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME);
        int n2 = 0;
        if (treeElement3 != null) {
            arrayList = treeElement3.getAllChildrenOfType("SOURCE_FILE");
            if (arrayList != null) {
                n2 = arrayList.size();
            }
            n = 0;
            while (arrayList != null && n < n2) {
                treeElement2 = (TreeElement)arrayList.get(n);
                this.updateLocation(treeElement2, string, string2);
                ++n;
            }
        }
        if (treeElement4 != null) {
            arrayList = treeElement4.getAllChildrenOfType(IViewConstants.LINKING_FILES_NAME);
            if (arrayList != null) {
                n2 = arrayList.size();
            }
            n = 0;
            while (arrayList != null && n < n2) {
                treeElement2 = (TreeElement)arrayList.get(n);
                this.updateLocation(treeElement2, string, string2);
                ++n;
            }
        }
        this.updateLocationInSubfolders(treeElement5, string, string2);
    }

    private void updateLocation(TreeElement treeElement, String string, String string2) {
        Path path;
        String string3 = treeElement.getLocation();
        if (string3 != null && (path = new Path(string3)).segmentCount() > 1 && path.segment(0).equals(string2)) {
            path = path.removeFirstSegments(1);
            path = new Path(String.valueOf(string) + '/' + path.toString());
            treeElement.setProject(treeElement.getName(), treeElement.getAttribute("TYPE"), treeElement.getParent());
            treeElement.setLocation(path.toString());
        }
    }

    private void updateLocationInSubfolders(TreeElement treeElement, String string, String string2) {
        ArrayList arrayList = treeElement.getAllChildrenOfType(IViewConstants.OTHER_FILES_NAME);
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        int n2 = 0;
        while (arrayList != null && n2 < n) {
            TreeElement treeElement2 = (TreeElement)arrayList.get(n2);
            this.updateLocation(treeElement2, string, string2);
            ++n2;
        }
        ArrayList arrayList2 = treeElement.getAllChildrenOfType(IViewConstants.OTHER_FILES_SUBFOLDER_NAME);
        if (arrayList2 != null) {
            n = arrayList2.size();
        }
        int n3 = 0;
        while (arrayList2 != null && n3 < n) {
            TreeElement treeElement3 = (TreeElement)arrayList2.get(n3);
            this.updateLocation(treeElement3, string, string2);
            this.updateLocationInSubfolders(treeElement3, string, string2);
            ++n3;
        }
    }

    private void addToDeletedList(String string, String string2, boolean bl, boolean bl2) {
        if (string != null && this.isExistInDeletedList(string) == null) {
            this.listOfDeletedFiles.add(new DeletedFiles(string, string2, bl));
        }
    }

    private void addToDeletedList(String string, String string2, boolean bl) {
        if (string != null && this.isExistInDeletedList(string) == null) {
            this.listOfDeletedFiles.add(new DeletedFiles(string, string2, bl));
        }
    }

    private DeletedFiles isExistInDeletedList(String string) {
        if (string != null && this.listOfDeletedFiles != null && this.listOfDeletedFiles.size() > 0) {
            int n = 0;
            while (n < this.listOfDeletedFiles.size()) {
                String string2;
                DeletedFiles deletedFiles = (DeletedFiles)this.listOfDeletedFiles.get(n);
                if (deletedFiles != null && (string2 = deletedFiles.getLocation()) != null && string2.toLowerCase().equals(string.toLowerCase())) {
                    return deletedFiles;
                }
                ++n;
            }
        }
        return null;
    }

    private void create(final IProject iProject) {
        ArrayList arrayList;
        if (iProject != null && (arrayList = CommonBuildUtil.getBuildTools((IProject)iProject)) != null && arrayList.size() > 0) {
            int n = arrayList.size();
            IBuildTool iBuildTool = null;
            Object var5_5 = null;
            try {
                String string = iProject.getLocation().toOSString().concat(File.separator);
                if (string != null && string.length() > 0) {
                    BuildUtil.updateDependencyViewFromINIFile(iProject);
                }
                int n2 = 0;
                while (n2 < n) {
                    String cfr_ignored_0 = (String)arrayList.get(n2);
                    var5_5 = null;
                    if (var5_5 == null) {
                        return;
                    }
                    iBuildTool = var5_5.createBuildTool();
                    if (iBuildTool == null) {
                        return;
                    }
                    iBuildTool.setProject(iProject);
                    ++n2;
                }
                String string2 = BuildUtil.getCobolMainFileNameFromINIFile(string);
                if (string2 != null && string2.length() > 0 && !string2.toLowerCase().startsWith(iProject.getName().toLowerCase())) {
                    Path path = new Path(string2);
                    path = path.removeFirstSegments(1);
                    String string3 = path.toString();
                    if ('/' != string2.charAt(0)) {
                        string3 = String.valueOf('/') + string3;
                    }
                    string3 = String.valueOf(iProject.getName()) + string3;
                    if (CBDTUiPlugin.getWorkspace().getRoot().findMember(string3) != null) {
                        BuildUtil.updateProjectPersistanceWithMainFile(iProject, string3);
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IResource iResource = iProject.findMember("build.xml");
                        if (iResource != null && iResource instanceof IFile) {
                            try {
                                iResource.delete(false, (IProgressMonitor)new NullProgressMonitor());
                                iProject.refreshLocal(0, null);
                                iResource.touch((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                });
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
            }
        }
    }

    public class DeletedFiles {
        private String location;
        private String type;
        private boolean isMainProgramSet = false;

        public DeletedFiles(String string, String string2, boolean bl) {
            this.location = string;
            this.type = string2;
            this.isMainProgramSet = bl;
        }

        public String getLocation() {
            return this.location;
        }

        public String getType() {
            return this.type;
        }

        public boolean isMainSet() {
            return this.isMainProgramSet;
        }
    }
}

