/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cobol.core.build.util.BuildConstants;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.COBOLTreeLabelProvider;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.RemoteFile;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class ViewsActionUtil {
    private static QualifiedName fKeyMainFile = new QualifiedName("org.eclipse.cobol.ui.views.dependency", "MAIN_FILE");

    public static void showCOBOLUnsupportedMessage(IProject iProject, String string) {
        if (CommonBuildUtil.isSourceFileSupported((IProject)iProject, (String)string)) {
            return;
        }
        ViewsUtil.displayUnsupportedSourceMessage(string);
    }

    public static void setAsMainProgram(TreeElement treeElement) {
        ViewsActionUtil.setAsMainProgram(treeElement, true);
    }

    public static void setAsMainProgram(TreeElement treeElement, boolean bl) {
        String string = "";
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(treeElement.getProject().getName());
        string = treeElement.getLocation();
        try {
            if (iProject != null && iProject.getLocation() != null) {
                iProject.setPersistentProperty(fKeyMainFile, string);
                if (bl) {
                    ViewsActionUtil.cleanOutputFiles(treeElement);
                }
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void resetMainProgram(TreeElement treeElement) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(treeElement.getProject().getName());
        try {
            if (iProject != null && iProject.getLocation() != null) {
                iProject.setPersistentProperty(fKeyMainFile, "");
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void setCopyFlag(TreeElement[] treeElementArray, boolean bl) {
        int n = 0;
        while (n < treeElementArray.length) {
            TreeElement treeElement = treeElementArray[n];
            treeElement.setCopied(bl);
            if (treeElement.getChildren() != null && treeElement.getChildren().size() > 0) {
                int n2 = treeElement.getChildren().size();
                TreeElement[] treeElementArray2 = new TreeElement[n2];
                int n3 = 0;
                while (n3 < n2) {
                    treeElementArray2[n3] = (TreeElement)treeElement.getChildren().get(n3);
                    ++n3;
                }
                ViewsActionUtil.setCopyFlag(treeElementArray2, bl);
            }
            ++n;
        }
    }

    public static boolean isCopyingSameLocation(TreeElement treeElement, TreeElement treeElement2) {
        if (treeElement != null && treeElement2 != null && treeElement.getAttribute("TYPE").equals("ROOT") && SelectionAction.isProject(treeElement2)) {
            return false;
        }
        if (treeElement != null && treeElement2 != null && treeElement.getIProject().equals((Object)treeElement2.getIProject()) && (SelectionAction.isSourceFile(treeElement2) || SelectionAction.isOtherFile(treeElement2) || SelectionAction.isOtherSubFolder(treeElement2))) {
            if (treeElement.equals(treeElement2.getParent())) {
                return true;
            }
            if (SelectionAction.isSourceFolder(treeElement2.getParent()) && SelectionAction.isOtherSubFolder(treeElement)) {
                String string = new Path(treeElement2.getLocation()).removeLastSegments(1).toOSString();
                if ('/' == string.charAt(0)) {
                    string = string.substring(1);
                }
                if (string.equalsIgnoreCase(treeElement.getLocation())) {
                    return true;
                }
            } else {
                if (SelectionAction.isSourceFolder(treeElement2.getParent()) && SelectionAction.isOtherFolder(treeElement) && new Path(treeElement2.getLocation()).segmentCount() == 2) {
                    return true;
                }
                if (SelectionAction.isOtherFolder(treeElement2.getParent()) && SelectionAction.isSourceFolder(treeElement)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static TreeElement isCopyingSameLocation(TreeElement treeElement, String string, String string2) {
        Object object;
        String string3;
        Object object2;
        if (treeElement != null && string2 != null && treeElement.getAttribute("TYPE").equals("ROOT")) {
            object2 = new Path(string2);
            string3 = object2.lastSegment();
            object = CBDTUiPlugin.getWorkspace().getRoot().findMember(string3);
            if (object != null && object instanceof IProject) {
                return null;
            }
        }
        if (treeElement != null && string != null && string2 != null && (SelectionAction.isSourceFolder(treeElement) || SelectionAction.isOtherFolder(treeElement) || SelectionAction.isOtherSubFolder(treeElement))) {
            object2 = treeElement.getIProject().getLocation().toOSString();
            string3 = new Path(string);
            if ((string = string3.toOSString()).toLowerCase().startsWith(((String)object2).toLowerCase())) {
                if ('/' == string2.charAt(0)) {
                    string2 = string2.substring(1);
                }
                object = string.substring(((String)object2).length());
                if ('/' == ((String)(object = new Path((String)object).toString())).charAt(0)) {
                    object = ((String)object).substring(1);
                }
                object = String.valueOf(treeElement.getIProject().getName()) + '/' + (String)object;
                if (treeElement.getChildFromLocation(string2) != null && ((String)object).equals(string2)) {
                    return treeElement.getChildFromLocation(string2);
                }
                if (SelectionAction.isOtherSubFolder(treeElement)) {
                    TreeElement treeElement2 = treeElement.getProject().getChildFromType("SOURCE_FOLDER");
                    if (treeElement.getChildFromLocation(string2) != null && ((String)object).equalsIgnoreCase(string2)) {
                        return treeElement.getChildFromLocation(string2);
                    }
                    if (treeElement2 != null && treeElement2.getChildFromLocation(string2) != null) {
                        return treeElement2.getChildFromLocation(string2);
                    }
                } else if (SelectionAction.isSourceFolder(treeElement) && new Path(string2).segmentCount() == 2 && ((String)object).equalsIgnoreCase(string2)) {
                    TreeElement treeElement3 = treeElement.getParent().getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME);
                    if (treeElement3.getChildFromLocation(string2) != null) {
                        return treeElement3.getChildFromLocation(string2);
                    }
                    if (treeElement.getChildFromLocation(string2) != null) {
                        return treeElement.getChildFromLocation(string2);
                    }
                } else if (SelectionAction.isOtherFolder(treeElement) && new Path(string2).segmentCount() == 2 && ((String)object).equalsIgnoreCase(string2)) {
                    TreeElement treeElement4 = treeElement.getParent().getChildFromType("SOURCE_FOLDER");
                    if (treeElement4.getChildFromLocation(string2) != null) {
                        return treeElement4.getChildFromLocation(string2);
                    }
                    if (treeElement.getChildFromLocation(string2) != null) {
                        return treeElement.getChildFromLocation(string2);
                    }
                }
            }
        }
        return null;
    }

    public static boolean canOverwriteMove(Shell shell, String string) {
        String[] stringArray = new String[]{Messages.getString((String)"Yes"), Messages.getString((String)"No")};
        String string2 = MessageFormat.format(Messages.getString((String)"RelocationAction.resourceExist.msg"), string);
        MessageDialog messageDialog = new MessageDialog(shell, Messages.getString((String)"RelocationAction.resourceExist.title"), null, string2, 3, stringArray, 0);
        return messageDialog.open() == 0;
    }

    public static void updateFilePersistance(TreeElement[] treeElementArray, boolean bl) {
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile iFile;
            Object object;
            if (treeElementArray != null && SelectionAction.isSourceFile(treeElementArray[n2]) && (object = treeElementArray[n2].getAdapter(IResource.class)) != null && object instanceof IFile && (iFile = (IFile)object).getLocation().toFile().exists()) {
                BuildUtil.setNameOptionInFilePersistance((IResource)iFile, bl);
                ViewsActionUtil.cleanOutputFiles(treeElementArray[n2]);
            }
            ++n2;
        }
    }

    public static void updateMianProgram(TreeElement treeElement, String string) {
        ViewsActionUtil.updateMianProgram(treeElement, string, true);
    }

    public static void updateMianProgram(TreeElement treeElement, String string, boolean bl) {
        if (treeElement != null && string != null && string.length() > 0) {
            String string2 = CBDTUiPlugin.getWorkspace().getRoot().getLocation().toOSString();
            string2 = string2.replace('\\', '/');
            if ((string = string.replace('\\', '/')).toLowerCase().startsWith(string2.toLowerCase())) {
                TreeElement treeElement2;
                TreeElement treeElement3;
                String string3 = string.substring(string2.length());
                Path path = new Path(string3);
                if (path.segmentCount() == 1) {
                    TreeElement treeElement4 = ViewsTreeModel.getInstance().getProjectNode(path.lastSegment());
                    if (treeElement4 != null) {
                        ViewsActionUtil.updateMianProgram(treeElement, treeElement4, bl);
                    }
                } else if (path.segmentCount() > 1 && (treeElement3 = ViewsTreeModel.getInstance().getProjectNode(path.segment(0))) != null && (treeElement2 = treeElement3.getChildFromType("SOURCE_FOLDER")) != null) {
                    TreeElement treeElement5;
                    String string4 = path.toString();
                    if ('/' == string4.charAt(0)) {
                        string4 = string4.substring(1);
                    }
                    if ((treeElement5 = treeElement2.getChildFromLocation(string4)) != null) {
                        ViewsActionUtil.updateMianProgram(treeElement, treeElement5, bl);
                    }
                }
            }
        }
    }

    public static void updateMianProgram(TreeElement treeElement, TreeElement treeElement2) {
        ViewsActionUtil.updateMianProgram(treeElement, treeElement2, true);
    }

    public static void updateMianProgram(TreeElement treeElement, TreeElement treeElement2, boolean bl) {
        if (treeElement != null && treeElement2 != null) {
            COBOLTreeLabelProvider cOBOLTreeLabelProvider = new COBOLTreeLabelProvider();
            if (SelectionAction.isSourceFile(treeElement) && SelectionAction.isSourceFile(treeElement2)) {
                if (cOBOLTreeLabelProvider.checkMainFileName(treeElement2) && !ViewsActionUtil.isMainProgramSet(treeElement) && !BuildUtil.isDLLTargetApplicationType(treeElement.getIProject())) {
                    ViewsActionUtil.setAsMainProgram(treeElement, bl);
                }
            } else if (SelectionAction.isProject(treeElement) && SelectionAction.isProject(treeElement2)) {
                Path path;
                String string = "";
                ArrayList arrayList = treeElement2.getChildFromType("SOURCE_FOLDER").getAllChildrenOfType("SOURCE_FILE");
                if (arrayList != null) {
                    int n = arrayList.size();
                    int n2 = 0;
                    while (n2 < n) {
                        TreeElement treeElement3 = (TreeElement)arrayList.get(n2);
                        if (BuildUtil.isCobolFileExtn(treeElement3.getName()) && cOBOLTreeLabelProvider.checkMainFileName(treeElement3)) {
                            string = treeElement3.getLocation();
                            break;
                        }
                        ++n2;
                    }
                }
                if ((path = new Path(string)) != null && path.segmentCount() > 0) {
                    string = path.removeFirstSegments(1).toString();
                    if ('/' == string.charAt(0)) {
                        string = string.substring(1);
                    }
                    string = String.valueOf(treeElement.getIProject().getName()) + '/' + string;
                    TreeElement treeElement4 = treeElement.getChildFromType("SOURCE_FOLDER").getChildFromLocation(string);
                    if (treeElement4 != null) {
                        ViewsActionUtil.setAsMainProgram(treeElement4, bl);
                    }
                }
            }
        }
    }

    public static boolean isMainProgramSet(TreeElement treeElement) {
        if (treeElement != null) {
            COBOLTreeLabelProvider cOBOLTreeLabelProvider = new COBOLTreeLabelProvider();
            TreeElement treeElement2 = treeElement.getProject();
            TreeElement treeElement3 = treeElement2.getChildFromType("SOURCE_FOLDER");
            ArrayList arrayList = treeElement3.getAllChildrenOfType("SOURCE_FILE");
            if (arrayList != null) {
                int n = 0;
                while (n < arrayList.size()) {
                    TreeElement treeElement4 = (TreeElement)arrayList.get(n);
                    if (treeElement4 != null && cOBOLTreeLabelProvider.checkMainFileName(treeElement4)) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        return false;
    }

    public static void setStructuredSelection(IWorkbenchPart iWorkbenchPart, TreeElement treeElement) {
        TreeViewer treeViewer = null;
        if (iWorkbenchPart == null) {
            return;
        }
        if (iWorkbenchPart instanceof DependencyView) {
            treeViewer = ((DependencyView)iWorkbenchPart).getViewer();
        } else if (iWorkbenchPart instanceof StructuresView) {
            treeViewer = ((StructuresView)iWorkbenchPart).getViewer();
        }
        try {
            if (SelectionAction.isSourceFile(treeElement)) {
                StructuredSelection structuredSelection = ViewsActionUtil.convertSelection(treeViewer.getSelection(), treeElement);
                treeViewer.setSelection((ISelection)structuredSelection);
            }
        }
        catch (RuntimeException runtimeException) {
            CBDTUiPlugin.logError(runtimeException);
        }
    }

    public static void setStructuredSelection(TreeViewer treeViewer, TreeElement treeElement) {
        if (treeViewer == null) {
            return;
        }
        try {
            if (SelectionAction.isSourceFile(treeElement)) {
                StructuredSelection structuredSelection = ViewsActionUtil.convertSelection(treeViewer.getSelection(), treeElement);
                treeViewer.setSelection((ISelection)structuredSelection);
            }
        }
        catch (RuntimeException runtimeException) {
            CBDTUiPlugin.logError(runtimeException);
        }
    }

    private static StructuredSelection convertSelection(ISelection iSelection, TreeElement treeElement) {
        Object object;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        if (iSelection instanceof IStructuredSelection && (object = treeElement.getAdapter(IResource.class)) instanceof IResource) {
            arrayList.add((IResource)object);
        }
        return new StructuredSelection(arrayList);
    }

    public static void showErrorMessage(Shell shell, String string, String string2) {
        if (!string2.equals("")) {
            String[] stringArray = new String[]{Messages.getString((String)"Ok")};
            MessageDialog messageDialog = new MessageDialog(shell, string, null, string2, 1, stringArray, 0);
            messageDialog.open();
        }
    }

    public static boolean checkReadOnlyAndNull(IResource iResource) {
        if (iResource == null) {
            return false;
        }
        return iResource.isReadOnly();
    }

    public static void deleteFolder(String string) {
        try {
            Path path = new Path(string);
            path.toFile().delete();
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void moveFolder(String string, String string2) {
        try {
            Path path = new Path(string);
            Path path2 = new Path(string2);
            if (path2.toFile().exists() && path2.toFile().isFile()) {
                if (path.toFile().exists()) {
                    path.toFile().delete();
                }
                new RemoteFile(string2);
            } else if (path2.toFile().exists() && path2.toFile().isDirectory()) {
                if (!path.toFile().exists()) {
                    path.toFile().mkdir();
                }
                String[] stringArray = path2.toFile().list();
                int n = 0;
                while (n < stringArray.length) {
                    ViewsActionUtil.moveFolder(path.append(stringArray[n]).toOSString(), path2.append(stringArray[n]).toOSString());
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void cleanOutputFiles(final TreeElement treeElement) {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                if (treeElement != null && SelectionAction.isSourceFile(treeElement) && BuildUtil.isCobolFileExtn(treeElement.getName())) {
                    File file;
                    Object object;
                    int n;
                    boolean bl = false;
                    TreeElement[] treeElementArray = ViewsUtil.getTargetRepositoryElements(treeElement);
                    TreeElement[] treeElementArray2 = ViewsUtil.getTargetObjectElements(treeElement);
                    if (treeElementArray != null && treeElementArray.length > 0) {
                        n = 0;
                        while (n < treeElementArray.length) {
                            object = new File(treeElementArray[n].getAbsolutePath());
                            if (object != null && ((File)object).exists()) {
                                ((File)object).delete();
                            }
                            bl = true;
                            ++n;
                        }
                    }
                    if (treeElementArray2 != null && treeElementArray2.length > 0) {
                        n = 0;
                        while (n < treeElementArray2.length) {
                            object = new File(treeElementArray2[n].getAbsolutePath());
                            if (object != null && ((File)object).exists()) {
                                ((File)object).delete();
                            }
                            bl = true;
                            ++n;
                        }
                    } else {
                        String string = treeElement.getAbsolutePath();
                        object = string.substring(0, string.lastIndexOf("."));
                        file = new File(String.valueOf(object) + BuildConstants.OBJ_EXTENSION);
                        if (file != null && file.exists()) {
                            file.delete();
                            bl = true;
                        }
                    }
                    String string = treeElement.getAbsolutePath();
                    object = string.substring(0, string.lastIndexOf("."));
                    file = new File(String.valueOf(object) + BuildConstants.SVD_EXTENSION);
                    if (file != null && file.exists()) {
                        file.delete();
                        bl = true;
                    }
                    IProject iProject = treeElement.getIProject();
                    try {
                        if (bl && iProject != null) {
                            iProject.refreshLocal(0, null);
                        }
                    }
                    catch (CoreException coreException) {
                        CBDTUiPlugin.logError((Exception)((Object)coreException));
                    }
                }
            }
        };
        try {
            CBDTUiPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
    }
}

