/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cobol.ui.views.actions.IActionValidate;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionGroup;

public class ViewsActionGroup
extends ActionGroup {
    protected IViewPart fViewPart = null;
    protected String fGroupName;
    private ArrayList fRegisteredSelectionListeners = null;

    public ViewsActionGroup(IViewPart iViewPart, String string) {
        Assert.isNotNull((Object)iViewPart);
        Assert.isNotNull((Object)string);
        this.fViewPart = iViewPart;
        this.fGroupName = string;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fViewPart.getSite().getSelectionProvider();
    }

    public Shell getShell() {
        return this.fViewPart.getSite().getShell();
    }

    public TreeElement getSelectedElement() {
        ISelection iSelection = this.getSelectionProvider().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            if (((IStructuredSelection)iSelection).size() > 1 || ((IStructuredSelection)iSelection).isEmpty()) {
                return null;
            }
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object instanceof TreeElement) {
                return (TreeElement)object;
            }
        }
        if (iSelection instanceof TreeElement) {
            return (TreeElement)iSelection;
        }
        return null;
    }

    public TreeElement[] getSelectedElements() {
        ISelection iSelection = this.getSelectionProvider().getSelection();
        ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
        if (iSelection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator != null && iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof TreeElement)) continue;
                arrayList.add((TreeElement)e);
            }
        }
        return arrayList.toArray(new TreeElement[arrayList.size()]);
    }

    protected void registerSelectionListener(ISelectionProvider iSelectionProvider, ISelectionChangedListener iSelectionChangedListener) {
        if (this.fRegisteredSelectionListeners == null) {
            this.fRegisteredSelectionListeners = new ArrayList(10);
        }
        this.fRegisteredSelectionListeners.add(iSelectionChangedListener);
        iSelectionProvider.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
    }

    public void dispose() {
        super.dispose();
        if (this.fRegisteredSelectionListeners != null && this.fRegisteredSelectionListeners.size() > 0) {
            int n = this.fRegisteredSelectionListeners.size();
            while (n > 0) {
                ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)this.fRegisteredSelectionListeners.get(n-- - 1);
                this.getSelectionProvider().removeSelectionChangedListener(iSelectionChangedListener);
            }
        }
    }

    protected int appendToGroup(IMenuManager iMenuManager, IAction iAction) {
        if (!(iAction instanceof IActionValidate)) {
            return 0;
        }
        if (iAction != null && ((IActionValidate)iAction).isValid()) {
            iMenuManager.appendToGroup(this.fGroupName, iAction);
            return 1;
        }
        return 0;
    }

    protected int appendToGroup(IMenuManager iMenuManager, IContributionItem iContributionItem) {
        if (iContributionItem != null) {
            iMenuManager.appendToGroup(this.fGroupName, iContributionItem);
            return 1;
        }
        return 0;
    }

    protected int addAction(IMenuManager iMenuManager, IAction iAction) {
        if (iAction != null && iAction.isEnabled()) {
            iMenuManager.add(iAction);
            return 1;
        }
        return 0;
    }
}

