/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.structures.MethodDetails;
import org.eclipse.cobol.ui.views.structures.PropertyDetails;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

public class TemplateInsertAction
extends SelectionAction {
    private PropertyDetails fDlgProperty = null;
    private MethodDetails fDlgMethod = null;
    private String fStrPasteIntoEditor = "";

    public TemplateInsertAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"AddDetails"));
    }

    public boolean isEnabled() {
        IWorkbenchPage iWorkbenchPage = this.fSite.getPage();
        if (iWorkbenchPage != null && iWorkbenchPage.getActiveEditor() instanceof COBOLEditor) {
            COBOLEditor cOBOLEditor = (COBOLEditor)iWorkbenchPage.getActiveEditor();
            IEditorInput iEditorInput = cOBOLEditor.getEditorInput();
            boolean bl = false;
            if (iEditorInput instanceof IFileEditorInput) {
                bl = ((IFileEditorInput)iEditorInput).getFile().isReadOnly();
            } else if (iEditorInput instanceof IStorageEditorInput) {
                try {
                    bl = ((IStorageEditorInput)iEditorInput).getStorage().isReadOnly();
                }
                catch (CoreException coreException) {
                    CBDTUiPlugin.logError((Exception)((Object)coreException));
                }
            }
            if (!bl) {
                return iEditorInput.exists();
            }
            return !bl;
        }
        return false;
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        this.addDetails();
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        return treeElementArray != null && treeElementArray.length == 1 && this.isEnabled() && (SelectionAction.isObjectProperty(treeElementArray[0]) || SelectionAction.isObjectMethod(treeElementArray[0]) || SelectionAction.isFactoryProperty(treeElementArray[0]) || SelectionAction.isFactoryMethod(treeElementArray[0]));
    }

    private void addDetails() {
        IWorkbenchPart iWorkbenchPart = this.getViewPart();
        if (iWorkbenchPart == null) {
            return;
        }
        StructuresView structuresView = null;
        if (!(iWorkbenchPart instanceof StructuresView)) {
            return;
        }
        structuresView = (StructuresView)iWorkbenchPart;
        TreeElement treeElement = this.getSelectedElement();
        IWorkbenchPage iWorkbenchPage = this.fSite.getPage();
        COBOLEditor cOBOLEditor = null;
        if (iWorkbenchPage.getActiveEditor() instanceof COBOLEditor) {
            cOBOLEditor = (COBOLEditor)iWorkbenchPage.getActiveEditor();
            if (treeElement.getAttribute("TYPE").equals(IViewConstants.OBJECT_PROPERTY_NAME)) {
                this.fDlgProperty = new PropertyDetails(this.getShell(), treeElement.getParent().getLocation(), treeElement.getLocation(), IViewConstants.OBJECT_PROPERTY_NAME, structuresView);
                try {
                    if (this.fDlgProperty.open() == 0) {
                        this.fStrPasteIntoEditor = structuresView.getStringPasteIntoEditor();
                        cOBOLEditor.pasteIntoEditor(this.fStrPasteIntoEditor);
                        this.fStrPasteIntoEditor = "";
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    CBDTUiPlugin.logError(indexOutOfBoundsException);
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                }
            } else if (treeElement.getAttribute("TYPE").equals(IViewConstants.FACTORY_PROPERTY_NAME)) {
                this.fDlgProperty = new PropertyDetails(this.getShell(), treeElement.getParent().getLocation(), treeElement.getLocation(), IViewConstants.FACTORY_PROPERTY_NAME, structuresView);
                try {
                    if (this.fDlgProperty.open() == 0) {
                        this.fStrPasteIntoEditor = structuresView.getStringPasteIntoEditor();
                        cOBOLEditor.pasteIntoEditor(this.fStrPasteIntoEditor);
                        this.fStrPasteIntoEditor = "";
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    CBDTUiPlugin.logError(indexOutOfBoundsException);
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                }
            } else if (treeElement.getAttribute("TYPE").equals(IViewConstants.OBJECT_METHOD_NAME) || treeElement.getAttribute("TYPE").equals(IViewConstants.FACTORY_METHOD_NAME)) {
                this.fDlgMethod = treeElement.getAttribute("TYPE").equals(IViewConstants.OBJECT_METHOD_NAME) ? new MethodDetails(this.getShell(), treeElement.getLocation(), IViewConstants.OBJECT_METHOD_NAME, treeElement, structuresView) : new MethodDetails(this.getShell(), treeElement.getLocation(), IViewConstants.FACTORY_METHOD_NAME, treeElement, structuresView);
                try {
                    if (this.fDlgMethod.open() == 0) {
                        this.fStrPasteIntoEditor = structuresView.getStringPasteIntoEditor();
                        cOBOLEditor.pasteIntoEditor(this.fStrPasteIntoEditor);
                        this.fStrPasteIntoEditor = "";
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    CBDTUiPlugin.logError(indexOutOfBoundsException);
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                }
            }
        }
        structuresView.setStringPasteIntoEditor(this.fStrPasteIntoEditor);
    }
}

