/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.views.actions.IActionValidate;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class SelectionAction
extends Action
implements ISelectionChangedListener,
IActionValidate {
    protected IWorkbenchSite fSite = null;

    protected SelectionAction(IWorkbenchSite iWorkbenchSite, String string) {
        super(string);
        Assert.isNotNull((Object)iWorkbenchSite);
        this.fSite = iWorkbenchSite;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSite.getSelectionProvider();
    }

    public Shell getShell() {
        return this.fSite.getShell();
    }

    public ISelection getSelection() {
        return this.getSelectionProvider().getSelection();
    }

    public TreeElement getSelectedElement() {
        ISelection iSelection = this.getSelectionProvider().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            if (((IStructuredSelection)iSelection).size() > 1 || ((IStructuredSelection)iSelection).isEmpty()) {
                return null;
            }
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object instanceof TreeElement) {
                return (TreeElement)object;
            }
        }
        if (iSelection instanceof TreeElement) {
            return (TreeElement)iSelection;
        }
        return null;
    }

    public TreeElement[] getSelectedElements() {
        ISelection iSelection = this.getSelectionProvider().getSelection();
        ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
        if (iSelection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator != null && iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof TreeElement)) continue;
                arrayList.add((TreeElement)e);
            }
        }
        return arrayList.toArray(new TreeElement[arrayList.size()]);
    }

    public void run() {
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof TreeElement)) continue;
                arrayList.add((TreeElement)e);
            }
            this.run(arrayList.toArray(new TreeElement[arrayList.size()]));
        } else if (iSelection instanceof TreeElement) {
            this.run(new TreeElement[]{(TreeElement)iSelection});
        } else if (iSelection instanceof ITextSelection) {
            this.run((ITextSelection)iSelection);
        } else {
            this.run(iSelection);
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        this.selectionChanged(iSelection);
    }

    protected String getName(IAdaptable iAdaptable) {
        IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter(IWorkbenchAdapter.class);
        if (iWorkbenchAdapter != null) {
            return iWorkbenchAdapter.getLabel((Object)iAdaptable);
        }
        return "";
    }

    public IWorkbenchPart getViewPart() {
        if (this.fSite instanceof ViewSite) {
            return ((ViewSite)this.fSite).getPart();
        }
        return null;
    }

    protected abstract void selectionChanged(ISelection var1);

    protected abstract void run(TreeElement[] var1);

    protected abstract void run(ISelection var1);

    protected abstract void run(ITextSelection var1);

    public static boolean isProject(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.PROJECT_NAME);
    }

    public static boolean isSourceFolder(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals("SOURCE_FOLDER");
    }

    public static boolean isLinkingFolder(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.LINKING_FILES_FOLDER_NAME);
    }

    public static boolean isOtherFolder(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.OTHER_FILES_FOLDER_NAME);
    }

    public static boolean isOtherSubFolder(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME);
    }

    public static boolean isREPFolder(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.REPOSITORY_FOLDER_NAME);
    }

    public static boolean isSourceFile(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals("SOURCE_FILE");
    }

    public static boolean isLinkingFile(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.LINKING_FILES_NAME);
    }

    public static boolean isOtherFile(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.OTHER_FILES_NAME);
    }

    public static boolean isObjectProperty(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.OBJECT_PROPERTY_NAME);
    }

    public static boolean isObjectMethod(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.OBJECT_METHOD_NAME);
    }

    public static boolean isFactoryProperty(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.FACTORY_PROPERTY_NAME);
    }

    public static boolean isFactoryMethod(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.FACTORY_METHOD_NAME);
    }

    public static boolean isRepositoryClass(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.REPOSITORY_CLASS_NAME);
    }

    public static boolean isDependentFile(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.DEPENDENT_FILES_NAME);
    }

    public static boolean isTargetFile(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals("TARGET_FILES");
    }

    public static boolean isTargetObjectFile(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals("TARGET_OBJECT_FILES");
    }

    public static boolean isTargetObjectFolder(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals("TARGET_OBJECT_FOLDER");
    }

    public static boolean isTargetRepositoryFolder(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals("TARGET_REPOSITORY_FOLDER");
    }

    public static boolean isDependentFolder(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME);
    }

    public static boolean isProgramIdName(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.PROGRAM_ID_NAME);
    }

    public static boolean isClassIdName(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.CLASS_ID_NAME);
    }

    public static boolean isFactoryIdName(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.FACTORY_ID_NAME);
    }

    public static boolean isFactoryMethodName(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.FACTORY_METHOD_NAME);
    }

    public static boolean isFactoryPropName(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.FACTORY_PROPERTY_NAME);
    }

    public static boolean isObjectIdName(TreeElement treeElement) {
        return treeElement != null && treeElement.getAttribute("TYPE").equals(IViewConstants.OBJECT_ID_NAME);
    }

    public static boolean isNameOptionSetInProjectOptions(TreeElement treeElement) {
        IProject iProject;
        if (treeElement != null && (iProject = treeElement.getIProject()) != null && iProject.isOpen()) {
            return BuildUtil.getNameOptionFromResourcePersistance((IResource)iProject);
        }
        return false;
    }

    public static IFile getFile(TreeElement treeElement) {
        Path path;
        if (treeElement.getAttribute("TYPE").equals("SOURCE_FILE") && (path = new Path(treeElement.getLocation())) != null && path.getDevice() == null && path.segmentCount() > 1 && path.segment(0).equals(treeElement.getIProject().getName())) {
            path = path.removeFirstSegments(1);
            try {
                IResource iResource = treeElement.getIProject().findMember((IPath)path);
                if (iResource != null && iResource instanceof IFile) {
                    return (IFile)iResource;
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
        return null;
    }
}

