/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import org.eclipse.cobol.ui.views.actions.AddToSourceAction;
import org.eclipse.cobol.ui.views.actions.CopyAction;
import org.eclipse.cobol.ui.views.actions.CutAction;
import org.eclipse.cobol.ui.views.actions.DeleteAction;
import org.eclipse.cobol.ui.views.actions.PasteAction;
import org.eclipse.cobol.ui.views.actions.RemoveFromSourceAction;
import org.eclipse.cobol.ui.views.actions.RenameAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionGroup;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;

public class ResourceActionGroup
extends ViewsActionGroup {
    private CopyAction fCopyAction = null;
    private PasteAction fPasteAction = null;
    private DeleteAction fDeleteAction = null;
    private AddToSourceAction fAddToSourceAction = null;
    private RemoveFromSourceAction fRemoveFromSourceAction = null;
    private RenameAction fRenameAction = null;
    private CutAction fCutAction = null;
    private Clipboard fClipboard = new Clipboard(this.getShell().getDisplay());
    private TreeViewer fTreeViewer = null;
    private KeyListener fKeyListener = null;

    public ResourceActionGroup(IViewPart iViewPart, String string) {
        super(iViewPart, string);
        this.fPasteAction = new PasteAction((IWorkbenchSite)iViewPart.getSite(), this.fClipboard);
        this.registerSelectionListener(this.getSelectionProvider(), this.fPasteAction);
        this.fCopyAction = new CopyAction((IWorkbenchSite)iViewPart.getSite(), this.fClipboard, this.fPasteAction);
        this.registerSelectionListener(this.getSelectionProvider(), this.fCopyAction);
        this.fCutAction = new CutAction((IWorkbenchSite)iViewPart.getSite(), this.fClipboard, this.fPasteAction);
        this.registerSelectionListener(this.getSelectionProvider(), this.fCutAction);
        this.fDeleteAction = new DeleteAction((IWorkbenchSite)iViewPart.getSite());
        this.registerSelectionListener(this.getSelectionProvider(), this.fDeleteAction);
        this.fRemoveFromSourceAction = new RemoveFromSourceAction((IWorkbenchSite)iViewPart.getSite());
        this.registerSelectionListener(this.getSelectionProvider(), this.fRemoveFromSourceAction);
        this.fAddToSourceAction = new AddToSourceAction((IWorkbenchSite)iViewPart.getSite());
        this.registerSelectionListener(this.getSelectionProvider(), this.fAddToSourceAction);
        this.fRenameAction = new RenameAction((IWorkbenchSite)iViewPart.getSite());
        this.registerSelectionListener(this.getSelectionProvider(), this.fRenameAction);
        this.registerKeyListener(iViewPart);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.setGlobalActionHandler("delete", (IAction)this.fDeleteAction);
        iActionBars.setGlobalActionHandler("copy", (IAction)this.fCopyAction);
        iActionBars.setGlobalActionHandler("cut", (IAction)this.fCutAction);
        iActionBars.setGlobalActionHandler("paste", (IAction)this.fPasteAction);
        IActionBars iActionBars2 = this.fViewPart.getViewSite().getActionBars();
        if (iActionBars2 != null) {
            iActionBars2.setGlobalActionHandler("delete", (IAction)this.fDeleteAction);
            iActionBars2.setGlobalActionHandler("copy", (IAction)this.fCopyAction);
            iActionBars2.setGlobalActionHandler("cut", (IAction)this.fCutAction);
            iActionBars2.setGlobalActionHandler("paste", (IAction)this.fPasteAction);
        }
    }

    @Override
    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.appendToGroup(iMenuManager, (IAction)this.fCutAction);
        this.appendToGroup(iMenuManager, (IAction)this.fCopyAction);
        this.appendToGroup(iMenuManager, (IAction)this.fPasteAction);
        this.appendToGroup(iMenuManager, (IAction)this.fDeleteAction);
        this.appendToGroup(iMenuManager, (IAction)this.fRenameAction);
        this.appendToGroup(iMenuManager, (IAction)this.fAddToSourceAction);
        this.appendToGroup(iMenuManager, (IAction)this.fRemoveFromSourceAction);
    }

    private void registerKeyListener(IViewPart iViewPart) {
        if (iViewPart instanceof DependencyView) {
            this.fTreeViewer = ((DependencyView)iViewPart).getViewer();
        } else if (iViewPart instanceof StructuresView) {
            this.fTreeViewer = ((StructuresView)iViewPart).getViewer();
        }
        if (this.fTreeViewer != null) {
            this.fKeyListener = new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.stateMask != 0) {
                        return;
                    }
                    if (keyEvent.character == '\u007f' && ResourceActionGroup.this.fDeleteAction.isEnabled() && ResourceActionGroup.this.fDeleteAction.canOperateOn()) {
                        ResourceActionGroup.this.fDeleteAction.run();
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            };
            this.fTreeViewer.getControl().addKeyListener(this.fKeyListener);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        if (this.fTreeViewer != null && this.fKeyListener != null && !this.fTreeViewer.getControl().isDisposed()) {
            this.fTreeViewer.getControl().removeKeyListener(this.fKeyListener);
        }
    }
}

