/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cobol.core.build.ant.AntScriptGenerator;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchSite;

public class RepositoryClearAction
extends SelectionAction {
    public RepositoryClearAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"MenuClearRepository"));
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        this.clearRepositoryFiles(treeElementArray);
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        if (treeElementArray != null && treeElementArray.length > 0 && this.isVaildToClear(treeElementArray)) {
            this.setText(Messages.getString((String)"RepClear"));
            return true;
        }
        return false;
    }

    private boolean isVaildToClear(TreeElement[] treeElementArray) {
        int n = treeElementArray.length;
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (!RepositoryClearAction.isTargetRepositoryFolder(treeElementArray[n2]) && !RepositoryClearAction.isDependentFolder(treeElementArray[n2])) {
                bl = false;
                break;
            }
            bl = true;
            ++n2;
        }
        return bl;
    }

    private void performRepositoryFiles(TreeElement[] treeElementArray) {
        TreeViewer treeViewer;
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (RepositoryClearAction.isTargetRepositoryFolder(treeElementArray[n2])) {
                this.clearDepAndTarAndObjFiles(treeElementArray[n2].getParent(), IViewConstants.TARGET_REPOSITORY_FOLDER_VALUE);
            } else if (RepositoryClearAction.isDependentFolder(treeElementArray[n2])) {
                this.clearDepAndTarAndObjFiles(treeElementArray[n2].getParent(), IViewConstants.DEPENDENT_FILES_FOLDER_VALUE);
            } else if (RepositoryClearAction.isTargetObjectFolder(treeElementArray[n2])) {
                this.clearDepAndTarAndObjFiles(treeElementArray[n2].getParent(), IViewConstants.TARGET_OBJECT_FOLDER_VALUE);
            }
            ++n2;
        }
        if (this.getViewPart() != null && this.getViewPart() instanceof DependencyView && (treeViewer = ((DependencyView)this.getViewPart()).getViewer()) != null) {
            treeViewer.refresh();
        }
        ViewsUtil.updateOtherViews();
        if (treeElementArray != null && treeElementArray.length > 0) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IProject iProject = iWorkspace.getRoot().getProject(treeElementArray[0].getProject().getName());
            AntScriptGenerator antScriptGenerator = new AntScriptGenerator(iProject);
            antScriptGenerator.run();
        }
    }

    private void clearRepositoryFiles(final TreeElement[] treeElementArray) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                RepositoryClearAction.this.performRepositoryFiles(treeElementArray);
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.run(false, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            CBDTUiPlugin.logError(interruptedException);
        }
    }

    private void clearDepAndTarAndObjFiles(TreeElement treeElement, String string) {
        TreeElement treeElement2 = null;
        if (string.equals(IViewConstants.TARGET_REPOSITORY_FOLDER_VALUE)) {
            treeElement2 = treeElement.getChildFromLocation(string);
        } else if (string.equals(IViewConstants.DEPENDENT_FILES_FOLDER_VALUE)) {
            treeElement2 = treeElement.getChildFromLocation(string);
        } else if (string.equals(IViewConstants.TARGET_OBJECT_FOLDER_VALUE)) {
            treeElement2 = treeElement.getChildFromLocation(string);
        }
        if (treeElement2 != null) {
            treeElement2.deleteChildren();
        }
    }
}

