/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.COBOLTreeLabelProvider;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class RenameAction
extends SelectionAction {
    private MultiStatus errorStatus;
    private static final String CHECK_RENAME_TITLE = IDEWorkbenchMessages.RenameResourceAction_checkTitle;
    private static final String CHECK_RENAME_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_readOnlyCheck;
    private static String RESOURCE_EXISTS_TITLE = IDEWorkbenchMessages.RenameResourceAction_resourceExists;
    private static String RESOURCE_EXISTS_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_overwriteQuestion;
    private static String RENAMING_MESSAGE = RefactoringCoreMessages.AbstractRenameChange_Renaming;

    public RenameAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"RenameFile"));
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        if (treeElementArray != null && treeElementArray.length == 1) {
            Path path = new Path(treeElementArray[0].getLocation());
            IResource iResource = treeElementArray[0].getIProject().findMember(path.removeFirstSegments(1));
            if (iResource != null) {
                this.renameFile(iResource, treeElementArray[0]);
            }
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getProblemsTitle(), null, (IStatus)this.errorStatus);
        }
        this.errorStatus = null;
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        return !(treeElementArray.length != 1 || !SelectionAction.isSourceFile(treeElementArray[0]) && !SelectionAction.isOtherSubFolder(treeElementArray[0]) && !SelectionAction.isOtherFile(treeElementArray[0]) || treeElementArray[0].getAdapter(IResource.class) == null || !(treeElementArray[0].getAdapter(IResource.class) instanceof IFile) && !(treeElementArray[0].getAdapter(IResource.class) instanceof IFolder));
    }

    private void renameFile(IResource iResource, TreeElement treeElement) {
        ArrayList arrayList;
        Object object;
        if (!this.checkReadOnlyAndNull(iResource)) {
            return;
        }
        ArrayList arrayList2 = treeElement.getAllChildren();
        String string = treeElement.getLocation();
        String string2 = treeElement.getName();
        String string3 = this.queryNewResourceName(iResource);
        if (string3 == null || string3.equals("")) {
            return;
        }
        Path path = new Path(string);
        path = path.removeLastSegments(1);
        String string4 = String.valueOf(path.toString()) + '/' + string3;
        IPath iPath = path.append(string3);
        try {
            if (!iPath.isAbsolute()) {
                iPath = new Path(String.valueOf('/') + iPath.toString());
            }
            object = new COBOLTreeLabelProvider();
            boolean bl = SelectionAction.isSourceFile(treeElement) && ((COBOLTreeLabelProvider)((Object)object)).checkMainFileName(treeElement);
            this.invokeOperation(iResource, iPath, treeElement, string4, string3);
            if (bl) {
                ViewsActionUtil.setAsMainProgram(treeElement);
            }
        }
        catch (CoreException coreException) {
            treeElement.setAttribute("NAME", string2);
            treeElement.setAttribute("LOCATION", string);
            this.recordError(coreException);
        }
        if ((arrayList = ((TreeElement)(object = treeElement.getParent())).getChildren()) == null || !arrayList.contains(treeElement)) {
            if (arrayList2 != null) {
                for (TreeElement treeElement2 : arrayList2) {
                    treeElement.addChild(treeElement2, treeElement2.getLocation(), treeElement2.getName(), treeElement2.getAttribute("TYPE"));
                }
            }
            ((TreeElement)object).addChild(treeElement, treeElement.getLocation(), treeElement.getName(), treeElement.getAttribute("TYPE"));
        }
        ViewsUtil.refreshViews((TreeElement)object);
    }

    private boolean checkReadOnlyAndNull(IResource iResource) {
        if (iResource == null) {
            return false;
        }
        if (iResource.isReadOnly()) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)CHECK_RENAME_TITLE, (String)MessageFormat.format(CHECK_RENAME_MESSAGE, iResource.getName()));
        }
        return true;
    }

    protected String queryNewResourceName(final IResource iResource) {
        final IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                IPath iPath = iResource.getFullPath().removeLastSegments(1).append(string);
                IResource iResource2 = iResource.getWorkspace().getRoot().findMember(iPath);
                if (iResource2 != null && iResource2.getLocation().toFile().exists()) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameMustBeDifferent;
                }
                if (iResource.getName().equals(string)) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameMustBeDifferent;
                }
                IStatus iStatus = iWorkspace.validateName(string, iResource.getType());
                if (!iStatus.isOK()) {
                    return iStatus.getMessage();
                }
                return null;
            }
        };
        InputDialog inputDialog = new InputDialog(this.getShell(), IDEWorkbenchMessages.RenameResourceAction_inputDialogTitle, IDEWorkbenchMessages.RenameResourceAction_inputDialogMessage, iResource.getName(), iInputValidator);
        inputDialog.setBlockOnOpen(true);
        if (inputDialog.open() == 0) {
            return inputDialog.getValue();
        }
        return null;
    }

    void invokeOperation(IResource iResource, IPath iPath, TreeElement treeElement, String string, String string2) throws CoreException {
        IWorkspaceRunnable iWorkspaceRunnable = this.getWorkspaceRunnable(iResource, iPath, treeElement, string, string2);
        ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, (IProgressMonitor)new NullProgressMonitor());
    }

    private IWorkspaceRunnable getWorkspaceRunnable(final IResource iResource, final IPath iPath, final TreeElement treeElement, final String string, final String string2) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask(RENAMING_MESSAGE, 100);
                final IResource iResource2 = RenameAction.this.getResource(iResource, iPath);
                TreeElement treeElement3 = treeElement.getProject();
                boolean bl = false;
                if (iPath != null && iResource != null && iPath.toString().equalsIgnoreCase(iResource.getFullPath().toString())) {
                    bl = true;
                }
                if (iResource2 != null) {
                    if (RenameAction.this.checkOverwrite(RenameAction.this.getShell(), iResource2)) {
                        Object object;
                        TreeElement treeElement2 = treeElement3.getChildFromName("SOURCE_FOLDER").getChildFromLocation(string);
                        if (treeElement2 == null || treeElement2 == treeElement) {
                            treeElement2 = treeElement3.getChildFromName(IViewConstants.LINKING_FILES_FOLDER_NAME).getChildFromLocation(string);
                        }
                        if (treeElement2 == null || treeElement2 == treeElement) {
                            object = treeElement3.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
                            treeElement2 = RenameAction.this.getElementByLocation((TreeElement)object, string);
                        }
                        if (treeElement2 != null) {
                            treeElement2.deleteChildren();
                            treeElement2.getParent().deleteChild(treeElement2);
                        }
                        treeElement.setAttribute("NAME", string2);
                        treeElement.setAttribute("LOCATION", string);
                        if (SelectionAction.isOtherSubFolder(treeElement)) {
                            RenameAction.this.updateLocation(treeElement, string);
                        }
                        object = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                                iResource2.delete(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                            }
                        };
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)object, (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        iProgressMonitor.worked(100);
                        return;
                    }
                }
                if (bl && SelectionAction.isOtherSubFolder(treeElement) && string2 != null && string != null) {
                    ViewsActionUtil.showErrorMessage(RenameAction.this.getShell(), RenameAction.this.getProblemsTitle(), RenameAction.this.getProblemsMessage());
                    return;
                }
                iResource.move(iPath, 2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                if (iResource2 == null && string2 != null && string != null) {
                    if (!CommonBuildUtil.isSourceFileSupported((IProject)treeElement.getProject().getIProject(), (String)string2)) {
                        treeElement.deleteChildren();
                    } else if (treeElement.getChildFromName("TARGET_REPOSITORY_FOLDER") == null && (treeElement.getParent().getAttribute("TYPE").equals(IViewConstants.SOURCE_FOLDER_VALUE) || treeElement.getParent().getAttribute("TYPE").equals("SOURCE_FOLDER"))) {
                        treeElement.addChild(IViewConstants.TARGET_REPOSITORY_FOLDER_VALUE, IViewConstants.TARGET_REPOSITORY_FOLDER_VALUE, "TARGET_REPOSITORY_FOLDER", false);
                        treeElement.addChild(IViewConstants.DEPENDENT_FILES_FOLDER_VALUE, IViewConstants.DEPENDENT_FILES_FOLDER_VALUE, IViewConstants.DEPENDENT_FILES_FOLDER_NAME, false);
                    }
                    treeElement.setAttribute("NAME", string2);
                    treeElement.setAttribute("LOCATION", string);
                    if (SelectionAction.isOtherSubFolder(treeElement)) {
                        RenameAction.this.updateLocation(treeElement, string);
                    }
                }
                if (treeElement != null && (SelectionAction.isOtherFile(treeElement) || SelectionAction.isOtherSubFolder(treeElement))) {
                    treeElement.getParent().sortOtherFolders();
                }
            }
        };
    }

    private TreeElement getElementByLocation(TreeElement treeElement, String string) {
        if (treeElement.getChildren() != null) {
            ArrayList arrayList = treeElement.getChildren();
            int n = 0;
            while (n < arrayList.size()) {
                TreeElement treeElement2 = (TreeElement)arrayList.get(n);
                if (treeElement2.getLocation().equals(string)) {
                    return treeElement2;
                }
                TreeElement treeElement3 = this.getElementByLocation(treeElement2, string);
                if (treeElement3 != null) {
                    return treeElement3;
                }
                ++n;
            }
        }
        return null;
    }

    private boolean checkOverwrite(final Shell shell, final IResource iResource) {
        final boolean[] blArray = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = iResource.getFullPath().makeRelative().toString();
                blArray[0] = MessageDialog.openQuestion((Shell)shell, (String)RESOURCE_EXISTS_TITLE, (String)MessageFormat.format(RESOURCE_EXISTS_MESSAGE, string));
            }
        };
        shell.getDisplay().syncExec(runnable);
        return blArray[0];
    }

    private void recordError(CoreException coreException) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 4, this.getProblemsMessage(), (Throwable)coreException);
        }
        this.errorStatus.merge(coreException.getStatus());
    }

    String getProblemsMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_problemMessage;
    }

    String getProblemsTitle() {
        return IDEWorkbenchMessages.RenameResourceAction_problemTitle;
    }

    private IResource getResource(IResource iResource, IPath iPath) {
        IWorkspaceRoot iWorkspaceRoot = iResource.getWorkspace().getRoot();
        iPath = iPath.makeAbsolute();
        return iWorkspaceRoot.findMember(iPath);
    }

    private void updateLocation(TreeElement treeElement, String string) {
        ArrayList arrayList = treeElement.getAllChildren();
        int n = 0;
        while (arrayList != null && n < arrayList.size()) {
            TreeElement treeElement2 = (TreeElement)arrayList.get(n);
            String string2 = "";
            Path path = new Path(string);
            Path path2 = new Path(treeElement2.getLocation());
            string2 = (path2 = path2.removeFirstSegments(path.segmentCount())).toString();
            if ('/' != string2.charAt(0)) {
                string2 = String.valueOf('/') + string2;
            }
            if (string.endsWith(String.valueOf('/'))) {
                string = string.substring(0, string.length() - 1);
            }
            string2 = String.valueOf(string) + string2;
            if (SelectionAction.isOtherFile(treeElement2)) {
                treeElement2.setLocation(string2);
            } else if (SelectionAction.isOtherSubFolder(treeElement2)) {
                treeElement2.setLocation(string2);
                this.updateLocation(treeElement2, string2);
            }
            ++n;
        }
    }
}

