/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import org.eclipse.cobol.ui.build.DependencyModelManipulation;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.COBOLTreeLabelProvider;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchSite;

public class RemoveFromSourceAction
extends SelectionAction {
    public RemoveFromSourceAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"RemoveFromSource"));
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        if (treeElementArray != null && treeElementArray.length > 0) {
            ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
            int n = treeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (treeElementArray != null && SelectionAction.isSourceFile(treeElementArray[n2])) {
                    RemoveFromSourceAction.moveToOtherFolder(treeElementArray[n2]);
                    if (treeElementArray[n2].getProject() != null && !arrayList.contains(treeElementArray[n2].getProject())) {
                        arrayList.add(treeElementArray[n2].getProject());
                    }
                }
                ++n2;
            }
            n2 = arrayList.size();
            if (n > 0 && n2 > 0) {
                int n3 = 0;
                while (n3 < n2) {
                    TreeElement treeElement = (TreeElement)arrayList.get(n3);
                    ViewsUtil.refreshViews(treeElement);
                    DependencyModelManipulation.generateAntFile(treeElement);
                    ++n3;
                }
            }
        }
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        if (treeElementArray == null || treeElementArray.length <= 0) {
            return false;
        }
        int n = treeElementArray.length;
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (treeElementArray == null || !SelectionAction.isSourceFile(treeElementArray[n2])) {
                bl = false;
                break;
            }
            bl = true;
            ++n2;
        }
        return bl;
    }

    public static void moveToOtherFolder(TreeElement treeElement) {
        if (treeElement != null) {
            TreeElement treeElement2 = treeElement.getProject();
            TreeElement treeElement3 = treeElement2.getChildFromName("SOURCE_FOLDER");
            TreeElement treeElement4 = treeElement2.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
            TreeElement treeElement5 = null;
            Path path = new Path(treeElement.getLocation());
            if (path.segmentCount() > 2) {
                path = path.removeFirstSegments(1).removeLastSegments(1);
                treeElement5 = RemoveFromSourceAction.getOtherFolderNode(treeElement4, (IPath)path);
            } else {
                treeElement5 = treeElement4;
            }
            if (treeElement5 != null && treeElement3 != null) {
                treeElement5.addChild(treeElement.getLocation(), treeElement.getName(), IViewConstants.OTHER_FILES_NAME, false);
                COBOLTreeLabelProvider cOBOLTreeLabelProvider = new COBOLTreeLabelProvider();
                if (cOBOLTreeLabelProvider.checkMainFileName(treeElement)) {
                    ViewsActionUtil.resetMainProgram(treeElement);
                }
                treeElement5.sortOtherFolders();
                treeElement3.deleteChild(treeElement);
                treeElement.deleteChildren();
            }
        }
    }

    public static TreeElement getOtherFolderNode(TreeElement treeElement, IPath iPath) {
        TreeElement treeElement2 = treeElement.getChildFromName(iPath.segments()[0]);
        if (iPath.segmentCount() > 1 && treeElement2 != null) {
            return RemoveFromSourceAction.getOtherFolderNode(treeElement2, iPath.removeFirstSegments(1));
        }
        return treeElement2;
    }
}

