/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.DependencyModelManipulation;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class RelocationAction
extends SelectionAction {
    protected TreeElement[] fElement = null;

    public RelocationAction(IWorkbenchSite iWorkbenchSite, String string) {
        super(iWorkbenchSite, string);
    }

    public void update(TreeElement[] treeElementArray) {
        this.fElement = treeElementArray;
    }

    public boolean canPaste() {
        return this.fElement != null;
    }

    public void relocate(TreeElement treeElement, boolean bl) {
        String string = treeElement.getAttribute("TYPE");
        if (string.equals("SOURCE_FILE") || string.equals(IViewConstants.LINKING_FILES_NAME) || string.equals(IViewConstants.OTHER_FILES_NAME)) {
            treeElement = treeElement.getParent();
        }
        IWorkspaceRunnable iWorkspaceRunnable = this.getWorkspaceRunnable(treeElement, bl);
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
    }

    private IWorkspaceRunnable getWorkspaceRunnable(final TreeElement treeElement, final boolean bl) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                String string = treeElement.getAttribute("TYPE");
                ArrayList arrayList = RelocationAction.this.getAllChildElements(treeElement);
                int n = RelocationAction.this.fElement.length;
                String string2 = "";
                boolean bl3 = false;
                TreeElement treeElement2 = null;
                int n2 = 0;
                while (n2 < n) {
                    block14: {
                        IFile iFile;
                        block13: {
                            Object object;
                            String string3;
                            String string4;
                            Object object2;
                            IProject iProject;
                            block18: {
                                block19: {
                                    boolean bl2;
                                    block16: {
                                        String string5;
                                        block17: {
                                            block15: {
                                                if (!bl && !RelocationAction.this.canPaste(RelocationAction.this.fElement[n2], treeElement)) break block14;
                                                bl2 = false;
                                                iProject = RelocationAction.this.fElement[n2].getIProject();
                                                Path path = null;
                                                path = string.equals("SOURCE_FOLDER") || string.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_FOLDER_NAME) ? new Path(iProject.getName()) : new Path(treeElement.getLocation());
                                                string2 = path.append(RelocationAction.this.fElement[n2].getName()).toString();
                                                Object object3 = RelocationAction.this.fElement[n2].getAdapter(IResource.class);
                                                if (object3 == null || (!(object3 instanceof IFile) || ((IFile)object3).exists()) && (!(object3 instanceof IFolder) || ((IFolder)object3).exists())) break block15;
                                                RelocationAction.this.FileNotExistsMessage(RelocationAction.this.fElement[n2].getName());
                                                break block14;
                                            }
                                            bl2 = RelocationAction.this.isFileAlreadyExist(arrayList, string2);
                                            string5 = "";
                                            if (!bl2 || bl) break block16;
                                            object2 = CBDTUiPlugin.getWorkspace();
                                            string4 = object2.getRoot().findMember(String.valueOf('/') + string2);
                                            string3 = string4.getFullPath().removeLastSegments(1);
                                            object = new IFile[]{""};
                                            RelocationAction.this.getShell().getDisplay().syncExec(new Runnable((IResource)string4, (String[])object, arrayList, (IPath)string3, (IWorkspace)object2){
                                                private final /* synthetic */ IResource val$resource;
                                                private final /* synthetic */ String[] val$returnValue;
                                                private final /* synthetic */ ArrayList val$childElements;
                                                private final /* synthetic */ IPath val$prefix;
                                                private final /* synthetic */ IWorkspace val$workspace;
                                                {
                                                    this.val$resource = iResource;
                                                    this.val$returnValue = stringArray;
                                                    this.val$childElements = arrayList;
                                                    this.val$prefix = iPath;
                                                    this.val$workspace = iWorkspace;
                                                }

                                                @Override
                                                public void run() {
                                                    IInputValidator iInputValidator = new IInputValidator(){

                                                        public String isValid(String string) {
                                                            if (val$resource.getName().equals(string) || RelocationAction.this.isFileAlreadyExist(val$childElements, val$prefix.append(string).toString())) {
                                                                return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameMustBeDifferent;
                                                            }
                                                            IStatus iStatus = val$workspace.validateName(string, val$resource.getType());
                                                            if (!iStatus.isOK()) {
                                                                return iStatus.getMessage();
                                                            }
                                                            if (val$workspace.getRoot().exists(val$prefix.append(string))) {
                                                                return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameExists;
                                                            }
                                                            return null;
                                                        }
                                                    };
                                                    InputDialog inputDialog = new InputDialog(RelocationAction.this.getShell(), IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogTitle, IDEWorkbenchMessages.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object[])new String[]{this.val$resource.getName()}), this.val$resource.getName(), iInputValidator);
                                                    inputDialog.setBlockOnOpen(true);
                                                    inputDialog.open();
                                                    if (inputDialog.getReturnCode() == 1) {
                                                        return;
                                                    }
                                                    this.val$returnValue[0] = inputDialog.getValue();
                                                }
                                            });
                                            string5 = object[0];
                                            if (string5 != null && !string5.equals("")) break block17;
                                            bl2 = false;
                                            break block14;
                                        }
                                        string2 = string3.append(string5).toString();
                                        bl2 = RelocationAction.this.isFileAlreadyExist(arrayList, string2);
                                        break block18;
                                    }
                                    if (!bl2 || !bl) break block18;
                                    if (RelocationAction.this.fElement[n2].getProject() == treeElement.getProject()) break block19;
                                    bl3 = RelocationAction.this.canOverwriteMove(RelocationAction.this.fElement[n2].getName());
                                    if (bl3) break block18;
                                    break block14;
                                }
                                bl3 = true;
                            }
                            object2 = new Path(string2).lastSegment();
                            string4 = treeElement.getAttribute("TYPE");
                            string3 = RelocationAction.this.getChildNodeType(string4);
                            if (string.equals("SOURCE_FILE") && !CommonBuildUtil.isSourceFileSupported((IProject)iProject, (String)object2)) {
                                ViewsActionUtil.showCOBOLUnsupportedMessage(iProject, RelocationAction.this.fElement[n2].getName());
                                if (arrayList != null && arrayList.size() > 0) {
                                    object = new ArrayList();
                                    int n3 = 0;
                                    while (n3 < arrayList.size()) {
                                        ((ArrayList)object).add(((TreeElement)arrayList.get(n3)).getName());
                                        ++n3;
                                    }
                                }
                            }
                            treeElement2 = treeElement.addChild(string2, (String)object2, string3, true);
                            object = (IFile)RelocationAction.this.fElement[n2].getAdapter(IResource.class);
                            iFile = null;
                            Path path = new Path(string2);
                            try {
                                iFile = CBDTUiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string2));
                                if (!bl && !iFile.exists()) {
                                    iFile.create(object.getContents(true), true, (IProgressMonitor)new NullProgressMonitor());
                                    break block13;
                                }
                                if (bl3 && RelocationAction.this.fElement[n2].getProject() != treeElement.getProject()) {
                                    iFile.delete(true, false, (IProgressMonitor)new NullProgressMonitor());
                                }
                                RelocationAction.this.fElement[n2].deleteChildren();
                                RelocationAction.this.fElement[n2].getParent().deleteChild(RelocationAction.this.fElement[n2]);
                                try {
                                    treeElement2.setAttribute("LOCATION", "");
                                }
                                catch (Exception exception) {}
                                if (RelocationAction.this.fElement[n2].getProject() != treeElement.getProject()) {
                                    object.move(path.makeAbsolute(), true, (IProgressMonitor)new NullProgressMonitor());
                                }
                                IFile iFile2 = (IFile)treeElement2.getAdapter(IResource.class);
                                treeElement2.setAttribute("LOCATION", string2);
                                ViewsTreeModel.getInstance().refreshStructuresViewAndUpdateModel(iFile2);
                            }
                            catch (Exception exception) {
                                CBDTUiPlugin.logError(exception);
                            }
                        }
                        if (iFile != null) {
                            ViewsTreeModel.getInstance().refreshStructuresViewAndUpdateModel(iFile);
                        }
                    }
                    ++n2;
                }
                ViewsUtil.updateOtherViews();
                if (treeElement2 != null) {
                    DependencyModelManipulation.generateAntFile(treeElement2);
                }
            }
        };
    }

    private boolean canPaste(TreeElement treeElement, TreeElement treeElement2) {
        String string;
        String[] stringArray;
        String string2 = treeElement.getAttribute("TYPE");
        String string3 = treeElement2.getAttribute("TYPE");
        String string4 = "";
        if (string2.equals("SOURCE_FILE")) {
            stringArray = new Path(treeElement.getLocation());
            string = stringArray.getFileExtension();
            if (string3.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) && string.toLowerCase().equals("lib")) {
                string4 = Messages.getString((String)"RelocationAction.source2link");
            }
        } else if (string2.equals(IViewConstants.OTHER_FILES_NAME)) {
            stringArray = new Path(treeElement.getLocation());
            string = stringArray.getFileExtension();
            if (string3.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) && !string.toLowerCase().equals("lib")) {
                string4 = Messages.getString((String)"RelocationAction.other2link");
            }
        } else if (string2.equals(IViewConstants.LINKING_FILES_NAME) && string3.equals("SOURCE_FOLDER")) {
            string4 = Messages.getString((String)"RelocationAction.link2source");
        }
        if (!string4.equals("")) {
            stringArray = new String[]{Messages.getString((String)"Ok")};
            string = new MessageDialog(this.getShell(), Messages.getString((String)"RelocationAction.cannotpaste"), null, string4, 2, stringArray, 0);
            string.open();
            return false;
        }
        return true;
    }

    public boolean isFileAlreadyExist(ArrayList arrayList, String string) {
        if (string != null && string.startsWith(String.valueOf('/'))) {
            string = string.substring(1);
        }
        int n = 0;
        while (arrayList != null && n < arrayList.size()) {
            String string2 = ((TreeElement)arrayList.get(n)).getLocation();
            if (string.equalsIgnoreCase(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void FileNotExistsMessage(String string) {
        String[] stringArray = new String[]{Messages.getString((String)"Ok")};
        MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString((String)"FileNotExist"), null, String.valueOf(string) + " " + Messages.getString((String)"FilePasteNotPossible"), 2, stringArray, 0);
        messageDialog.open();
    }

    public String getChildNodeType(String string) {
        if (string.equals("SOURCE_FOLDER")) {
            return "SOURCE_FILE";
        }
        if (string.equals("TARGET_REPOSITORY_FOLDER")) {
            return "TARGET_FILES";
        }
        if (string.equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME)) {
            return IViewConstants.DEPENDENT_FILES_NAME;
        }
        if (string.equals(IViewConstants.LINKING_FILES_FOLDER_NAME)) {
            return IViewConstants.LINKING_FILES_NAME;
        }
        if (string.equals(IViewConstants.OTHER_FILES_FOLDER_NAME)) {
            return IViewConstants.OTHER_FILES_NAME;
        }
        if (string.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) {
            return IViewConstants.OTHER_FILES_NAME;
        }
        return null;
    }

    public String getParentNodeType(String string) {
        if (string.equals("SOURCE_FILE")) {
            return "SOURCE_FOLDER";
        }
        if (string.equals("TARGET_FILES")) {
            return "TARGET_REPOSITORY_FOLDER";
        }
        if (string.equals(IViewConstants.DEPENDENT_FILES_NAME)) {
            return IViewConstants.DEPENDENT_FILES_FOLDER_NAME;
        }
        if (string.equals(IViewConstants.LINKING_FILES_NAME)) {
            return IViewConstants.LINKING_FILES_FOLDER_NAME;
        }
        if (string.equals(IViewConstants.OTHER_FILES_NAME)) {
            return IViewConstants.OTHER_FILES_FOLDER_NAME;
        }
        return string;
    }

    public ArrayList getAllChildElements(TreeElement treeElement) {
        int n;
        ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
        ArrayList arrayList2 = new ArrayList(5);
        TreeElement treeElement2 = treeElement;
        if (treeElement2 != null && (SelectionAction.isSourceFolder(treeElement2) || SelectionAction.isOtherFolder(treeElement2)) && (arrayList2 = treeElement2.getChildren()) != null) {
            n = 0;
            while (n < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n));
                ++n;
            }
        }
        if (treeElement2 != null && (SelectionAction.isOtherFolder(treeElement2) || SelectionAction.isSourceFolder(treeElement2)) && (arrayList2 = treeElement2.getChildren()) != null) {
            n = 0;
            while (n < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n));
                ++n;
            }
        }
        if (treeElement2 != null && SelectionAction.isLinkingFolder(treeElement2) && (arrayList2 = treeElement2.getChildren()) != null) {
            n = 0;
            while (n < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n));
                ++n;
            }
        }
        if (treeElement2 != null && SelectionAction.isOtherSubFolder(treeElement2) && (arrayList2 = treeElement2.getChildren()) != null) {
            n = 0;
            while (n < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n));
                ++n;
            }
        }
        return arrayList;
    }

    public boolean canOverwriteMove(String string) {
        String[] stringArray = new String[]{Messages.getString((String)"Yes"), Messages.getString((String)"No")};
        String string2 = MessageFormat.format(Messages.getString((String)"RelocationAction.resourceExist.msg"), string);
        MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString((String)"RelocationAction.resourceExist.title"), null, string2, 3, stringArray, 0);
        return messageDialog.open() == 0;
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    public boolean isValid() {
        return false;
    }
}

