/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import org.eclipse.cobol.ui.views.actions.RefreshAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionGroup;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;

public class RefreshActionGroup
extends ViewsActionGroup {
    private RefreshAction fRefreshAction = null;
    private TreeViewer fTreeViewer = null;
    private KeyListener fKeyListener = null;

    public RefreshActionGroup(IViewPart iViewPart, String string) {
        super(iViewPart, string);
        this.fRefreshAction = new RefreshAction((IWorkbenchSite)iViewPart.getSite());
        this.registerSelectionListener(this.getSelectionProvider(), this.fRefreshAction);
        this.registerKeyListener(iViewPart);
    }

    @Override
    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.appendToGroup(iMenuManager, (IAction)this.fRefreshAction);
    }

    private void registerKeyListener(IViewPart iViewPart) {
        if (iViewPart instanceof DependencyView) {
            this.fTreeViewer = ((DependencyView)iViewPart).getViewer();
        } else if (iViewPart instanceof StructuresView) {
            this.fTreeViewer = ((StructuresView)iViewPart).getViewer();
        }
        if (this.fTreeViewer != null) {
            this.fKeyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.stateMask != 0) {
                        return;
                    }
                    if (keyEvent.keyCode == 0x100000E && RefreshActionGroup.this.fTreeViewer != null) {
                        RefreshActionGroup.this.fRefreshAction.run(RefreshActionGroup.this.getSelectedElements());
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            };
            this.fTreeViewer.getControl().addKeyListener(this.fKeyListener);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fTreeViewer != null && !this.fTreeViewer.getControl().isDisposed() && this.fKeyListener != null) {
            this.fTreeViewer.getControl().removeKeyListener(this.fKeyListener);
        }
    }
}

