/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

public class RefreshAction
extends SelectionAction {
    public RefreshAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"RefreshFromLocal"));
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        if (treeElementArray != null && treeElementArray.length > 0) {
            this.refreshFromLocal(treeElementArray);
        }
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        if (treeElementArray == null || treeElementArray.length <= 0) {
            return false;
        }
        TreeElement treeElement = this.getSelectedElement();
        return treeElement == null || !SelectionAction.isTargetObjectFile(treeElement);
    }

    private void refreshFromLocal(TreeElement[] treeElementArray) {
        IWorkbenchPart iWorkbenchPart;
        boolean bl = false;
        try {
            iWorkbenchPart = null;
            int n = 0;
            while (n < treeElementArray.length) {
                iWorkbenchPart = treeElementArray[n].getIProject();
                if (iWorkbenchPart == null || !iWorkbenchPart.isOpen()) {
                    bl = false;
                    break;
                }
                iWorkbenchPart.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                this.synchronizeResources(treeElementArray[n].getProject());
                bl = true;
                ++n;
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        iWorkbenchPart = this.getViewPart();
        if (bl) {
            if (iWorkbenchPart instanceof DependencyView) {
                this.refreshFromLocalDependencyView(treeElementArray);
            } else {
                this.refreshFromLocalStructureView(treeElementArray);
            }
        }
    }

    private void refreshFromLocalDependencyView(final TreeElement[] treeElementArray) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                int n = 0;
                while (n < treeElementArray.length) {
                    ViewsUtil.refreshViews(treeElementArray[n]);
                    ++n;
                }
            }
        };
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(false, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            CBDTUiPlugin.logError(interruptedException);
        }
    }

    private void refreshFromLocalStructureView(final TreeElement[] treeElementArray) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                int n = 0;
                while (n < treeElementArray.length) {
                    ViewsUtil.refreshViews(treeElementArray[n]);
                    ++n;
                }
            }
        };
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(false, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            CBDTUiPlugin.logError(interruptedException);
        }
    }

    private void synchronizeResources(TreeElement treeElement) {
        if (treeElement != null) {
            ArrayList arrayList = treeElement.getAllChildren();
            ViewsUtil.refreshTreeElement(arrayList);
        }
    }
}

