/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.Iterator;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;

public class PropertyAction
extends SelectionAction {
    public PropertyAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"DVProperties"));
    }

    public boolean isEnabled() {
        TreeElement treeElement = this.getSelectedElement();
        return this.isResourceExist(treeElement);
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        if (treeElementArray.length > 0) {
            this.createPropertyPage(treeElementArray[0]);
        }
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        if (treeElementArray.length == 1 && (SelectionAction.isSourceFile(treeElementArray[0]) || SelectionAction.isLinkingFile(treeElementArray[0]) || SelectionAction.isOtherFile(treeElementArray[0]) || SelectionAction.isProject(treeElementArray[0]) || SelectionAction.isTargetFile(treeElementArray[0]) || SelectionAction.isDependentFile(treeElementArray[0]) || SelectionAction.isOtherSubFolder(treeElementArray[0]))) {
            return this.isEnabled();
        }
        return false;
    }

    private boolean isFromWorkspace(TreeElement treeElement) {
        if (treeElement == null) {
            return false;
        }
        if (treeElement.getAttribute("TYPE").equals(IViewConstants.PROJECT_NAME)) {
            return true;
        }
        String string = treeElement.getAttribute("LOCATION");
        Path path = new Path(string);
        if (path.getDevice() != null && path.getDevice().length() > 0) {
            return false;
        }
        if (treeElement.getIProject().findMember(string) != null) {
            return true;
        }
        return path.segmentCount() > 0 && treeElement.getIProject().getWorkspace().getRoot().findMember(path.segments()[0]) != null;
    }

    private void createPropertyPage(TreeElement treeElement) {
        PropertyPageManager propertyPageManager = new PropertyPageManager();
        IAdaptable iAdaptable = null;
        String string = "";
        iAdaptable = this.getAdaptable(treeElement);
        if (iAdaptable != null) {
            PropertyPageContributorManager.getManager().contribute(propertyPageManager, (Object)iAdaptable);
            Iterator iterator = propertyPageManager.getElements(0).iterator();
            String string2 = this.getName(iAdaptable);
            if (!iterator.hasNext()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.PropertyDialog_messageTitle, (String)WorkbenchMessages.bind((String)WorkbenchMessages.PropertyDialog_noPropertyMessage, (Object[])new Object[]{string2}));
                return;
            }
            string = WorkbenchMessages.bind((String)WorkbenchMessages.PropertyDialog_propertyMessage, (Object[])new Object[]{string2});
            try {
                PropertyDialog propertyDialog = new PropertyDialog(this.getShell(), (PreferenceManager)propertyPageManager, (ISelection)((IStructuredSelection)this.getSelection()));
                propertyDialog.create();
                propertyDialog.getShell().setText(string);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)propertyDialog.getShell(), "org.eclipse.ui.property_dialog_context");
                propertyDialog.open();
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        } else {
            String[] stringArray = new String[]{Messages.getString((String)"Ok")};
            MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString((String)"ProjectDoesNotExist"), null, Messages.getString((String)"ProjectDoesNotExistMessage"), 2, stringArray, 0);
            messageDialog.open();
        }
    }

    private IAdaptable getAdaptable(TreeElement treeElement) {
        IFile iFile = null;
        IProject iProject = treeElement.getIProject();
        Object object = treeElement.getAdapter(IResource.class);
        IFile iFile2 = null;
        IFolder iFolder = null;
        if (object != null && object instanceof IFile) {
            iFile2 = (IFile)object;
        } else if (object != null && object instanceof IFolder) {
            iFolder = (IFolder)object;
        }
        if (iFile2 != null) {
            iFile = iFile2;
        } else if (iFolder != null) {
            iFile = iFolder;
        } else if (iProject != null) {
            iFile = iProject;
        }
        return iFile;
    }

    private boolean isResourceExist(TreeElement treeElement) {
        if (treeElement != null) {
            IProject iProject = treeElement.getIProject();
            Object object = treeElement.getAdapter(IResource.class);
            IFile iFile = null;
            IFolder iFolder = null;
            if (object != null && object instanceof IFile) {
                iFile = (IFile)object;
            } else if (object != null && object instanceof IFolder) {
                iFolder = (IFolder)object;
            }
            if (iFile != null) {
                return iFile.getLocation().toFile().exists();
            }
            if (iFolder != null) {
                return iFolder.getLocation().toFile().exists();
            }
            if (iProject != null) {
                return true;
            }
        }
        return false;
    }
}

