/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.build.DependencyModelManipulation;
import org.eclipse.cobol.ui.views.actions.CopyProjectOperation;
import org.eclipse.cobol.ui.views.actions.RelocationAction;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.RemoteFile;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class PasteAction
extends RelocationAction {
    private Clipboard fClipboard = null;

    public PasteAction(IWorkbenchSite iWorkbenchSite, Clipboard clipboard) {
        super(iWorkbenchSite, Messages.getString((String)"PasteFile"));
        this.fClipboard = clipboard;
    }

    public boolean isEnabled() {
        return this.isValid() && (this.canPaste() || !this.isClipboradEmpty());
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    protected void run(final TreeElement[] treeElementArray) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                Object object;
                TreeElement[] treeElementArray3 = treeElementArray;
                if (PasteAction.this.fClipboard.getContents((Transfer)FileTransfer.getInstance()) != null && (object = PasteAction.this.fClipboard.getContents((Transfer)FileTransfer.getInstance())) != null && object instanceof String[]) {
                    TreeElement[] treeElementArray2 = PasteAction.this.filterList((String[])object);
                    if (treeElementArray2 != null && treeElementArray2.length > 0 && treeElementArray3 != null && treeElementArray3.length == 1) {
                        PasteAction.this.pasteItem(treeElementArray3[0], iProgressMonitor);
                    } else {
                        if (treeElementArray3 != null && treeElementArray3.length == 0) {
                            treeElementArray3 = new TreeElement[1];
                        }
                        PasteAction.this.pasteItem(treeElementArray3[0], (String[])object, iProgressMonitor);
                        PasteAction.this.resetClipboard(PasteAction.this.fElement);
                    }
                }
            }
        };
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(false, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            CBDTUiPlugin.logError(interruptedException);
        }
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        if (treeElementArray != null && treeElementArray.length == 1 && (SelectionAction.isSourceFolder(treeElementArray[0]) || SelectionAction.isOtherFolder(treeElementArray[0]) || SelectionAction.isSourceFile(treeElementArray[0]) || SelectionAction.isOtherFile(treeElementArray[0]) || SelectionAction.isOtherSubFolder(treeElementArray[0]))) {
            if (SelectionAction.isOtherSubFolder(treeElementArray[0]) && this.fElement != null && this.fElement.length == 1 && this.fElement[0].equals(treeElementArray[0])) {
                return false;
            }
            return !SelectionAction.isOtherSubFolder(treeElementArray[0].getParent()) || this.fElement == null || this.fElement.length != 1 || !this.fElement[0].equals(treeElementArray[0].getParent()) && !treeElementArray[0].getAbsolutePath().toLowerCase().startsWith(this.fElement[0].getAbsolutePath().concat(File.separator).toLowerCase());
        }
        if (treeElementArray == null || treeElementArray.length <= 0 || SelectionAction.isTargetFile(treeElementArray[0]) || SelectionAction.isTargetObjectFile(treeElementArray[0]) || SelectionAction.isTargetObjectFolder(treeElementArray[0]) || SelectionAction.isTargetRepositoryFolder(treeElementArray[0]) || SelectionAction.isDependentFile(treeElementArray[0]) || SelectionAction.isDependentFolder(treeElementArray[0]) || SelectionAction.isLinkingFile(treeElementArray[0]) || SelectionAction.isLinkingFolder(treeElementArray[0]) || SelectionAction.isFactoryMethod(treeElementArray[0]) || SelectionAction.isFactoryProperty(treeElementArray[0]) || SelectionAction.isObjectMethod(treeElementArray[0]) || SelectionAction.isObjectProperty(treeElementArray[0]) || SelectionAction.isProgramIdName(treeElementArray[0]) || SelectionAction.isREPFolder(treeElementArray[0]) || SelectionAction.isRepositoryClass(treeElementArray[0]) || SelectionAction.isClassIdName(treeElementArray[0]) || SelectionAction.isFactoryIdName(treeElementArray[0]) || SelectionAction.isFactoryMethodName(treeElementArray[0]) || SelectionAction.isFactoryPropName(treeElementArray[0]) || SelectionAction.isObjectIdName(treeElementArray[0])) {
            return false;
        }
        if (this.fElement != null) {
            int n = 0;
            while (n < this.fElement.length) {
                if (SelectionAction.isProject(this.fElement[n])) {
                    return true;
                }
                ++n;
            }
            if (this.isProjectCopiedInClipboard()) {
                return true;
            }
        } else if (this.isProjectCopiedInClipboard()) {
            return true;
        }
        return false;
    }

    private void pasteItem(TreeElement treeElement, IProgressMonitor iProgressMonitor) {
        String string;
        if (treeElement != null && ((string = treeElement.getAttribute("TYPE")).equals("SOURCE_FILE") || string.equals(IViewConstants.LINKING_FILES_NAME) || string.equals(IViewConstants.OTHER_FILES_NAME))) {
            treeElement = treeElement.getParent();
        }
        string = this.getWorkspaceRunnable(treeElement);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)string, iProgressMonitor);
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
    }

    private void pasteItem(TreeElement treeElement, String[] stringArray, IProgressMonitor iProgressMonitor) {
        if (treeElement != null && stringArray != null && stringArray.length > 0) {
            Object object;
            String string = treeElement.getAttribute("TYPE");
            if (string.equals("SOURCE_FILE") || string.equals(IViewConstants.LINKING_FILES_NAME) || string.equals(IViewConstants.OTHER_FILES_NAME)) {
                treeElement = treeElement.getParent();
            } else if (!(string.equals("SOURCE_FOLDER") || string.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_FOLDER_NAME) || string.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME))) {
                object = treeElement.getProject();
                TreeElement treeElement2 = null;
                if (object != null && (treeElement2 = ((TreeElement)object).getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME)) != null) {
                    treeElement = treeElement2;
                }
            }
            object = this.getWorkspaceRunnableForClipborad(treeElement, stringArray);
            try {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)object, iProgressMonitor);
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
            }
        } else if (treeElement == null && stringArray != null && stringArray.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(10);
            int n = 0;
            while (n < stringArray.length) {
                if (this.isProject(stringArray[n]) != null) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
            IWorkspaceRunnable iWorkspaceRunnable = this.getWorkspaceRunnableForClipborad(treeElement, arrayList.toArray(new String[arrayList.size()]));
            try {
                ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, iProgressMonitor);
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
            }
        }
    }

    private IWorkspaceRunnable getWorkspaceRunnable(final TreeElement treeElement) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                Object object;
                TreeElement treeElement2 = treeElement;
                boolean bl = false;
                ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>();
                ArrayList arrayList2 = PasteAction.this.getAllChildElements(treeElement2);
                int n = PasteAction.this.fElement.length;
                String string = "";
                iProgressMonitor.beginTask("", 5 + n);
                iProgressMonitor.worked(5);
                int n2 = 0;
                while (n2 < n) {
                    block14: {
                        Object object2;
                        Object object3;
                        IProject iProject;
                        block20: {
                            boolean bl2;
                            block18: {
                                IPath iPath;
                                String string2;
                                block19: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                if (iProgressMonitor.isCanceled()) break;
                                                iProgressMonitor.worked(5 + n2);
                                                if (!SelectionAction.isProject(PasteAction.this.fElement[n2]) && !SelectionAction.isSourceFile(PasteAction.this.fElement[n2]) && !SelectionAction.isOtherFile(PasteAction.this.fElement[n2]) && !SelectionAction.isOtherSubFolder(PasteAction.this.fElement[n2])) break block14;
                                                if (!SelectionAction.isProject(PasteAction.this.fElement[n2])) break block15;
                                                treeElement2 = ViewsTreeModel.getInstance().getRoot();
                                                bl = true;
                                                break block16;
                                            }
                                            if (treeElement == null) break block14;
                                            treeElement2 = treeElement;
                                        }
                                        object = treeElement2.getAttribute("TYPE");
                                        if (!PasteAction.this.canPaste(PasteAction.this.fElement[n2], treeElement2)) break block14;
                                        bl2 = false;
                                        iProject = treeElement2.getIProject();
                                        Path path = null;
                                        path = ((String)object).equals("SOURCE_FOLDER") || ((String)object).equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || ((String)object).equals(IViewConstants.OTHER_FILES_FOLDER_NAME) ? new Path(iProject.getName()) : (SelectionAction.isProject(PasteAction.this.fElement[n2]) ? new Path("") : new Path(treeElement2.getLocation()));
                                        string = path.append(PasteAction.this.fElement[n2].getName()).toString();
                                        Object object4 = PasteAction.this.fElement[n2].getAdapter(IResource.class);
                                        if (object4 == null || (!(object4 instanceof IFile) || ((IFile)object4).exists()) && (!(object4 instanceof IFolder) || ((IFolder)object4).exists())) break block17;
                                        PasteAction.this.FileNotExistsMessage(PasteAction.this.fElement[n2].getName());
                                        break block14;
                                    }
                                    bl2 = PasteAction.this.isFileAlreadyExist(arrayList2, string);
                                    string2 = "";
                                    if (!ViewsActionUtil.isCopyingSameLocation(treeElement2, PasteAction.this.fElement[n2])) break block18;
                                    object3 = CBDTUiPlugin.getWorkspace();
                                    object2 = object3.getRoot().findMember(String.valueOf('/') + string);
                                    iPath = object2.getFullPath().removeLastSegments(1);
                                    String[] stringArray = new String[]{""};
                                    PasteAction.this.getShell().getDisplay().syncExec(new Runnable((IResource)object2, stringArray, arrayList2, iPath, (IWorkspace)object3){
                                        private final /* synthetic */ IResource val$resource;
                                        private final /* synthetic */ String[] val$returnValue;
                                        private final /* synthetic */ ArrayList val$childElements;
                                        private final /* synthetic */ IPath val$prefix;
                                        private final /* synthetic */ IWorkspace val$workspace;
                                        {
                                            this.val$resource = iResource;
                                            this.val$returnValue = stringArray;
                                            this.val$childElements = arrayList;
                                            this.val$prefix = iPath;
                                            this.val$workspace = iWorkspace;
                                        }

                                        @Override
                                        public void run() {
                                            IInputValidator iInputValidator = new IInputValidator(){

                                                public String isValid(String string) {
                                                    if (val$resource.getName().equals(string) || PasteAction.this.isFileAlreadyExist(val$childElements, val$prefix.append(string).toString())) {
                                                        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameMustBeDifferent;
                                                    }
                                                    IStatus iStatus = val$workspace.validateName(string, val$resource.getType());
                                                    if (!iStatus.isOK()) {
                                                        return iStatus.getMessage();
                                                    }
                                                    if (val$workspace.getRoot().exists(val$prefix.append(string))) {
                                                        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameExists;
                                                    }
                                                    return null;
                                                }
                                            };
                                            InputDialog inputDialog = new InputDialog(PasteAction.this.getShell(), IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogTitle, IDEWorkbenchMessages.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object[])new String[]{this.val$resource.getName()}), this.val$resource.getName(), iInputValidator);
                                            inputDialog.setBlockOnOpen(true);
                                            inputDialog.open();
                                            if (inputDialog.getReturnCode() == 1) {
                                                return;
                                            }
                                            this.val$returnValue[0] = inputDialog.getValue();
                                        }
                                    });
                                    string2 = stringArray[0];
                                    if (string2 != null && !string2.equals("")) break block19;
                                    bl2 = false;
                                    break block14;
                                }
                                string = iPath.append(string2).toString();
                                if (string != null && string.startsWith(String.valueOf('/'))) {
                                    string = string.substring(1);
                                }
                                bl2 = PasteAction.this.isFileAlreadyExist(arrayList2, string);
                                break block20;
                            }
                            if (!bl2) break block20;
                            if (PasteAction.this.fElement[n2].getName().equals("build.xml")) {
                                return;
                            }
                            if (!PasteAction.this.canOverwriteMove(PasteAction.this.fElement[n2].getName())) break block14;
                        }
                        object3 = new Path(string).lastSegment();
                        if (((String)object).equals("SOURCE_FOLDER")) {
                            ViewsActionUtil.showCOBOLUnsupportedMessage(iProject, (String)object3);
                            if (arrayList2 != null && arrayList2.size() > 0) {
                                object2 = new ArrayList();
                                int n3 = 0;
                                while (n3 < arrayList2.size()) {
                                    ((ArrayList)object2).add(((TreeElement)arrayList2.get(n3)).getName());
                                    ++n3;
                                }
                            }
                        }
                        if ((object2 = PasteAction.this.createElement(treeElement2, PasteAction.this.fElement[n2], string, (String)object3)) != null && !arrayList.contains(((TreeElement)object2).getProject())) {
                            arrayList.add(((TreeElement)object2).getProject());
                        }
                        if (object2 != null && (SelectionAction.isSourceFile((TreeElement)object2) && BuildUtil.isCobolFileExtn(((TreeElement)object2).getName()) || SelectionAction.isProject((TreeElement)object2))) {
                            ViewsActionUtil.updateMianProgram((TreeElement)object2, PasteAction.this.fElement[n2], false);
                            ViewsActionUtil.setStructuredSelection(PasteAction.this.getViewPart(), (TreeElement)object2);
                        }
                        if (iProgressMonitor.isCanceled()) break;
                    }
                    ++n2;
                }
                if (bl) {
                    ViewsUtil.updateOtherViews();
                }
                n2 = 0;
                while (n2 < arrayList.size()) {
                    object = (TreeElement)arrayList.get(n2);
                    if (!bl) {
                        ViewsUtil.refreshViews((TreeElement)object);
                    }
                    DependencyModelManipulation.generateAntFile((TreeElement)object);
                    ++n2;
                }
            }
        };
    }

    private IWorkspaceRunnable getWorkspaceRunnableForClipborad(final TreeElement treeElement, final String[] stringArray) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                Object object;
                boolean bl = false;
                TreeElement treeElement2 = treeElement;
                ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>();
                ArrayList arrayList2 = PasteAction.this.getAllChildElements(treeElement2);
                int n = stringArray.length;
                String string = "";
                iProgressMonitor.beginTask("", 5 + n);
                iProgressMonitor.worked(5);
                int n2 = 0;
                while (n2 < n) {
                    block18: {
                        Object object2;
                        Object object3;
                        Object object4;
                        Path path;
                        IProject iProject;
                        block22: {
                            boolean bl2;
                            block20: {
                                String string2;
                                block21: {
                                    boolean bl3;
                                    block19: {
                                        block17: {
                                            block16: {
                                                if (iProgressMonitor.isCanceled()) break;
                                                iProgressMonitor.worked(5 + n2);
                                                if (PasteAction.this.isProject(stringArray[n2]) == null) break block16;
                                                treeElement2 = ViewsTreeModel.getInstance().getRoot();
                                                bl = true;
                                                break block17;
                                            }
                                            if (treeElement == null) break block18;
                                            treeElement2 = treeElement;
                                        }
                                        object = treeElement2.getAttribute("TYPE");
                                        if (!PasteAction.this.canPaste(stringArray[n2], treeElement2)) break block18;
                                        bl2 = false;
                                        iProject = treeElement2.getIProject();
                                        Path path2 = null;
                                        path = new Path(stringArray[n2]);
                                        path2 = ((String)object).equals("SOURCE_FOLDER") || ((String)object).equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || ((String)object).equals(IViewConstants.OTHER_FILES_FOLDER_NAME) ? new Path(iProject.getName()) : (PasteAction.this.isProject(stringArray[n2]) != null ? new Path("") : new Path(treeElement2.getLocation()));
                                        string = path2.append(path.lastSegment()).toString();
                                        if (path.toFile().exists()) break block19;
                                        PasteAction.this.FileNotExistsMessage(path.lastSegment());
                                        break block18;
                                    }
                                    bl2 = PasteAction.this.isFileAlreadyExist(arrayList2, string);
                                    string2 = "";
                                    boolean bl4 = bl3 = ViewsActionUtil.isCopyingSameLocation(treeElement2, stringArray[n2], string) != null;
                                    if (!bl3) break block20;
                                    object4 = CBDTUiPlugin.getWorkspace();
                                    object3 = object4.getRoot().findMember(String.valueOf('/') + string);
                                    if (object3 == null) break block18;
                                    object2 = object3.getFullPath().removeLastSegments(1);
                                    String[] stringArray2 = new String[]{""};
                                    PasteAction.this.getShell().getDisplay().syncExec(new Runnable((IResource)object3, stringArray2, arrayList2, (IPath)object2, (IWorkspace)object4){
                                        private final /* synthetic */ IResource val$resource;
                                        private final /* synthetic */ String[] val$returnValue;
                                        private final /* synthetic */ ArrayList val$childElements;
                                        private final /* synthetic */ IPath val$prefix;
                                        private final /* synthetic */ IWorkspace val$workspace;
                                        {
                                            this.val$resource = iResource;
                                            this.val$returnValue = stringArray;
                                            this.val$childElements = arrayList;
                                            this.val$prefix = iPath;
                                            this.val$workspace = iWorkspace;
                                        }

                                        @Override
                                        public void run() {
                                            IInputValidator iInputValidator = new IInputValidator(){

                                                public String isValid(String string) {
                                                    if (val$resource.getName().equals(string) || PasteAction.this.isFileAlreadyExist(val$childElements, val$prefix.append(string).toString())) {
                                                        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameMustBeDifferent;
                                                    }
                                                    IStatus iStatus = val$workspace.validateName(string, val$resource.getType());
                                                    if (!iStatus.isOK()) {
                                                        return iStatus.getMessage();
                                                    }
                                                    if (val$workspace.getRoot().exists(val$prefix.append(string))) {
                                                        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameExists;
                                                    }
                                                    return null;
                                                }
                                            };
                                            InputDialog inputDialog = new InputDialog(PasteAction.this.getShell(), IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogTitle, IDEWorkbenchMessages.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object[])new String[]{this.val$resource.getName()}), this.val$resource.getName(), iInputValidator);
                                            inputDialog.setBlockOnOpen(true);
                                            inputDialog.open();
                                            if (inputDialog.getReturnCode() == 1) {
                                                return;
                                            }
                                            this.val$returnValue[0] = inputDialog.getValue();
                                        }
                                    });
                                    string2 = stringArray2[0];
                                    if (string2 != null && !string2.equals("")) break block21;
                                    bl2 = false;
                                    break block18;
                                }
                                string = object2.append(string2).toString();
                                if (string != null && string.startsWith(String.valueOf('/'))) {
                                    string = string.substring(1);
                                }
                                bl2 = PasteAction.this.isFileAlreadyExist(arrayList2, string);
                                break block22;
                            }
                            if (bl2 && !PasteAction.this.canOverwriteMove(new Path(string).lastSegment())) break block18;
                        }
                        object4 = new Path(string).lastSegment();
                        if (((String)object).equals("SOURCE_FOLDER")) {
                            if (path.toFile().isFile()) {
                                ViewsActionUtil.showCOBOLUnsupportedMessage(iProject, (String)object4);
                            }
                            if (path.toFile().isFile() && arrayList2 != null && arrayList2.size() > 0) {
                                object3 = new ArrayList();
                                int n3 = 0;
                                while (n3 < arrayList2.size()) {
                                    ((ArrayList)object3).add(((TreeElement)arrayList2.get(n3)).getName());
                                    ++n3;
                                }
                            }
                        }
                        object3 = new Path(stringArray[n2]);
                        if (treeElement2 != null && SelectionAction.isOtherSubFolder(treeElement2) && treeElement2.getAbsolutePath().toLowerCase().startsWith(object3.toOSString().toLowerCase()) && object3.toFile().exists() && object3.toFile().isDirectory()) {
                            PasteAction.this.showErrorMessage(Messages.getString((String)"Copy.Paste.Descendent.Message"));
                        } else {
                            object2 = PasteAction.this.createElement(treeElement2, stringArray[n2], string, (String)object4);
                            if (object2 != null && !arrayList.contains(((TreeElement)object2).getProject())) {
                                arrayList.add(((TreeElement)object2).getProject());
                            }
                            if (object2 != null && (SelectionAction.isSourceFile((TreeElement)object2) && BuildUtil.isCobolFileExtn(((TreeElement)object2).getName()) || SelectionAction.isProject((TreeElement)object2))) {
                                ViewsActionUtil.updateMianProgram((TreeElement)object2, stringArray[n2], false);
                                ViewsActionUtil.setStructuredSelection(PasteAction.this.getViewPart(), (TreeElement)object2);
                            }
                            if (iProgressMonitor.isCanceled()) break;
                        }
                    }
                    ++n2;
                }
                if (bl) {
                    ViewsUtil.updateOtherViews();
                }
                n2 = 0;
                while (n2 < arrayList.size()) {
                    object = (TreeElement)arrayList.get(n2);
                    if (!bl) {
                        ViewsUtil.refreshViews((TreeElement)object);
                    }
                    DependencyModelManipulation.generateAntFile((TreeElement)object);
                    ++n2;
                }
            }
        };
    }

    private TreeElement createElement(TreeElement treeElement, TreeElement treeElement2, String string, String string2) {
        Object object;
        Object object2;
        if (SelectionAction.isProject(treeElement2)) {
            CopyProjectOperation copyProjectOperation = new CopyProjectOperation(this.getShell());
            return copyProjectOperation.copyProject(treeElement2.getIProject(), treeElement2);
        }
        IResource iResource = (IResource)treeElement2.getAdapter(IResource.class);
        String string3 = "";
        String string4 = treeElement.getAttribute("TYPE");
        boolean bl = true;
        if (iResource instanceof IFile) {
            string3 = this.getChildNodeType(string4);
        } else if (iResource instanceof IFolder) {
            string3 = IViewConstants.OTHER_FILES_SUBFOLDER_NAME;
            if (string4.equals("SOURCE_FOLDER")) {
                bl = false;
            }
        }
        TreeElement treeElement3 = null;
        String string5 = "";
        String string6 = "";
        if (bl) {
            treeElement3 = treeElement.getChildFromLocation(string);
            if (treeElement3 != null) {
                string5 = treeElement3.getName();
                string6 = treeElement3.getLocation();
            }
            treeElement3 = treeElement.addChild(string, string2, string3, true);
            if (SelectionAction.isSourceFolder(treeElement)) {
                object2 = treeElement.getProject().getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME);
                if (object2 != null && ((TreeElement)object2).getChildFromLocation(string) != null) {
                    ((TreeElement)object2).deleteChild(((TreeElement)object2).getChildFromLocation(string));
                }
            } else if (SelectionAction.isOtherFolder(treeElement) && (object2 = treeElement.getProject().getChildFromType("SOURCE_FOLDER")) != null && ((TreeElement)object2).getChildFromLocation(string) != null) {
                ((TreeElement)object2).deleteChild(((TreeElement)object2).getChildFromLocation(string));
            }
            if (SelectionAction.isOtherFolder(treeElement) || SelectionAction.isOtherSubFolder(treeElement)) {
                treeElement.sortOtherFolders();
            }
        } else {
            treeElement3 = treeElement;
        }
        object2 = new StructuredSelection((Object)treeElement3);
        IFile iFile = null;
        IFolder iFolder = null;
        try {
            if (iResource instanceof IFile) {
                iFile = CBDTUiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
                if (!iFile.exists() && iFile.getLocation().toFile().exists()) {
                    object = iFile.getLocation().toFile().getCanonicalPath();
                    String string7 = new Path((String)object).lastSegment();
                    iFile = CBDTUiPlugin.getWorkspace().getRoot().getFile(new Path(string).removeLastSegments(1).append(string7));
                    if (ViewsActionUtil.checkReadOnlyAndNull((IResource)iFile)) {
                        treeElement3.setName(string5);
                        treeElement3.setLocation(string6);
                        this.showErrorMessage(Messages.getString((String)"Copy.Paste.ReadOnly.Message"));
                        return treeElement3;
                    }
                    if (iFile != null && iFile.exists() && treeElement3 != null) {
                        IPath iPath = iFile.getFullPath().removeLastSegments(1).append(string2);
                        iFile.delete(true, true, null);
                        iFile = CBDTUiPlugin.getWorkspace().getRoot().getFile(iPath);
                        iResource.copy(iFile.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                if (!iFile.exists() && !iFile.getLocation().toFile().exists()) {
                    iResource.copy(iFile.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    if (ViewsActionUtil.checkReadOnlyAndNull((IResource)iFile)) {
                        treeElement3.setName(string5);
                        treeElement3.setLocation(string6);
                        this.showErrorMessage(Messages.getString((String)"Copy.Paste.ReadOnly.Message"));
                        return treeElement3;
                    }
                    iFile.setContents(((IFile)iResource).getContents(true), true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            } else if (iResource instanceof IFolder) {
                iFolder = CBDTUiPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(string));
                if (!iFolder.exists()) {
                    iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                if (treeElement2.getChildren() != null) {
                    int n = 0;
                    while (n < treeElement2.getChildren().size()) {
                        TreeElement treeElement4 = (TreeElement)treeElement2.getChildren().get(n);
                        String string8 = iFolder.getFullPath().toString();
                        if (string8.startsWith(String.valueOf('/'))) {
                            string8 = string8.substring(1);
                        }
                        string8 = String.valueOf(string8) + '/' + treeElement4.getName();
                        if (treeElement4.isCopied() && !this.isDuplicated(treeElement4, string8)) {
                            this.createElement(treeElement3, treeElement4, string8, treeElement4.getName());
                        }
                        ++n;
                    }
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        if (string3.equals("SOURCE_FILE") && iFile != null) {
            ViewsTreeModel.getInstance().refreshStructuresViewAndUpdateModel(iFile);
        }
        if (this.getViewPart() instanceof DependencyView) {
            object = (DependencyView)this.getViewPart();
            object.getViewer().setSelection((ISelection)object2);
        } else if (this.getViewPart() instanceof StructuresView) {
            object = (StructuresView)this.getViewPart();
            ((StructuresView)((Object)object)).getViewer().setSelection((ISelection)object2);
        }
        return treeElement3;
    }

    private TreeElement createElement(TreeElement treeElement, String string, String string2, String string3) {
        Object object;
        Object object2;
        if (this.isProject(string) != null) {
            CopyProjectOperation copyProjectOperation = new CopyProjectOperation(this.getShell());
            IProject iProject = this.isProject(string);
            TreeElement treeElement2 = ViewsTreeModel.getInstance().getProjectNode(iProject.getName());
            if (treeElement2 != null) {
                return copyProjectOperation.copyProject(this.isProject(string), treeElement2);
            }
            return null;
        }
        File file = new File(string);
        String string4 = "";
        String string5 = treeElement.getAttribute("TYPE");
        boolean bl = true;
        if (file.isFile()) {
            string4 = this.getChildNodeType(string5);
        } else if (file.isDirectory()) {
            string4 = IViewConstants.OTHER_FILES_SUBFOLDER_NAME;
            if (string5.equals("SOURCE_FOLDER")) {
                bl = false;
            }
        }
        TreeElement treeElement3 = null;
        String string6 = "";
        String string7 = "";
        if (bl) {
            treeElement3 = treeElement.getChildFromLocation(string2);
            if (treeElement3 != null) {
                string6 = treeElement3.getName();
                string7 = treeElement3.getLocation();
            }
            treeElement3 = treeElement.addChild(string2, string3, string4, true);
            if (SelectionAction.isSourceFolder(treeElement)) {
                object2 = treeElement.getProject().getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME);
                if (object2 != null && ((TreeElement)object2).getChildFromLocation(string2) != null) {
                    ((TreeElement)object2).deleteChild(((TreeElement)object2).getChildFromLocation(string2));
                }
            } else if (SelectionAction.isOtherFolder(treeElement) && (object2 = treeElement.getProject().getChildFromType("SOURCE_FOLDER")) != null && ((TreeElement)object2).getChildFromLocation(string2) != null) {
                ((TreeElement)object2).deleteChild(((TreeElement)object2).getChildFromLocation(string2));
            }
            if (SelectionAction.isOtherFolder(treeElement) || SelectionAction.isOtherSubFolder(treeElement)) {
                treeElement.sortOtherFolders();
            }
        } else {
            treeElement3 = treeElement;
        }
        object2 = new StructuredSelection((Object)treeElement3);
        IFile iFile = null;
        IFolder iFolder = null;
        try {
            if (file.isFile()) {
                iFile = CBDTUiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string2));
                object = new RemoteFile(string);
                if (!iFile.exists() && iFile.getLocation().toFile().exists()) {
                    String string8 = iFile.getLocation().toFile().getCanonicalPath();
                    String string9 = new Path(string8).lastSegment();
                    iFile = CBDTUiPlugin.getWorkspace().getRoot().getFile(new Path(string2).removeLastSegments(1).append(string9));
                    if (ViewsActionUtil.checkReadOnlyAndNull((IResource)iFile)) {
                        treeElement3.setName(string6);
                        treeElement3.setLocation(string7);
                        this.showErrorMessage(Messages.getString((String)"Copy.Paste.ReadOnly.Message"));
                        return treeElement3;
                    }
                    if (iFile != null && iFile.exists() && treeElement3 != null) {
                        IPath iPath = iFile.getFullPath().removeLastSegments(1).append(string3);
                        iFile.delete(true, true, null);
                        iFile = CBDTUiPlugin.getWorkspace().getRoot().getFile(iPath);
                        iFile.create(((RemoteFile)((Object)object)).fFileToOpen.getContents(), true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                if (!iFile.exists() && !iFile.getLocation().toFile().exists()) {
                    iFile.create(((RemoteFile)((Object)object)).fFileToOpen.getContents(), true, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    if (ViewsActionUtil.checkReadOnlyAndNull((IResource)iFile)) {
                        treeElement3.setName(string6);
                        treeElement3.setLocation(string7);
                        this.showErrorMessage(Messages.getString((String)"Copy.Paste.ReadOnly.Message"));
                        return treeElement3;
                    }
                    iFile.setContents(((RemoteFile)((Object)object)).fFileToOpen.getContents(true), true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            } else if (file.isDirectory()) {
                iFolder = CBDTUiPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(string2));
                object = file.list();
                if (!iFolder.exists()) {
                    iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                if (object != null) {
                    int n = 0;
                    while (n < ((Object)object).length) {
                        Path path = new Path((String)object[n]);
                        String string10 = iFolder.getFullPath().toString();
                        if (string10.startsWith(String.valueOf('/'))) {
                            string10 = string10.substring(1);
                        }
                        string10 = String.valueOf(string10) + '/' + path.lastSegment();
                        String string11 = System.getProperty("file.separator");
                        this.createElement(treeElement3, String.valueOf(string) + string11 + (String)object[n], string10, path.lastSegment());
                        ++n;
                    }
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        if (string4.equals("SOURCE_FILE") && iFile != null) {
            ViewsTreeModel.getInstance().refreshStructuresViewAndUpdateModel(iFile);
        }
        if (this.getViewPart() instanceof DependencyView) {
            object = (DependencyView)this.getViewPart();
            ((DependencyView)((Object)object)).getViewer().setSelection((ISelection)object2);
        } else if (this.getViewPart() instanceof StructuresView) {
            object = (StructuresView)this.getViewPart();
            ((StructuresView)((Object)object)).getViewer().setSelection((ISelection)object2);
        }
        return treeElement3;
    }

    private boolean isDuplicated(TreeElement treeElement, String string) {
        if (string.startsWith(String.valueOf('/'))) {
            string = string.substring(1);
        }
        if (string.equals(treeElement.getLocation())) {
            return true;
        }
        if (treeElement.getChildren() != null) {
            int n = 0;
            while (n < treeElement.getChildren().size()) {
                TreeElement treeElement2 = (TreeElement)treeElement.getChildren().get(n);
                if (this.isDuplicated(treeElement2, string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private boolean canPaste(TreeElement treeElement, TreeElement treeElement2) {
        String string;
        String[] stringArray;
        String string2 = treeElement.getAttribute("TYPE");
        String string3 = treeElement2.getAttribute("TYPE");
        String string4 = "";
        if (string2.equals("SOURCE_FILE")) {
            stringArray = new Path(treeElement.getLocation());
            string = stringArray.getFileExtension();
            if (string3.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) && !string.toLowerCase().equals("lib")) {
                string4 = Messages.getString((String)"RelocationAction.source2link");
            }
        } else if (string2.equals(IViewConstants.OTHER_FILES_NAME)) {
            stringArray = new Path(treeElement.getLocation());
            string = stringArray.getFileExtension();
            if (string3.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) && !string.toLowerCase().equals("lib")) {
                string4 = Messages.getString((String)"RelocationAction.other2link");
            }
        } else if (string2.equals(IViewConstants.LINKING_FILES_NAME)) {
            if (string3.equals(IViewConstants.OTHER_FILES_FOLDER_NAME)) {
                string4 = Messages.getString((String)"RelocationAction.link2other");
            } else if (string3.equals("SOURCE_FOLDER")) {
                string4 = Messages.getString((String)"RelocationAction.link2source");
            }
        } else if (string2.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME) && string3.equals("SOURCE_FOLDER")) {
            string4 = Messages.getString((String)"Copy.Paste.InvalidFolderSelection.Message");
        }
        if (!string4.equals("")) {
            stringArray = new String[]{Messages.getString((String)"Ok")};
            string = new MessageDialog(this.getShell(), Messages.getString((String)"RelocationAction.cannotpaste"), null, string4, 2, stringArray, 0);
            string.open();
            return false;
        }
        return true;
    }

    private boolean canPaste(String string, TreeElement treeElement) {
        String string2 = treeElement.getAttribute("TYPE");
        String string3 = "";
        Path path = new Path(string);
        String string4 = "";
        if (path.segmentCount() > 0 && path.lastSegment().indexOf(46) >= 0) {
            string4 = path.getFileExtension();
        }
        if (path.toFile().isFile() && string2.equals(IViewConstants.LINKING_FILES_FOLDER_NAME) && !string4.toLowerCase().equals("lib")) {
            string3 = Messages.getString((String)"RelocationAction.source2link");
        } else if ((string2.equals("SOURCE_FOLDER") || string2.equals(IViewConstants.LINKING_FILES_FOLDER_NAME)) && path.toFile().isDirectory()) {
            string3 = Messages.getString((String)"Copy.Paste.InvalidFolderSelection.Message");
        }
        if (!string3.equals("")) {
            String[] stringArray = new String[]{Messages.getString((String)"Ok")};
            MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString((String)"RelocationAction.cannotpaste"), null, string3, 2, stringArray, 0);
            messageDialog.open();
            return false;
        }
        return true;
    }

    @Override
    public ArrayList getAllChildElements(TreeElement treeElement) {
        int n;
        TreeElement treeElement2;
        ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
        ArrayList arrayList2 = new ArrayList(5);
        TreeElement treeElement3 = treeElement;
        if (treeElement3 != null && (SelectionAction.isSourceFolder(treeElement3) || SelectionAction.isOtherFolder(treeElement3) || SelectionAction.isOtherSubFolder(treeElement3)) && (treeElement2 = treeElement3.getProject().getChildFromType("SOURCE_FOLDER")) != null && (arrayList2 = treeElement2.getChildren()) != null) {
            n = 0;
            while (n < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n));
                ++n;
            }
        }
        if (treeElement3 != null && (SelectionAction.isOtherFolder(treeElement3) || SelectionAction.isSourceFolder(treeElement3)) && (treeElement2 = treeElement3.getProject().getChildFromType(IViewConstants.OTHER_FILES_FOLDER_NAME)) != null && (arrayList2 = treeElement2.getChildren()) != null) {
            n = 0;
            while (n < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n));
                ++n;
            }
        }
        if (treeElement3 != null && SelectionAction.isLinkingFolder(treeElement3) && (arrayList2 = treeElement3.getChildren()) != null) {
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n2));
                ++n2;
            }
        }
        if (treeElement3 != null && SelectionAction.isOtherSubFolder(treeElement3) && (arrayList2 = treeElement3.getChildren()) != null) {
            int n3 = 0;
            while (n3 < arrayList2.size()) {
                arrayList.add((TreeElement)arrayList2.get(n3));
                ++n3;
            }
        }
        return arrayList;
    }

    private boolean isClipboradEmpty() {
        Object object = this.fClipboard.getContents((Transfer)FileTransfer.getInstance());
        return object == null || object != null && object instanceof String[] && ((String[])object).length == 0;
    }

    private TreeElement[] filterList(String[] stringArray) {
        ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>(10);
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            TreeElement treeElement = this.isExistsInCopiedElements(stringArray[n]);
            if (treeElement != null) {
                arrayList.add(treeElement);
            }
            ++n;
        }
        if (arrayList.size() == stringArray.length) {
            return arrayList.toArray(new TreeElement[arrayList.size()]);
        }
        return null;
    }

    private TreeElement isExistsInCopiedElements(String string) {
        int n = 0;
        while (string != null && this.fElement != null && n < this.fElement.length) {
            String string2;
            Object object = this.fElement[n].getAdapter(IResource.class);
            if (object != null && (object instanceof IFile ? (string2 = ((IFile)object).getLocation().toOSString()).toLowerCase().equals(string.toLowerCase()) : (object instanceof IFolder ? (string2 = ((IFolder)object).getLocation().toOSString()).toLowerCase().equals(string.toLowerCase()) : object instanceof IProject && (string2 = ((IProject)object).getLocation().toOSString()).toLowerCase().equals(string.toLowerCase())))) {
                return this.fElement[n];
            }
            ++n;
        }
        return null;
    }

    public void resetClipboard(TreeElement[] treeElementArray) {
        if (treeElementArray != null) {
            ViewsActionUtil.setCopyFlag(treeElementArray, false);
        }
        this.update(null);
    }

    private IProject isProject(String string) {
        IResource iResource;
        String string2;
        Path path;
        if (string != null && (path = new Path(string)).segmentCount() > 0 && (string2 = path.lastSegment()) != null && string2.length() > 0 && (iResource = CBDTUiPlugin.getWorkspace().getRoot().findMember(string2)) != null && iResource instanceof IProject && iResource.getLocation().toOSString().toLowerCase().equals(string.toLowerCase())) {
            return (IProject)iResource;
        }
        return null;
    }

    private boolean isProjectCopiedInClipboard() {
        Object object;
        if (this.fClipboard.getContents((Transfer)FileTransfer.getInstance()) != null && (object = this.fClipboard.getContents((Transfer)FileTransfer.getInstance())) != null && object instanceof String[]) {
            String[] stringArray = (String[])object;
            int n = 0;
            while (n < stringArray.length) {
                if (this.isProject(stringArray[n]) != null) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private void showErrorMessage(String string) {
        if (!string.equals("")) {
            String[] stringArray = new String[]{Messages.getString((String)"Ok")};
            MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString((String)"RelocationAction.cannotpaste"), null, string, 1, stringArray, 0);
            messageDialog.open();
        }
    }
}

