/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchSite;

public class NewCOBOLContributorSourceAction
extends SelectionAction {
    private String contributorClass = null;
    private String contributorName = null;
    private IConfigurationElement fConfigurationElement = null;

    public NewCOBOLContributorSourceAction(IWorkbenchSite iWorkbenchSite, String string, String string2, IConfigurationElement iConfigurationElement) {
        super(iWorkbenchSite, string);
        Assert.isNotNull((Object)string2);
        Assert.isNotNull((Object)iConfigurationElement);
        this.contributorClass = string2;
        this.contributorName = string;
        this.fConfigurationElement = iConfigurationElement;
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        this.createNewFile();
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private void createNewFile() {
        Object object = null;
        Wizard wizard = null;
        TreeViewer treeViewer = null;
        ISelection iSelection = this.getSelection();
        try {
            if (this.getViewPart() instanceof DependencyView) {
                treeViewer = ((DependencyView)this.getViewPart()).getViewer();
            } else if (this.getViewPart() instanceof StructuresView) {
                treeViewer = ((StructuresView)this.getViewPart()).getViewer();
            }
            this.getSelectedResource(this.getSelection());
            this.resetSelection(this.getSelection(), treeViewer);
            object = this.fConfigurationElement.createExecutableExtension("class");
            if (object == null) {
                return;
            }
            wizard = (Wizard)object;
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        if (treeViewer != null) {
            treeViewer.setSelection(iSelection, true);
        }
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), wizard);
        wizardDialog.setMinimumPageSize(500, 350);
        wizardDialog.create();
        wizardDialog.open();
    }

    public void resetSelection(ISelection iSelection, TreeViewer treeViewer) {
        StructuredSelection structuredSelection = this.convertSelection(iSelection);
        if (!structuredSelection.isEmpty()) {
            treeViewer.setSelection((ISelection)structuredSelection, true);
        }
    }

    private StructuredSelection convertSelection(ISelection iSelection) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                IResource iResource = null;
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                } else if (e instanceof IAdaptable) {
                    iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class);
                }
                if (iResource == null) continue;
                arrayList.add(iResource);
            }
        }
        return new StructuredSelection(arrayList);
    }

    private IResource getSelectedResource(ISelection iSelection) {
        IResource iResource = null;
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                    continue;
                }
                if (!(e instanceof IAdaptable)) continue;
                iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class);
            }
        }
        return iResource;
    }

    public String toString() {
        return this.contributorName;
    }
}

