/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class NewAction
extends SelectionAction {
    public NewAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"Newfile"));
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        this.createNewFile();
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        return treeElementArray != null && treeElementArray.length == 1 && (SelectionAction.isOtherFolder(treeElementArray[0]) || SelectionAction.isOtherSubFolder(treeElementArray[0]) || SelectionAction.isOtherFile(treeElementArray[0]));
    }

    private void createNewFile() {
        WizardDialog wizardDialog;
        Object var1_1 = null;
        Wizard wizard = null;
        TreeViewer treeViewer = null;
        ISelection iSelection = this.getSelection();
        try {
            if (this.getViewPart() instanceof DependencyView) {
                treeViewer = ((DependencyView)this.getViewPart()).getViewer();
            } else if (this.getViewPart() instanceof StructuresView) {
                treeViewer = ((StructuresView)this.getViewPart()).getViewer();
            }
            wizardDialog = this.getSelectedResource(this.getSelection());
            this.resetSelection(this.getSelection(), treeViewer);
            IPluginDescriptor iPluginDescriptor = WorkbenchPlugin.getDefault().getDescriptor();
            iPluginDescriptor.getExtensions();
            wizard = var1_1;
            if (wizard instanceof BasicNewFileResourceWizard) {
                BasicNewFileResourceWizard.selectAndReveal((IResource)wizardDialog, (IWorkbenchWindow)CBDTUiPlugin.getActiveWorkbenchWindow());
                ((BasicNewFileResourceWizard)wizard).init(CBDTUiPlugin.getActiveWorkbenchWindow().getWorkbench(), (IStructuredSelection)iSelection);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        wizardDialog = new WizardDialog(this.getShell(), wizard);
        wizardDialog.setMinimumPageSize(500, 350);
        wizardDialog.create();
        wizardDialog.open();
        if (treeViewer != null) {
            treeViewer.setSelection(iSelection, true);
        }
    }

    private ConfigurationElement getStdConfigurationElement(IExtension[] iExtensionArray) {
        String string = "id";
        String string2 = "org.eclipse.ui.wizards.new.file";
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n2] != null && iConfigurationElementArray[n2].getAttribute(string) != null && iConfigurationElementArray[n2].getAttribute(string).equals(string2)) {
                    return (ConfigurationElement)iConfigurationElementArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public void resetSelection(ISelection iSelection, TreeViewer treeViewer) {
        StructuredSelection structuredSelection = this.convertSelection(iSelection);
        if (!structuredSelection.isEmpty()) {
            treeViewer.setSelection((ISelection)structuredSelection, true);
        }
    }

    private StructuredSelection convertSelection(ISelection iSelection) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                IResource iResource = null;
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                } else if (e instanceof IAdaptable) {
                    iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class);
                }
                if (iResource == null) continue;
                arrayList.add(iResource);
            }
        }
        return new StructuredSelection(arrayList);
    }

    private IResource getSelectedResource(ISelection iSelection) {
        IResource iResource = null;
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                    continue;
                }
                if (!(e instanceof IAdaptable)) continue;
                iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class);
            }
        }
        return iResource;
    }
}

