/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.build.DependencyModelManipulation;
import org.eclipse.cobol.ui.views.actions.GoToActionGroup;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class MoveUpAction
extends SelectionAction {
    private GoToActionGroup fGoToActionGroup = null;

    public MoveUpAction(IWorkbenchSite iWorkbenchSite, GoToActionGroup goToActionGroup) {
        super(iWorkbenchSite, Messages.getString((String)"MoveUpToolTip"));
        this.fGoToActionGroup = goToActionGroup;
        this.setToolTipText(Messages.getString((String)"MoveUpToolTip"));
        this.setImageDescriptor(COBOLPluginImages.DESC_IMG_MOVE_FILE_UP);
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
        this.fGoToActionGroup.updateToolBarStatus();
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        if (treeElementArray != null && treeElementArray.length == 1) {
            this.moveUp(treeElementArray[0]);
        }
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private void moveUp(TreeElement treeElement) {
        try {
            TreeElement treeElement2 = treeElement.getParent();
            treeElement2.moveTreeElement(treeElement, true);
            this.fGoToActionGroup.updateToolBarStatus();
            ViewsUtil.refreshViews(treeElement2);
            if (this.getViewPart() instanceof DependencyView) {
                DependencyView dependencyView = (DependencyView)this.getViewPart();
                dependencyView.getViewer().setSelection((ISelection)new StructuredSelection((Object)treeElement));
            }
            if (treeElement != null) {
                DependencyModelManipulation.generateAntFile(treeElement);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }
}

