/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.DependencyModelManipulation;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

public class MainProgramAction
extends SelectionAction {
    private QualifiedName fKeyMainFile = new QualifiedName("org.eclipse.cobol.ui.views.dependency", "MAIN_FILE");

    public MainProgramAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"SetAsMainProgram"));
    }

    public String getText() {
        TreeElement treeElement = this.getSelectedElement();
        if (treeElement != null && this.checkMainFileName(treeElement)) {
            return Messages.getString((String)"ResetMainProgram");
        }
        return Messages.getString((String)"SetAsMainProgram");
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
        this.setEnabled(this.canOperateOn(this.getSelectedElement()));
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        if (treeElementArray.length > 1) {
            return;
        }
        if (treeElementArray.length > 0 && !this.checkMainFileName(treeElementArray[0])) {
            this.setAsMainProgram(treeElementArray[0]);
        } else {
            this.resetMainProgram(treeElementArray[0]);
        }
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        this.setText(this.getText());
        TreeElement treeElement = this.getSelectedElement();
        return treeElement != null && SelectionAction.isSourceFile(treeElement) && treeElement.getAdapter(IResource.class) != null && treeElement.getAdapter(IResource.class) instanceof IFile && ViewsUtil.isValidCOBOLSource(((IFile)treeElement.getAdapter(IResource.class)).getFileExtension());
    }

    private boolean canOperateOn(TreeElement treeElement) {
        IProject iProject;
        block8: {
            block7: {
                if (treeElement != null) break block7;
                return false;
            }
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            iProject = iWorkspace.getRoot().getProject(treeElement.getProject().getName());
            if (iProject != null && (iProject == null || iProject.isOpen())) break block8;
            return false;
        }
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.cobol.ui.common", "ITargetType");
            String string = null;
            string = iProject.getPersistentProperty(qualifiedName);
            if (string == null || string.equals("")) {
                string = "false";
            }
            if (iProject != null && iProject.getLocation() != null && string.equalsIgnoreCase("true")) {
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return true;
    }

    public boolean checkMainFileName(TreeElement treeElement) {
        String string = "";
        String string2 = "";
        IWorkspace iWorkspace = null;
        IProject iProject = null;
        if (treeElement == null) {
            return false;
        }
        try {
            iWorkspace = ResourcesPlugin.getWorkspace();
            iProject = iWorkspace.getRoot().getProject(treeElement.getProject().getName());
            string = treeElement.getLocation();
            if (iProject != null && iProject.getLocation() != null && iProject.isOpen()) {
                string2 = iProject.getPersistentProperty(this.fKeyMainFile);
            }
        }
        catch (CoreException coreException) {
            string2 = "";
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            string2 = "";
            CBDTUiPlugin.logError(exception);
        }
        try {
            return string2 != null && !string2.equals("") && string2.equals(string);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return false;
    }

    public void setAsMainProgram(TreeElement treeElement) {
        String string = "";
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(treeElement.getProject().getName());
        string = treeElement.getLocation();
        TreeElement treeElement2 = null;
        try {
            String string2 = iProject.getPersistentProperty(this.fKeyMainFile);
            if (string2 != null && !string2.equals("")) {
                TreeElement treeElement3 = treeElement.getProject().getChildFromType("SOURCE_FOLDER");
                if (treeElement3 != null) {
                    treeElement2 = treeElement3.getChildFromLocation(string2);
                }
            } else {
                treeElement2 = null;
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        if (treeElement2 != null) {
            ViewsActionUtil.cleanOutputFiles(treeElement2);
        }
        try {
            if (iProject != null && iProject.getLocation() != null) {
                this.setTouch(treeElement2, treeElement);
                iProject.setPersistentProperty(this.fKeyMainFile, string);
                ViewsActionUtil.cleanOutputFiles(treeElement);
                ViewsUtil.refreshViews(treeElement.getParent());
                if (treeElement != null) {
                    DependencyModelManipulation.generateAntFile(treeElement);
                }
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void resetMainProgram(TreeElement treeElement) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(treeElement.getProject().getName());
        try {
            if (iProject != null && iProject.getLocation() != null) {
                iProject.setPersistentProperty(this.fKeyMainFile, "");
                ViewsActionUtil.cleanOutputFiles(treeElement);
                this.setTouch(null, treeElement);
                ViewsUtil.refreshViews(treeElement.getParent());
                if (treeElement != null) {
                    DependencyModelManipulation.generateAntFile(treeElement);
                }
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private void setTouch(final TreeElement treeElement, final TreeElement treeElement2) {
        IRunnableWithProgress iRunnableWithProgress = null;
        try {
            final IRunnableWithProgress iRunnableWithProgress2 = iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    try {
                        IFile iFile;
                        iProgressMonitor.setTaskName("Updating the time stamp of file");
                        if (treeElement != null && (iFile = (IFile)treeElement.getAdapter(IResource.class)) != null) {
                            iFile.touch(iProgressMonitor);
                        }
                        if (treeElement2 != null && (iFile = (IFile)treeElement2.getAdapter(IResource.class)) != null && iFile.exists()) {
                            iFile.touch(iProgressMonitor);
                        }
                    }
                    catch (CoreException coreException) {
                        CBDTUiPlugin.logError((Exception)((Object)coreException));
                    }
                }
            };
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow iWorkbenchWindow = CBDTUiPlugin.getActiveWorkbenchWindow();
                    if (iWorkbenchWindow != null) {
                        Shell shell = iWorkbenchWindow.getShell();
                        try {
                            new ProgressMonitorDialog(shell).run(false, false, iRunnableWithProgress2);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            CBDTUiPlugin.logError(invocationTargetException);
                        }
                        catch (InterruptedException interruptedException) {
                            CBDTUiPlugin.logError(interruptedException);
                        }
                    }
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }
}

