/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.actions.IActionValidate;
import org.eclipse.cobol.ui.views.actions.MoveDownAction;
import org.eclipse.cobol.ui.views.actions.MoveUpAction;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionGroup;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.UpAction;
import org.eclipse.ui.views.navigator.CollapseAllAction;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ToggleLinkingAction;

public class GoToActionGroup
extends ViewsActionGroup {
    private BackAction fBackAction = null;
    private ForwardAction fForwardAction = null;
    private UpAction fUpAction = null;
    private COBOLGoIntoAction fGoIntoAction = null;
    private MoveDownAction fMoveDownAction = null;
    private MoveUpAction fMoveUpAction = null;
    protected CollapseAllAction collapseAllAction;
    protected ToggleLinkingAction toggleLinkingAction;

    public GoToActionGroup(IViewPart iViewPart, String string) {
        super(iViewPart, string);
        try {
            FrameList frameList = this.getFrameList();
            if (frameList != null) {
                this.fBackAction = new BackAction(frameList);
                this.fForwardAction = new ForwardAction(frameList);
                this.fUpAction = new UpAction(frameList);
                this.fGoIntoAction = new COBOLGoIntoAction(frameList);
                if (iViewPart instanceof StructuresView || iViewPart instanceof DependencyView) {
                    IResourceNavigator iResourceNavigator = (IResourceNavigator)iViewPart;
                    this.collapseAllAction = new CollapseAllAction(iResourceNavigator, ResourceNavigatorMessages.CollapseAllAction_title);
                    this.collapseAllAction.setToolTipText(ResourceNavigatorMessages.CollapseAllAction_toolTip);
                    this.collapseAllAction.setImageDescriptor(this.getPlatformImageDescriptor("elcl16/collapseall.gif"));
                    this.toggleLinkingAction = new ToggleLinkingAction(iResourceNavigator, ResourceNavigatorMessages.ToggleLinkingAction_text);
                    this.toggleLinkingAction.setToolTipText(ResourceNavigatorMessages.ToggleLinkingAction_toolTip);
                    this.toggleLinkingAction.setImageDescriptor(this.getPlatformImageDescriptor("elcl16/synced.gif"));
                }
            }
            if (this.fViewPart instanceof DependencyView) {
                this.fMoveDownAction = new MoveDownAction((IWorkbenchSite)iViewPart.getSite(), this);
                this.fMoveUpAction = new MoveUpAction((IWorkbenchSite)iViewPart.getSite(), this);
                this.registerSelectionListener(this.getSelectionProvider(), this.fMoveDownAction);
                this.registerSelectionListener(this.getSelectionProvider(), this.fMoveUpAction);
            }
            this.createToolbar();
            this.hookGlobalActions();
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    protected ImageDescriptor getPlatformImageDescriptor(String string) {
        String string2 = "icons/full/";
        try {
            AbstractUIPlugin abstractUIPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL uRL = abstractUIPlugin.getDescriptor().getInstallURL();
            URL uRL2 = new URL(uRL, String.valueOf(string2) + string);
            return ImageDescriptor.createFromURL((URL)uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.setGlobalActionHandler("goInto", (IAction)this.fGoIntoAction);
        iActionBars.setGlobalActionHandler("back", (IAction)this.fBackAction);
        iActionBars.setGlobalActionHandler("forward", (IAction)this.fForwardAction);
        iActionBars.setGlobalActionHandler("up", (IAction)this.fUpAction);
    }

    @Override
    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        if (this.fGoIntoAction != null) {
            this.fGoIntoAction.update();
            this.appendToGroup(iMenuManager, (IAction)this.fGoIntoAction);
            if (this.isVisible()) {
                MenuManager menuManager = new MenuManager(Messages.getString((String)"DVNavigatorGoto"));
                this.appendToGroup(iMenuManager, (IContributionItem)menuManager);
                menuManager.add((IAction)this.fBackAction);
                menuManager.add((IAction)this.fForwardAction);
                menuManager.add((IAction)this.fUpAction);
            }
        }
    }

    private void hookGlobalActions() {
        IActionBars iActionBars = this.fViewPart.getViewSite().getActionBars();
        iActionBars.setGlobalActionHandler("goInto", (IAction)this.fGoIntoAction);
        iActionBars.setGlobalActionHandler("back", (IAction)this.fBackAction);
        iActionBars.setGlobalActionHandler("forward", (IAction)this.fForwardAction);
        iActionBars.setGlobalActionHandler("up", (IAction)this.fUpAction);
    }

    private void createToolbar() {
        IActionBars iActionBars = this.fViewPart.getViewSite().getActionBars();
        iActionBars.setGlobalActionHandler("goInto", (IAction)this.fGoIntoAction);
        iActionBars.setGlobalActionHandler("back", (IAction)this.fBackAction);
        iActionBars.setGlobalActionHandler("forward", (IAction)this.fForwardAction);
        iActionBars.setGlobalActionHandler("up", (IAction)this.fUpAction);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        if (iToolBarManager != null) {
            iToolBarManager.removeAll();
            iToolBarManager.add((IAction)this.fBackAction);
            iToolBarManager.add((IAction)this.fForwardAction);
            iToolBarManager.add((IAction)this.fUpAction);
            if (this.collapseAllAction != null) {
                iToolBarManager.add((IContributionItem)new Separator());
                iToolBarManager.add((IAction)this.collapseAllAction);
                iToolBarManager.add((IAction)this.toggleLinkingAction);
            }
            if (this.fViewPart instanceof DependencyView) {
                iToolBarManager.add((IContributionItem)new Separator());
                iToolBarManager.add((IAction)this.fMoveDownAction);
                iToolBarManager.add((IAction)this.fMoveUpAction);
                this.updateToolBarStatus();
            }
        }
    }

    private FrameList getFrameList() {
        DependencyView dependencyView;
        if (this.fViewPart instanceof StructuresView) {
            StructuresView structuresView = (StructuresView)this.fViewPart;
            if (structuresView != null) {
                return structuresView.getFrameList();
            }
        } else if (this.fViewPart instanceof DependencyView && (dependencyView = (DependencyView)this.fViewPart) != null) {
            return dependencyView.getFrameList();
        }
        return null;
    }

    private boolean isVisible() {
        TreeElement treeElement = this.getSelectedElement();
        return treeElement != null && (SelectionAction.isProject(treeElement) || SelectionAction.isSourceFolder(treeElement) || this.fViewPart instanceof DependencyView && SelectionAction.isSourceFile(treeElement));
    }

    private void updateActionStatus() {
        if (this.getSelectedElement() != null && SelectionAction.isProject(this.getSelectedElement())) {
            this.fBackAction.setEnabled(false);
            this.fForwardAction.setEnabled(false);
            this.fUpAction.setEnabled(false);
            this.fGoIntoAction.setEnabled(true);
        }
    }

    public void updateToolBarStatus() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        if (treeElementArray != null && treeElementArray.length == 1 && SelectionAction.isSourceFile(treeElementArray[0])) {
            TreeElement treeElement = treeElementArray[0].getParent();
            int n = treeElement.sizeOfChildren();
            try {
                if (n > 1) {
                    this.fMoveDownAction.setEnabled(true);
                    this.fMoveUpAction.setEnabled(true);
                    ArrayList arrayList = treeElement.getChildren();
                    int n2 = arrayList.size();
                    if (arrayList.get(0) == treeElementArray[0]) {
                        this.fMoveUpAction.setEnabled(false);
                    }
                    if (arrayList.get(n2 - 1) == treeElementArray[0]) {
                        this.fMoveDownAction.setEnabled(false);
                    }
                    return;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                CBDTUiPlugin.logError(arrayIndexOutOfBoundsException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
        this.fMoveDownAction.setEnabled(false);
        this.fMoveUpAction.setEnabled(false);
    }

    class COBOLGoIntoAction
    extends GoIntoAction
    implements IActionValidate {
        public COBOLGoIntoAction(FrameList frameList) {
            super(frameList);
        }

        @Override
        public boolean isValid() {
            return GoToActionGroup.this.isVisible();
        }

        public String getText() {
            return Messages.getString((String)"DVNavigatorGoInTo");
        }
    }
}

