/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.RemoteFile;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;

public class FileOpenAction
extends SelectionAction {
    public FileOpenAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"OpenFile"));
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        if (treeElementArray != null && treeElementArray.length > 0) {
            this.openFile(treeElementArray);
        }
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        if (treeElementArray == null || treeElementArray.length <= 0) {
            return false;
        }
        int n = treeElementArray.length;
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (treeElementArray[n2].getAdapter(IResource.class) == null || !(treeElementArray[n2].getAdapter(IResource.class) instanceof IFile)) {
                bl = false;
                break;
            }
            bl = true;
            ++n2;
        }
        return bl;
    }

    private void openFile(TreeElement[] treeElementArray) {
        if (treeElementArray != null) {
            int n = treeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (FileOpenAction.isSourceFile(treeElementArray[n2]) || FileOpenAction.isDependentFile(treeElementArray[n2]) || FileOpenAction.isLinkingFile(treeElementArray[n2]) || FileOpenAction.isOtherFile(treeElementArray[n2]) || FileOpenAction.isTargetFile(treeElementArray[n2]) || FileOpenAction.isRepositoryClass(treeElementArray[n2])) {
                    try {
                        Object object;
                        Path path;
                        String[] stringArray;
                        IWorkbenchPage iWorkbenchPage = this.fSite.getPage();
                        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                        IProject iProject = iWorkspace.getRoot().getProject(treeElementArray[n2].getProject().getName());
                        if (iProject == null || iProject.getLocation() == null) {
                            stringArray = new String[]{Messages.getString((String)"Ok")};
                            path = new MessageDialog(this.getShell(), Messages.getString((String)"ProjectDoesNotExist"), null, Messages.getString((String)"ProjectDoesNotExistMessage"), 2, stringArray, 0);
                            path.open();
                            return;
                        }
                        stringArray = treeElementArray[n2].getAdapter(IResource.class);
                        path = new Path(treeElementArray[n2].getLocation());
                        if (stringArray != null && stringArray instanceof IFile) {
                            ViewsUtil.openFileInEditor(iWorkbenchPage, (IFile)stringArray);
                        } else if (path != null && path.getDevice() != null && path.getDevice().length() > 0) {
                            object = new RemoteFile(treeElementArray[n2].getLocation());
                            ViewsUtil.openFileInEditor(iWorkbenchPage, object.fFileToOpen);
                        } else if (path.segmentCount() > 1 && (object = iProject.findMember(path.removeFirstSegments(1).toString())) != null && object instanceof IFile) {
                            ViewsUtil.openFileInEditor(iWorkbenchPage, (IFile)object);
                        }
                    }
                    catch (Exception exception) {
                        CBDTUiPlugin.logError(exception);
                    }
                }
                ++n2;
            }
        }
    }
}

