/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class FileCompileAction
extends SelectionAction {
    public FileCompileAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"CompileFile"));
    }

    public boolean isEnabled() {
        return this.isValidCompileFile();
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        if (treeElementArray != null && treeElementArray.length > 0) {
            int n = treeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.compileFile(treeElementArray[n2]);
                ++n2;
            }
        }
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    private void compileFile(TreeElement treeElement) {
        Object object;
        Object object2 = treeElement.getAdapter(IResource.class);
        IFile iFile = null;
        if (object2 != null && object2 instanceof IFile && !((File)(object = new File((iFile = (IFile)object2).getLocation().toOSString()))).exists()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString((String)"BuildController.fileDoesNotExistLabel"), (String)Messages.getString((String)"BuildController.fileDoesNotExistMsg"));
            try {
                treeElement.getIProject().refreshLocal(0, null);
            }
            catch (CoreException coreException) {}
            ViewsUtil.updateOtherViews();
            return;
        }
        object = iFile.getProject();
        if (CommonBuildUtil.isSourceFileSupported((IProject)object, (String)treeElement.getName())) {
            ViewsUtil.compileSourceFile(this.getShell(), iFile);
        } else {
            ViewsUtil.displayUnsupportedSourceMessage(treeElement.getName());
        }
    }

    @Override
    public boolean isValid() {
        return this.isValidCompileFile();
    }

    private boolean isValidCompileFile() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        String string = null;
        boolean bl = false;
        if (treeElementArray != null && treeElementArray.length > 0) {
            int n = treeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = treeElementArray[n2].getName().toLowerCase();
                IProject iProject = treeElementArray[n2].getProject().getIProject();
                if (CommonBuildUtil.isSourceFileSupported((IProject)iProject, (String)string2)) {
                    string = treeElementArray[n2].getParent().getAttribute("TYPE");
                    if (!string.equals("SOURCE_FOLDER")) {
                        bl = false;
                        break;
                    }
                } else {
                    bl = false;
                    break;
                }
                bl = true;
                ++n2;
            }
        }
        return bl;
    }
}

