/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class DeleteProjectDialog
extends MessageDialog {
    private String projName;
    private boolean deleteContent = false;
    private Button radio1;
    private Button radio2;
    private int length;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            if (button.getSelection()) {
                DeleteProjectDialog.this.deleteContent = button == DeleteProjectDialog.this.radio1;
            }
        }
    };

    DeleteProjectDialog(Shell shell, String string, int n) {
        super(shell, DeleteProjectDialog.getTitle(n), null, DeleteProjectDialog.getMessage(string, n), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        this.projName = string;
        this.length = n;
    }

    static String getTitle(int n) {
        if (n == 1) {
            return IDEWorkbenchMessages.DeleteResourceAction_titleProject1;
        }
        return IDEWorkbenchMessages.DeleteResourceAction_titleProjectN;
    }

    static String getMessage(String string, int n) {
        if (string.indexOf(File.separator) > -1) {
            string = string.substring(string.lastIndexOf(File.separator) + 1);
        }
        if (n == 1) {
            return IDEWorkbenchMessages.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmProject1, (Object[])new Object[]{string});
        }
        return IDEWorkbenchMessages.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmProjectN, (Object[])new Object[]{new Integer(n)});
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.delete_project_dialog_context");
    }

    protected Control createCustomArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.radio1 = new Button(composite2, 16);
        this.radio1.addSelectionListener(this.selectionListener);
        String string = "";
        string = this.length == 1 ? IDEWorkbenchMessages.bind((String)IDEWorkbenchMessages.DeleteResourceAction_deleteContents1, (Object[])new Object[]{this.projName}) : IDEWorkbenchMessages.DeleteResourceAction_deleteContentsN;
        this.radio1.setText(string);
        this.radio2 = new Button(composite2, 16);
        this.radio2.addSelectionListener(this.selectionListener);
        String string2 = IDEWorkbenchMessages.DeleteResourceAction_doNotDeleteContents;
        this.radio2.setText(string2);
        this.radio1.setSelection(this.deleteContent);
        this.radio2.setSelection(!this.deleteContent);
        return composite2;
    }

    public boolean getDeleteContent() {
        return this.deleteContent;
    }
}

