/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.build.DependencyModelManipulation;
import org.eclipse.cobol.ui.views.actions.DeleteProjectDialog;
import org.eclipse.cobol.ui.views.actions.MainProgramAction;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.COBOLTreeLabelProvider;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class DeleteAction
extends SelectionAction {
    private boolean deleteContent = false;

    public DeleteAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"Delete"));
    }

    public boolean isEnabled() {
        return this.canOperateOn();
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
        this.setEnabled(this.canOperateOn());
    }

    @Override
    protected void run(final TreeElement[] treeElementArray) {
        if (!this.confirmDelete(treeElementArray)) {
            return;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                if (treeElementArray != null && treeElementArray.length > 0) {
                    iProgressMonitor.beginTask("", 10);
                    iProgressMonitor.worked(6);
                    DeleteAction.this.deleteItem(treeElementArray);
                    iProgressMonitor.worked(4);
                    iProgressMonitor.done();
                }
            }
        };
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(false, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            CBDTUiPlugin.logError(interruptedException);
        }
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        return this.canOperateOn();
    }

    public boolean canOperateOn() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        return treeElementArray != null && treeElementArray.length > 0 && this.isVaildToDelete(treeElementArray);
    }

    private boolean isVaildToDelete(TreeElement[] treeElementArray) {
        return this.isSelectedOnlyPrjNodes(treeElementArray) || this.isSourceOrOtherFiles(treeElementArray) || this.isDepentOrLinkFiles(treeElementArray) || this.isTargetRepFiles(treeElementArray) || this.isTargetObjFolder(treeElementArray);
    }

    private boolean confirmDeleteProjects(String string, int n) {
        DeleteProjectDialog deleteProjectDialog = new DeleteProjectDialog(this.getShell(), string, n);
        int n2 = deleteProjectDialog.open();
        this.deleteContent = deleteProjectDialog.getDeleteContent();
        return n2 == 0;
    }

    private IWorkspaceRunnable getWorkspaceRunnable(final TreeElement treeElement) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                IProject iProject = treeElement.getIProject();
                try {
                    if (iProject.exists()) {
                        iProject.delete(DeleteAction.this.deleteContent, true, iProgressMonitor);
                    }
                }
                catch (CoreException coreException) {
                    CBDTUiPlugin.logError((Exception)((Object)coreException));
                }
            }
        };
    }

    private int DeleteProject(TreeElement treeElement, int n) {
        if (!this.confirmDeleteProjects(treeElement.getAbsolutePath(), n)) {
            return 1;
        }
        IWorkspaceRunnable iWorkspaceRunnable = this.getWorkspaceRunnable(treeElement);
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        return 0;
    }

    private boolean isSelectedOnlyPrjNodes(TreeElement[] treeElementArray) {
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!DeleteAction.isProject(treeElementArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isSourceOrOtherFiles(TreeElement[] treeElementArray) {
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!(DeleteAction.isSourceFile(treeElementArray[n2]) || DeleteAction.isOtherFile(treeElementArray[n2]) || DeleteAction.isOtherSubFolder(treeElementArray[n2]))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isDepentOrLinkFiles(TreeElement[] treeElementArray) {
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!DeleteAction.isDependentFile(treeElementArray[n2]) && !DeleteAction.isLinkingFile(treeElementArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isTargetObjFolder(TreeElement[] treeElementArray) {
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!DeleteAction.isTargetObjectFolder(treeElementArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isTargetRepFiles(TreeElement[] treeElementArray) {
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!DeleteAction.isTargetFile(treeElementArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String getMessage(TreeElement[] treeElementArray) {
        String string = "";
        int n = treeElementArray.length;
        if (this.isTargetObjFolder(treeElementArray)) {
            string = n == 1 ? MessageFormat.format(Messages.getString((String)"DeleteMessageString"), "'" + Messages.getString((String)"TargetObjectSpecification") + "'") : MessageFormat.format(Messages.getString((String)"DeleteMultipleMessageString"), new Integer(n));
        } else if (this.isSourceOrOtherFiles(treeElementArray)) {
            string = n == 1 ? MessageFormat.format(Messages.getString((String)"DeleteMessageString"), "'" + treeElementArray[0].getName() + "'") : MessageFormat.format(Messages.getString((String)"DeleteMultipleMessageString"), new Integer(treeElementArray.length));
        } else if (this.isDepentOrLinkFiles(treeElementArray) || this.isTargetRepFiles(treeElementArray)) {
            string = n == 1 ? MessageFormat.format(Messages.getString((String)"LinkTypeDeleteMessageString"), "'" + treeElementArray[0].getName() + "'") : MessageFormat.format(Messages.getString((String)"LinkTypeDeleteMultipleMessageString"), new Integer(treeElementArray.length));
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void deleteItem(TreeElement[] var1_1) {
        block24: {
            var2_2 = this.rearrangeItems(var1_1);
            var3_3 = new HashMap<String, TreeElement>(10);
            var4_4 = var2_2.length;
            var5_5 = new MainProgramAction((IWorkbenchSite)this.getViewPart().getSite());
            var6_6 = false;
            var7_7 = false;
            var8_8 = 0;
            while (var8_8 < var4_4) {
                var9_10 = var2_2[var8_8];
                if (var9_10 == null) {
                    return;
                }
                var10_11 = var9_10;
                var11_12 = var9_10.getAttribute("TYPE");
                var6_6 = this.isSelectedOnlyPrjNodes(var2_2);
                if (var4_4 > 1 && var11_12.equals(IViewConstants.PROJECT_NAME) && !var6_6) {
                    this.DeleteProject((TreeElement)var10_11, 1);
                } else {
                    if (var4_4 > 1 && var11_12.equals(IViewConstants.PROJECT_NAME) && var6_6) {
                        var12_13 = this.getWorkspaceRunnable((TreeElement)var10_11);
                        try {
                            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)var12_13, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException var13_16) {
                            CBDTUiPlugin.logError((Exception)var13_16);
                        }
                    }
                    if (var11_12.equals("SOURCE_FILE") && var5_5.checkMainFileName(null)) {
                        var5_5.resetMainProgram(null);
                    }
                    var12_13 = var9_10.getParent();
                    var9_10.deleteChildren();
                    var12_13.deleteChild((TreeElement)var9_10);
                    if (var11_12.equals("TARGET_OBJECT_FOLDER") && (var13_15 /* !! */  = DeleteAction.getFile(var12_13)) != null && BuildUtil.getNameOptionFromResourcePersistance((IResource)var13_15 /* !! */ )) {
                        BuildUtil.setNameOptionInFilePersistance((IResource)var13_15 /* !! */ , false);
                        ViewsActionUtil.cleanOutputFiles(var12_13);
                    }
                    if (var11_12.equals("SOURCE_FILE") || var11_12.equals(IViewConstants.OTHER_FILES_NAME) || var11_12.equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) {
                        ViewsUtil.deleteFile(var9_10.getProject().getName(), var9_10.getLocation(), (String)var11_12);
                        var13_15 /* !! */  = var9_10.getLocation();
                        var14_17 = new Path((String)var13_15 /* !! */ );
                        if (var14_17.getDevice() == null && var14_17.segmentCount() > 0 && var9_10.getIProject().getName().equals(var14_17.segment(0))) {
                            var15_18 = new File(var9_10.getAbsolutePath());
                            if (var15_18 != null && var15_18.exists() && var15_18.isFile()) {
                                var15_18.delete();
                            } else if (var15_18 != null && var15_18.exists() && var15_18.isDirectory()) {
                                this.deleteFolder((File)var15_18);
                            }
                        }
                        var15_18 = new COBOLTreeLabelProvider();
                        if (var11_12.equals("SOURCE_FILE") && var15_18.checkMainFileName((TreeElement)var9_10)) {
                            ViewsActionUtil.resetMainProgram((TreeElement)var9_10);
                        }
                    }
                    if (var10_11 != null && !var10_11.getAttribute("TYPE").equals(IViewConstants.PROJECT_NAME)) {
                        if (!var3_3.containsKey(var10_11.getProject().getName())) {
                            var3_3.put(var10_11.getProject().getName(), var10_11.getParent());
                        }
                    } else {
                        var7_7 = true;
                    }
                }
                ++var8_8;
            }
            if (var7_7) {
                ViewsUtil.updateOtherViews();
            }
            if (var4_4 <= 0) break block24;
            var8_9 = var3_3.values();
            if (var8_9 == null) {
                return;
            }
            var9_10 = var3_3.keySet().iterator();
            if (var9_10 != null) ** GOTO lbl76
            return;
lbl-1000:
            // 1 sources

            {
                var10_11 = (String)var9_10.next();
                var11_12 = (TreeElement)var3_3.get(var10_11);
                try {
                    var11_12.getIProject().refreshLocal(0, null);
                }
                catch (CoreException var12_14) {
                    CBDTUiPlugin.log(var12_14.getStatus());
                }
                if (!var7_7) {
                    ViewsUtil.refreshViews((TreeElement)var11_12);
                }
                DependencyModelManipulation.generateAntFile(var11_12.getProject());
lbl76:
                // 2 sources

                ** while (var9_10.hasNext())
            }
        }
    }

    public int promptForConfirm(String string, String string2) {
        String[] stringArray = new String[]{Messages.getString((String)"Yes"), Messages.getString((String)"No")};
        MessageDialog messageDialog = new MessageDialog(this.getShell(), string, null, string2, 3, stringArray, 0);
        int n = messageDialog.open();
        return n;
    }

    private TreeElement[] rearrangeItems(TreeElement[] treeElementArray) {
        TreeElement[] treeElementArray2 = null;
        if (treeElementArray != null && treeElementArray.length > 0) {
            int n = 0;
            treeElementArray2 = new TreeElement[treeElementArray.length];
            int n2 = 0;
            while (n2 < treeElementArray.length) {
                if (treeElementArray[n2].getAttribute("TYPE").equals(IViewConstants.DEPENDENT_FILES_NAME) || treeElementArray[n2].getAttribute("TYPE").equals("TARGET_FILES") || treeElementArray[n2].getAttribute("TYPE").equals("TARGET_OBJECT_FILES")) {
                    treeElementArray2[n++] = treeElementArray[n2];
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < treeElementArray.length) {
                if (treeElementArray[n2].getAttribute("TYPE").equals(IViewConstants.DEPENDENT_FILES_FOLDER_NAME) || treeElementArray[n2].getAttribute("TYPE").equals("TARGET_REPOSITORY_FOLDER") || treeElementArray[n2].getAttribute("TYPE").equals("TARGET_OBJECT_FOLDER")) {
                    treeElementArray2[n++] = treeElementArray[n2];
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < treeElementArray.length) {
                if (treeElementArray[n2].getAttribute("TYPE").equals("SOURCE_FILE") || treeElementArray[n2].getAttribute("TYPE").equals(IViewConstants.LINKING_FILES_NAME) || treeElementArray[n2].getAttribute("TYPE").equals(IViewConstants.OTHER_FILES_NAME)) {
                    treeElementArray2[n++] = treeElementArray[n2];
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < treeElementArray.length) {
                if (treeElementArray[n2].getAttribute("TYPE").equals(IViewConstants.PROJECT_NAME)) {
                    treeElementArray2[n++] = treeElementArray[n2];
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < treeElementArray.length) {
                if (treeElementArray[n2].getAttribute("TYPE").equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME)) {
                    treeElementArray2[n++] = treeElementArray[n2];
                }
                ++n2;
            }
        }
        return treeElementArray2;
    }

    private void deleteFolder(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (fileArray != null && n < fileArray.length) {
                if (fileArray[n].isFile()) {
                    fileArray[n].delete();
                } else {
                    this.deleteFolder(fileArray[n]);
                }
                ++n;
            }
            file.delete();
        }
    }

    boolean confirmDelete(TreeElement[] treeElementArray) {
        int n = -1;
        boolean bl = false;
        TreeElement[] treeElementArray2 = this.rearrangeItems(treeElementArray);
        boolean bl2 = false;
        int n2 = treeElementArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            bl2 = this.isSelectedOnlyPrjNodes(treeElementArray2);
            String string = treeElementArray2[n3].getAttribute("TYPE");
            if (n2 > 1 && !bl && bl2) {
                n = this.DeleteProject(treeElementArray2[n3], n2);
                bl = true;
            } else if (n2 == 1 && string.equals(IViewConstants.PROJECT_NAME)) {
                n = this.DeleteProject(treeElementArray2[n3], n2);
            } else if (n2 > 1 && string.equals(IViewConstants.PROJECT_NAME) && bl2 && n != 1) {
                IWorkspaceRunnable iWorkspaceRunnable = this.getWorkspaceRunnable(treeElementArray2[n3]);
                try {
                    ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    CBDTUiPlugin.logError((Exception)((Object)coreException));
                }
            }
            ++n3;
        }
        if (!bl2) {
            String string;
            String string2;
            if (n2 == 1) {
                string2 = Messages.getString((String)"ConfirmFileDelete");
                string = this.getMessage(treeElementArray);
            } else {
                string2 = Messages.getString((String)"ConfirmFileDelete");
                string = this.getMessage(treeElementArray);
            }
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)string2, (String)string);
        }
        return false;
    }
}

