/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.COBOLTreeLabelProvider;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ProjectLocationSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class CopyProjectOperation {
    private MultiStatus errorStatus;
    private Shell parentShell;

    public CopyProjectOperation(Shell shell) {
        this.parentShell = shell;
    }

    public TreeElement copyProject(IProject iProject, TreeElement treeElement) {
        this.errorStatus = null;
        ProjectLocationSelectionDialog projectLocationSelectionDialog = new ProjectLocationSelectionDialog(this.parentShell, iProject);
        projectLocationSelectionDialog.setTitle(IDEWorkbenchMessages.CopyProjectOperation_copyProject);
        if (projectLocationSelectionDialog.open() != 0) {
            return null;
        }
        Object[] objectArray = projectLocationSelectionDialog.getResult();
        if (objectArray == null) {
            return null;
        }
        String string = (String)objectArray[0];
        Path path = new Path((String)objectArray[1]);
        boolean bl = this.performProjectCopy(iProject, string, (IPath)path);
        if (!bl) {
            return null;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.parentShell, (String)IDEWorkbenchMessages.CopyProjectOperation_copyFailedTitle, null, (IStatus)this.errorStatus);
            this.errorStatus = null;
            return null;
        }
        return this.createProjectElement(treeElement, string);
    }

    private boolean performProjectCopy(final IProject iProject, final String string, final IPath iPath) {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(IDEWorkbenchMessages.CopyProjectOperation_progressTitle, 100);
                try {
                    try {
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        IProjectDescription iProjectDescription = CopyProjectOperation.this.createProjectDescription(iProject, string, iPath);
                        iProgressMonitor.worked(50);
                        iProject.copy(iProjectDescription, true, iProgressMonitor);
                        iProgressMonitor.worked(50);
                    }
                    catch (CoreException coreException) {
                        CopyProjectOperation.this.recordError(coreException);
                        iProgressMonitor.done();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.parentShell).run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            final String string2 = invocationTargetException.getTargetException().getMessage();
            this.parentShell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)CopyProjectOperation.this.parentShell, (String)IDEWorkbenchMessages.CopyProjectOperation_copyFailedTitle, (String)IDEWorkbenchMessages.bind((String)IDEWorkbenchMessages.CopyProjectOperation_internalError, (Object[])new Object[]{string2}));
                }
            });
            return false;
        }
        return true;
    }

    private IProjectDescription createProjectDescription(IProject iProject, String string, IPath iPath) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        iProjectDescription.setName(string);
        if (iPath.equals((Object)Platform.getLocation())) {
            iProjectDescription.setLocation(null);
        } else {
            iProjectDescription.setLocation(iPath);
        }
        return iProjectDescription;
    }

    private void recordError(CoreException coreException) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus("org.eclipse.ui", 4, IDEWorkbenchMessages.CopyProjectOperation_copyFailedMessage, (Throwable)coreException);
        }
        this.errorStatus.merge(coreException.getStatus());
    }

    private String setLocation(String string) {
        IPath iPath = Platform.getLocation().append(string);
        return iPath.toOSString();
    }

    private TreeElement createProjectElement(TreeElement treeElement, String string) {
        Path path;
        String string2;
        String string3;
        TreeElement treeElement2;
        TreeElement treeElement3 = ViewsTreeModel.getInstance().getRoot().addChild(Platform.getLocation().append(string).toOSString(), string, IViewConstants.PROJECT_NAME, false);
        TreeElement treeElement4 = treeElement3.addChild(IViewConstants.SOURCE_FOLDER_VALUE, "SOURCE_FOLDER", "SOURCE_FOLDER", false);
        TreeElement treeElement5 = treeElement3.addChild(IViewConstants.LINKING_FILES_FOLDER_VALUE, IViewConstants.LINKING_FILES_FOLDER_NAME, IViewConstants.LINKING_FILES_FOLDER_NAME, false);
        treeElement3.addChild(IViewConstants.OTHER_FILES_FOLDER_VALUE, IViewConstants.OTHER_FILES_FOLDER_NAME, IViewConstants.OTHER_FILES_FOLDER_NAME, false);
        ArrayList arrayList = treeElement.getChildFromType("SOURCE_FOLDER").getAllChildrenOfType("SOURCE_FILE");
        int n = 0;
        while (arrayList != null && n < arrayList.size()) {
            TreeElement treeElement6;
            treeElement2 = (TreeElement)arrayList.get(n);
            string3 = treeElement2.getName();
            string2 = treeElement2.getLocation();
            path = new Path(string2);
            if (path.segmentCount() > 1) {
                path = path.removeFirstSegments(1);
            }
            if (BuildUtil.isCobolFileExtn((treeElement6 = treeElement4.addChild(string2 = String.valueOf(string) + '/' + path.toString(), string3, "SOURCE_FILE", false)).getName())) {
                treeElement6.addChild(IViewConstants.TARGET_REPOSITORY_FOLDER_VALUE, IViewConstants.TARGET_REPOSITORY_FOLDER_VALUE, "TARGET_REPOSITORY_FOLDER", false);
                treeElement6.addChild(IViewConstants.DEPENDENT_FILES_FOLDER_VALUE, IViewConstants.DEPENDENT_FILES_FOLDER_VALUE, IViewConstants.DEPENDENT_FILES_FOLDER_NAME, false);
                IFile iFile = (IFile)treeElement6.getAdapter(IResource.class);
                if (iFile != null) {
                    ViewsTreeModel.getInstance().refreshStructuresViewAndUpdateModel(iFile);
                }
            }
            this.setMainProgramOption(treeElement2, treeElement6);
            ++n;
        }
        arrayList = treeElement.getChildFromType(IViewConstants.LINKING_FILES_FOLDER_NAME).getAllChildrenOfType(IViewConstants.LINKING_FILES_NAME);
        n = 0;
        while (arrayList != null && n < arrayList.size()) {
            treeElement2 = (TreeElement)arrayList.get(n);
            string3 = treeElement2.getName();
            string2 = treeElement2.getLocation();
            path = new Path(string2);
            if (path.segmentCount() > 1) {
                path = path.removeFirstSegments(1);
            }
            string2 = String.valueOf(string) + '/' + path.toString();
            treeElement5.addChild(string2, string3, IViewConstants.LINKING_FILES_NAME, false);
            ++n;
        }
        return treeElement3;
    }

    private void setMainProgramOption(TreeElement treeElement, TreeElement treeElement2) {
        COBOLTreeLabelProvider cOBOLTreeLabelProvider = new COBOLTreeLabelProvider();
        if (cOBOLTreeLabelProvider.checkMainFileName(treeElement)) {
            ViewsActionUtil.setAsMainProgram(treeElement2, false);
        }
    }
}

