/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import org.eclipse.cobol.ui.views.actions.PasteAction;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IWorkbenchSite;

public class CopyAction
extends SelectionAction {
    private Clipboard fClipboard = null;
    private PasteAction fPasteAction = null;
    private TreeElement[] copiedElements = null;

    public CopyAction(IWorkbenchSite iWorkbenchSite, Clipboard clipboard, PasteAction pasteAction) {
        super(iWorkbenchSite, Messages.getString((String)"CopyFile"));
        this.fClipboard = clipboard;
        this.fPasteAction = pasteAction;
    }

    public boolean isEnabled() {
        return this.isValid();
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
        this.setEnabled(this.isValid());
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        this.copyItems(treeElementArray);
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement[] treeElementArray = this.getSelectedElements();
        if (treeElementArray == null || treeElementArray.length <= 0) {
            return false;
        }
        boolean bl = false;
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!(SelectionAction.isSourceFile(treeElementArray[n2]) || SelectionAction.isOtherFile(treeElementArray[n2]) || SelectionAction.isOtherSubFolder(treeElementArray[n2]) || SelectionAction.isProject(treeElementArray[n2]))) {
                bl = false;
                break;
            }
            bl = true;
            ++n2;
        }
        if (bl) {
            TreeElement treeElement = treeElementArray[0].getParent();
            int n3 = 1;
            while (n3 < n) {
                if (!treeElement.equals(treeElementArray[n3].getParent())) {
                    bl = false;
                    break;
                }
                bl = true;
                ++n3;
            }
        }
        return bl;
    }

    private void copyItems(TreeElement[] treeElementArray) {
        if (this.copiedElements != null) {
            this.setCopyFlag(this.copiedElements, false);
        }
        if (treeElementArray == null || treeElementArray != null && treeElementArray.length == 0) {
            return;
        }
        this.copiedElements = treeElementArray;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        ArrayList<TreeElement> arrayList2 = new ArrayList<TreeElement>(10);
        int n = 0;
        while (n < this.copiedElements.length) {
            if ((SelectionAction.isProject(this.copiedElements[n]) || SelectionAction.isSourceFile(this.copiedElements[n]) || SelectionAction.isOtherFile(this.copiedElements[n]) || SelectionAction.isOtherSubFolder(this.copiedElements[n])) && this.copiedElements[n].getAdapter(IResource.class) != null) {
                Object object = this.copiedElements[n].getAdapter(IResource.class);
                if (object instanceof IFile) {
                    arrayList.add(((IFile)object).getLocation().toOSString());
                    arrayList2.add(this.copiedElements[n]);
                } else if (object instanceof IFolder) {
                    arrayList.add(((IFolder)object).getLocation().toOSString());
                    arrayList2.add(this.copiedElements[n]);
                } else if (object instanceof IProject) {
                    arrayList.add(((IProject)object).getLocation().toOSString());
                    arrayList2.add(this.copiedElements[n]);
                }
            }
            ++n;
        }
        this.fClipboard.setContents(new Object[]{arrayList.toArray(new String[arrayList.size()])}, new Transfer[]{FileTransfer.getInstance()});
        this.copiedElements = arrayList2.toArray(new TreeElement[arrayList2.size()]);
        this.setCopyFlag(this.copiedElements, true);
        this.fPasteAction.update(this.copiedElements);
    }

    private void setCopyFlag(TreeElement[] treeElementArray, boolean bl) {
        ViewsActionUtil.setCopyFlag(treeElementArray, bl);
    }
}

