/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cobol.core.build.ant.AntScriptGenerator;
import org.eclipse.cobol.core.util.ValidationManager;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.DependencyModelManipulation;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.actions.ViewsActionUtil;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.dependency.AddFilesDialog;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

public class AddSourceFileAction
extends SelectionAction {
    public AddSourceFileAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite, Messages.getString((String)"AddSourceFile"));
    }

    @Override
    protected void selectionChanged(ISelection iSelection) {
    }

    @Override
    protected void run(TreeElement[] treeElementArray) {
        if (treeElementArray != null && treeElementArray.length == 1 && (SelectionAction.isTargetRepositoryFolder(treeElementArray[0]) || SelectionAction.isTargetFile(treeElementArray[0]))) {
            this.addTargetRepFile();
        } else if (treeElementArray != null && treeElementArray.length == 1 && (SelectionAction.isLinkingFolder(treeElementArray[0]) || SelectionAction.isLinkingFile(treeElementArray[0]))) {
            this.addLinkingFile();
        } else if (treeElementArray != null && treeElementArray.length == 1 && (SelectionAction.isDependentFolder(treeElementArray[0]) || SelectionAction.isDependentFile(treeElementArray[0]))) {
            this.addCopyLibraryFile(treeElementArray[0]);
        } else if (treeElementArray != null && treeElementArray.length == 1 && (SelectionAction.isSourceFolder(treeElementArray[0]) || SelectionAction.isSourceFile(treeElementArray[0]))) {
            this.addSourceFile(treeElementArray[0]);
        }
    }

    @Override
    protected void run(ISelection iSelection) {
    }

    @Override
    protected void run(ITextSelection iTextSelection) {
    }

    @Override
    public boolean isValid() {
        TreeElement treeElement = this.getSelectedElement();
        return treeElement != null && (SelectionAction.isSourceFolder(treeElement) || SelectionAction.isLinkingFolder(treeElement) || SelectionAction.isSourceFile(treeElement) || SelectionAction.isDependentFolder(treeElement) || SelectionAction.isDependentFile(treeElement) || SelectionAction.isLinkingFile(treeElement) || SelectionAction.isTargetRepositoryFolder(treeElement) || SelectionAction.isTargetFile(treeElement));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TreeElement addSourceFile(TreeElement treeElement) {
        Object object;
        Object object2;
        TreeElement treeElement2;
        block27: {
            int n;
            StructuredSelection structuredSelection = null;
            treeElement2 = null;
            String string = "";
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string2 = treeElement.getProject().getLocation();
            ViewsUtil.refreshFromLocal(treeElement.getParent(), this.getShell());
            String[] stringArray = null;
            TreeElement treeElement3 = treeElement.getProject();
            arrayList = treeElement3.getChildren();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList arrayList3 = ViewsUtil.getFilesForFolder(treeElement3, "SOURCE_FOLDER");
            if (arrayList3 != null) {
                n = 0;
                while (n < arrayList3.size()) {
                    arrayList2.add(((TreeElement)arrayList3.get(n)).getName().trim());
                    n += 1;
                }
            }
            try {
                TreeViewer treeViewer;
                block26: {
                    n = 1;
                    try {
                        object2 = null;
                        object = null;
                        if (treeElement.getAttribute("TYPE").equals("SOURCE_FILE")) {
                            treeElement = treeElement.getParent();
                        }
                        if ((object = treeElement.getChildren()) != null) {
                            int n2 = ((ArrayList)object).size();
                            arrayList = new ArrayList<Object>(n2);
                            int n3 = 0;
                            while (n3 < n2) {
                                object2 = ((TreeElement)((ArrayList)object).get(n3)).getName();
                                arrayList.add(object2);
                                ++n3;
                            }
                        }
                        AddFilesDialog addFilesDialog = new AddFilesDialog(this.getShell(), n != 0, string2, Messages.getString((String)"AddFileDialog.title.name"), arrayList);
                        addFilesDialog.open();
                        stringArray = addFilesDialog.getSelectedFiles();
                    }
                    catch (Exception exception) {
                        CBDTUiPlugin.logError(exception);
                    }
                    if (stringArray == null) {
                        return null;
                    }
                    object2 = new File(treeElement.getIProject().getWorkspace().getRoot().getLocation().toOSString());
                    object = "";
                    if (object2 != null) {
                        object = ((File)object2).getCanonicalPath();
                    }
                    int n4 = 0;
                    while (true) {
                        if (n4 >= stringArray.length) {
                            stringArray = null;
                            ViewsUtil.updateOtherViews();
                            if (treeElement2 != null) {
                                structuredSelection = new StructuredSelection(treeElement2);
                            }
                            treeViewer = null;
                            if (!(this.fSite instanceof DependencyView)) break;
                            treeViewer = ((DependencyView)this.fSite).getViewer();
                            break block26;
                        }
                        void var15_22 = stringArray[n4];
                        int n5 = var15_22.lastIndexOf(File.separatorChar);
                        String string3 = var15_22.substring(0, n5);
                        string = var15_22.substring(n5 + 1);
                        if (string == null || string.equals("")) {
                            return null;
                        }
                        ViewsActionUtil.showCOBOLUnsupportedMessage(treeElement.getProject().getIProject(), string);
                        File file = new File((String)var15_22);
                        String string4 = "";
                        if (file != null) {
                            string4 = file.getCanonicalPath();
                        }
                        String string5 = string4.substring(((String)object).length());
                        if ((string5 = string5.replace(File.separatorChar, '/')).startsWith(String.valueOf('/'))) {
                            string5 = string5.substring(1);
                        }
                        this.checkFileExistanceInOtherFolder(treeElement, string5);
                        String string6 = string3;
                        String string7 = string2;
                        if (string6.indexOf(string7) == -1) {
                            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"AlertSourceFiles"), (String)Messages.getString((String)"AlertSourceFilesMessage"));
                            this.addSourceFile(treeElement);
                        } else if (string != null && !string.equals("")) {
                            IFile iFile;
                            String string8 = ViewsUtil.getFileLocation(string, string3, treeElement);
                            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                            IProject iProject = iWorkspace.getRoot().getProject(treeElement.getProject().getName());
                            IFile iFile2 = iProject.getFile(string8);
                            if (iFile2 != null && !iFile2.exists() && ViewsUtil.isWindows() && (iFile = iProject.getFile(string8 = ViewsUtil.getActualFileName(string8, string))) != null && iFile.exists()) {
                                string = string.toUpperCase();
                            }
                            if (treeElement.getChildFromLocation(string8) != null) {
                                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"FileAlreadyPresent"), (String)(String.valueOf(Messages.getString((String)"FileAlreadyAddedMessage1")) + " '" + string + "'   " + Messages.getString((String)"FileAlreadyAddedMessage2")));
                            } else {
                                treeElement2 = treeElement.addChild(string5, string, "SOURCE_FILE", true);
                                if (iFile2 != null) {
                                    ViewsTreeModel.getInstance().refreshStructuresViewAndUpdateModel(iFile2);
                                }
                            }
                        }
                        ++n4;
                    }
                    if (this.fSite instanceof StructuresView) {
                        treeViewer = ((StructuresView)this.fSite).getViewer();
                    }
                }
                if (treeViewer == null) break block27;
                treeViewer.refresh();
                if (structuredSelection != null) {
                    treeViewer.setSelection((ISelection)structuredSelection);
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        object2 = iWorkspace.getRoot().getProject(treeElement.getProject().getName());
        object = new AntScriptGenerator((IProject)object2);
        object.run();
        return treeElement2;
    }

    private void checkFileExistanceInOtherFolder(TreeElement treeElement, String string) {
        TreeElement treeElement2 = treeElement.getProject().getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME);
        if (treeElement2 != null && ViewsUtil.isFileExistInOtherFolder(treeElement2, (IPath)new Path(string)) != null) {
            ViewsUtil.deleteFileInOtherFolder(treeElement2, (IPath)new Path(string));
        }
    }

    private void addLinkingFile() {
        String[] stringArray = new String[]{"*.lib", "*.*"};
        String[] stringArray2 = new String[]{String.valueOf(Messages.getString((String)"Libraryfile")) + "(*.lib)", String.valueOf(Messages.getString((String)"AllFiles")) + "(*.*)"};
        StructuredSelection structuredSelection = null;
        TreeElement treeElement = null;
        try {
            String string;
            String string2;
            IWorkbenchPart iWorkbenchPart = this.getViewPart();
            TreeViewer treeViewer = null;
            if (iWorkbenchPart instanceof DependencyView) {
                treeViewer = ((DependencyView)iWorkbenchPart).getViewer();
            } else if (iWorkbenchPart instanceof StructuresView) {
                treeViewer = ((StructuresView)iWorkbenchPart).getViewer();
            }
            TreeElement treeElement2 = ViewsUtil.getSelection(treeViewer);
            String string3 = treeElement2.getProject().getLocation();
            FileDialog fileDialog = new FileDialog(this.getShell(), 2);
            fileDialog.setText(Messages.getString((String)"SelectFileTitle.label"));
            fileDialog.setFilterPath(string3);
            fileDialog.setFilterExtensions(stringArray);
            fileDialog.setFilterNames(stringArray2);
            String string4 = fileDialog.open();
            if (string4 == null || string4 == "") {
                return;
            }
            String[] stringArray3 = fileDialog.getFileNames();
            String string5 = fileDialog.getFilterPath();
            string5 = this.getFileLocation(treeElement2.getIProject(), string5);
            int n = 0;
            while (n < stringArray3.length) {
                string2 = "";
                string2 = stringArray3[n].indexOf(".") != -1 ? stringArray3[n].substring(0, stringArray3[n].indexOf(".")) : stringArray3[n];
                if (string2 != null && !string2.equals("") && !(string = ValidationManager.validateFileName((String)string2)).isOK()) {
                    String[] stringArray4 = new String[]{Messages.getString((String)"Ok")};
                    MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString((String)"AlertSourceFiles"), null, Messages.getString((String)"AlertFilesSelectMessage"), 2, stringArray4, 0);
                    messageDialog.open();
                    return;
                }
                string = treeElement2.getAttribute("TYPE");
                if (string.equals(IViewConstants.LINKING_FILES_NAME)) {
                    treeElement2 = treeElement2.getParent();
                }
                treeElement = treeElement2.addChild(String.valueOf(string5) + stringArray3[n], stringArray3[n], IViewConstants.LINKING_FILES_NAME, false);
                ++n;
            }
            if (treeElement2 != null && SelectionAction.isLinkingFolder(treeElement2)) {
                treeElement2.sortTreeElements();
            }
            ViewsUtil.updateOtherViews();
            if (treeElement != null) {
                structuredSelection = new StructuredSelection(treeElement);
            }
            if (treeViewer != null) {
                treeViewer.refresh();
                if (structuredSelection != null) {
                    treeViewer.setSelection((ISelection)structuredSelection);
                }
            }
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            string2 = iWorkspace.getRoot().getProject(treeElement2.getProject().getName());
            string = new AntScriptGenerator((IProject)string2);
            string.run();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private void addTargetRepFile() {
        String[] stringArray = new String[]{"*.rep", "*.*"};
        String[] stringArray2 = new String[]{String.valueOf(Messages.getString((String)"TargetRepfile")) + "(*.rep)", String.valueOf(Messages.getString((String)"AllFiles")) + "(*.*)"};
        StructuredSelection structuredSelection = null;
        TreeElement treeElement = null;
        try {
            String string;
            String string2;
            IWorkbenchPart iWorkbenchPart = this.getViewPart();
            TreeViewer treeViewer = null;
            if (iWorkbenchPart instanceof DependencyView) {
                treeViewer = ((DependencyView)iWorkbenchPart).getViewer();
            } else if (iWorkbenchPart instanceof StructuresView) {
                treeViewer = ((StructuresView)iWorkbenchPart).getViewer();
            }
            TreeElement treeElement2 = ViewsUtil.getSelection(treeViewer);
            String string3 = treeElement2.getProject().getLocation();
            FileDialog fileDialog = new FileDialog(this.getShell(), 2);
            fileDialog.setText(Messages.getString((String)"SelectFileTitle.label"));
            fileDialog.setFilterPath(string3);
            fileDialog.setFilterExtensions(stringArray);
            fileDialog.setFilterNames(stringArray2);
            String string4 = fileDialog.open();
            if (string4 == null || string4 == "") {
                return;
            }
            String[] stringArray3 = fileDialog.getFileNames();
            String string5 = fileDialog.getFilterPath();
            string5 = this.getFileLocation(treeElement2.getIProject(), string5);
            int n = 0;
            while (n < stringArray3.length) {
                string2 = "";
                string2 = stringArray3[n].indexOf(".") != -1 ? stringArray3[n].substring(0, stringArray3[n].indexOf(".")) : stringArray3[n];
                if (string2 != null && !string2.equals("") && !(string = ValidationManager.validateFileName((String)string2)).isOK()) {
                    String[] stringArray4 = new String[]{Messages.getString((String)"Ok")};
                    MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString((String)"AlertSourceFiles"), null, Messages.getString((String)"AlertFilesSelectMessage"), 2, stringArray4, 0);
                    messageDialog.open();
                    return;
                }
                string = treeElement2.getAttribute("TYPE");
                if (string.equals("TARGET_FILES")) {
                    treeElement2 = treeElement2.getParent();
                }
                treeElement = treeElement2.addChild(String.valueOf(string5) + stringArray3[n], stringArray3[n], "TARGET_FILES", false);
                ++n;
            }
            if (treeElement2 != null && SelectionAction.isTargetRepositoryFolder(treeElement2)) {
                treeElement2.sortTreeElements();
            }
            ViewsUtil.updateOtherViews();
            if (treeElement != null) {
                structuredSelection = new StructuredSelection(treeElement);
            }
            if (treeViewer != null) {
                treeViewer.refresh();
                if (structuredSelection != null) {
                    treeViewer.setSelection((ISelection)structuredSelection);
                }
            }
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            string2 = iWorkspace.getRoot().getProject(treeElement2.getProject().getName());
            string = new AntScriptGenerator((IProject)string2);
            string.run();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private String getFileLocation(IProject iProject, String string) {
        String string2 = string;
        if (iProject == null) {
            return string2;
        }
        IPath iPath = iProject.getWorkspace().getRoot().getLocation().makeAbsolute();
        if (iPath == null) {
            return string2;
        }
        String string3 = "";
        try {
            string3 = iPath.toFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
        }
        if (!string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        if (string.length() > string3.length() && string.startsWith(string3)) {
            string2 = string.substring(string3.length() + 1);
            Path path = new Path(string2);
            if (iProject.getWorkspace().getRoot().findMember(path.segments()[0]) instanceof IProject) {
                try {
                    iProject.getWorkspace().getRoot().findMember(path.segments()[0]).refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    CBDTUiPlugin.logError((Exception)((Object)coreException));
                }
                if (string2.indexOf(File.separatorChar) > 0) {
                    string2 = string2.replace(File.separatorChar, '/');
                }
                if (string2.length() > 0 && !string2.endsWith(String.valueOf('/'))) {
                    string2 = String.valueOf(string2) + '/';
                }
            } else {
                if (!string.endsWith(File.separator)) {
                    string = String.valueOf(string) + File.separator;
                }
                string2 = string;
            }
        }
        return string2;
    }

    private void addCopyLibraryFile(TreeElement treeElement) {
        String[] stringArray = new String[]{"*.cbl; *.cob; *.cobol", "*.rep", "*.*"};
        String[] stringArray2 = new String[]{String.valueOf(Messages.getString((String)"RegCollFiles")) + "(*.cbl; *.cob; *.cobol)", String.valueOf(Messages.getString((String)"RepFiles")) + "(*.rep)", String.valueOf(Messages.getString((String)"AllFiles")) + "(*.*)"};
        try {
            String string = treeElement.getProject().getLocation();
            FileDialog fileDialog = new FileDialog(this.getShell(), 2);
            fileDialog.setText(Messages.getString((String)"SelectFileTitle.label"));
            fileDialog.setFilterPath(string);
            fileDialog.setFilterExtensions(stringArray);
            fileDialog.setFilterNames(stringArray2);
            String string2 = fileDialog.open();
            if (string2 == null || string2 == "") {
                return;
            }
            String[] stringArray3 = fileDialog.getFileNames();
            String string3 = fileDialog.getFilterPath();
            string3 = this.getFileLocation(treeElement.getIProject(), string3);
            int n = 0;
            while (n < stringArray3.length) {
                String[] stringArray4;
                String string4 = "";
                string4 = stringArray3[n].indexOf(".") != -1 ? stringArray3[n].substring(0, stringArray3[n].indexOf(".")) : stringArray3[n];
                IStatus iStatus = ValidationManager.validateFileName((String)string4);
                if (!iStatus.isOK()) {
                    stringArray4 = new String[]{Messages.getString((String)"Ok")};
                    MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString((String)"AlertSourceFiles"), null, Messages.getString((String)"AlertFilesSelectMessage"), 2, stringArray4, 0);
                    messageDialog.open();
                    return;
                }
                stringArray4 = treeElement.getAttribute("TYPE");
                if (stringArray4.equals(IViewConstants.DEPENDENT_FILES_NAME)) {
                    treeElement = treeElement.getParent();
                }
                treeElement.addChild(String.valueOf(string3) + stringArray3[n], stringArray3[n], IViewConstants.DEPENDENT_FILES_NAME, false);
                ++n;
            }
            if (treeElement != null && SelectionAction.isDependentFolder(treeElement)) {
                treeElement.sortTreeElements();
            }
            ViewsUtil.refreshViews(treeElement);
            if (treeElement != null) {
                DependencyModelManipulation.generateAntFile(treeElement.getProject());
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }
}

