/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.variableformat;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.text.COBOLAbstractCodeScanner;
import org.eclipse.cobol.ui.common.text.COBOLColorManager;
import org.eclipse.cobol.ui.common.text.COBOLWhitespaceDetector;
import org.eclipse.cobol.ui.common.text.COBOLWordDetector;
import org.eclipse.cobol.ui.common.text.COBOLWordRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public final class COBOLVariableFormatCodeScanner
extends COBOLAbstractCodeScanner {
    private static String[] fTokenProperties = new String[]{"cobol_comment", "cobol_string", "cobol_reserved_word", "cobol_in_line_comment", "cobol_figurative_constant", "cobol_special_register", "cobol_default"};

    public COBOLVariableFormatCodeScanner(COBOLColorManager cOBOLColorManager, IPreferenceStore iPreferenceStore) {
        super(cOBOLColorManager, iPreferenceStore);
        this.initialize();
    }

    @Override
    protected String[] getTokenProperties() {
        return fTokenProperties;
    }

    @Override
    protected List createRules() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getToken("cobol_comment");
        this.getToken("cobol_string");
        arrayList.add(new WhitespaceRule((IWhitespaceDetector)new COBOLWhitespaceDetector()));
        WordRule wordRule = this.createWordRules();
        if (wordRule != null) {
            arrayList.add(wordRule);
        }
        this.setDefaultReturnToken((IToken)this.getToken("cobol_default"));
        return arrayList;
    }

    @Override
    protected WordRule createWordRules() {
        Token token = this.getToken("cobol_default");
        COBOLWordRule cOBOLWordRule = new COBOLWordRule(new COBOLWordDetector("VARIABLE"), (IToken)token, "VARIABLE");
        token = this.getToken("cobol_reserved_word");
        int n = 0;
        while (n < this.fReservedWords.length) {
            cOBOLWordRule.addWord(this.fReservedWords[n], (IToken)token);
            ++n;
        }
        token = this.getToken("cobol_figurative_constant");
        n = 0;
        while (n < this.fFigurativeConstants.length) {
            cOBOLWordRule.addWord(this.fFigurativeConstants[n], (IToken)token);
            ++n;
        }
        token = this.getToken("cobol_special_register");
        n = 0;
        while (n < this.fSpecialRegisters.length) {
            cOBOLWordRule.addWord(this.fSpecialRegisters[n], (IToken)token);
            ++n;
        }
        return cOBOLWordRule;
    }

    public int getColumn() {
        int n = 0;
        try {
            int n2 = this.fDocument.getLineOfOffset(this.fOffset);
            int n3 = this.fDocument.getLineOffset(n2);
            int n4 = CBDTUiPlugin.getDefault().getPreferenceStore().getInt("Tab Width");
            int n5 = 1;
            int n6 = n3;
            while (n6 < this.fOffset) {
                if ('\t' == this.fDocument.getChar(n6)) {
                    while ((n + n5 + 6) % n4 != 0) {
                        ++n5;
                    }
                    n += n5;
                    n5 = 1;
                } else {
                    ++n;
                }
                ++n6;
            }
            this.fColumn = n;
        }
        catch (BadLocationException badLocationException) {}
        return this.fColumn;
    }
}

